/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureRequest;
import com.ibm.xml.soapsec.dsig.SignatureSender;
import com.ibm.xml.soapsec.dsig.SignatureSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionRequest;
import com.ibm.xml.soapsec.enc.EncryptionSender;
import com.ibm.xml.soapsec.enc.EncryptionSenderConfig;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.proxy.MessageFactory;
import com.ibm.xml.soapsec.proxy.MessageProxy;
import com.ibm.xml.soapsec.time.TimestampSender;
import com.ibm.xml.soapsec.time.TimestampSenderConfig;
import com.ibm.xml.soapsec.token.BinaryTokenSender;
import com.ibm.xml.soapsec.token.SenderLogin;
import com.ibm.xml.soapsec.token.SenderLoginComponent;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.token.TokenSenderConfig;
import com.ibm.xml.soapsec.token.UsernameTokenSender;
import com.ibm.xml.soapsec.token.XMLTokenSender;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.SetupJCEProviders;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SoapSecuritySender {
    public static final String CONFIG_KEY;
    private ThreadLocal _messageConfig = new ThreadLocal();
    private Map handlerOption = new HashMap();
    protected static final String MESSAGE_CONTEXT = "com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.messageContext";
    private static final TraceComponent tc;
    private static final String comp = "security.wssecurity";
    private static final String clsName;

    public void setHandlerOption(String key, Object value2) {
        this.handlerOption.put(key, value2);
    }

    public Object getHandlerOption(String key) {
        return this.handlerOption.get(key);
    }

    private final void clear() {
        this._messageConfig.set(null);
    }

    private Map getMessageConfig() {
        HashMap map = (HashMap)this._messageConfig.get();
        if (map == null) {
            map = new HashMap();
            this._messageConfig.set(map);
        }
        return map;
    }

    public void setMessageOption(String key, Object value2) {
        this.getMessageConfig().put(key, value2);
    }

    public Object getMessageOption(String key) {
        return this.getMessageConfig().get(key);
    }

    public Map getMessageOptions() {
        return this.getMessageConfig();
    }

    public void init() {
    }

    protected void initConfig(MessageContextProxy context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initConfig(" + context + ")");
        }
        SignatureSender signatureSender = new SignatureSender();
        SenderLoginComponent senderLogin = this.createLoginComponent(context);
        UsernameTokenSender tokenSender = new UsernameTokenSender();
        BinaryTokenSender binarySender = new BinaryTokenSender();
        XMLTokenSender xmlSender = new XMLTokenSender();
        TimestampSender tssender = new TimestampSender();
        EncryptionSender encryptionSender = new EncryptionSender();
        SenderConfig config = (SenderConfig)this.getMessageOption(CONFIG_KEY);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Configuration object is as follows:", new Object[]{config});
        }
        try {
            HashMap<Class<TimestampSenderConfig>, Object> map = new HashMap<Class<TimestampSenderConfig>, Object>();
            map.put(SenderConfig.class, config);
            map.put(SignatureSenderConfig.class, config.getSignatureConfig());
            map.put(TokenSenderConfig.class, config.getTokenConfig());
            map.put(EncryptionSenderConfig.class, config.getEncryptionConfig());
            map.put(TimestampSenderConfig.class, config.getTimestampConfig());
            signatureSender.init(map);
            senderLogin.init(map);
            tokenSender.init(map);
            binarySender.init(map);
            xmlSender.init(map);
            tssender.init(map);
            encryptionSender.init(map);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".initConfig", "118", this);
            Tr.error(tc, "security.wssecurity.SoapSecuritySender.initConfig", e);
            throw new RuntimeException(e.getMessage());
        }
        this.setMessageOption(SignatureSender.class.getName(), signatureSender);
        this.setMessageOption(SenderLoginComponent.class.getName(), senderLogin);
        this.setMessageOption(UsernameTokenSender.class.getName(), tokenSender);
        this.setMessageOption(BinaryTokenSender.class.getName(), binarySender);
        this.setMessageOption(XMLTokenSender.class.getName(), xmlSender);
        this.setMessageOption(TimestampSender.class.getName(), tssender);
        this.setMessageOption(EncryptionSender.class.getName(), encryptionSender);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initConfig(MessageContextProxy context)");
        }
    }

    protected SenderLoginComponent createLoginComponent(MessageContextProxy context) {
        return new SenderLogin();
    }

    protected boolean adjustContext(MessageContextProxy context, Map ccontext) throws FaultProxy {
        return false;
    }

    protected boolean backContext(MessageContextProxy context, Map ccontext) throws FaultProxy {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContextProxy context) throws FaultProxy {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + context + ")");
        }
        this.clear();
        try {
            Document doc;
            MessageProxy inMessage;
            boolean doSecurity;
            this.initConfig(context);
            SenderConfig config = (SenderConfig)this.getMessageOption(CONFIG_KEY);
            try {
                config.validate();
            }
            catch (SoapSecurityException sse) {
                Tr.processException((Throwable)sse, clsName + ".invoke", "173", this);
                Tr.error(tc, "security.wssecurity.config.invalid", (Object)sse);
                throw FaultProxy.makeFault(sse);
            }
            boolean doTimestamp = config.isTimestampEnabled();
            HashMap<String, Object> componentContext = new HashMap<String, Object>();
            RequestPool.initialize(componentContext);
            boolean externalRequests = this.adjustContext(context, componentContext);
            boolean bl = doSecurity = config.isTokenEnabled() || config.isSignatureEnabled() || config.isEncryptionEnabled() || externalRequests;
            if (!doTimestamp && !doSecurity) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_invoke(MessageContext context)");
                }
                return;
            }
            try {
                inMessage = context.getCurrentMessage();
                doc = inMessage.getDocument();
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, clsName + ".invoke", "197", this);
                Tr.error(tc, "security.wssecurity.message.getDocument", e);
                throw FaultProxy.makeFault(e);
            }
            try {
                this.setMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress", context.getTargetEndpointAddress());
                this.setMessageOption(MESSAGE_CONTEXT, context);
                componentContext.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", Constants.getWSSENS(context));
                componentContext.put("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", Constants.getWSUNS(context));
                if (doTimestamp) {
                    Element header2 = SoapSecuritySender.getHeader(doc);
                    this.invokeComponent(doc, header2, componentContext, TimestampSender.class);
                }
                if (doSecurity) {
                    boolean mustUnderstand = this.checkMustUnderstand(config, context);
                    Element security2 = SoapSecuritySender.addSecurityHeader(doc, Constants.getWSSENS(componentContext), config.getTargetActor(), mustUnderstand ? "1" : null);
                    if (config.isTokenEnabled()) {
                        this.invokeComponent(doc, security2, componentContext, SenderLoginComponent.class);
                    }
                    int numreq = RequestPool.get(componentContext, TokenRequest.Username.class).length;
                    if (config.isTokenEnabled() && numreq > 0) {
                        this.invokeComponent(doc, security2, componentContext, UsernameTokenSender.class);
                    }
                    if (RequestPool.get(componentContext, TokenRequest.Binary.class).length > 0) {
                        this.invokeComponent(doc, security2, componentContext, BinaryTokenSender.class);
                    }
                    if (RequestPool.get(componentContext, TokenRequest.XML.class).length > 0) {
                        this.invokeComponent(doc, security2, componentContext, XMLTokenSender.class);
                    }
                    numreq = RequestPool.get(componentContext, SignatureRequest.class).length;
                    if (config.isSignatureEnabled() || numreq > 0) {
                        this.invokeComponent(doc, security2, componentContext, SignatureSender.class);
                    }
                    if (RequestPool.get(componentContext, TokenRequest.Binary.class).length > 0) {
                        this.invokeComponent(doc, security2, componentContext, BinaryTokenSender.class);
                    }
                    numreq = RequestPool.get(componentContext, EncryptionRequest.class).length;
                    if (config.isEncryptionEnabled() || numreq > 0) {
                        componentContext.put("com.ibm.xml.soapsec.RequestCert", context.getConfig("com.ibm.xml.soapsec.RequestCert"));
                        this.invokeComponent(doc, security2, componentContext, EncryptionSender.class);
                    }
                    if (!config.doIndentation()) {
                        DOMUtil.removeIndentation(security2);
                    }
                }
                MessageProxy m = MessageFactory.getInstance().create(doc, inMessage);
                context.setCurrentMessage(m);
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, clsName + ".invoke", "264", this);
                Tr.error(tc, "security.wssecurity.invoke.exception", new Object[]{context.getTargetEndpointAddress(), e});
                FaultProxy fault2 = FaultProxy.makeFault(e);
                if (context.getPastPivot()) {
                    context.setCurrentMessage(MessageProxy.getInstance(fault2));
                }
                throw fault2;
            }
            this.backContext(context, componentContext);
            RequestPool.finalize(componentContext);
        }
        finally {
            this.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(MessageContextProxy context)");
        }
    }

    private void invokeComponent(Document doc, Element security2, Map context, Class cl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeComponent(" + doc + "," + context + "," + cl + ")");
        }
        SoapSecurityComponent sender = this.getComponent(cl);
        sender.invoke(doc, security2, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeComponent(Document doc, Element security, Map context, Class cl)");
        }
    }

    public void onFault(MessageContextProxy context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onFault(" + context + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onFault(MessageContextProxy context)");
        }
    }

    private SoapSecurityComponent getComponent(Class cl) {
        return (SoapSecurityComponent)this.getMessageOption(cl.getName());
    }

    private static Element searchForSecurityHeader(Element header2, String actor, String mustUnderstand) {
        Element el = DOMUtil.getFirstElement(header2);
        while (el != null) {
            String ns = el.getNamespaceURI();
            String ln = el.getLocalName();
            if (NamespaceUtil.isWsse(ns) && "Security".equals(ln) && !(actor != null && actor.length() != 0 ? !actor.equals(el.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor")) : el.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor").length() != 0)) {
                String mu;
                if (mustUnderstand != null && !mustUnderstand.equals(mu = el.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand"))) {
                    Tr.error(tc, "security.wssecurity.SoapSecurityReceiver.sss03", new Object[]{mu, mustUnderstand});
                }
                return el;
            }
            el = DOMUtil.getNextElement(el);
        }
        return null;
    }

    public static Element getHeader(Document factory) {
        Element root = factory.getDocumentElement();
        Element header2 = DOMUtil.getFirstElement(root, "http://schemas.xmlsoap.org/soap/envelope/", "Header");
        if (header2 == null) {
            String prefix = root.getPrefix();
            if (prefix == null) {
                prefix = "";
            } else if (prefix.length() > 0) {
                prefix = prefix + ":";
            }
            header2 = factory.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", prefix + "Header");
            root.insertBefore(header2, root.getFirstChild());
        }
        return header2;
    }

    private static Element addSecurityHeader(Document factory, String wsseNamespace, String actor, String must) {
        String prefix;
        Element header2;
        Element security2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSecurityHeader(" + factory + "," + actor + "," + must + ")");
        }
        if ((security2 = SoapSecuritySender.searchForSecurityHeader(header2 = SoapSecuritySender.getHeader(factory), actor, must)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addSecurityHeader Uses existing wsse:Security element");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addSecurityHeader(Document factory, String actor, String must)");
            }
            return security2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addSecurityHeader Creates new wsse:Security element");
        }
        security2 = factory.createElementNS(wsseNamespace, "wsse:Security");
        security2.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsse", wsseNamespace);
        if (actor != null) {
            prefix = header2.getPrefix();
            if (prefix == null || prefix.length() <= 0) {
                security2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "env:actor", actor);
                security2.setAttributeNS(Constants.NS_XMLNS, "xmlns:env", "http://schemas.xmlsoap.org/soap/envelope/");
            } else {
                security2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", prefix + ":actor", actor);
            }
        }
        if (must != null) {
            prefix = header2.getPrefix();
            if (prefix == null || prefix.length() <= 0) {
                security2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "env:mustUnderstand", must);
                security2.setAttributeNS(Constants.NS_XMLNS, "xmlns:env", "http://schemas.xmlsoap.org/soap/envelope/");
            } else {
                security2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", prefix + ":mustUnderstand", must);
            }
        }
        header2.insertBefore(security2, header2.getFirstChild());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSecurityHeader(Document factory, String actor, String must)");
        }
        return security2;
    }

    public static void prependSecurityElement(Element security2, Element elem) {
        security2.insertBefore(elem, security2.getFirstChild());
    }

    private boolean checkMustUnderstand(SenderConfig config, MessageContextProxy context) {
        boolean mustUnderstand = true;
        boolean isServer = false;
        isServer = ((MessageContext)context.get()).isServer();
        if (isServer) {
            boolean setMustUnderstand = config.getServiceGetMustUnderstand();
            if (setMustUnderstand) {
                mustUnderstand = ConfigUtil.getMustUnderstand(context);
            }
        } else {
            mustUnderstand = config.getClientSetMustUnderstand();
        }
        ConfigUtil.setMustUnderstand(context, mustUnderstand);
        return mustUnderstand;
    }

    static {
        String setup_jce = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("setup-jce");
            }
        });
        if (setup_jce != null) {
            SetupJCEProviders.setup();
        }
        CONFIG_KEY = SenderConfig.class.getName();
        tc = Tr.register(SoapSecuritySender.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
        clsName = SoapSecuritySender.class.getName();
    }
}

