/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.securitydomain;

import com.ibm.ejs.ras.TraceNLS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Locale;

public class SecurityDomainValidationException
extends Exception
implements Externalizable {
    private String _bundle;
    private String _messageKey;
    private String[] _inserts;
    private String _defaultMessage;
    private static final String[] NULL_INSERTS = new String[0];
    private boolean _allowReadExternal = false;
    private static final long serialVersionUID = 3758241984149701876L;

    public SecurityDomainValidationException(String message) {
        super(message);
    }

    public SecurityDomainValidationException(Throwable cause) {
        super(cause);
    }

    public SecurityDomainValidationException(String message, Exception e) {
        super(message, e);
    }

    public SecurityDomainValidationException() {
        this._allowReadExternal = true;
    }

    public SecurityDomainValidationException(String bundle, String messageKey, Object[] inserts) {
        this._bundle = bundle;
        this._messageKey = messageKey;
        if (inserts != null) {
            this._inserts = new String[inserts.length];
            for (int i = 0; i < this._inserts.length; ++i) {
                this._inserts[i] = String.valueOf(inserts[i]);
            }
        } else {
            this._inserts = NULL_INSERTS;
        }
        this._defaultMessage = this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale localeToRenderIn) {
        String reason = TraceNLS.getFormattedMessage(this._bundle, this._messageKey, localeToRenderIn, this._inserts, this._defaultMessage);
        return reason;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
        objOut.writeUTF(this._bundle);
        objOut.writeUTF(this._messageKey);
        objOut.writeUTF(this._defaultMessage);
        objOut.writeObject(this._inserts);
        out.writeObject(bytesOut.toByteArray());
        objOut.close();
        bytesOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        SecurityDomainValidationException securityDomainValidationException = this;
        synchronized (securityDomainValidationException) {
            if (!this._allowReadExternal) {
                IOException ioe = new IOException();
                throw ioe;
            }
            this._allowReadExternal = false;
        }
        Object obj = in.readObject();
        if (obj instanceof byte[]) {
            ByteArrayInputStream bytesIn = new ByteArrayInputStream((byte[])obj);
            ObjectInputStream objIn = new ObjectInputStream(bytesIn);
            objIn.readLong();
            this._bundle = objIn.readUTF();
            this._messageKey = objIn.readUTF();
            this._defaultMessage = objIn.readUTF();
            Object inserts = objIn.readObject();
            if (!(inserts instanceof String[])) {
                IOException ioe = new IOException();
                throw ioe;
            }
            this._inserts = (String[])inserts;
        } else {
            IOException ioe = new IOException();
            throw ioe;
        }
    }
}

