/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASProductInfo;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class ManagedObjectMetadataCollectorImplBase
implements ManagedObjectMetadataCollector {
    public static final String ACTION_PARAM_PROFILE_TYPE = "BASE_PROFILE_TYPE";
    static final String PROFILE_TYPE_DMGR = "dmgr";
    static final String PROFILE_TYPE_MANAGED = "managed";
    static final String PROFILE_TYPE_DEFAULT = "default";
    public static final String[] PROFILE_TYPES = new String[]{"dmgr", "managed", "default"};
    private String _prodVersion_PropName;
    private String _prodShortName_PropName;
    private String _extensionID;
    private String[][] _productIDs;
    private String[] _defaultDirFilters;
    private String[] _dmgrDirFilters;
    private String[] _managedDirFilters;
    private WASProductInfo _curProdInfo;
    private String _curProdShortName;
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataCollector.class, "Admin", null);
    private Properties _inputProps;
    private Properties _metadata;
    private Exception _e = null;

    protected abstract String getProdVersion_PropName();

    protected abstract String getProdShortName_PropName();

    protected abstract String getExtensionID();

    protected abstract String[][] getProductIDs();

    protected abstract String[] getDefaultDirFilters();

    protected abstract String[] getDmgrDirFilters();

    protected abstract String[] getManagedDirFilters();

    public ManagedObjectMetadataCollectorImplBase(Properties inputProps) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ManagedObjectMetadataCollectorImplBase(Properties)", "Input props: " + DebugUtils.createPropertiesMaskPlainTextPassword(inputProps));
        }
        this._inputProps = inputProps;
        this._extensionID = this.getExtensionID();
        this._prodVersion_PropName = this.getProdVersion_PropName();
        this._prodShortName_PropName = this.getProdShortName_PropName();
        this._productIDs = this.getProductIDs();
        this._defaultDirFilters = this.getDefaultDirFilters();
        this._dmgrDirFilters = this.getDmgrDirFilters();
        this._managedDirFilters = this.getManagedDirFilters();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ManagedObjectMetadataCollectorImplBase(Properties)");
        }
    }

    protected boolean isProfileAugmentationRequired() {
        return true;
    }

    public void updateMetadata(String action, Hashtable actionParams, Properties metadata) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateMetadata", new String[]{"action=" + action, "actionParams=" + actionParams, "metadata(in)=" + metadata});
        }
        try {
            if (action == null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "updateMetadata: Null action.  No action taken.");
                }
            } else if (action.equals("Collect Metadata")) {
                this.collectMetadata(metadata);
            } else if (action.equals("Add Extension")) {
                if (this.isExtensionIDRecognized(actionParams)) {
                    String profileType = (String)actionParams.get(ACTION_PARAM_PROFILE_TYPE);
                    this.addMetadata(metadata, profileType);
                }
            } else if (action.equals("Remove Extension")) {
                if (this.isExtensionIDRecognized(actionParams)) {
                    String profileType = (String)actionParams.get(ACTION_PARAM_PROFILE_TYPE);
                    this.removeMetadata(metadata, profileType);
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateMetadata: Action not recognized.  No action taken.");
            }
        }
        catch (Exception e) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Exception: " + e);
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateMetadata", new String[]{"metadata(out)=" + metadata});
        }
    }

    private boolean isExtensionIDRecognized(Hashtable actionParams) {
        boolean isValid = false;
        String extID = (String)actionParams.get("param.action.extension.id");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isExtensionIDRecognized: extID = " + extID);
        }
        if (extID != null && extID.equals(this._extensionID)) {
            isValid = true;
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isExtensionIDRecognized: Extension ID not recognized or not present.  No action taken.");
        }
        return isValid;
    }

    private void collectMetadata(Properties metadata) throws AdminException {
        Properties tempMetadata = new Properties();
        this.getProductInfo();
        if (this.isProfileAugmentationRequired()) {
            if (this.isThisProfileAugmented(metadata)) {
                Tr.debug(_tc, "collectMetadata: this profile has been augmented by the extension associated with this collector.");
                this.collectVersionInfo(tempMetadata);
            } else {
                Tr.debug(_tc, "collectMetadata: this profile has not been augmented by the extension associated with this collector.");
            }
        } else {
            Tr.debug(_tc, "collectMetadata: no profile augmentation is required by the extension associated with this collector.");
            tempMetadata.setProperty(this._prodShortName_PropName, this._curProdShortName);
            this.collectVersionInfo(tempMetadata);
        }
        metadata.putAll((Map<?, ?>)tempMetadata);
    }

    private void getProductInfo() throws AdminException {
        block8: {
            try {
                WASDirectory wasDir = new WASDirectory(this._inputProps.getProperty("was.install.root"));
                if (this._productIDs != null) {
                    int i = 0;
                    if (i >= this._productIDs.length) break block8;
                    WASProductInfo prodInfo = wasDir.getWASProductInfo(this._productIDs[i][0]);
                    if (prodInfo != null) {
                        this._curProdInfo = prodInfo;
                        this._curProdShortName = this._productIDs[i][1];
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "getProductInfo: Got the product information for " + this._productIDs[i][0] + ".");
                        }
                        break block8;
                    }
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "getProductInfo: Caught exception.");
                    }
                    throw new AdminException("Could not obtain product information.");
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "getProductInfo: No produdct ID provided.");
                }
                throw new AdminException("No product ID provided and could not obtain product information.");
            }
            catch (Exception e) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "getProductInfo: Caught exception.", e);
                }
                throw new AdminException(e, "Could not obtain product information.");
            }
        }
    }

    private boolean isThisProfileAugmented(Properties metadata) {
        boolean augmented = false;
        String prodSName = null;
        if (metadata != null) {
            prodSName = metadata.getProperty(this._prodShortName_PropName);
        }
        if (prodSName != null && prodSName.equals(this._curProdShortName)) {
            augmented = true;
        }
        return augmented;
    }

    private void collectVersionInfo(Properties metadata) throws AdminException {
        String prodVer = null;
        try {
            if (this._curProdInfo != null && (prodVer = this._curProdInfo.getVersion()) != null) {
                metadata.setProperty(this._prodVersion_PropName, prodVer);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "collectVersionInfo: Collecting version info is successful.");
                }
            }
        }
        catch (Exception e) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectVersionInfo: Caught exception.", e);
            }
            throw new AdminException(e, "Could not obtain product version.");
        }
        if (prodVer == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectVersionInfo: Could not obtain product version.");
            }
            throw new AdminException("Could not obtain product version.");
        }
    }

    private void addMetadata(Properties metadata, String profileType) throws Exception {
        block18: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "addMetadata", new String[]{"metadata(in)=" + metadata, "profileType=" + profileType});
            }
            this.getProductInfo();
            metadata.setProperty(this._prodShortName_PropName, this._curProdShortName);
            if (profileType.equals(PROFILE_TYPE_DMGR) || profileType.equals(PROFILE_TYPE_DEFAULT)) {
                String installRootPath = this._inputProps.getProperty("was.install.root");
                if (installRootPath == null) {
                    AdminException ae = new AdminException("No install root path provided.");
                    Manager.Ffdc.log(ae, this, "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorImplBase.addMetadata", "472", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "addMetadata: No install root path.", ae);
                    }
                    throw ae;
                }
                String featuresDirPath = installRootPath + File.separator + "features";
                File featuresDir = new File(featuresDirPath);
                if (!featuresDir.exists()) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "addMetadata: No features directory found under the install root directory, " + installRootPath + ".");
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "addMetadata: No features added.");
                    }
                    return;
                }
                if (!featuresDir.isDirectory()) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "appendBaseFeatures: The path \"" + featuresDirPath + "\" does not resolve to a directory.");
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "addMetadata: No features added.");
                    }
                    return;
                }
                try {
                    String comma;
                    StringBuffer propBuff;
                    String featuresProp = metadata.getProperty("com.ibm.websphere.deployed.features");
                    Set existingFeatures = this.parseFeaturesProp(featuresProp);
                    String[] newFeatures = featuresDir.list(new FeatureFileFilter(profileType));
                    if (featuresProp == null) {
                        propBuff = new StringBuffer();
                        comma = "";
                    } else {
                        propBuff = new StringBuffer(featuresProp);
                        comma = ",";
                    }
                    int addCount = 0;
                    for (int i = 0; i < newFeatures.length; ++i) {
                        String newFeature = newFeatures[i];
                        if (existingFeatures.contains(newFeature)) continue;
                        propBuff.append(comma);
                        propBuff.append(newFeature);
                        ++addCount;
                        comma = ",";
                    }
                    if (addCount > 0) {
                        featuresProp = propBuff.toString();
                        Tr.debug(_tc, "addMetadata: setting features list:", "featuresProp=" + featuresProp);
                        metadata.setProperty("com.ibm.websphere.deployed.features", featuresProp);
                    } else {
                        Tr.debug(_tc, "addMetadata: No features added.");
                    }
                }
                catch (Exception e) {
                    if (!_tc.isEventEnabled()) break block18;
                    Tr.event(_tc, "addMetadata: Exception received:", e);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addMetadata", new String[]{"metadata(out)=" + metadata});
        }
    }

    private void removeMetadata(Properties metadata, String profileType) throws Exception {
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "removeMetadata", new String[]{"metadata(in)=" + metadata, "profileType=" + profileType});
            }
            metadata.remove(this._prodShortName_PropName);
            metadata.remove(this._prodVersion_PropName);
            String installRootPath = this._inputProps.getProperty("was.install.root");
            if (profileType.equals(PROFILE_TYPE_DMGR) || profileType.equals(PROFILE_TYPE_DEFAULT)) {
                try {
                    String featuresProp = metadata.getProperty("com.ibm.websphere.deployed.features");
                    if (featuresProp != null && featuresProp.length() != 0) {
                        String feature;
                        int bi = 0;
                        String newFeaturesProp = new String("");
                        String[] unwantedFeatures = null;
                        unwantedFeatures = profileType.equals(PROFILE_TYPE_DEFAULT) ? this._defaultDirFilters : this._dmgrDirFilters;
                        int ei = featuresProp.indexOf(44);
                        while (ei != -1) {
                            boolean wantedFeature;
                            feature = featuresProp.substring(bi, ei).trim();
                            if (feature.length() > 0 && (wantedFeature = this.isWantedFeature(feature, unwantedFeatures))) {
                                newFeaturesProp = newFeaturesProp + feature + ",";
                            }
                            bi = ei + 1;
                            ei = featuresProp.indexOf(44, bi);
                        }
                        feature = featuresProp.substring(bi).trim();
                        newFeaturesProp = feature.length() > 0 && this.isWantedFeature(feature, unwantedFeatures) ? newFeaturesProp + feature : newFeaturesProp.substring(0, newFeaturesProp.length() - 1);
                        Tr.debug(_tc, "removeMetadata: setting features list:", "newFeaturesProp=" + newFeaturesProp);
                        metadata.setProperty("com.ibm.websphere.deployed.features", newFeaturesProp);
                    } else {
                        Tr.debug(_tc, "remvoeMetadata: No feature removed.");
                    }
                }
                catch (Exception e) {
                    if (!_tc.isEventEnabled()) break block9;
                    Tr.event(_tc, "removeMetadata: Exception received:", e);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeMetadata", new String[]{"metadata(out)=" + metadata});
        }
    }

    private boolean isWantedFeature(String feature, String[] unwantedFeatures) {
        boolean wantedFeature = true;
        for (int i = 0; i < unwantedFeatures.length; ++i) {
            if (!feature.startsWith(unwantedFeatures[i])) continue;
            wantedFeature = false;
        }
        return wantedFeature;
    }

    private Set parseFeaturesProp(String featuresProp) {
        String feature;
        HashSet<String> featuresSet = new HashSet<String>();
        if (featuresProp == null || featuresProp.length() == 0) {
            return featuresSet;
        }
        int bi = 0;
        int ei = featuresProp.indexOf(44);
        while (ei != -1) {
            feature = featuresProp.substring(bi, ei).trim();
            if (feature.length() > 0) {
                featuresSet.add(feature);
            }
            bi = ei + 1;
            ei = featuresProp.indexOf(44, bi);
        }
        feature = featuresProp.substring(bi).trim();
        if (feature.length() > 0) {
            featuresSet.add(feature);
        }
        return featuresSet;
    }

    private class FeatureFileFilter
    implements FilenameFilter {
        private String[] _featureFilters;

        public FeatureFileFilter(String profileType) {
            if (profileType.equals(ManagedObjectMetadataCollectorImplBase.PROFILE_TYPE_DEFAULT)) {
                this._featureFilters = ManagedObjectMetadataCollectorImplBase.this._defaultDirFilters;
            } else if (profileType.equals(ManagedObjectMetadataCollectorImplBase.PROFILE_TYPE_DMGR)) {
                this._featureFilters = ManagedObjectMetadataCollectorImplBase.this._dmgrDirFilters;
            } else if (profileType.equals(ManagedObjectMetadataCollectorImplBase.PROFILE_TYPE_MANAGED)) {
                this._featureFilters = ManagedObjectMetadataCollectorImplBase.this._managedDirFilters;
            } else {
                Manager.Ffdc.log(new AdminException("No feature filters for profile type " + profileType), this, "com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorBase.FilenameFilter.FeatureFileFilter", "691", this);
                this._featureFilters = null;
            }
        }

        public boolean accept(File dir, String name2) {
            if (this._featureFilters == null) {
                return false;
            }
            for (int i = 0; i < this._featureFilters.length; ++i) {
                if (!name2.startsWith(this._featureFilters[i])) continue;
                File childDir = new File(dir.getAbsolutePath() + File.separator + name2);
                return childDir.isDirectory();
            }
            return false;
        }
    }
}

