/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConfigServiceException;
import java.lang.reflect.Method;

public class PortResolution {
    private static TraceComponent tc = Tr.register(PortResolution.class, "PortResolution", "com.ibm.wsspi.management.configservice");

    public static int resolvePort(Session session, String nodeName, int defaultPort) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolvePort", new Object[]{"session: " + session, "nodeName: " + nodeName, "defaultPort: " + defaultPort});
        }
        Integer port2 = 0;
        if (session == null || nodeName == null || nodeName.equals("")) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0017E", new Object[]{session, "nodeName=" + nodeName}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new ConfigServiceException(msg);
        }
        if (defaultPort < 0) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0017E", new Object[]{session, "port=" + defaultPort}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new ConfigServiceException(msg);
        }
        try {
            Class<?> implClass = Class.forName("com.ibm.ws.management.configservice.EndpointConfigHelper");
            Method method = implClass.getMethod("adjustPort", Session.class, String.class, Integer.class);
            port2 = (Integer)method.invoke(null, session, nodeName, new Integer(defaultPort));
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got unexpected exception, " + th + ", root cause: " + th.getCause());
            }
            Manager.Ffdc.log(th, PortResolution.class, "com.ibm.wsspi.management.configservice.PortResolution", "100");
            throw new ConfigServiceException(th, "Root cause: " + th.getCause());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolvePort, return port number " + port2);
        }
        return port2;
    }
}

