/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.wsspi.management.commands.server.ServerCommandBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.management.ObjectName;

public class CreateServerTemplate
extends ServerCommandBase {
    private static TraceComponent tc = Tr.register(CreateServerTemplate.class, "management", "com.ibm.ws.management.resources.configservice");

    public CreateServerTemplate(TaskCommandMetadata taskcommandmetadata) throws CommandNotFoundException {
        super(taskcommandmetadata);
    }

    public CreateServerTemplate(CommandData commanddata) throws CommandNotFoundException, CommandLoadException {
        super(commanddata);
    }

    public void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            String nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", nodeName);
            }
            String serverName = (String)this.getParameter("serverName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server name", serverName);
            }
            String templateName = (String)this.getParameter("templateName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template name", templateName);
            }
            String description = (String)this.getParameter("description");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "description", description);
            }
            ObjectName templateLoc = (ObjectName)this.getParameter("templateLocation");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "templateLoc", templateLoc);
            }
            ObjectName template = null;
            try {
                Method method = this.implClass.getMethod("createServerTemplate", Session.class, String.class, String.class, String.class, String.class, ObjectName.class);
                template = (ObjectName)method.invoke(null, session, nodeName, serverName, templateName, description, templateLoc);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template", template);
            }
            result.setResult(template);
        }
        catch (Throwable ex) {
            result.setException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void taskCommandExecuted(boolean success) {
        if (!success) {
            // empty if block
        }
    }

    public void validate() throws CommandValidationException {
        boolean templateNameValid;
        String nodeName;
        Session session;
        ConfigService configService;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate, ");
            }
            Object templates = null;
            Object template = null;
            configService = ConfigServiceFactory.getConfigService();
            session = this.getConfigSession();
            nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node Name: " + nodeName);
            }
            try {
                ObjectName[] queryResult = configService.resolve(session, "Node=" + nodeName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Result from ConfigService: " + queryResult);
                }
                if (queryResult.length == 0) {
                    String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0258E", new Object[]{nodeName}, null);
                    throw new CommandValidationException(msg);
                }
            }
            catch (ConfigServiceException cse) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0261E", new Object[]{cse}, null);
                throw new CommandValidationException(msg);
            }
            catch (ConnectorException ce) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0261E", new Object[]{ce}, null);
                throw new CommandValidationException(msg);
            }
            String majorVersion = null;
            try {
                majorVersion = this.metadataHelper.getNodeMajorVersion(nodeName);
                String os = this.metadataHelper.getNodePlatformOS(nodeName);
            }
            catch (Exception e) {
                if (majorVersion != null && majorVersion.equals("5")) break block21;
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0504E", new Object[]{nodeName}, null);
                throw new CommandValidationException(msg);
            }
        }
        String serverName = (String)this.getParameter("serverName");
        ObjectName server2 = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "server name", serverName);
        }
        try {
            ObjectName[] serverResult = configService.resolve(session, "Node=" + nodeName + ":Server=" + serverName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result from ConfigService: " + serverResult);
            }
            if (serverResult.length == 0) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0256E", new Object[]{serverName, nodeName}, null);
                throw new CommandValidationException(msg);
            }
            server2 = serverResult[0];
        }
        catch (ConfigServiceException cse) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0261E", new Object[]{cse}, null);
            throw new CommandValidationException(msg);
        }
        catch (ConnectorException ce) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0261E", new Object[]{ce}, null);
            throw new CommandValidationException(msg);
        }
        String templateName = (String)this.getParameter("templateName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Template Name: " + serverName);
        }
        boolean bl = templateNameValid = templateName != null && templateName.trim().length() > 0;
        if (!templateNameValid) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0255E", new Object[0], null);
            throw new CommandValidationException(msg);
        }
        boolean templateValid = ConfigServiceHelper.checkIfNameValid(templateName);
        if (!templateValid) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0257E", new Object[]{templateName}, null);
            throw new CommandValidationException(msg);
        }
        List exist = null;
        try {
            String serverType = (String)configService.getAttribute(session, server2, "serverType");
            exist = this.listServerTemplates(serverType, new String[]{"name=" + templateName});
        }
        catch (Throwable e) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0261E", new Object[]{e}, null);
            throw new CommandValidationException(msg);
        }
        if (exist != null && exist.size() > 0) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0262E", new Object[]{templateName}, null);
            throw new CommandValidationException(msg);
        }
    }
}

