/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimePeriodRule
extends DefaultRule
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(TimePeriodRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private int beginHours = -99;
    private int beginMinutes = -99;
    private int endHours = -99;
    private int endMinutes = -99;
    private List<Identity> members = null;
    private Calendar beginTime = null;
    private long beginMillis = 0L;
    private Calendar endTime = null;
    private long endMillis = 0L;
    private boolean disabled = false;
    private boolean exclusive = false;
    private int hash = 0;
    private boolean active = false;
    private boolean endAtMidnight = false;
    private final int FUDGE_FACTOR = 327;
    private boolean destroy = false;
    private Alarm theAlarm = null;
    private static boolean displayErrors;

    public TimePeriodRule(Integer startHours, Integer startMinutes, Integer stopHours, Integer stopMinutes, List<Identity> clusterMembers, boolean exclusive) {
        IllegalArgumentException iae;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{(startHours == null ? "null" : startHours.toString()) + " " + (startMinutes == null ? "null" : startMinutes.toString()) + " " + (stopHours == null ? "null" : stopHours.toString()) + " " + (stopMinutes == null ? "null" : stopMinutes.toString()), clusterMembers, String.valueOf(exclusive)});
        }
        if (startHours == null || startMinutes == null || stopHours == null || stopMinutes == null) {
            this.disabled = true;
            if (startHours == null || startMinutes == null) {
                iae = new IllegalArgumentException("The start time is invalid.");
                FFDCFilter.processException(iae, TimePeriodRule.class.getName() + "<init>", "120");
            }
            if (stopHours == null || stopMinutes == null) {
                iae = new IllegalArgumentException("The end time is invalid.");
                FFDCFilter.processException(iae, TimePeriodRule.class.getName() + "<init>", "125");
            }
        } else if (startHours < 0 || startHours > 23 || startMinutes < 0 || startMinutes > 59 || stopHours < 0 || stopHours > 23 || stopMinutes < 0 || stopMinutes > 59) {
            this.disabled = true;
            iae = new IllegalArgumentException("The times specified, start time: " + startHours + ":" + startMinutes + ", end time: " + stopHours + ":" + stopMinutes + " are outside the valid ranges of 0 - 23 for hours and 0 - 59 for minutes");
            FFDCFilter.processException(iae, TimePeriodRule.class.getName() + "<init>", "139");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "<init>", "The times specified: " + startHours + ":" + startMinutes + "  and " + stopHours + ":" + stopMinutes + " are outside of the valid ranges.");
            }
            if (displayErrors) {
                Tr.warning(tc, "WLMKEY_MALFORMEDTIMEPERIODRULE", new Object[]{String.valueOf(startHours) + ":" + String.valueOf(startMinutes), String.valueOf(stopHours) + ":" + String.valueOf(stopMinutes)});
            }
        } else if ((startHours != 0 || startMinutes != 0) && stopHours == 0 && stopMinutes == 0) {
            this.endAtMidnight = true;
        } else if (startHours.intValue() == stopHours.intValue() && stopMinutes <= startMinutes || stopHours < startHours) {
            this.disabled = true;
            iae = new IllegalArgumentException("The end time: " + stopHours + ":" + stopMinutes + " must be greater than the begin time: " + startHours + ":" + startMinutes);
            FFDCFilter.processException(iae, TimePeriodRule.class.getName() + "<init>", "147");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "<init>", "The end time: " + stopHours + ":" + stopMinutes + " must be greater than the begin time: " + startHours + ":" + stopMinutes + ".  Disabling the rule.");
            }
            if (displayErrors) {
                Tr.warning(tc, "WLMKEY_MALFORMEDTIMEPERIODRULE", new Object[]{String.valueOf(startHours) + ":" + String.valueOf(startMinutes), String.valueOf(stopHours) + ":" + String.valueOf(stopMinutes)});
            }
        }
        if (startHours != null) {
            this.beginHours = startHours;
        }
        if (startMinutes != null) {
            this.beginMinutes = startMinutes;
        }
        if (stopHours != null) {
            this.endHours = stopHours;
        }
        if (stopMinutes != null) {
            this.endMinutes = stopMinutes;
        }
        this.members = clusterMembers;
        if (this.members == null) {
            this.members = new ArrayList<Identity>();
        }
        this.exclusive = exclusive;
        if (!this.disabled) {
            this.beginTime = Calendar.getInstance();
            this.beginTime.setLenient(true);
            this.beginTime.set(11, this.beginHours);
            this.beginTime.set(12, this.beginMinutes);
            this.beginTime.set(13, 1);
            this.beginTime.set(14, 0);
            this.beginMillis = this.beginTime.getTimeInMillis();
            this.endTime = Calendar.getInstance();
            this.endTime.setLenient(true);
            if (this.endAtMidnight) {
                this.endTime.add(5, 1);
            }
            this.endTime.set(11, this.endHours);
            this.endTime.set(12, this.endMinutes);
            this.endTime.set(13, 1);
            this.endTime.set(14, 0);
            this.endMillis = this.endTime.getTimeInMillis();
            long currentTime = System.currentTimeMillis();
            this.setupNextAlarm(currentTime);
            int exclusiveHash = 0;
            if (exclusive) {
                exclusiveHash = 10000000;
            }
            this.hash = ((Object)this.members).hashCode() + this.beginHours + this.beginMinutes * 24 + this.endHours * 1440 + this.endMinutes * 34560 + exclusiveHash;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", String.valueOf(this.beginMillis) + " " + String.valueOf(this.endMillis) + " " + String.valueOf(this.disabled));
        }
    }

    @Override
    public void subset(List identities, StringBuffer reason) {
        block5: {
            if (this.disabled) {
                return;
            }
            if (!this.ruleActive(0L)) break block5;
            if (!this.exclusive) {
                Iterator identityIter = identities.iterator();
                while (identityIter.hasNext()) {
                    Identity identity = (Identity)identityIter.next();
                    if (this.members.contains(identity)) continue;
                    identityIter.remove();
                    reason.append(identity + " removed: Not in this rule's list of acceptable servers");
                }
            } else {
                Iterator identityIter = identities.iterator();
                while (identityIter.hasNext()) {
                    Identity identity = (Identity)identityIter.next();
                    if (!this.members.contains(identity)) continue;
                    identityIter.remove();
                    reason.append(identity + " removed: In this rule's list of servers to exclude");
                }
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof TimePeriodRule) {
            TimePeriodRule other = (TimePeriodRule)object;
            if (other.beginHours == this.beginHours && other.beginMinutes == this.beginMinutes && other.endHours == this.endHours && other.endMinutes == this.endMinutes && other.exclusive == this.exclusive && ((Object)other.members).equals(this.members)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{[beginHours: ");
        sb.append(this.beginHours);
        sb.append(", beginMinutes: ");
        sb.append(this.beginMinutes);
        sb.append(", endHours: ");
        sb.append(this.endHours);
        sb.append(", endMinutes: ");
        sb.append(this.endMinutes);
        sb.append(", beginMillis: ");
        sb.append(this.beginMillis);
        sb.append(", endMillis: ");
        sb.append(this.endMillis);
        sb.append(", ruleActive: ");
        sb.append(this.ruleActive(0L));
        sb.append(", disabled: ");
        sb.append(this.disabled);
        sb.append(", exclusive: ");
        sb.append(this.exclusive);
        sb.append("]\n");
        Iterator<Identity> memberIterator = this.members.iterator();
        while (memberIterator.hasNext()) {
            sb.append(memberIterator.next().toString());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void alarm(Object alarmContext) {
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < this.arbitrator.length; ++i) {
            this.arbitrator[i].triggerRuleUpdate();
        }
        this.setupNextAlarm(currentTime);
    }

    private void setupNextAlarm(long currentMillis) {
        if (this.beginMillis <= currentMillis && currentMillis < this.endMillis) {
            long endDelayTime = this.endMillis - currentMillis;
            if (endDelayTime > 327L) {
                if (!this.destroy) {
                    this.theAlarm = AlarmManager.createNonDeferrable(this.endMillis - currentMillis, this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setupNextAlarm", "inside time range; delay: " + (this.endMillis - currentMillis));
                }
            } else {
                this.setupTomorrowsBeginAlarm(currentMillis);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setupNextAlarm", "inside endTime FUDGE_FACTOR; delay: " + (this.beginMillis - currentMillis));
                }
            }
        } else if (currentMillis <= this.beginMillis) {
            long beginDelayTime = this.beginMillis - currentMillis;
            if (beginDelayTime > 327L) {
                if (!this.destroy) {
                    this.theAlarm = AlarmManager.createNonDeferrable(beginDelayTime, this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setupNextAlarm", "outside beginTime FUDGE_FACTOR; delay: " + beginDelayTime);
                }
            } else {
                if (!this.destroy) {
                    this.theAlarm = AlarmManager.createNonDeferrable(this.endMillis - currentMillis, this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setupNextAlarm", "inside beginTime FUDGE_FACTOR; delay: " + (this.endMillis - currentMillis));
                }
            }
        } else if (currentMillis >= this.endMillis) {
            this.setupTomorrowsBeginAlarm(currentMillis);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setupNextAlarm", "past time range; delay: " + (this.beginMillis - currentMillis));
            }
        }
    }

    private void setupTomorrowsBeginAlarm(long currentMillis) {
        this.beginTime.add(5, 1);
        this.beginMillis = this.beginTime.getTimeInMillis();
        if (!this.destroy) {
            this.theAlarm = AlarmManager.createNonDeferrable(this.beginMillis - currentMillis, this);
        }
        this.endTime.add(5, 1);
        this.endMillis = this.endTime.getTimeInMillis();
    }

    public boolean ruleActive(long currentMillis) {
        if (this.disabled) {
            this.active = false;
            return false;
        }
        if (currentMillis == 0L) {
            return this.active;
        }
        long beginDelayTime = this.beginMillis - currentMillis;
        if ((beginDelayTime <= 327L || this.beginMillis <= currentMillis) && currentMillis < this.endMillis - 327L) {
            this.active = true;
            return true;
        }
        this.active = false;
        return false;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public List<Identity> getMemberList() {
        return this.members;
    }

    public void setDestroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setDestroy");
        }
        this.destroy = true;
        if (this.theAlarm != null) {
            this.theAlarm.cancel();
        }
    }

    public static void suppressErrors() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "suppressErrors");
        }
        displayErrors = false;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.11 ");
        }
        displayErrors = true;
    }
}

