/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import java.util.Iterator;
import java.util.List;

public class QuiesceRule
implements SelectionRule {
    private static final TraceComponent tc = Tr.register(QuiesceRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private final DescriptionKey clusterKey;
    private ClusterDescription myClusterDescription = null;
    private RuleArbitrator arbitrator = null;

    public QuiesceRule(Identity cluster) {
        this.clusterKey = (DescriptionKey)cluster;
        this.myClusterDescription = (ClusterDescription)descMgr.getDescription(this.clusterKey);
    }

    public void subset(List identities, StringBuffer reason) {
        if (this.myClusterDescription == null) {
            this.myClusterDescription = (ClusterDescription)descMgr.getDescription(this.clusterKey);
            if (this.myClusterDescription == null) {
                return;
            }
        }
        Iterator iter = identities.iterator();
        while (iter.hasNext()) {
            Identity memberIdentity = (Identity)iter.next();
            ClusterDescription.Memento myMemento = (ClusterDescription.Memento)this.myClusterDescription.getMemento();
            if (!myMemento.isQuiesced(memberIdentity)) continue;
            iter.remove();
            reason.append(memberIdentity);
            reason.append(" removed: Member is quiesced. ");
        }
    }

    public void registerRuleArbitrator(RuleArbitrator coordinator) {
        this.arbitrator = coordinator;
        this.arbitrator.registerNotificationType(this, this.clusterKey, "type.quiesce.state.changed");
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.5 ");
        }
    }
}

