/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EndPointRule
extends DefaultRule {
    private static final TraceComponent tc = Tr.register(EndPointRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService;
    private Map endpoints;

    public EndPointRule(Map endpointMap) {
        if (endpointMap == null) {
            throw new IllegalArgumentException("The endpointMap must not be null.");
        }
        this.endpoints = endpointMap;
    }

    public void subset(List identities, StringBuffer reason) {
        Iterator iter = identities.iterator();
        while (iter.hasNext()) {
            Identity memberIdentity = (Identity)iter.next();
            ClusterMemberDescription member = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)memberIdentity);
            this.registerNotificationType(memberIdentity, "type.add.extrinsic");
            this.registerNotificationType(memberIdentity, "type.remove.extrinsic");
            if (member == null) continue;
            ClusterMemberDescription.Memento cmdMemento = (ClusterMemberDescription.Memento)member.getMemento();
            if (cmdMemento.isLeaf()) {
                int availableEndPoints;
                EndPoint[] eps = clusterService.matchEndPoints(memberIdentity, this.endpoints);
                int n = availableEndPoints = eps == null ? 0 : eps.length;
                if (availableEndPoints > 0) {
                    for (int i = 0; i < eps.length; ++i) {
                        this.registerNotificationType(eps[i].getIdentity(), "type.state.change.reachability");
                        if (eps[i].isAvailable()) continue;
                        --availableEndPoints;
                    }
                }
                if (availableEndPoints != 0) continue;
                iter.remove();
                reason.append(memberIdentity);
                reason.append(" removed: Lack of available end point  ");
                reason.append(this.endpoints);
                reason.append(' ');
                continue;
            }
            this.registerNotificationType(memberIdentity, "member.added");
            this.registerNotificationType(memberIdentity, "member.removed");
            ClusterDescription.Memento cdMemento = (ClusterDescription.Memento)cmdMemento;
            ArrayList members = new ArrayList(cdMemento.getMembers().keySet());
            StringBuffer subreason = new StringBuffer();
            this.subset(members, subreason);
            if (members.size() != 0) continue;
            iter.remove();
            reason.append(memberIdentity);
            reason.append(" removed: Lack of subordinates matching end point [");
            reason.append(subreason);
            reason.append(']');
        }
    }

    public boolean equals(Object object) {
        return ((Object)this.endpoints).equals(object);
    }

    public int hashCode() {
        return ((Object)this.endpoints).hashCode();
    }

    public String toString() {
        return EndPointRule.class.getName() + '#' + System.identityHashCode(this) + '[' + this.endpoints + ']';
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.8 ");
        }
        clusterService = ClusterServiceFactory.getClusterService();
    }
}

