/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import java.util.Iterator;
import java.util.List;

public class DefaultRule
implements SelectionRule {
    private static final TraceComponent tc = Tr.register(DefaultRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    protected static final DescriptionManager descMgr;
    protected RuleArbitrator[] arbitrator = new RuleArbitrator[0];
    private final Object arbitratorMutex = new Object();

    public void subset(List identities, StringBuffer reason) {
        Iterator iter = identities.iterator();
        while (iter.hasNext()) {
            DescriptionKey element = (DescriptionKey)iter.next();
            Description member = descMgr.getDescription(element);
            if (member != null) continue;
            iter.remove();
            reason.append(element + " removed: Did not contain any member information. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRuleArbitrator(RuleArbitrator coordinator) {
        if (coordinator == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "registerRuleArbitrator: coordinator is null");
            }
            return;
        }
        Object object = this.arbitratorMutex;
        synchronized (object) {
            int length = this.arbitrator.length;
            RuleArbitrator[] local_arbitrator = new RuleArbitrator[length + 1];
            System.arraycopy(this.arbitrator, 0, local_arbitrator, 0, length);
            local_arbitrator[length] = coordinator;
            this.arbitrator = local_arbitrator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNotificationType(Identity instance, String notificationType) {
        RuleArbitrator[] local_arbitrator;
        Object object = this.arbitratorMutex;
        synchronized (object) {
            local_arbitrator = this.arbitrator;
        }
        for (int i = 0; i < local_arbitrator.length; ++i) {
            if (local_arbitrator[i] != null) {
                local_arbitrator[i].registerNotificationType(this, instance, notificationType);
                continue;
            }
            if (!tc.isEventEnabled()) continue;
            Tr.event(tc, "registerNotificationType: local_arbitrator[i] is null i = ", String.valueOf(i));
        }
    }

    public boolean equals(Object object) {
        return this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.19 ");
        }
        descMgr = DescriptionManagerFactory.getDescriptionManager();
    }
}

