/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.bootstrap;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.bootstrap.NlvPrintStream;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.security.util.AccessController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import org.eclipse.core.launcher.Main;

public class WSPreLauncher {
    private static Thread shutdownHook = new OnExit();
    static final String WAS_INSTALL_ROOT = "was.install.root";
    static final String USER_INSTALL_ROOT = "user.install.root";
    static final String OSGI_INSTALL = "osgi.install.area";
    static final String OSGI_CONFIG = "osgi.configuration.area";
    static final String OSGI_INSTANCE = "osgi.instance.area";
    private static String osgiInstanceArea = null;
    static final String WAS_PROPERTY_FILE = "cmd.properties.file";
    static final String OSGI_TRACE = "ws.osgi.debug";
    static final String CONFIG_INI = "configuration" + File.separatorChar + "config.ini";
    static final String OSGI_CFGINI_OVERRIDE = "user.osgi.cfgini.file";
    static final String OSGI_CONFIG_AREA_READONLY = "osgi.configuration.area.readOnly";
    static final String OSGI_CLEAN_CFG = "osgi.clean";
    static final String OSGI_DEBUG = "osgi.debug";
    static final String PROP_CLASSPATH = "osgi.frameworkClassPath";
    static String[] passedArgs = null;
    public static String osgiCfgDir = null;
    private static PrintStream originalSystemErr = System.err;
    private static final String S_JAVA_FILE_ENCODING_PROPERTY = "file.encoding";
    private static final String S_JAVA_USER_LANGUAGE_PROPERTY = "user.language";
    private static final String S_SERBIAN_CYRILLIC_USER_LANGUAGE_KEY = "sr";
    private static final String S_CP720 = "Cp720";
    private static final String S_CP737 = "Cp737";
    private static final String S_CP775 = "Cp775";
    private static final String S_CP850 = "Cp850";
    private static final String S_CP852 = "Cp852";
    private static final String S_CP855 = "Cp855";
    private static final String S_CP857 = "Cp857";
    private static final String S_CP862 = "Cp862";
    private static final String S_CP866 = "Cp866";
    private static final String S_CP1047 = "Cp1047";
    private static final String S_CP1250 = "Cp1250";
    private static final String S_CP1251 = "Cp1251";
    private static final String S_CP1252 = "Cp1252";
    private static final String S_CP1253 = "Cp1253";
    private static final String S_CP1254 = "Cp1254";
    private static final String S_CP1255 = "Cp1255";
    private static final String S_CP1256 = "Cp1256";
    private static final String S_CP1257 = "Cp1257";

    public static void main(String[] args) throws IOException {
        WSPreLauncher.setConsoleEncoding();
        WSPreLauncher.setImplicitProperties();
        String[] newArgs = WSPreLauncher.processArgsIn(args);
        WSPreLauncher.launchEclipse(newArgs);
    }

    public static PrintStream getOriginalSystemErrStream() {
        return originalSystemErr;
    }

    private static void setConsoleEncoding() {
        block5: {
            String encoding = System.getProperty("ws.output.encoding");
            if (encoding != null && !encoding.equals("file")) {
                if (encoding.equals("console")) {
                    String currentEncoding = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
                    encoding = currentEncoding.equalsIgnoreCase(S_CP1252) ? S_CP850 : null;
                }
                if (encoding != null) {
                    try {
                        System.setOut(new NlvPrintStream((OutputStream)System.out, true, encoding));
                        System.setErr(new NlvPrintStream((OutputStream)System.err, true, encoding));
                    }
                    catch (UnsupportedEncodingException ex) {
                        if (!LoggingServices.debugEnabled) break block5;
                        ex.printStackTrace(LoggingServices.out);
                    }
                }
            }
        }
        LoggingServices.out = System.out;
    }

    private static String[] processArgsIn(String[] args) {
        int pos;
        String osgiTrace;
        if (LoggingServices.debugEnabled) {
            for (int i = 0; i < args.length; ++i) {
                LoggingServices.out.println("ws.ext.mains.args[" + i + "]=" + args[i]);
            }
        }
        if (WSPreLauncher.configurationIsStale()) {
            WSPreLauncher.debug("Setting    osgiCfg_property[osgi.clean]=true - due to stale configuration");
            System.setProperty(OSGI_CLEAN_CFG, "true");
        }
        if ((osgiTrace = System.getProperty(OSGI_TRACE)) != null && osgiTrace.equals("")) {
            osgiTrace = WSPreLauncher.getWasInstallRoot() + "/properties/osgi.debug.options";
        }
        boolean foundIt = false;
        for (pos = 0; pos < args.length && !foundIt; ++pos) {
            foundIt = args[pos].equals("-application");
        }
        if (foundIt) {
            int osgiLength = pos + 1;
            int passedLength = args.length - osgiLength;
            String[] osgi_args = new String[osgiLength];
            int osgiAdjustedLength = 0;
            for (int cnt = 0; cnt < osgiLength; ++cnt) {
                if (args[cnt].equals("-clean")) {
                    WSPreLauncher.debug("Setting    osgiCfg_property[osgi.clean]=true - param provided.");
                    System.setProperty(OSGI_CLEAN_CFG, "true");
                    continue;
                }
                if (args[cnt].equals("-debug")) {
                    osgiTrace = args[cnt + 1].startsWith("-") ? WSPreLauncher.getWasInstallRoot() + "/properties/osgi.debug.options" : args[++cnt];
                    continue;
                }
                osgi_args[osgiAdjustedLength++] = args[cnt];
            }
            String[] osgi_adj_args = new String[osgiAdjustedLength];
            System.arraycopy(osgi_args, 0, osgi_adj_args, 0, osgiAdjustedLength);
            passedArgs = new String[passedLength];
            System.arraycopy(args, osgiLength, passedArgs, 0, passedLength);
            if (LoggingServices.debugEnabled) {
                int i;
                for (i = 0; i < osgiAdjustedLength; ++i) {
                    LoggingServices.out.println("osgi_args[" + i + "]=" + osgi_args[i]);
                }
                for (i = 0; i < passedLength; ++i) {
                    LoggingServices.out.println("passedArgs[" + i + "]=" + passedArgs[i]);
                }
            }
            args = osgi_adj_args;
        } else {
            LoggingServices.trace("WSVR0703W", "com.ibm.ws.bootstrap.WSLauncher");
        }
        if (osgiTrace != null) {
            WSPreLauncher.debug("Turning    osgiCfg_property[osgi.debug] on. Option file=" + osgiTrace);
            System.setProperty(OSGI_DEBUG, osgiTrace);
        }
        return args;
    }

    public static String[] processArgsOut(String[] args) {
        if (passedArgs != null) {
            args = passedArgs;
        }
        return args;
    }

    private static void setImplicitProperties() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WSPreLauncher.processPropertiesFile();
                if (System.getProperty(WSPreLauncher.OSGI_INSTALL) == null) {
                    String was_install_root = WSPreLauncher.getWasInstallRoot();
                    if (was_install_root != null) {
                        System.setProperty(WSPreLauncher.OSGI_INSTALL, was_install_root);
                        WSPreLauncher.debug("Implicitly setting -Dosgi.install.area=" + System.getProperty(WSPreLauncher.OSGI_INSTALL));
                    } else {
                        WSPreLauncher.debug("WARNING: The system property was.install.root is not set.");
                    }
                }
                if (System.getProperty(WSPreLauncher.OSGI_CONFIG) == null) {
                    String config_root = WSPreLauncher.getOsgiConfigRoot();
                    if (config_root != null) {
                        System.setProperty(WSPreLauncher.OSGI_CONFIG, config_root);
                        WSPreLauncher.debug("Implicitly setting -Dosgi.configuration.area=" + System.getProperty(WSPreLauncher.OSGI_CONFIG));
                    } else {
                        WSPreLauncher.debug("WARNING: The system properties user.install.root and was.install.root are not set.");
                    }
                }
                if (System.getProperty(WSPreLauncher.OSGI_INSTANCE) == null) {
                    osgiInstanceArea = WSPreLauncher.getOsgiInstanceRoot();
                    if (osgiInstanceArea != null) {
                        System.setProperty(WSPreLauncher.OSGI_INSTANCE, osgiInstanceArea);
                        Runtime.getRuntime().addShutdownHook(shutdownHook);
                        WSPreLauncher.debug("Implicitly setting -Dosgi.instance.area=" + System.getProperty(WSPreLauncher.OSGI_INSTANCE));
                    } else {
                        WSPreLauncher.debug("WARNING: The system properties user.install.root and was.install.root are not set.");
                    }
                }
                return null;
            }
        });
    }

    private static void launchEclipse(String[] newArgs) throws IOException {
        String osgiCfgName = System.getProperty(OSGI_CFGINI_OVERRIDE, WSPreLauncher.getOsgiInstallRoot() + File.separatorChar + CONFIG_INI);
        File osgiCfgFile = new File(osgiCfgName);
        WSPreLauncher.debug("Loading OSGi properties from " + osgiCfgFile.toString());
        WSPreLauncher.mergeOsgiPropsWithSystemProps(osgiCfgFile);
        osgiCfgDir = System.getProperty(OSGI_CONFIG);
        Main main = new Main();
        main.run(newArgs);
    }

    private static String getWasInstallRoot() {
        return System.getProperty(WAS_INSTALL_ROOT);
    }

    private static String getUserInstallRoot() {
        return System.getProperty(USER_INSTALL_ROOT);
    }

    private static String getOsgiConfigRoot() {
        String result = System.getProperty(OSGI_CONFIG);
        if (result == null) {
            result = WSPreLauncher.getUserInstallRoot();
            if (result == null && (result = WSPreLauncher.getWasInstallRoot()) == null) {
                result = WSPreLauncher.getOsgiInstallRoot();
            }
            if (result != null) {
                result = result + "/configuration";
            }
        }
        return result;
    }

    private static String getOsgiInstallRoot() {
        String result = System.getProperty(OSGI_INSTALL);
        if (result == null) {
            result = WSPreLauncher.getWasInstallRoot();
        }
        return result;
    }

    private static String getOsgiInstanceRoot() {
        String result = System.getProperty(OSGI_INSTANCE);
        if (result == null && WSPreLauncher.getUserInstallRoot() != null && !WSPreLauncher.getUserInstallRoot().equals(WSPreLauncher.getWasInstallRoot())) {
            result = WSPreLauncher.getOsgiTmpDir(WSPreLauncher.getUserInstallRoot() + File.separator + "temp");
        }
        if (result == null) {
            result = WSPreLauncher.getOsgiTmpDir(System.getProperty("java.io.tmpdir"));
        }
        return result;
    }

    private static String getOsgiTmpDir(String result) {
        String uid = System.getProperty("user.name");
        if (uid == null) {
            uid = "default";
        }
        Random generator = new Random();
        result = result + File.separator + "osgi_instance_location" + File.separator + uid + File.separator;
        File osgiTmp = new File(result + generator.nextInt(Integer.MAX_VALUE));
        while (!osgiTmp.mkdirs()) {
            if (!osgiTmp.exists()) {
                return null;
            }
            osgiTmp = new File(result + generator.nextInt(Integer.MAX_VALUE));
        }
        result = osgiTmp.getAbsolutePath();
        WSPreLauncher.debug("osgi.instance.area has been set to: " + result);
        return result;
    }

    private static void debug(String msg) {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println(msg);
        }
    }

    private static boolean configurationIsStale() {
        File lastUpdateIndicator = new File(WSPreLauncher.getWasInstallRoot() + "/properties/version/nif/backup/NIFHistory.xml");
        File lastTouched = new File(WSPreLauncher.getOsgiConfigRoot() + "/.lastTouched");
        if (lastUpdateIndicator.exists() && lastTouched.exists() && lastUpdateIndicator.lastModified() < lastTouched.lastModified()) {
            return false;
        }
        return lastUpdateIndicator.exists();
    }

    public static void processPropertiesFile() {
        String propFile;
        if (WSLauncher.isWindows() && (propFile = System.getProperty(WAS_PROPERTY_FILE)) != null) {
            try {
                String line;
                String OSEncoding = WSPreLauncher.getProperEncodingForCurrentOSShellScripts();
                WSPreLauncher.debug("OSEncoding is " + OSEncoding);
                FileInputStream fis = new FileInputStream(new File(propFile));
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, OSEncoding));
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    line.trim();
                    int colon = line.indexOf(61);
                    String key = line.substring(0, colon);
                    String value2 = line.substring(colon + 1);
                    WSPreLauncher.debug("Key is " + key + ", value is " + value2);
                    if (System.getProperty(key) != null) continue;
                    WSPreLauncher.debug("Adding key " + key);
                    System.setProperty(key, value2);
                }
                in.close();
                fis.close();
            }
            catch (IOException e) {
                WSPreLauncher.debug("WARNING: IOException processing properties file: " + e);
                e.printStackTrace(LoggingServices.out);
            }
        }
    }

    private static String getProperEncodingForCurrentOSShellScripts() {
        String sEncoding = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
        if (WSLauncher.isWindows()) {
            return WSPreLauncher.lookupEncoding(sEncoding);
        }
        if (WSLauncher.isZOS()) {
            return S_CP1047;
        }
        return sEncoding;
    }

    private static String lookupEncoding(String currentEncoding) {
        if (currentEncoding.equalsIgnoreCase(S_CP1252)) {
            return S_CP850;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1251)) {
            if (WSPreLauncher.isSerbianCyrillic()) {
                return S_CP855;
            }
            return S_CP866;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1250)) {
            return S_CP852;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1253)) {
            return S_CP737;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1254)) {
            return S_CP857;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1255)) {
            return S_CP862;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1256)) {
            return S_CP720;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1257)) {
            return S_CP775;
        }
        return currentEncoding;
    }

    private static boolean isSerbianCyrillic() {
        String userLanguage = System.getProperty(S_JAVA_USER_LANGUAGE_PROPERTY);
        return userLanguage.equalsIgnoreCase(S_SERBIAN_CYRILLIC_USER_LANGUAGE_KEY);
    }

    static void onExit() {
        WSPreLauncher.deleteEclipseInstanceArea(new File(osgiInstanceArea));
    }

    private static boolean deleteEclipseInstanceArea(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = WSPreLauncher.deleteEclipseInstanceArea(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static void mergeOsgiPropsWithSystemProps(File cfgFile) throws IOException {
        Properties cfgIniProps = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(cfgFile);
            cfgIniProps.load(fis);
        }
        catch (IOException e1) {
            WSPreLauncher.debug("WARNING: IOException processing config.ini file: " + e1);
            e1.printStackTrace(LoggingServices.out);
            throw e1;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        WSPreLauncher.mergeProperties(System.getProperties(), cfgIniProps);
        if (Boolean.getBoolean(OSGI_CLEAN_CFG) && Boolean.getBoolean(OSGI_CONFIG_AREA_READONLY)) {
            WSPreLauncher.debug("Overriding osgiCfg_property[osgi.configuration.area.readOnly]=false");
            System.setProperty(OSGI_CONFIG_AREA_READONLY, "false");
        }
    }

    private static void mergeProperties(Properties destination, Properties source) {
        if (destination == null || source == null) {
            return;
        }
        Enumeration<Object> e = source.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals(PROP_CLASSPATH)) {
                String destinationClasspath = destination.getProperty(PROP_CLASSPATH);
                String sourceClasspath = source.getProperty(PROP_CLASSPATH);
                if (destinationClasspath == null) {
                    WSPreLauncher.debug("Setting    osgiCfg_property[osgi.frameworkClassPath]=" + destinationClasspath);
                    destinationClasspath = sourceClasspath;
                } else {
                    WSPreLauncher.debug("Merging    osgiCfg_property[osgi.frameworkClassPath]=" + destinationClasspath);
                    destinationClasspath = destinationClasspath + sourceClasspath;
                }
                destination.put(PROP_CLASSPATH, destinationClasspath);
                continue;
            }
            String value2 = source.getProperty(key);
            if (destination.getProperty(key) == null) {
                WSPreLauncher.debug("Setting    osgiCfg_property[" + key + "]=" + value2);
                destination.put(key, value2);
                continue;
            }
            WSPreLauncher.debug("Ignoring   osgiCfg_property[" + key + "]=" + value2 + " - property was already set.");
        }
    }

    private static class OnExit
    extends Thread {
        private OnExit() {
        }

        public void run() {
            WSPreLauncher.onExit();
        }
    }
}

