/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.wsaddressing.component.WSAddressingBaseServiceImpl;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.ws.wsaddressing.urimap.Prefix;
import com.ibm.ws.wsaddressing.urimap.TransportChannelServiceHelper;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataChannelHelper {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.urimap.MetaDataChannelHelper";
    private static TraceComponent _tc = Tr.register(MetaDataChannelHelper.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static List<WSAddressingBaseService.Prefix> _webContainerPortList = new ArrayList<WSAddressingBaseService.Prefix>();
    private static List<WSAddressingBaseService.Prefix> _proxyPortList = new ArrayList<WSAddressingBaseService.Prefix>();
    private static boolean _initialized = false;
    private static boolean _failed = false;
    private static String _hostName;
    private static EndPointMgr epm;
    private static EndPointMgr.ServerEndPoints _currentServerEndpoints;
    private static List<EndPointMgr.ServerEndPoints> _onNodeProxyServers;
    private static List<EndPointMgr.ServerEndPoints> _offNodeProxyServers;
    private static Map<EndPointMgr.ServerEndPoints, String> _proxiesToNodes;

    private static synchronized void initialize() {
        block5: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "initialize");
            }
            if (!_initialized && !_failed) {
                try {
                    Server process = WSAddressingBaseServiceImpl.getInstance().getCurrentServer();
                    String serverName = process.getName();
                    String nodeName = process.getNodeName();
                    MetaDataChannelHelper.processServers(nodeName, serverName);
                    MetaDataChannelHelper.loadHTTPPortsFromV5Template();
                    MetaDataChannelHelper.loadHTTPPortsFromV6Template();
                    MetaDataChannelHelper.loadProxyHttpPorts();
                    _initialized = true;
                }
                catch (Exception e) {
                    _failed = true;
                    FFDCFilter.processException(e, CLASSNAME, "1:123:1.8");
                    if (!_tc.isDebugEnabled()) break block5;
                    Tr.debug(_tc, "initialize caught exeption ", e);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initialize");
        }
    }

    private static void processServers(String nodeName, String serverName) throws Exception {
        epm = WsServiceRegistry.getService(MetaDataChannelHelper.class, EndPointMgr.class);
        _hostName = epm.getNodeHostName(nodeName);
        Map nodeEndpointMap = epm.getNodeEndPoints();
        for (Map.Entry nodeEntry : nodeEndpointMap.entrySet()) {
            EndPointMgr.ServerEndPoints sep;
            Map serverEndpointMap;
            if (((String)nodeEntry.getKey()).equals(nodeName)) {
                serverEndpointMap = ((EndPointMgr.NodeEndPoints)nodeEntry.getValue()).getServerEndPoints();
                for (Map.Entry serverEntry : serverEndpointMap.entrySet()) {
                    sep = (EndPointMgr.ServerEndPoints)serverEntry.getValue();
                    if (_currentServerEndpoints == null && ((String)serverEntry.getKey()).equals(serverName)) {
                        _currentServerEndpoints = sep;
                    }
                    if (!"PROXY_SERVER".equals(sep.getType())) continue;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding on-node proxy server: " + sep.getName() + " node: " + (String)nodeEntry.getKey());
                    }
                    _onNodeProxyServers.add(sep);
                }
                continue;
            }
            serverEndpointMap = ((EndPointMgr.NodeEndPoints)nodeEntry.getValue()).getServerEndPoints();
            for (Map.Entry serverEntry : serverEndpointMap.entrySet()) {
                sep = (EndPointMgr.ServerEndPoints)serverEntry.getValue();
                if (!"PROXY_SERVER".equals(sep.getType())) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding off-node proxy server: " + sep.getName() + " node: " + (String)nodeEntry.getKey());
                }
                _offNodeProxyServers.add(sep);
                _proxiesToNodes.put(sep, ((EndPointMgr.NodeEndPoints)nodeEntry.getValue()).getName());
            }
        }
    }

    private static void loadProxyHttpPorts() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadProxyHttpPorts");
        }
        for (EndPointMgr.ServerEndPoints sep : _onNodeProxyServers) {
            Map<String, String> endPointMap = TransportChannelServiceHelper.getLocalNodeProxyEndPointMap(sep.getName());
            MetaDataChannelHelper.mergeV6EndPoints2Ports(sep, endPointMap, _proxyPortList, true);
        }
        if (_proxyPortList.isEmpty()) {
            Map<String, String> endPointMap = TransportChannelServiceHelper.getRemoteNodeProxyEndPointMap();
            for (EndPointMgr.ServerEndPoints sep : _offNodeProxyServers) {
                MetaDataChannelHelper.mergeV6EndPoints2Ports(sep, endPointMap, _proxyPortList, true);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadProxyHttpPorts");
        }
    }

    private static void loadHTTPPortsFromV6Template() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadHTTPPortsFromV6Template");
        }
        Map<String, String> endPointMap = TransportChannelServiceHelper.getLocalWebContainerEndPointMap();
        MetaDataChannelHelper.mergeV6EndPoints2Ports(_currentServerEndpoints, endPointMap, _webContainerPortList, false);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadHTTPPortsFromV6Template");
        }
    }

    private static void mergeV6EndPoints2Ports(EndPointMgr.ServerEndPoints seps, Map<String, String> endPointMap, List<WSAddressingBaseService.Prefix> portList, boolean intermediary) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "mergeV6EndPoints2Ports", new Object[]{endPointMap, portList});
        }
        Map endpointInfo = seps.getEndPointInfo();
        for (Map.Entry entry : endpointInfo.entrySet()) {
            String protocol2 = endPointMap.get(entry.getKey());
            if (protocol2 == null || protocol2.length() <= 0) continue;
            int portNum = ((EndPointMgr.EndPointInfo)entry.getValue()).getPort();
            String port2 = Integer.valueOf(portNum).toString();
            String host = ((EndPointMgr.EndPointInfo)entry.getValue()).getHost();
            if (host.equals("*")) {
                String nodeName;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "For server: " + seps.getName() + " host was *");
                }
                if ((nodeName = _proxiesToNodes.get(seps)) != null && epm != null) {
                    host = epm.getNodeHostName(nodeName);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting host for off-node: " + nodeName + ": " + host);
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Defaulting host name to current node host: " + _hostName);
                    }
                    host = _hostName;
                }
            }
            portList.add(new Prefix(protocol2, host, port2));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "mergeV6EndPoints2Ports");
        }
    }

    private static void loadHTTPPortsFromV5Template() {
        block8: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "loadHTTPPortsFromV5Template");
            }
            try {
                ConfigService configService = WsServiceRegistry.getService(MetaDataChannelHelper.class, ConfigService.class);
                ConfigScope cscope = configService.createScope(4);
                ConfigObject s = (ConfigObject)configService.getDocumentObjects(cscope, "server.xml", false).get(0);
                List components = s.getObjectList("components");
                ConfigObject webContainer = null;
                boolean found = false;
                Iterator it = components.iterator();
                block2: while (it.hasNext() && !found) {
                    ConfigObject component = (ConfigObject)it.next();
                    if (!component.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.xmi", "ApplicationServer")) continue;
                    List components1 = component.getObjectList("components");
                    for (ConfigObject component1 : components1) {
                        if (!component1.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.webcontainer.xmi", "WebContainer")) continue;
                        webContainer = component1;
                        found = true;
                        continue block2;
                    }
                }
                if (webContainer != null && found) {
                    List transports = webContainer.getObjectList("transports");
                    for (ConfigObject transport2 : transports) {
                        ConfigObject ep;
                        if (!transport2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.webcontainer.xmi", "HTTPTransport") || (ep = transport2.getObject("address")) == null) continue;
                        int portNum = ep.getInt("port", 0);
                        String port2 = Integer.valueOf(portNum).toString();
                        boolean isSSLEnabled = transport2.getBoolean("sslEnabled", false);
                        String protocol2 = isSSLEnabled ? "https" : "http";
                        String host = ep.getString("host", "__null__");
                        _webContainerPortList.add(new Prefix(protocol2, host, port2));
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:354:1.8");
                if (!_tc.isDebugEnabled()) break block8;
                Tr.debug(_tc, "loadHTTPPortsFromV5Template caught exeption ", e);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadHTTPPortsfromV5Template");
        }
    }

    public static List<WSAddressingBaseService.Prefix> getWebContainerPortList() {
        if (!_initialized) {
            MetaDataChannelHelper.initialize();
        }
        return _webContainerPortList;
    }

    public static List<WSAddressingBaseService.Prefix> getProxyPortList() {
        if (!_initialized) {
            MetaDataChannelHelper.initialize();
        }
        return _proxyPortList;
    }

    static {
        _onNodeProxyServers = new ArrayList<EndPointMgr.ServerEndPoints>();
        _offNodeProxyServers = new ArrayList<EndPointMgr.ServerEndPoints>();
        _proxiesToNodes = new HashMap<EndPointMgr.ServerEndPoints, String>();
    }
}

