/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.namespace;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.NamespaceHelper;
import com.ibm.ws.wsaddressing.namespace.NamespaceData200408;
import com.ibm.ws.wsaddressing.namespace.NamespaceData200508;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.NamespaceNotSupportedException;
import java.io.Serializable;
import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;

public abstract class NamespaceData
implements Serializable {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.namespace.NamespaceData";
    private static final long serialVersionUID = 1303878684027422823L;
    private static final TraceComponent TRACE_COMPONENT = Tr.register(NamespaceData.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static NamespaceHelper _nh = new NamespaceHelper();

    public static NamespaceData getDefaultNamespaceInstance() {
        return NamespaceData200508.getInstance();
    }

    public static NamespaceData getInstance(String namespace) throws NamespaceNotSupportedException {
        if (namespace == null) {
            return null;
        }
        if (namespace.equals("http://www.w3.org/2005/08/addressing")) {
            return NamespaceData200508.getInstance();
        }
        if (namespace.equals("http://schemas.xmlsoap.org/ws/2004/08/addressing")) {
            return NamespaceData200408.getInstance();
        }
        throw new NamespaceNotSupportedException("Namespace  : " + namespace + " is not supported.");
    }

    public abstract String getNamespace();

    public abstract String getWSDLNamespace();

    public abstract URI getAnonymousURI();

    public abstract URI getNoneURI() throws NamespaceNotSupportedException;

    public abstract URI getFaultActionURI();

    public abstract URI getUnspecifiedMessageURI();

    public abstract URI getReplyRelationshipURI();

    public abstract EndpointReference createAnonymousEPR() throws EndpointReferenceCreationException;

    public abstract Name getwsaEndpointReference();

    public abstract Name getwsaAddress();

    public abstract Name getwsaReferenceParameters();

    public abstract Name getwsaIsReferenceParameter();

    public abstract Name getwsaMetadata();

    public abstract Name getwsaFaultTo();

    public abstract Name getwsaReplyTo();

    public abstract Name getwsaFrom();

    public abstract Name getwsaRelatesTo();

    public abstract Name getwsaRelationshipType();

    public abstract Name getwsaMessageID();

    public abstract Name getwsaAction();

    public abstract Name getwsaTo();

    public abstract Name getwsaProblemHeaderQN();

    public abstract Name getwsaFaultDetailName();

    public abstract Name getwsawInterfaceName();

    public abstract Name getwsawServiceName();

    public abstract Name getwsawEndpointName();

    public abstract QName getMessageAddressingPropertyRequired();

    public abstract QName getActionMismatch();

    public abstract QName getInvalidMessageAddressingProperty();

    public abstract QName getDestinationUnreachable();

    public abstract QName getActionNotSupported();

    public abstract QName getEndpointUnavailable();

    public static NamespaceData addInboundNamespaceDataToContext(SOAPHeader soapHeader, MessageContext msgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addInboundNamespaceDataToContext", new Object[]{soapHeader, msgContext});
        }
        String namespaceFromContext = _nh.updateInboundWSANamespaceForMessageContext(soapHeader, msgContext);
        NamespaceData nsd = null;
        try {
            nsd = NamespaceData.getInstance(namespaceFromContext);
        }
        catch (NamespaceNotSupportedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.namespace.NamespaceData.addInboundNamespaceDataToContext", "1:201:1.8", namespaceFromContext);
            Tr.warning(TRACE_COMPONENT, "NamespaceHelper returned an namespace for which no NamespaceData was available: " + namespaceFromContext);
            nsd = NamespaceData.getDefaultNamespaceInstance();
        }
        msgContext.setProperty("com.ibm.ws.wsaddressing.NamespaceData", nsd);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addInboundNamespaceDataToContext", nsd);
        }
        return nsd;
    }

    public static NamespaceData addOutboundNamespaceDataToContext(MessageContext msgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addOutboundNamespaceDataToContext", msgContext);
        }
        String namespaceFromContext = _nh.updateOutboundWSANamespaceForMessageContext(msgContext);
        NamespaceData nsd = null;
        try {
            nsd = NamespaceData.getInstance(namespaceFromContext);
        }
        catch (NamespaceNotSupportedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.namespace.NamespaceData.addOutboundNamespaceDataToContext", "1:239:1.8", namespaceFromContext);
            Tr.warning(TRACE_COMPONENT, "NamespaceHelper returned an namespace for which no NamespaceData was available: " + namespaceFromContext);
            nsd = NamespaceData.getDefaultNamespaceInstance();
        }
        msgContext.setProperty("com.ibm.ws.wsaddressing.NamespaceData", nsd);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addOutboundNamespaceDataToContext", nsd);
        }
        return nsd;
    }

    public static NamespaceData getNamespaceDataFromContext(MessageContext msgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getNamespaceDataFromContext", msgContext);
        }
        NamespaceData nsd = null;
        Object value2 = msgContext.getProperty("com.ibm.ws.wsaddressing.NamespaceData");
        if (value2 != null && value2 instanceof NamespaceData) {
            nsd = (NamespaceData)value2;
        } else {
            nsd = NamespaceData.getDefaultNamespaceInstance();
            Tr.debug(TRACE_COMPONENT, "NamespaceData object not found on context. Using default.", nsd);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getNamespaceDataFromContext", nsd);
        }
        return nsd;
    }

    protected static Name createSOAPNameForWSALocalName(String localName, SOAPFactory soapFactory, String namespace) {
        Name name2 = null;
        try {
            name2 = soapFactory.createName(localName, "wsa", namespace);
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.namespace.NamespaceData.createSOAPNameForWSALocalName", "1:310:1.8", localName);
        }
        return name2;
    }

    protected static Name createSOAPNameForWSAWLocalName(String localName, SOAPFactory soapFactory, String wsdlnamespace) {
        Name name2 = null;
        try {
            name2 = soapFactory.createName(localName, "wsaw", wsdlnamespace);
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.namespace.NamespaceData.createSOAPNameForWSAWLocalName", "1:330:1.8", localName);
        }
        return name2;
    }

    protected static Name createNCNameForLocalName(String localName, SOAPFactory soapFactory) {
        Name name2 = null;
        try {
            name2 = soapFactory.createName(localName);
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.namespace.NamespaceData.createNCNameForLocalName", "1:349:1.8", localName);
        }
        return name2;
    }
}

