/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;

public abstract class WSACommonHandler
implements Handler {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.WSACommonHandler";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSACommonHandler.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    public void init(HandlerInfo arg0) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "init", arg0);
        }
        String bv = null;
        try {
            bv = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return System.getProperty("com.ibm.ws.wsaddressingAndDependentsDisabled");
                }
            });
        }
        catch (Exception e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "init", "Unable to obtain configuration :" + e);
            }
            FFDCFilter.processException(e, this.getClass().toString(), "1:83:1.6");
        }
        if ("true".equalsIgnoreCase(bv)) {
            this.setAddressingDisabledGlobally(true);
            Tr.warning(TRACE_COMPONENT, "WSAddressing and dependents are disabled. Limited Trace.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "init");
        }
    }

    public void handleClosure(MessageContext arg0) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.info(TRACE_COMPONENT, "handleClosure", arg0);
        }
    }

    protected abstract boolean addressingDisabledGlobally();

    protected abstract void setAddressingDisabledGlobally(boolean var1);

    protected boolean isAddressingDisabled(MessageContext jaxRpcMsgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isAddressingDisabled", jaxRpcMsgContext);
        }
        boolean result = false;
        result = this.addressingDisabledGlobally();
        if (!result) {
            result = this.addressingDisabledMessage(jaxRpcMsgContext);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isAddressingDisabled result[" + result + "]");
        }
        return result;
    }

    private boolean addressingDisabledMessage(MessageContext jaxRpcMsgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addressingDisabledMessage", jaxRpcMsgContext);
        }
        boolean result = false;
        Object wsaddressingDisabledFlag = jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.disabled");
        if (wsaddressingDisabledFlag != null) {
            if (!(wsaddressingDisabledFlag instanceof Boolean)) {
                if (TRACE_COMPONENT.isErrorEnabled()) {
                    Tr.error(TRACE_COMPONENT, "WSADDRESSING_DISABLED set by application not of type java.lang.Boolean");
                }
            } else {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "WSADDRESSING_DISABLED set by application and is of type java.lang.Boolean");
                }
                result = (Boolean)wsaddressingDisabledFlag;
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addressingDisabledMessage result[" + result + "]");
        }
        return result;
    }

    public void destroy() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.info(TRACE_COMPONENT, "destroy");
        }
    }
}

