/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.wsaddressing.DestinationUnreachableException;
import com.ibm.ws.wsaddressing.InvalidMultipleElementException;
import com.ibm.ws.wsaddressing.handlers.MAPReader;
import com.ibm.ws.wsaddressing.handlers.ReplyHelper;
import com.ibm.ws.wsaddressing.integration.EndpointReference;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.webservices.sysapp.SystemEndpointContext;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;

public final class InboundWSAProcessor {
    private boolean _wsaPresent = false;
    private boolean _actionPresent = false;
    private boolean _messageIDPresent = false;
    private boolean _replyToPresent = false;
    private boolean _faultToPresent = false;
    private MAPReader _mapReader;
    private Boolean _validation = null;
    private MessageContext _context = null;
    private QName _faultCode = null;
    private String _faultDetail = null;
    private static final TraceComponent TRACE_COMPONENT = Tr.register(InboundWSAProcessor.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.InboundWSAProcessor";
    private NamespaceData _namespaceData = null;

    public InboundWSAProcessor() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "InboundWSAProcessor");
        }
        this._namespaceData = NamespaceData.getDefaultNamespaceInstance();
        this._mapReader = new MAPReader();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "InboundWSAProcessor");
        }
    }

    private SOAPFaultException setSOAPFaultException(Exception exception, MessageContext jaxRpcMsgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setSOAPFaultException exception[" + exception + "]");
        }
        this.setFaultCode(this._namespaceData.getInvalidMessageAddressingProperty());
        if (exception instanceof InvalidMultipleElementException) {
            InvalidMultipleElementException imme = (InvalidMultipleElementException)exception;
            this.setFaultDetail(imme.getProblemHeaderQName().getLocalPart());
        } else if (exception instanceof DestinationUnreachableException) {
            this.setFaultCode(this._namespaceData.getDestinationUnreachable());
        }
        SOAPFaultException sfe = this.getSoapFaultException();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setSOAPFaultException");
        }
        return sfe;
    }

    public boolean setMessageContext(SOAPMessageContext ctx) throws SOAPFaultException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setMessageContext");
        }
        this._context = ctx;
        try {
            this._wsaPresent = this._mapReader.setMessageContext(ctx);
        }
        catch (InvalidMultipleElementException e) {
            this._mapReader.addPropertiesToContext();
            this._namespaceData = this._mapReader.getNamespaceData();
            ctx.setProperty("com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.WsaFoundInbound", Boolean.TRUE);
            this.setupRedirectProperties();
            String message = "Check the contents on the SOAPHeader.  An InvalidMultipleElementException was thrown.  This is invalid according to the WS-Addressing Specification." + e.getMessage();
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.warning(TRACE_COMPONENT, message);
            }
            FFDCFilter.processException(e, CLASSNAME, "1:201:1.29");
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "setMessageContext", ctx);
            }
            SOAPFaultException sfe = this.setSOAPFaultException(e, ctx);
            throw sfe;
        }
        catch (DestinationUnreachableException e) {
            this._mapReader.addPropertiesToContext();
            this._namespaceData = this._mapReader.getNamespaceData();
            ctx.setProperty("com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.WsaFoundInbound", Boolean.TRUE);
            String message = "A DestinationUnreachableException was thrown. This occurs when the wsaucf:RoutingInformation relates to a cluster which the processing server is not a memebr of.";
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.warning(TRACE_COMPONENT, message);
            }
            FFDCFilter.processException(e, CLASSNAME, "1:224:1.29");
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "setMessageContext", ctx);
            }
            SOAPFaultException sfe = this.setSOAPFaultException(e, ctx);
            throw sfe;
        }
        if (!this._wsaPresent) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "setMessageContext", Boolean.FALSE);
            }
            return false;
        }
        this._mapReader.addPropertiesToContext();
        this._namespaceData = this._mapReader.getNamespaceData();
        ctx.setProperty("com.ibm.ws.wsaddressing.handlers.WSAddressingServerHandler.WsaFoundInbound", this._wsaPresent);
        this.checkForPresence();
        this.performValidation();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setMessageContext");
        }
        return this._wsaPresent;
    }

    public boolean isWSAPresent() {
        return this._wsaPresent;
    }

    public boolean isAddressingValid() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isValid");
        }
        if (this._validation == null) {
            this.performValidation();
        }
        boolean result = this._validation;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isValid result[" + result + "]");
        }
        return result;
    }

    private void checkForPresence() {
        AttributedURI action;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "checkForPresence");
        }
        this._actionPresent = (action = this._mapReader.getActionURI()) != null;
        AttributedURI messageID = this._mapReader.getMessageIDAURI();
        this._messageIDPresent = messageID != null;
        EndpointReference faultTo = this._mapReader.getFaultToEPR();
        this._faultToPresent = faultTo != null;
        EndpointReference replyTo = this._mapReader.getReplyToEPR();
        boolean bl = this._replyToPresent = replyTo != null;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isValid");
        }
    }

    private boolean performValidation() {
        boolean result;
        block11: {
            AttributedURI auri;
            boolean idCheck;
            block22: {
                block23: {
                    block24: {
                        block16: {
                            block20: {
                                block21: {
                                    Object endpointContext;
                                    EndpointReference rt;
                                    block17: {
                                        block18: {
                                            block19: {
                                                block15: {
                                                    block14: {
                                                        AttributedURI attUri;
                                                        block13: {
                                                            block12: {
                                                                if (TRACE_COMPONENT.isEntryEnabled()) {
                                                                    Tr.entry(TRACE_COMPONENT, "performValidation");
                                                                }
                                                                result = true;
                                                                if (!this.isWSAPresent() || !result) break block11;
                                                                if (this._actionPresent) break block12;
                                                                Tr.debug(TRACE_COMPONENT, "<wsa:Action> field is not present.");
                                                                this.setFaultCode(this._namespaceData.getMessageAddressingPropertyRequired());
                                                                this.setFaultDetail(this._namespaceData.getwsaAction());
                                                                result = false;
                                                                break block11;
                                                            }
                                                            attUri = this._mapReader.getActionURI();
                                                            if (attUri != null && attUri.getURI() != null) break block13;
                                                            this.setFaultCode(this._namespaceData.getInvalidMessageAddressingProperty());
                                                            this.setFaultDetail(this._namespaceData.getwsaAction());
                                                            result = false;
                                                            break block11;
                                                        }
                                                        Object obj = this._context.getProperty("javax.xml.rpc.soap.http.soapaction.use");
                                                        if (obj != null) {
                                                            Tr.debug(TRACE_COMPONENT, "We have a soapAction field:" + (Boolean)obj);
                                                        }
                                                        if ((obj = this._context.getProperty("javax.xml.rpc.soap.http.soapaction.uri")) == null) break block14;
                                                        String str = (String)obj;
                                                        if (str.equals("")) break block15;
                                                        Tr.debug(TRACE_COMPONENT, "We have a soapActionURI:" + str);
                                                        if (str.equals(attUri.getURI().toString())) break block15;
                                                        Tr.debug(TRACE_COMPONENT, "Mismatch SOAPActionURI and wsa:Action");
                                                        this.setFaultCode(this._namespaceData.getActionMismatch());
                                                        this.setFaultDetail(this._namespaceData.getwsaAction());
                                                        result = false;
                                                        break block11;
                                                    }
                                                    Tr.debug(TRACE_COMPONENT, "SOAPACTION_URI_PROPERTY not present");
                                                }
                                                idCheck = false;
                                                if (!this._replyToPresent && !this._faultToPresent) break block16;
                                                if (!this._replyToPresent || (rt = this._mapReader.getReplyToEPR()).isAnonymousURI() || rt.isNoneURI()) break block17;
                                                if (this._messageIDPresent) break block18;
                                                endpointContext = this._context.getProperty("servletEndpointContext");
                                                if (TRACE_COMPONENT.isDebugEnabled()) {
                                                    Tr.debug(TRACE_COMPONENT, "endpointContext=" + endpointContext);
                                                }
                                                if (!(endpointContext instanceof SystemEndpointContext)) break block19;
                                                this._context.setProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID", WSAddressingFactory.createAttributedURI(this._namespaceData.getUnspecifiedMessageURI()));
                                                if (TRACE_COMPONENT.isDebugEnabled()) {
                                                    Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present but in sysapp container so ignoring.");
                                                }
                                                break block17;
                                            }
                                            Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present when protocol expects response");
                                            this.setFaultCode(this._namespaceData.getMessageAddressingPropertyRequired());
                                            this.setFaultDetail(this._namespaceData.getwsaMessageID());
                                            result = false;
                                            break block11;
                                        }
                                        idCheck = true;
                                    }
                                    if (!this._faultToPresent || (rt = this._mapReader.getFaultToEPR()).isAnonymousURI() || rt.isNoneURI()) break block16;
                                    if (this._messageIDPresent) break block20;
                                    endpointContext = this._context.getProperty("servletEndpointContext");
                                    if (TRACE_COMPONENT.isDebugEnabled()) {
                                        Tr.debug(TRACE_COMPONENT, "endpointContext=" + endpointContext);
                                    }
                                    if (!(endpointContext instanceof SystemEndpointContext)) break block21;
                                    this._context.setProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID", WSAddressingFactory.createAttributedURI(this._namespaceData.getUnspecifiedMessageURI()));
                                    if (TRACE_COMPONENT.isDebugEnabled()) {
                                        Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present but in sysapp container so ignoring.");
                                    }
                                    break block16;
                                }
                                Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present when protocol expects response");
                                this.setFaultCode(this._namespaceData.getMessageAddressingPropertyRequired());
                                this.setFaultDetail(this._namespaceData.getwsaMessageID());
                                result = false;
                                break block11;
                            }
                            idCheck = true;
                        }
                        if (((com.ibm.ws.webservices.engine.MessageContext)this._context).isOneWay()) break block22;
                        if (this._messageIDPresent) break block23;
                        Object endpointContext = this._context.getProperty("servletEndpointContext");
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "endpointContext=" + endpointContext);
                        }
                        if (!(endpointContext instanceof SystemEndpointContext)) break block24;
                        this._context.setProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID", WSAddressingFactory.createAttributedURI(this._namespaceData.getUnspecifiedMessageURI()));
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present but in sysapp container so ignoring.");
                        }
                        break block22;
                    }
                    Tr.debug(TRACE_COMPONENT, "<wsa:MessageID> is not present when protocol expects response");
                    this.setFaultCode(this._namespaceData.getMessageAddressingPropertyRequired());
                    this.setFaultDetail(this._namespaceData.getwsaMessageID());
                    result = false;
                    break block11;
                }
                idCheck = true;
            }
            if (idCheck && ((auri = this._mapReader.getMessageIDAURI()) == null || auri.getURI() == null)) {
                Tr.debug(TRACE_COMPONENT, "<wsa:MessageId> is not valid");
                this.setFaultCode(this._namespaceData.getInvalidMessageAddressingProperty());
                this.setFaultDetail(this._namespaceData.getwsaMessageID());
                result = false;
            } else {
                this.setupRedirectProperties();
            }
        }
        this._validation = result;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "performValidation result[" + result + "]");
        }
        return result;
    }

    private void setupRedirectProperties() {
        if (!((com.ibm.ws.webservices.engine.MessageContext)this._context).isOneWay()) {
            ReplyHelper rh;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "performValidation", "Operation has return value, so check for redirected replies.");
            }
            EndpointReference replyTo = this._mapReader.getReplyToEPR();
            EndpointReference faultTo = this._mapReader.getFaultToEPR();
            if (replyTo != null && replyTo.isNoneURI()) {
                this._context.setProperty("com.ibm.ws.wsaddressing.NoneResponse", replyTo);
            }
            if (faultTo != null) {
                if (faultTo.isNoneURI()) {
                    this._context.setProperty("com.ibm.ws.wsaddressing.NoneFault", faultTo);
                }
            } else if (replyTo != null && replyTo.isNoneURI()) {
                this._context.setProperty("com.ibm.ws.wsaddressing.NoneFault", replyTo);
            }
            if ((rh = new ReplyHelper(replyTo, faultTo, this._namespaceData)).isAsyncReply()) {
                this._context.setProperty("com.ibm.ws.wsaddressing.RedirectRequired", "true");
                this._context.setProperty("com.ibm.ws.wsaddressing.RedirectResponse", rh.getAsyncReplyEPR());
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "performValidation", "REDIRECT_RESPONSE is true");
                }
            }
            if (rh.isAsyncFault()) {
                this._context.setProperty("com.ibm.ws.wsaddressing.RedirectRequired", "true");
                this._context.setProperty("com.ibm.ws.wsaddressing.RedirectFault", rh.getAsyncFaultEPR());
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "performValidation", "REDIRECT_FAULT is true.");
                }
            }
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "performValidation", "Redirection check complete.");
            }
        }
    }

    public SOAPFault getSoapFault() {
        return this.getSoapFault(this.getFaultCode(), this._faultDetail);
    }

    public SOAPFault getSoapFault(QName faultCode) {
        return this.getSoapFault(faultCode, null);
    }

    public SOAPFault getSoapFault(QName faultCode, String detail) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSoapFault faultCode/detail[" + faultCode + "/" + detail + "]");
        }
        String reason = null;
        if (faultCode == null) {
            return null;
        }
        if (faultCode.equals(this._namespaceData.getInvalidMessageAddressingProperty())) {
            reason = "A header representing a Message Addressing Property is not valid and the message cannot be processed";
        } else if (faultCode.equals(this._namespaceData.getMessageAddressingPropertyRequired())) {
            reason = "A required header representing a Message Addressing Property is not present";
        } else if (faultCode.equals(this._namespaceData.getDestinationUnreachable())) {
            detail = detail == null ? "[destination]" : detail;
            reason = "No route can be determined to reach " + InboundWSAProcessor.encode(detail) + ".";
        } else if (faultCode.equals(this._namespaceData.getActionNotSupported())) {
            detail = detail == null ? "[action]" : detail;
            reason = "The " + InboundWSAProcessor.encode(detail) + " cannot be processed at the receiver.";
        } else if (faultCode.equals(this._namespaceData.getEndpointUnavailable())) {
            reason = "The endpoint is unable to process the message at this time.";
        }
        SOAPFault result = null;
        SOAPFactory sf = new SOAPFactory();
        try {
            result = sf.createSOAPFault();
            result.setFaultCode(faultCode.toString());
            result.setFaultString(reason);
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.handlers.InboundWSAProcessor.getFaultMsg", "1:793:1.29", sf);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSoapFault result[" + result + "]");
        }
        return result;
    }

    private static String encode(String str) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '<') {
                result.append("&lt;");
                continue;
            }
            if (c == '>') {
                result.append("&gt;");
                continue;
            }
            if (c == '&') {
                result.append("&amp;");
                continue;
            }
            if (c == '\"') {
                result.append("&quot;");
                continue;
            }
            if (c == '\'') {
                result.append("&apos;");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private void setFaultCode(QName faultSubcode) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setFaultCode faultSubcode[" + faultSubcode + "]");
        }
        this._faultCode = faultSubcode;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setFaultCode");
        }
    }

    public QName getFaultCode() {
        return this._faultCode;
    }

    public SOAPFaultException getSoapFaultException() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSoapFaultException");
        }
        SOAPFaultException result = null;
        if (this._faultCode != null) {
            String actor = this.getSoapFault().getFaultActor();
            String faultString = this.getSoapFault().getFaultString();
            Detail detail = this.getSoapFault().getDetail();
            QName faultCode = this.getSoapFault().getFaultCodeAsQName();
            result = new SOAPFaultException(faultCode, faultString, actor, detail);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSoapFaultException result[" + result + "]");
        }
        return result;
    }

    private void setFaultDetail(Name detail) {
        this.setFaultDetail(detail.getLocalName());
    }

    private void setFaultDetail(String detail) {
        this._context.setProperty("com.ibm.ws.wsaddressing.soapfault.detail", detail);
        this._faultDetail = detail;
    }
}

