/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.holders.BooleanHolder;

public class JavaTestCaseWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;
    private int counter = 1;

    protected JavaTestCaseWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName() + "TestCase", "testCase");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends junit.framework.TestCase ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        pw.print("    public ");
        pw.print(this.getClassName());
        pw.println("(java.lang.String name) {");
        pw.println("        super(name);");
        pw.println("    }");
        for (int i = 0; i < this.sEntry.numPorts(); ++i) {
            PortEntry pe = this.sEntry.getPort(i);
            Port p = pe.getPort();
            Binding binding = p.getBinding();
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry.getBindingType() != 0) continue;
            String portName = JavaUtils.xmlNameToJavaClass(pe.getName());
            PortType portType = binding.getPortType();
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
            this.writeComment(pw, p.getDocumentationElement());
            this.writeServiceTestCode(pw, portName, portType, ptEntry, binding, bEntry);
        }
    }

    private final void writeServiceTestCode(PrintWriter pw, String portName, PortType portType, PortTypeEntry ptEntry, Binding binding, BindingEntry bEntry) throws IOException {
        Iterator ops = portType.getOperations().iterator();
        while (ops.hasNext()) {
            int i;
            Operation op = (Operation)ops.next();
            OperationType type = op.getStyle();
            BindingOperationEntry boe = bEntry.getOperation(op);
            String signature = (String)boe.getDynamicVar(JavaGeneratorFactory.SIGNATURE);
            BooleanHolder bThrow = new BooleanHolder(false);
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println("    " + signature);
                continue;
            }
            String javaOpName = boe.getName();
            String testMethodName = "test" + this.counter++ + portName + javaOpName;
            pw.println("    public void " + testMethodName + "() throws Exception {");
            String seiName = (String)bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
            this.writeBindingAssignment(pw, seiName, portName);
            pw.println("        // Test operation");
            String indent = "";
            if (boe.numFaults() > 0) {
                pw.println("        try {");
                indent = "    ";
            }
            if (boe.getReturn() != null) {
                String paramType = (String)boe.getReturn().getDynamicVar("parameterType");
                pw.print("        " + indent);
                pw.print(paramType + " value = ");
                if (boe.getReturn().getMIMEType() == null && Utils.isPrimitiveType(paramType)) {
                    if ("boolean".equals(paramType)) {
                        pw.println("false;");
                    } else {
                        pw.println("-3;");
                    }
                } else {
                    pw.println("null;");
                }
            }
            pw.print("        " + indent);
            if (boe.getReturn() != null) {
                pw.print("value = ");
            }
            pw.print("binding.");
            pw.print(boe.getName());
            pw.print("(");
            for (i = 0; i < boe.numParameters(); ++i) {
                BindingParamEntry param;
                if (i > 0) {
                    pw.print(", ");
                }
                if ((param = boe.getParameter(i)).getMode() != 1) {
                    pw.print("new " + param.getDynamicVar("parameterSignatureType") + "(");
                }
                if (param.getMode() != 2) {
                    String constructorString = Utils.getConstructorForParam(param, this.symbolTable, bThrow, this.emitter);
                    pw.print(constructorString);
                }
                if (param.getMode() == 1) continue;
                pw.print(")");
            }
            pw.println(");");
            if (boe.numFaults() > 0) {
                pw.println("        }");
            }
            for (i = 0; i < boe.numFaults(); ++i) {
                BindingFaultRefEntry f = boe.getFault(i);
                MessageEntry me = f.getMessageEntry();
                SymTabEntry faultEntry = (SymTabEntry)me.getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
                pw.print("        catch (");
                pw.print(faultEntry.getName());
                pw.println(" e" + i + ") {");
                pw.print("            ");
                pw.println("throw new junit.framework.AssertionFailedError(\"" + faultEntry.getName() + " Exception caught: \" + e" + i + ");");
                pw.println("        }");
            }
            pw.println("        " + indent + "// TBD - validate results");
            pw.println("    }");
            pw.println();
        }
    }

    public final void writeBindingAssignment(PrintWriter pw, String seiName, String portName) throws IOException {
        pw.println("        " + seiName + " binding;");
        pw.println("        try {");
        pw.print("            binding = new " + this.sEntry.getName());
        pw.println("Locator().get" + portName + "();");
        pw.println("        }");
        pw.println("        catch (" + ServiceException.class.getName() + " jre) {");
        pw.println("            if(jre.getLinkedCause()!=null)");
        pw.println("                jre.getLinkedCause().printStackTrace();");
        pw.println("            throw new junit.framework.AssertionFailedError(\"JAX-RPC ServiceException caught: \" + jre);");
        pw.println("        }");
        pw.println("        assertTrue(\"" + Messages.getMessage("null00", "binding") + "\", binding != null);");
        pw.println();
    }
}

