/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaFaultWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class JavaFaultHelperWriter
extends JavaClassWriter {
    private MessageEntry faultMessage;
    private SymbolTable symbolTable;

    protected JavaFaultHelperWriter(Emitter emitter, SymbolTable symbolTable, MessageEntry faultMessage) {
        super(emitter, faultMessage.getName() + "_Helper", "fault helper");
        this.symbolTable = symbolTable;
        this.faultMessage = faultMessage;
        this.setDeployPhaseOnly(true);
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Vector childEntrys = new Vector();
        Vector partNames = new Vector();
        JavaFaultWriter.getTypesAndNames(this.faultMessage, childEntrys, partNames, this.emitter);
        pw.println();
        pw.println("    /**");
        pw.println("     * Get the detail of this simple exception");
        pw.println("     */");
        pw.println("    public static Object getDetail(Exception e) {");
        if (partNames.size() > 0) {
            String variable = (String)partNames.elementAt(0);
            ChildEntry ce = (ChildEntry)childEntrys.elementAt(0);
            String getter = "userException." + JavaBeanWriter.getterMethodName(ce) + "()";
            pw.println("        " + this.faultMessage.getName() + " userException = (" + this.faultMessage.getName() + ") e;");
            pw.println("        return " + Utils.wrapPrimitiveType(ce.getType().getQName(), getter, (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE)) + ";");
        } else {
            pw.println("        return null;");
        }
        pw.println("    }");
    }
}

