/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Undefined;
import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public abstract class TypeEntry
extends SymTabEntry
implements Serializable {
    protected Node node;
    protected List nodeStack;
    protected int refTypeSIDX;
    protected String dims = "";
    protected boolean onlyWrappedLiteralReferenced = false;
    private boolean isAbstract = false;

    protected TypeEntry(QName pqName, Node pNode, List pNodeStack, SymbolTable symbolTable) {
        super(pqName, symbolTable);
        this.node = pNode;
        this.nodeStack = pNodeStack;
        this.dims = "";
    }

    public void setRefType(TypeEntry refType, String dims) {
        this.refTypeSIDX = refType.getSIDX();
        if (dims == null) {
            dims = "";
        }
        this.dims = dims;
    }

    public Node getNode() {
        return this.node;
    }

    public List getNodeStack() {
        return this.nodeStack;
    }

    public boolean isOnlyWrappedLiteralReferenced() {
        return this.onlyWrappedLiteralReferenced;
    }

    void setOnlyWrappedLiteralReference(boolean set) {
        this.onlyWrappedLiteralReferenced = set;
    }

    protected TypeEntry getUndefinedTypeRef() {
        if (this instanceof Undefined) {
            return this;
        }
        TypeEntry refType = this.getRefType();
        if (this.isUndefined() && refType != null && refType.isUndefined()) {
            TypeEntry uType = refType;
            while (!(uType instanceof Undefined)) {
                uType = uType.getRefType();
            }
            return uType;
        }
        return null;
    }

    protected boolean isUndefined() {
        if (this instanceof Undefined) {
            return true;
        }
        if (this.refTypeSIDX != 0) {
            return this.getRefType().isUndefined();
        }
        return false;
    }

    public TypeEntry getRefType() {
        return (TypeEntry)this.symbolTable.lookup(this.refTypeSIDX);
    }

    public boolean isNotMappable() {
        if (this == this.symbolTable.getUnmappableType()) {
            return true;
        }
        TypeEntry refType = this.getRefType();
        if (refType == null) {
            return false;
        }
        return refType.isNotMappable();
    }

    public String getDimensions() {
        return this.dims;
    }

    public boolean isBaseType() {
        if (this.dims.length() > 0) {
            return false;
        }
        TypeEntry refType = this.getRefType();
        if (refType != null) {
            return refType.isBaseType();
        }
        return this.node == null;
    }

    public boolean isCollectionTypeEntry() {
        return this.qname.getLocalPart().indexOf(93) > 0;
    }

    void setAbstract(boolean value2) {
        this.isAbstract = value2;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String indent) {
        return super.toString(indent) + indent + "refTypeSIDX:   " + this.refTypeSIDX + "\n" + indent + "Undefined?:    " + this.isUndefined() + "\n" + indent + "Not Mappable?: " + this.isNotMappable() + "\n" + indent + "isBaseType     " + this.isBaseType() + "\n" + (this.getNode() != null ? indent + "Node:\n    " + this.getNode() + "\n" : indent + "Node:          " + this.getNode() + "\n") + indent + "NodeStack:     " + this.getNodeStack() + "\n" + indent + "Dims:          " + this.dims + "\n" + indent + "isAbstract     " + this.isAbstract + "\n" + indent + "OnlyWrappedLitRef " + this.onlyWrappedLiteralReferenced + "\n";
    }
}

