/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Namespaces;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.extensions.ejb.EJBBinding;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.symbolTable.Attribute;
import com.ibm.ws.webservices.wsdl.symbolTable.AttributeGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.BaseTypeMapping;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedAttributeGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedElement;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedType;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.Group;
import com.ibm.ws.webservices.wsdl.symbolTable.GroupEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MMDEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaInfo;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaOperationKey;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaOperationValue;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Resolver;
import com.ibm.ws.webservices.wsdl.symbolTable.SchemaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntryComparator;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Undefined;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedAttributeGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedElement;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedGroup;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedType;
import com.ibm.ws.webservices.wsdl.symbolTable.Utils;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.StringHolder;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SymbolTable {
    protected static Log log = LogFactory.getLog(SymbolTable.class.getName());
    private boolean addImports;
    private HashMap symbolTable = new HashMap();
    private Vector types = new Vector();
    private Vector groups = new Vector();
    private Vector attributeGroups = new Vector();
    private ArrayList entryList = new ArrayList();
    private Type unmappableType = null;
    private HashMap mmdMap = new HashMap();
    private boolean isDuringProcessingOfRedefine = false;
    private boolean verbose;
    private boolean debug = false;
    private boolean warnUnmappableTypes = true;
    private BaseTypeMapping btm = null;
    public static final String ANON_TOKEN = ">";
    private Definition def = null;
    private Document document = null;
    private String wsdlURI = null;
    private WSDLReader reader;
    private MetaInfo metaInfo;
    private Resolver resolver;
    private ToolEnv env;
    private boolean needInit = true;
    private Map allServices = new LinkedHashMap();
    private LinkedHashSet servicesToWrite = null;
    private LinkedHashSet unmappableTypes = null;
    public static String LEGACY_QNAME = "legacyQName";
    public static String WRAPPED_ARRAY_PATTERN = "wrapped array pattern component";
    public static String REF_IN_RESTRICTED_SIMPLETYPE = "reference in restriction of simpleType";
    public static String NON_BOUND_WSDL = "nonBoundWSDL";
    static final int TYPE = 0;
    static final int ELEMENT = 1;
    static final int ATTRIBUTE = 2;
    TreeSet allTypes = null;
    private static final int ABOVE_SCHEMA_LEVEL = -1;
    private static final int SCHEMA_LEVEL = 0;

    public SymbolTable(ToolEnv env, MetaInfo metaInfo, boolean addImports, boolean verbose) {
        this.env = env;
        this.btm = metaInfo.getBaseTypeMapping();
        this.addImports = addImports;
        this.verbose = verbose;
        this.metaInfo = metaInfo;
        if (metaInfo.getProperty("debugMode") != null && metaInfo.getProperty("debugMode") instanceof Boolean) {
            this.debug = (Boolean)metaInfo.getProperty("debugMode");
        }
    }

    public void setWarnUnmappableTypes(boolean value2) {
        this.warnUnmappableTypes = value2;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ToolEnv getToolEnv() {
        return this.env;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public HashMap getHashMap() {
        return this.symbolTable;
    }

    public Vector getSymbols(QName qname) {
        return (Vector)this.symbolTable.get(qname);
    }

    public SymTabEntry get(QName qname, Class cls) {
        Vector v = (Vector)this.symbolTable.get(qname);
        if (v == null) {
            return null;
        }
        for (int i = 0; i < v.size(); ++i) {
            SymTabEntry entry = (SymTabEntry)v.elementAt(i);
            if (!cls.isInstance(entry)) continue;
            return entry;
        }
        return null;
    }

    public MMDEntry getMMDEntry(QName qName) {
        return (MMDEntry)this.mmdMap.get(qName);
    }

    public Iterator getMMDEntries() {
        return this.mmdMap.values().iterator();
    }

    public Type getType(QName qname) {
        Vector v = this.getSymbols(qname);
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.get(i);
                if (!entry.getQName().equals(qname) || !(entry instanceof Type)) continue;
                return (Type)entry;
            }
        }
        return null;
    }

    Type getUnmappableType() {
        if (this.unmappableType == null) {
            this.unmappableType = this.getType(Constants.WEBSERVICES_SOAPELEMENT);
            if (this.unmappableType == null) {
                this.unmappableType = new DefinedType(Constants.WEBSERVICES_SOAPELEMENT, this);
                this.unmappableType.setName("javax.xml.soap.SOAPElement");
                try {
                    this.symbolTablePut(this.unmappableType);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.wsdl.symbolTable.SymbolTable.getUnmappableType", "450", this);
                }
            }
        }
        return this.unmappableType;
    }

    public Element getElement(QName qname) {
        Vector v = this.getSymbols(qname);
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.get(i);
                if (!entry.getQName().equals(qname) || !(entry instanceof Element)) continue;
                return (Element)entry;
            }
        }
        return null;
    }

    private ExtensibilityElement getHttpSoapEJBBindingExtElement(Binding binding) {
        Iterator extensibilityElementsIterator = binding.getExtensibilityElements().iterator();
        while (extensibilityElementsIterator.hasNext()) {
            Object obj = extensibilityElementsIterator.next();
            if (!(obj instanceof SOAPBinding) && !(obj instanceof HTTPBinding) && !(obj instanceof EJBBinding)) continue;
            return (ExtensibilityElement)obj;
        }
        return null;
    }

    public Attribute getAttribute(QName qname) {
        Vector v = this.getSymbols(qname);
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.get(i);
                if (!entry.getQName().equals(qname) || !(entry instanceof Attribute)) continue;
                return (Attribute)entry;
            }
        }
        return null;
    }

    public MessageEntry getMessageEntry(QName qname) {
        return (MessageEntry)this.get(qname, MessageEntry.class);
    }

    public PortTypeEntry getPortTypeEntry(QName qname) {
        return (PortTypeEntry)this.get(qname, PortTypeEntry.class);
    }

    public BindingEntry getBindingEntry(QName qname) {
        return (BindingEntry)this.get(qname, BindingEntry.class);
    }

    public ServiceEntry getServiceEntry(QName qname) {
        return (ServiceEntry)this.get(qname, ServiceEntry.class);
    }

    public AttributeGroup getAttributeGroup(QName qname) {
        return (AttributeGroup)this.get(qname, AttributeGroup.class);
    }

    public Group getGroup(QName qname) {
        return (Group)this.get(qname, Group.class);
    }

    public Vector getTypes() {
        return this.types;
    }

    Set _getAllTypes() {
        if (this.allTypes == null) {
            this.allTypes = new TreeSet(new SymTabEntryComparator());
            this.allTypes.addAll(this.types);
        }
        return this.allTypes;
    }

    public Vector getGroups() {
        return this.groups;
    }

    public Vector getAttributeGroups() {
        return this.attributeGroups;
    }

    public void addServices(Service service) {
        this.allServices.put(service.getQName(), service);
    }

    public Map getServices() {
        return this.allServices;
    }

    public boolean shouldServiceBeWritten(String name2) {
        return this.servicesToWrite != null ? this.servicesToWrite.contains(name2) : true;
    }

    public void setServicesToBeWritten(Set services) {
        this.servicesToWrite = services == null ? null : new LinkedHashSet(services);
    }

    public Definition getDefinition() {
        return this.def;
    }

    public String getWSDLURI() {
        return this.wsdlURI;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public void dump(PrintStream out) {
        ArrayList symTabEntries = new ArrayList();
        out.println();
        out.println("-----------------------");
        out.println(Messages.getMessage("symbolTable00") + "          |");
        out.println("-----------------------");
        Iterator it = this.symbolTable.values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                symTabEntries.add(v.elementAt(i));
            }
        }
        symTabEntries = this.entrySort(symTabEntries);
        ArrayList symTabEntriesChildren = this.getChildren(symTabEntries);
        ArrayList symTabEntriesStrings = this.formatEntries(symTabEntries, symTabEntriesChildren);
        for (int i = 0; i < symTabEntriesStrings.size(); ++i) {
            out.println();
            out.println(symTabEntriesStrings.get(i));
            out.println("======================================================================================");
        }
        for (int j = 0; j < symTabEntriesChildren.size(); ++j) {
            out.println();
            out.println(j + 1 + "c --");
            out.println(symTabEntriesChildren.get(j));
        }
        out.println("======================================================================================");
        out.println("-----------------------");
    }

    private ArrayList entrySort(ArrayList entries) {
        for (int i = 0; i < entries.size(); ++i) {
            for (int j = 0; j < entries.size() - i - 1; ++j) {
                if (((SymTabEntry)entries.get(j)).getSIDX() <= ((SymTabEntry)entries.get(j + 1)).getSIDX()) continue;
                Object temp = entries.get(j);
                entries.set(j, entries.get(j + 1));
                entries.set(j + 1, temp);
            }
        }
        return entries;
    }

    private ArrayList getChildren(ArrayList STE) {
        ArrayList children = new ArrayList();
        for (int i = 0; i < STE.size(); ++i) {
            Vector curEntryChildren = null;
            if (STE.get(i) instanceof GroupEntry) {
                curEntryChildren = ((GroupEntry)STE.get(i)).getChildren();
            } else if (STE.get(i) instanceof MessageEntry) {
                curEntryChildren = ((MessageEntry)STE.get(i)).getFaultParts();
            } else if (STE.get(i) instanceof Type) {
                curEntryChildren = ((Type)STE.get(i)).getChildren();
            }
            if (curEntryChildren == null) continue;
            for (int j = 0; j < curEntryChildren.size(); ++j) {
                if (children.contains(curEntryChildren.get(j))) continue;
                children.add(curEntryChildren.get(j));
            }
        }
        return children;
    }

    private ArrayList formatEntries(ArrayList entries, ArrayList children) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < entries.size(); ++i) {
            String curStr = entries.get(i).toString();
            if (curStr.indexOf("Children       [QName") != -1) {
                curStr = curStr.substring(0, curStr.indexOf("Children       [") + 16) + " ";
                Vector curEntryChildren = null;
                if (entries.get(i) instanceof GroupEntry) {
                    curEntryChildren = ((GroupEntry)entries.get(i)).getChildren();
                } else if (entries.get(i) instanceof MessageEntry) {
                    curEntryChildren = ((MessageEntry)entries.get(i)).getFaultParts();
                } else if (entries.get(i) instanceof Type) {
                    curEntryChildren = ((Type)entries.get(i)).getChildren();
                }
                if (curEntryChildren != null) {
                    for (int j = 0; j < curEntryChildren.size(); ++j) {
                        int index = children.indexOf(curEntryChildren.get(j));
                        if (index == -1) continue;
                        curStr = curStr + "(" + (index + 1) + "c) ";
                    }
                }
                curStr = curStr + "]\n";
            }
            strings.add(curStr);
        }
        return strings;
    }

    public void populate(String uri) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.populate(uri, null, null);
    }

    public void populate(String uri, String username, String password) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (this.verbose) {
            this.env.report(Messages.getMessage("parsing00", uri));
        }
        Document doc = XMLUtils.newDocument(uri, username, password, this.metaInfo.getRetry(), this.metaInfo.getTimeout());
        this.wsdlURI = uri;
        try {
            uri = new URL(uri).toString();
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.populate(uri, doc, true, username, password);
    }

    public void populate(String context, Document doc) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.populate(context, doc, false, null, null);
    }

    private void populate(String context, Document doc, boolean readWithResolver, String username, String password) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.resolver = new Resolver(this.wsdlURI, this.metaInfo.getImportResolver());
        this.resolver.enableWSIChecking(this.metaInfo.getWSICheck());
        this.resolver.setId(username);
        this.resolver.setPass(password);
        this.resolver.setEnv(this.env);
        this.resolver.setRetry(this.metaInfo.getRetry());
        this.resolver.setTimeout(this.metaInfo.getTimeout());
        ServiceProviderManager spm = new ServiceProviderManager(null);
        this.reader = spm.getWSDLFactory().newWSDLReader();
        this.reader.setFeature("javax.wsdl.verbose", this.verbose);
        try {
            this.def = readWithResolver ? this.reader.readWSDL(this.resolver) : this.reader.readWSDL(context, doc);
        }
        catch (WSDLException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable.populate", "556", this);
            this.env.reportFatalErr(Messages.getMessage("errorReadingImport", e.getMessage()));
            return;
        }
        this.firstPass(context, this.def, doc);
    }

    public void populateUsingDefinition(String context, Document doc, Definition defn) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.def = defn;
        if (this.resolver == null) {
            this.resolver = new Resolver(null, this.metaInfo.getImportResolver());
            this.resolver.enableWSIChecking(this.metaInfo.getWSICheck());
            this.resolver.setEnv(this.env);
            this.resolver.setRetry(this.metaInfo.getRetry());
            this.resolver.setTimeout(this.metaInfo.getTimeout());
        }
        ServiceProviderManager spm = new ServiceProviderManager(null);
        this.reader = spm.getWSDLFactory().newWSDLReader();
        this.reader.setFeature("javax.wsdl.verbose", this.verbose);
        this.firstPass(context, this.def, doc);
    }

    private void firstPass(String context, Definition def, Document doc) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        URL contextURL = context == null ? null : Utils.getURL(null, context);
        this.populate(contextURL, def, doc, null, new ArrayList());
        this.checkForUndefined();
        this.expandGroupReferences();
        this.document = doc;
        this.collectNamespaces();
    }

    public void secondPass() {
        this.processEnumerations();
        for (int i = 0; i < this.types.size(); ++i) {
            TypeEntry type = (TypeEntry)this.types.get(i);
            if (type != null && type instanceof DefinedType && ((Type)type).getExtensionBase() == null && ((Type)type).getRestrictionBase() == null && (((Type)type).getChildren() == null || ((Type)type).getChildren().size() == 0)) {
                Utils.getNestedTypes(type, this);
            }
            this.setLegacyQName(type);
        }
        this.setReferences(this.def, this.document);
    }

    private void setLegacyQName(TypeEntry te) {
        boolean calculate = this.metaInfo != null && "1.0".equals(this.metaInfo.getProperty("MMDVersion"));
        QName legacyQName = null;
        if (calculate && (te instanceof Type || te.isCollectionTypeEntry()) && te.getNode() != null && te.getNodeStack() != null) {
            legacyQName = te.isCollectionTypeEntry() ? Utils.getTypeQName(te.getNode(), new BooleanHolder(), false, te.getNodeStack(), this.env, true) : Utils.getNodeNameQName_v5(te.getNode(), te.getNodeStack());
        }
        if (legacyQName != null && !te.getQName().equals(legacyQName)) {
            te.setDynamicVar(LEGACY_QNAME, legacyQName);
            this.mmdMap.put(legacyQName, new MMDEntry(legacyQName, te, this));
        }
    }

    private void processEnumerations() {
        for (int i = 0; i < this.types.size(); ++i) {
            Vector legacyEnums;
            Type type;
            TypeEntry typeEntry = (TypeEntry)this.types.get(i);
            if (!(typeEntry instanceof DefinedType) || typeEntry.getNode() == null || !(type = (Type)typeEntry).isSimpleType() || type.getDynamicVar(REF_IN_RESTRICTED_SIMPLETYPE) != null) continue;
            Vector enums = SchemaUtils.getEnumerationBaseAndValuesToEmit(type.getNode(), this, type.getNodeStack());
            if (enums != null) {
                type.setEnumeration(true);
                type.setChildren(enums);
                type.setRestrictionBase((Type)((ChildEnumValueEntry)enums.get(0)).getType());
            }
            if (type.isEnumeration || (legacyEnums = SchemaUtils.getEnumerationBaseAndValues(type.getNode(), this, type.getNodeStack())) == null) continue;
            type.setEnumeration(true);
            type.setChildren(legacyEnums);
            type.setRestrictionBase((Type)((ChildEnumValueEntry)legacyEnums.get(0)).getType());
            type.setDynamicVar("disable generation", new Boolean(true));
        }
    }

    private void checkValidXSDImportFromSchema(Node parentNode, String fromFile, String importedDoc, String action) {
        if (parentNode.getNodeName().indexOf("schema") == -1) {
            this.env.reportWarning(Messages.getMessage("notWSICompliantXSDImportNotFromSchema00", fromFile, importedDoc, action));
        }
    }

    private void checkForWSDLElemOrder(Node node, String filename) {
        if (node != null) {
            boolean types = false;
            boolean other = false;
            String element = "";
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeName().indexOf("definitions") > -1) {
                    child = child.getFirstChild();
                    types = false;
                    other = false;
                    continue;
                }
                if (child.getNodeName().indexOf("import") > -1) {
                    if (!types && !other) continue;
                    this.env.reportWarning(Messages.getMessage("notWSICompliantWSDLImportWrongOrder00", filename, element));
                    continue;
                }
                if (child.getNodeName().indexOf("types") > -1) {
                    types = true;
                    if (other) {
                        this.env.reportWarning(Messages.getMessage("notWSICompliantWSDLImportWrongOrder01", filename, element));
                    }
                    element = child.getNodeName();
                    continue;
                }
                if (child.getNodeName().indexOf("documentation") != -1 || child.getNodeName().indexOf("#text") != -1 || child.getNodeName().indexOf("#comment") != -1) continue;
                other = true;
                element = child.getNodeName();
            }
        }
    }

    private void checkForUndefined(Definition def, String filename) throws IOException {
        if (def != null) {
            Iterator ib = def.getBindings().values().iterator();
            while (ib.hasNext()) {
                Binding binding = (Binding)ib.next();
                if (!binding.isUndefined()) continue;
                if (filename == null) {
                    throw new IOException(Messages.getMessage("emitFailtUndefinedBinding01", binding.getQName().getLocalPart()));
                }
                throw new IOException(Messages.getMessage("emitFailtUndefinedBinding02", binding.getQName().getLocalPart(), filename));
            }
            Iterator ip = def.getPortTypes().values().iterator();
            while (ip.hasNext()) {
                PortType portType = (PortType)ip.next();
                if (!portType.isUndefined()) continue;
                if (filename == null) {
                    throw new IOException(Messages.getMessage("emitFailtUndefinedPort01", portType.getQName().getLocalPart()));
                }
                throw new IOException(Messages.getMessage("emitFailtUndefinedPort02", portType.getQName().getLocalPart(), filename));
            }
        }
    }

    private void checkForUndefined() throws IOException {
        Vector<DefinedType> addSymbols = null;
        Iterator it = this.symbolTable.values().iterator();
        while (it.hasNext()) {
            Vector v = (Vector)it.next();
            for (int i = 0; i < v.size(); ++i) {
                SymTabEntry entry = (SymTabEntry)v.get(i);
                if (entry instanceof UndefinedType) {
                    QName qn = entry.getQName();
                    if (qn.getLocalPart().equals("dateTime") && !qn.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || qn.getLocalPart().equals("timeInstant") && qn.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        throw new IOException(Messages.getMessage("wrongNamespace00", qn.getLocalPart(), qn.getNamespaceURI()));
                    }
                    if (SchemaUtils.isXSDType(entry.getQName())) {
                        this.env.reporterr(Messages.getMessage("unsupportedSchemaType00", qn.getLocalPart()));
                        this.reportUnmappableConstruct(qn);
                        if (addSymbols == null) {
                            addSymbols = new Vector<DefinedType>();
                        }
                        Type se = this.getUnmappableType();
                        DefinedType te = new DefinedType(qn, this);
                        te.setSimpleType(((Type)entry).isSimpleType());
                        te.setSimpleContent(((Type)entry).isSimpleContent());
                        te.setRefType(se, null);
                        addSymbols.add(te);
                        continue;
                    }
                    this.env.reportFatalErr(Messages.getMessage("undefined00", entry.getQName().toString()));
                    return;
                }
                if (entry instanceof UndefinedElement) {
                    throw new IOException(Messages.getMessage("undefinedElem00", entry.getQName().toString()));
                }
                if (entry instanceof UndefinedAttribute) {
                    throw new IOException(Messages.getMessage("undefinedAttr00", entry.getQName().toString()));
                }
                if (entry instanceof UndefinedGroup) {
                    throw new IOException(Messages.getMessage("undefinedGroup00", entry.getQName().toString()));
                }
                if (!(entry instanceof UndefinedAttributeGroup)) continue;
                throw new IOException(Messages.getMessage("undefinedAttributeGroup00", entry.getQName().toString()));
            }
        }
        if (addSymbols != null) {
            for (int i = 0; i < addSymbols.size(); ++i) {
                this.symbolTablePut((Type)addSymbols.get(i));
            }
        }
    }

    private void populate(URL context, Definition def, Document doc, String filename, List nodeStack) throws IOException, ParserConfigurationException, SAXException, WSDLException {
        if (doc != null) {
            this.populateTypes(context, doc, nodeStack);
            if (this.addImports) {
                this.lookForImports(context, doc, nodeStack);
            }
        }
        if (def != null) {
            String wsdlFilename = context == null ? "" : context.getFile();
            this.checkForWSDLElemOrder(doc, wsdlFilename);
            this.checkForUndefined(def, filename);
            this.enhance();
            if (this.addImports) {
                Map imports = def.getImports();
                Object[] importKeys = imports.keySet().toArray();
                for (int i = 0; i < importKeys.length; ++i) {
                    Vector v = (Vector)imports.get(importKeys[i]);
                    for (int j = 0; j < v.size(); ++j) {
                        Import imp = (Import)v.get(j);
                        if (imp.getLocationURI() == null) {
                            throw new IOException(Messages.getMessage("notWSICompliantWSDLImportNoLocation00", wsdlFilename, imp.getNamespaceURI()));
                        }
                        Resolver.Info info = this.resolver.resolveWSDLImport(context, imp, this.reader);
                        if (info == null) continue;
                        this.populate(info.url, info.def, info.doc, info.url != null ? info.url.toString() : null, new ArrayList());
                    }
                }
            }
            this.populateMessages(def);
            this.populatePortTypes(def);
            this.populateBindings(def);
            this.populateServices(def);
        }
    }

    private void lookForImports(URL context, Node node, List nodeStack) throws IOException, ParserConfigurationException, SAXException, WSDLException {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ("import".equals(child.getLocalName())) {
                NamedNodeMap attributes = child.getAttributes();
                Node namespace = attributes.getNamedItem("namespace");
                if (namespace != null && Constants.isSOAP_ENC(namespace.getNodeValue())) continue;
                Node importFile = attributes.getNamedItem("schemaLocation");
                if (importFile != null) {
                    this.checkValidXSDImportFromSchema(node, context == null ? "" : context.getFile(), importFile.getNodeValue(), "import");
                    Resolver.Info resolveInfo = this.resolver.resolveXSDImport(context, namespace == null ? null : namespace.getNodeValue(), importFile.getNodeValue(), Utils.getAbsoluteNamespace(node, nodeStack, this.env));
                    if (this.verbose) {
                        this.env.report(Messages.getMessage("loadingFile00", "imported", Utils.getURL(context, importFile.getNodeValue()).toString(), context == null ? "" : context.getFile()));
                    }
                    if (resolveInfo != null) {
                        this.populate(resolveInfo.url, null, resolveInfo.doc, resolveInfo.url.toString(), new ArrayList());
                    }
                }
            }
            this.lookForImports(context, child, nodeStack);
        }
    }

    private void populateTypes(URL context, Document doc, List nodeStack) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.addTypes(context, doc, -1, nodeStack);
    }

    private void initSymbolTable() throws IOException {
        this.needInit = false;
        this.getUnmappableType();
        DefinedType type = new DefinedType(Constants.SOAP_ELEMENT, null, this);
        type.setName("org.w3c.dom.Element");
        this.symbolTablePut(type);
    }

    private void addTypes(URL context, Node node, int level, List nodeStack) throws IOException, ParserConfigurationException, WSDLException, SAXException {
        String redefineName;
        ArrayList<Node> newNodeStack;
        Resolver.Info resolveInfo;
        if (this.needInit) {
            this.initSymbolTable();
        }
        if (node == null) {
            return;
        }
        String filename = context == null ? "" : context.getFile();
        boolean needDelayedProcessingOfRedefine = false;
        boolean isMappable = true;
        QName nodeKind = Utils.getNodeQName(node);
        if (nodeKind != null) {
            BooleanHolder forElement;
            QName refQName;
            Node re;
            String localPart = nodeKind.getLocalPart();
            boolean isXSD = Constants.isSchemaXSD(nodeKind.getNamespaceURI());
            if (isXSD && localPart.equals("complexType") || localPart.equals("simpleType")) {
                re = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (re != null) {
                    QName kind;
                    if (this.isDuringProcessingOfRedefine && (kind = Utils.getNodeQName(re)) != null && kind.getLocalPart().equals("extension")) {
                        throw new IOException(Messages.getMessage("unsupportedExtension00"));
                    }
                    if (Utils.getAttribute(re, "base") != null) {
                        this.createTypeFromRef(re, nodeStack, false);
                    }
                }
                isMappable = this.createTypeFromDef(node, 0, false, nodeStack);
            } else if (isXSD && localPart.equals("element")) {
                this.createTypeFromRef(node, nodeStack, false);
                re = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (re != null && Utils.getAttribute(re, "base") != null) {
                    this.createTypeFromRef(re, nodeStack, false);
                }
                isMappable = this.createTypeFromDef(node, 1, level > 0, nodeStack);
            } else if (isXSD && localPart.equals("attribute") && (refQName = Utils.getTypeQName(node, forElement = new BooleanHolder(), false, nodeStack, this.env)) != null && !forElement.value) {
                this.createTypeFromRef(node, nodeStack, true);
                if (refQName != null) {
                    Type refType = this.getType(refQName);
                    if (refType != null && refType instanceof Undefined) {
                        refType.setSimpleType(true);
                    } else if (refType == null || !refType.isSimpleType()) {
                        throw new IOException(Messages.getMessage("AttrNotSimpleType01", refQName.toString()));
                    }
                }
                isMappable = this.createTypeFromDef(node, 2, level > 0, nodeStack);
            }
            if (isXSD && localPart.equals("group") || localPart.equals("attributeGroup")) {
                this.createGroupFromRef(node, nodeStack, nodeKind);
                this.createGroupFromDef(node, level > 0, nodeStack, nodeKind);
            } else if (isXSD && localPart.equals("any")) {
                this.createTypeFromRef(node, nodeStack, false);
            } else if (localPart.equals("part") && Constants.isWSDL(nodeKind.getNamespaceURI())) {
                this.createTypeFromRef(node, nodeStack, false);
            } else if (isXSD && localPart.equals("include")) {
                String includeName = Utils.getAttribute(node, "schemaLocation");
                if (includeName != null) {
                    this.checkValidXSDImportFromSchema(node.getParentNode(), filename, includeName, "include");
                    resolveInfo = this.resolver.resolveXSDInclude(context, includeName, Utils.getAbsoluteNamespace(node, nodeStack, this.env));
                    if (this.verbose) {
                        this.env.report(Messages.getMessage("loadingFile00", "included", Utils.getURL(context, includeName).toString(), context == null ? "" : context.getFile()));
                    }
                    if (resolveInfo != null) {
                        newNodeStack = new ArrayList(nodeStack);
                        newNodeStack.add(node);
                        this.populate(resolveInfo.url, (Definition)null, resolveInfo.doc, resolveInfo.url.toString(), newNodeStack);
                    }
                    this.resolver.isIncludedMultipleTimes = false;
                }
            } else if (isXSD && localPart.equals("redefine")) {
                needDelayedProcessingOfRedefine = true;
            }
        }
        if (level == -1) {
            if (nodeKind != null && nodeKind.getLocalPart().equals("schema")) {
                level = 0;
            }
        } else {
            ++level;
        }
        if (isMappable) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.addTypes(context, children.item(i), level, nodeStack);
            }
        }
        if (needDelayedProcessingOfRedefine && (redefineName = Utils.getAttribute(node, "schemaLocation")) != null) {
            this.checkValidXSDImportFromSchema(node.getParentNode(), filename, redefineName, "redefine");
            QName nodeNameQName = Utils.getNodeNameQName(node, nodeStack, this.env);
            String nsURI = null;
            nsURI = nodeNameQName == null || nodeNameQName.getNamespaceURI() == null ? "" : nodeNameQName.getNamespaceURI();
            resolveInfo = this.resolver.resolveXSDRedefine(context, redefineName, nsURI);
            if (this.verbose) {
                this.env.report(Messages.getMessage("loadingFile00", "included", Utils.getURL(context, redefineName).toString(), context == null ? "" : context.getFile()));
            }
            if (resolveInfo != null) {
                this.isDuringProcessingOfRedefine = true;
                newNodeStack = new ArrayList<Node>(nodeStack);
                newNodeStack.add(node);
                this.populate(resolveInfo.url, (Definition)null, resolveInfo.doc, resolveInfo.url.toString(), newNodeStack);
                this.isDuringProcessingOfRedefine = false;
            }
        }
    }

    private boolean createTypeFromDef(Node node, int typeOfType, boolean belowSchemaLevel, List nodeStack) throws IOException {
        boolean isMapped = true;
        QName qName = Utils.getNodeNameQName(node, nodeStack, this.env);
        if (qName != null) {
            if (typeOfType == 0 && this.btm.getBaseName(qName) != null) {
                return isMapped;
            }
            boolean isAbstract = JavaUtils.isTrueExplicitly(Utils.getAttribute(node, "abstract"));
            BooleanHolder forElement = new BooleanHolder();
            QName refQName = Utils.getTypeQName(node, forElement, false, nodeStack, this.env);
            if (refQName != null) {
                if (qName.getLocalPart().length() == 0) {
                    String name2 = Utils.getAttribute(node, "name");
                    if (name2 == null) {
                        name2 = "unknown";
                    }
                    throw new IOException(Messages.getMessage("emptyref00", name2));
                }
                TypeEntry refType = null;
                refType = forElement.value ? (typeOfType == 2 ? this.getAttribute(refQName) : this.getElement(refQName)) : this.getType(refQName);
                if (!belowSchemaLevel) {
                    TypeEntry te = null;
                    if (typeOfType == 2) {
                        te = new DefinedAttribute(qName, node, nodeStack, this);
                    } else {
                        te = new DefinedElement(qName, node, nodeStack, this);
                        this.setNillable((Element)te, node);
                    }
                    te.setRefType(refType, null);
                    te.setAbstract(isAbstract);
                    if (isAbstract && refType != null && refType instanceof Type && ((Type)refType).isAnonType()) {
                        refType.setAbstract(isAbstract);
                    }
                    this.symbolTablePut(te);
                }
            } else {
                IntHolder numDims = new IntHolder();
                numDims.value = 0;
                QName arrayEQName = SchemaUtils.getArrayComponentQName(node, numDims, nodeStack, this);
                if (arrayEQName != null) {
                    refQName = arrayEQName;
                    TypeEntry refType = this.getType(refQName);
                    if (refType == null) {
                        refType = this.createBaseType(refQName);
                        if (refType == null) {
                            refType = new UndefinedType(refQName, this);
                        }
                        this.symbolTablePut(refType);
                    }
                    String dims = "";
                    while (numDims.value > 0) {
                        dims = dims + "[]";
                        --numDims.value;
                    }
                    TypeEntry defType = null;
                    if (typeOfType == 0 || !belowSchemaLevel) {
                        if (typeOfType == 1) {
                            defType = new DefinedElement(qName, node, nodeStack, this);
                            this.setNillable((Element)defType, node);
                        } else if (typeOfType == 2) {
                            defType = new DefinedAttribute(qName, node, nodeStack, this);
                        } else {
                            defType = new DefinedType(qName, node, nodeStack, this);
                            if (SchemaUtils.isSimpleType(node, nodeStack)) {
                                ((Type)defType).setSimpleType(true);
                            }
                            if (SchemaUtils.isSimpleContent(node, nodeStack)) {
                                ((Type)defType).setSimpleContent(true);
                            }
                        }
                        defType.setAbstract(isAbstract);
                        defType.setRefType(refType, dims);
                    }
                    if (defType != null) {
                        this.symbolTablePut(defType);
                    }
                } else {
                    String baseName = this.btm.getBaseName(qName);
                    if (baseName != null) {
                        DefinedType baseType = new DefinedType(qName, this);
                        if (!Constants.equals(qName, Constants.XSD_ANY)) {
                            baseType.setSimpleType(true);
                        }
                        this.symbolTablePut(baseType);
                    } else {
                        TypeEntry te = null;
                        if (SchemaUtils.isNotMappable(node, this, nodeStack)) {
                            Type se = this.getUnmappableType();
                            if (typeOfType == 0) {
                                te = new DefinedType(qName, node, nodeStack, this);
                            } else if (!belowSchemaLevel) {
                                if (typeOfType == 1) {
                                    te = new DefinedElement(qName, node, nodeStack, this);
                                    this.setNillable((Element)te, node);
                                } else if (typeOfType == 2) {
                                    te = new DefinedAttribute(qName, node, nodeStack, this);
                                }
                            }
                            te.setRefType(se, null);
                            if (SchemaUtils.isSimpleType(node, nodeStack)) {
                                ((Type)te).setSimpleType(true);
                            }
                            if (SchemaUtils.isSimpleContent(node, nodeStack)) {
                                ((Type)te).setSimpleContent(true);
                            }
                            this.reportUnmappableConstruct(qName);
                            te.setDynamicVar("notMappable", Boolean.TRUE);
                            isMapped = false;
                        } else if (typeOfType == 0) {
                            te = new DefinedType(qName, node, nodeStack, this);
                            if (SchemaUtils.isSimpleType(node, nodeStack)) {
                                ((Type)te).setSimpleType(true);
                            }
                            if (SchemaUtils.isSimpleContent(node, nodeStack)) {
                                ((Type)te).setSimpleContent(true);
                            }
                        } else if (!belowSchemaLevel) {
                            if (typeOfType == 1) {
                                te = new DefinedElement(qName, node, nodeStack, this);
                                this.setNillable((Element)te, node);
                            } else if (typeOfType == 2) {
                                te = new DefinedAttribute(qName, node, nodeStack, this);
                            }
                        }
                        if (te != null) {
                            te.setAbstract(isAbstract);
                            this.symbolTablePut(te);
                        }
                    }
                }
            }
        }
        return isMapped;
    }

    private void createTypeFromRef(Node node, List nodeStack, boolean attribute) throws IOException {
        BooleanHolder forElement = new BooleanHolder();
        QName qName = Utils.getTypeQName(node, forElement, false, nodeStack, this.env);
        if (qName != null) {
            QName refingQName;
            if (qName.getLocalPart().length() == 0) {
                String name2 = Utils.getAttribute(node, "name");
                if (name2 == null) {
                    name2 = "unknown";
                }
                throw new IOException(Messages.getMessage("emptyref00", name2));
            }
            TypeEntry typeEntry = null;
            typeEntry = forElement.value ? (attribute ? this.getAttribute(qName) : this.getElement(qName)) : this.getType(qName);
            if (typeEntry == null) {
                if (qName.getLocalPart().indexOf("[") > 0) {
                    QName containedQName = Utils.getTypeQName(node, forElement, true, nodeStack, this.env);
                    TypeEntry containedTE = null;
                    containedTE = forElement.value ? this.getElement(containedQName) : this.getType(containedQName);
                    if (!forElement.value) {
                        if (containedTE == null) {
                            containedTE = this.createBaseType(containedQName);
                            if (containedTE == null) {
                                containedTE = new UndefinedType(containedQName, this);
                            }
                            this.symbolTablePut(containedTE);
                        }
                        typeEntry = new DefinedType(qName, node, nodeStack, this);
                        typeEntry.setRefType(containedTE, "[]");
                        this.symbolTablePut(typeEntry);
                    } else {
                        if (containedTE == null) {
                            containedTE = new UndefinedElement(containedQName, this);
                            this.symbolTablePut(containedTE);
                        }
                        typeEntry = new DefinedElement(qName, node, nodeStack, this);
                        this.setNillable((Element)typeEntry, node);
                        typeEntry.setRefType(containedTE, "[]");
                        this.symbolTablePut(typeEntry);
                    }
                } else {
                    TypeEntry baseType = this.createBaseType(qName);
                    if (baseType != null) {
                        TypeEntry type = this.getType(qName);
                        if (type == null) {
                            this.symbolTablePut(baseType);
                            type = baseType;
                        }
                        if (forElement.value) {
                            typeEntry = attribute ? new DefinedAttribute(qName, node, nodeStack, this) : new DefinedElement(qName, node, nodeStack, this);
                            typeEntry.setRefType(type, null);
                            this.symbolTablePut(typeEntry);
                        }
                    } else if (!forElement.value) {
                        typeEntry = new UndefinedType(qName, this);
                        this.symbolTablePut(typeEntry);
                    } else {
                        typeEntry = attribute ? new UndefinedAttribute(qName, this) : new UndefinedElement(qName, this);
                        this.symbolTablePut(typeEntry);
                    }
                }
            }
            if (!(qName.getLocalPart().indexOf("[") <= 0 || (refingQName = Utils.getNodeNameQName(node, nodeStack, this.env)).getNamespaceURI().equals(qName.getNamespaceURI()) && refingQName.getLocalPart().equals(qName.getLocalPart().substring(0, qName.getLocalPart().indexOf("["))))) {
                QName mmdQName = QNameTable.createQName(refingQName.getNamespaceURI(), refingQName.getLocalPart() + qName.getLocalPart().substring(qName.getLocalPart().indexOf("[")));
                this.mmdMap.put(mmdQName, new MMDEntry(mmdQName, typeEntry, this));
            }
        }
    }

    private void setNillable(Element element, Node node) {
        if (!element.isCollectionTypeEntry()) {
            String value2 = Utils.getAttribute(node, "nillable");
            element.setNillable(JavaUtils.isTrueExplicitly(value2));
        }
    }

    private void createGroupFromRef(Node node, List nodeStack, QName nodeKind) throws IOException {
        QName ref = Utils.getTypeQNameFromAttr(node, "ref", nodeStack, this.env, false);
        if (ref == null) {
            return;
        }
        if (ref.getLocalPart().equals("Array") && Constants.isSOAP_ENC(ref.getNamespaceURI())) {
            return;
        }
        GroupEntry groupEntry = null;
        if (nodeKind.getLocalPart().equals("attributeGroup")) {
            groupEntry = this.getAttributeGroup(ref);
            if (groupEntry == null) {
                groupEntry = new UndefinedAttributeGroup(ref, this);
                this.symbolTablePut(groupEntry);
            }
        } else if (nodeKind.getLocalPart().equals("group") && (groupEntry = this.getGroup(ref)) == null) {
            groupEntry = new UndefinedGroup(ref, this);
            this.symbolTablePut(groupEntry);
        }
    }

    private void createGroupFromDef(Node node, boolean belowSchemaLevel, List nodeStack, QName nodeKind) throws IOException {
        QName ref = Utils.getTypeQNameFromAttr(node, "ref", nodeStack, this.env, false);
        if (ref != null) {
            return;
        }
        if (belowSchemaLevel) {
            return;
        }
        QName qName = Utils.getNodeNameQName(node, nodeStack, this.env);
        GroupEntry groupEntry = null;
        if (nodeKind.getLocalPart().equals("attributeGroup")) {
            groupEntry = new DefinedAttributeGroup(qName, node, nodeStack, this);
        } else if (nodeKind.getLocalPart().equals("group")) {
            groupEntry = new DefinedGroup(qName, node, nodeStack, this);
        }
        this.symbolTablePut(groupEntry);
    }

    private void enhance() throws IOException {
        int i;
        for (i = 0; i < this.groups.size(); ++i) {
            Group group = (Group)this.groups.get(i);
            if (!(group instanceof DefinedGroup) || group.getNode() == null) continue;
            this.enhance(group);
        }
        for (i = 0; i < this.attributeGroups.size(); ++i) {
            AttributeGroup attributeGroup = (AttributeGroup)this.attributeGroups.get(i);
            if (!(attributeGroup instanceof DefinedAttributeGroup) || attributeGroup.getNode() == null) continue;
            this.enhance(attributeGroup);
        }
        for (i = 0; i < this.types.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)this.types.get(i);
            if (!(typeEntry instanceof DefinedType) || typeEntry.getNode() == null) continue;
            this.enhance((Type)typeEntry);
        }
    }

    private void enhance(Type type) throws IOException {
        if (type.getChildren() != null) {
            return;
        }
        Type base = SchemaUtils.getComplexElementExtensionBase(type.getNode(), this, type.getNodeStack());
        if (base != null) {
            this.enhance(base);
            type.setExtensionBase(base);
            base.setDynamicVar(WRAPPED_ARRAY_PATTERN, null);
        } else {
            QName baseQName = SchemaUtils.getSimpleTypeBase(type.getNode(), this, type.getNodeStack());
            if (baseQName != null) {
                base = this.getType(baseQName);
                this.enhance(base);
                type.setRestrictionBase(base);
                base.setDynamicVar(WRAPPED_ARRAY_PATTERN, null);
                base.setDynamicVar(REF_IN_RESTRICTED_SIMPLETYPE, type);
            }
        }
        if (base != null && base.getRefType() != null && base.getRefType() == this.getUnmappableType()) {
            String dims = type.getDimensions();
            if (!type.isCollectionTypeEntry()) {
                dims = null;
            }
            type.setRefType(this.getUnmappableType(), dims);
            this.reportUnmappableConstruct(base.getQName());
        } else {
            TypeEntry compType;
            ChildElement ce;
            TypeEntry ctype;
            Vector children = new Vector();
            boolean possiblyWrappedArray = this.getChildren(type.getNode(), type.getNodeStack(), children);
            type.setChildren(children);
            if (this.metaInfo.getProperty("noWrappedArrays") != Boolean.TRUE && possiblyWrappedArray && base == null && (ctype = (ce = (ChildElement)type.getChildren().get(0)).getType()) instanceof Type && ctype.isCollectionTypeEntry() && (compType = ctype.getRefType()) instanceof Type) {
                type.setDynamicVar(WRAPPED_ARRAY_PATTERN, compType);
            }
        }
        boolean isBaseComplexType = false;
        if (base != null) {
            isBaseComplexType = SchemaUtils.isComplexType(base.getNode(), base.getNodeStack());
        }
        if (isBaseComplexType && type.getChildren() != null) {
            boolean isUnmappable = false;
            Iterator it = type.getChildren().iterator();
            while (it.hasNext() && !isUnmappable) {
                ChildEntry ce = (ChildEntry)it.next();
                QName ceName = ce.getQName();
                if (ceName == null || !ceName.getNamespaceURI().equals("") || !ceName.getLocalPart().equals("_value")) continue;
                isUnmappable = true;
            }
            if (isUnmappable) {
                String dims = type.getDimensions();
                if (!type.isCollectionTypeEntry()) {
                    dims = null;
                }
                type.setRefType(this.getUnmappableType(), dims);
                type.setChildren(null);
                this.reportUnmappableConstruct(type.getQName());
            }
        }
    }

    private void enhance(GroupEntry groupEntry) throws IOException {
        if (groupEntry.getChildren() != null) {
            return;
        }
        Vector children = new Vector();
        boolean possiblyWrappedArray = this.getChildren(groupEntry.getNode(), groupEntry.getNodeStack(), children);
        groupEntry.setChildren(children);
    }

    private boolean getChildren(Node node, List nodeStack, Vector children) {
        Vector attributeGroupRefs;
        Vector groupRefs;
        Vector elems;
        boolean possiblyWrappedArray = true;
        Vector attrs = SchemaUtils.getContainedAttributeTypes(node, this, nodeStack);
        if (attrs != null && attrs.size() > 0) {
            possiblyWrappedArray = false;
            children.addAll(attrs);
        }
        if ((elems = SchemaUtils.getContainedElementDeclarations(node, this, nodeStack)) != null && elems.size() > 0) {
            children.addAll(elems);
        }
        if ((groupRefs = SchemaUtils.getContainedGroupRefs(node, this, nodeStack)) != null && groupRefs.size() > 0) {
            possiblyWrappedArray = false;
            children.addAll(groupRefs);
        }
        if ((attributeGroupRefs = SchemaUtils.getContainedAttributeGroupRefs(node, this, nodeStack)) != null && attributeGroupRefs.size() > 0) {
            possiblyWrappedArray = false;
            children.addAll(attributeGroupRefs);
        }
        if (children.size() != 1) {
            possiblyWrappedArray = false;
        }
        for (int i = 0; i < children.size(); ++i) {
            TypeEntry te;
            ChildEntry ce = (ChildEntry)children.get(i);
            if (ce instanceof ChildElement) {
                te = ((ChildElement)ce).getType();
                while (te instanceof Element && !te.isCollectionTypeEntry() && te.getRefType() != null) {
                    if (((Element)te).isNillable()) {
                        ((ChildElement)ce).setNillable(true);
                    }
                    te = te.getRefType();
                    possiblyWrappedArray = false;
                }
                ((ChildElement)ce).setType(te);
                continue;
            }
            if (!(ce instanceof ChildAttribute)) continue;
            te = ((ChildAttribute)ce).getType();
            while (te instanceof Attribute && te.getRefType() != null) {
                te = te.getRefType();
            }
            ((ChildAttribute)ce).setType(te);
        }
        return possiblyWrappedArray;
    }

    private void expandGroupReferences() throws IOException {
        for (int i = 0; i < this.types.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)this.types.get(i);
            if (!(typeEntry instanceof DefinedType) || typeEntry.getNode() == null) continue;
            this.expandGroupReferences((Type)typeEntry);
        }
    }

    private void expandGroupReferences(Type type) throws IOException {
        Vector children = type.getChildren();
        if (children == null || children != null && children.size() == 0) {
            return;
        }
        int index = 0;
        QName duplicateQName = null;
        while (index < children.size()) {
            ChildEntry child = (ChildEntry)children.elementAt(index);
            SymTabEntry reference = child.getReference();
            if (reference instanceof GroupEntry) {
                children.remove(index);
                Vector gChildren = ((GroupEntry)reference).getChildren();
                if (gChildren == null || gChildren.size() == 0) continue;
                children.addAll(gChildren);
                continue;
            }
            if (this.containsQName(children, index)) {
                duplicateQName = child.getQName();
            }
            ++index;
        }
        if (duplicateQName != null) {
            String dims = type.getDimensions();
            if (!type.isCollectionTypeEntry()) {
                dims = null;
            }
            type.setRefType(this.getUnmappableType(), dims);
            type.setChildren(null);
            this.reportUnmappableConstruct(type.getQName());
        }
    }

    private boolean containsQName(List list, int index) {
        QName qName = ((Entry)list.get(index)).getQName();
        for (int i = 0; i < index; ++i) {
            QName qName2 = ((Entry)list.get(i)).getQName();
            if (qName2 == null || !qName2.equals(qName)) continue;
            return true;
        }
        return false;
    }

    private void populateMessages(Definition def) throws IOException {
        Iterator i = def.getMessages().values().iterator();
        while (i.hasNext()) {
            Message message = (Message)i.next();
            MessageEntry mEntry = new MessageEntry(message, this);
            this.symbolTablePut(mEntry);
        }
    }

    private void populatePortTypes(Definition def) throws IOException {
        Iterator i = def.getPortTypes().values().iterator();
        while (i.hasNext()) {
            PortType portType = (PortType)i.next();
            if (portType.isUndefined()) continue;
            PortTypeEntry ptEntry = new PortTypeEntry(portType, this);
            this.symbolTablePut(ptEntry);
        }
    }

    private void populateBindings(Definition def) throws IOException {
        Iterator i = def.getBindings().values().iterator();
        while (i.hasNext()) {
            Binding binding = (Binding)i.next();
            BindingEntry bEntry = new BindingEntry(binding, this);
            this.symbolTablePut(bEntry);
            ExtensibilityElement extBinding = this.getHttpSoapEJBBindingExtElement(binding);
            if (extBinding != null) {
                bEntry.setDynamicVar(BindingEntry.BINDING_NAMESPACE, extBinding.getElementType().getNamespaceURI());
            }
            if (extBinding instanceof SOAPBinding) {
                bEntry.setBindingType(0);
                SOAPBinding sb = (SOAPBinding)extBinding;
                bEntry.setDynamicVar(BindingEntry.SOAP_TRANSPORT_URI, sb.getTransportURI());
                String style = sb.getStyle();
                if ("rpc".equalsIgnoreCase(style)) {
                    bEntry.setBindingStyle(Style.RPC);
                }
            } else if (extBinding instanceof HTTPBinding) {
                HTTPBinding hb = (HTTPBinding)extBinding;
                if (hb.getVerb().equalsIgnoreCase("post")) {
                    bEntry.setBindingType(2);
                } else {
                    bEntry.setBindingType(1);
                }
            } else {
                bEntry.setBindingType(4);
            }
            List bindList = binding.getBindingOperations();
            Iterator opIterator = bindList.iterator();
            while (opIterator.hasNext()) {
                BindingOperation bindOp = (BindingOperation)opIterator.next();
                this.addBindingOperation(bEntry, bindOp);
            }
            this.checkOperations(binding.getPortType(), binding);
        }
    }

    private void checkOperations(PortType portType, Binding binding) throws IOException {
        List portTypeList = portType.getOperations();
        Iterator opIterator = portTypeList.iterator();
        while (opIterator.hasNext()) {
            String outputName;
            String inputName;
            Operation operation = (Operation)opIterator.next();
            Input input = operation.getInput();
            Output output = operation.getOutput();
            String opName = operation.getName();
            if (binding.getBindingOperation(opName, inputName = input == null ? null : input.getName(), outputName = output == null ? null : output.getName()) != null) continue;
            boolean fatalError = false;
            try {
                portType.getOperation(opName, null, null);
                fatalError = binding.getBindingOperation(opName, null, null) == null;
            }
            catch (IllegalArgumentException e) {
                fatalError = true;
            }
            if (!fatalError) continue;
            this.env.reportFatalErr(Messages.getMessage("unmatchedBindOp00", new String[]{opName, inputName, outputName}));
        }
    }

    private void addBindingOperation(BindingEntry bEntry, BindingOperation bindOp) throws IOException {
        String outputName;
        Operation operation = bindOp.getOperation();
        BindingInput bindingInput = bindOp.getBindingInput();
        BindingOutput bindingOutput = bindOp.getBindingOutput();
        String opName = bindOp.getName();
        String inputName = bindingInput == null ? null : bindingInput.getName();
        String string = outputName = bindingOutput == null ? null : bindingOutput.getName();
        if (bEntry.getBinding().getPortType().getOperation(opName, inputName, outputName) == null) {
            throw new IOException(Messages.getMessage("unmatchedOp", new String[]{opName, inputName, outputName}));
        }
        BindingOperationEntry boe = new BindingOperationEntry(bindOp, this);
        bEntry.addOperation(operation, boe);
        List elems = boe.getBindingOperation().getExtensibilityElements();
        Iterator j = elems.iterator();
        while (j.hasNext()) {
            Object obj = j.next();
            if (!(obj instanceof SOAPOperation)) continue;
            String style = ((SOAPOperation)obj).getStyle();
            boe.setDynamicVar(BindingOperationEntry.SOAP_ACTION_URI, ((SOAPOperation)obj).getSoapActionURI());
            if (style == null || style.equals(bEntry.getBindingStyle().toString())) continue;
            throw new IOException(Messages.getMessage("useMismatch", new String[]{opName, "binding style", bEntry.getBindingStyle().toString(), "operation style", style}));
        }
        if (bindingInput != null) {
            this.setBodyUseAndNamespace(boe, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setBodyUseAndNamespace(boe, bindingOutput.getExtensibilityElements(), false);
        }
        if (boe.getInputBodyUse() != null && boe.getOutputBodyUse() != null && boe.getInputBodyUse() != boe.getOutputBodyUse()) {
            throw new IOException(Messages.getMessage("useMismatch", new String[]{opName, "input use", boe.getInputBodyUse().toString(), "output use", boe.getOutputBodyUse().toString()}));
        }
        if (bEntry.getBindingStyle() == Style.DOCUMENT && boe.getInputBodyUse() == Use.ENCODED) {
            this.env.reportFatalErr(Messages.getMessage("invalidDocEnc01", Style.DOCUMENT.getName(), Use.ENCODED.getName(), bEntry.getQName().getLocalPart(), boe.getBindingOperation().getName()));
        }
        this.addOperationParameters(bEntry, boe);
        if (bindingInput != null) {
            this.setHeaderInfo(boe, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setHeaderInfo(boe, bindingOutput.getExtensibilityElements(), false);
        }
        if (bindingInput != null) {
            this.setMIMEInfo(boe, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setMIMEInfo(boe, bindingOutput.getExtensibilityElements(), false);
        }
        this.addOperationFaults(bEntry, boe);
        if (bindingInput != null) {
            this.setHeaderFaultInfo(boe, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setHeaderFaultInfo(boe, bindingOutput.getExtensibilityElements(), false);
        }
    }

    public void addOperationParameters(BindingEntry bEntry, BindingOperationEntry boe) throws IOException {
        int i;
        Binding binding = bEntry.getBinding();
        PortType portType = binding.getPortType();
        String namespace = portType.getQName().getNamespaceURI();
        Operation operation = boe.getBindingOperation().getOperation();
        Input input = operation.getInput();
        Output output = operation.getOutput();
        QName inMessageQName = null;
        QName outMessageQName = null;
        if (input != null && input.getMessage() != null && input.getMessage().getParts() != null && input.getMessage().getParts().values().size() != 0) {
            inMessageQName = input.getMessage().getQName();
        }
        if (output != null && output.getMessage() != null) {
            outMessageQName = output.getMessage().getQName();
        }
        MetaOperationKey key = new MetaOperationKey(bEntry.getQName(), operation.getName(), inMessageQName, outMessageQName);
        MetaOperationValue metaValue = (MetaOperationValue)this.metaInfo.getOperationMap().get(key);
        if (metaValue == null) {
            key = new MetaOperationKey(bEntry.getQName(), operation.getName(), inMessageQName, null);
            metaValue = (MetaOperationValue)this.metaInfo.getOperationMap().get(key);
        }
        boolean forceNoWrap = false;
        if (metaValue != null) {
            forceNoWrap = !metaValue.isWrapped();
        } else if (this.metaInfo != null) {
            forceNoWrap = this.metaInfo.getProperty("noWrappedOperations") == Boolean.TRUE || this.metaInfo.getProperty("noDataBinding") == Boolean.TRUE;
        }
        List parameterOrder = null;
        ArrayList modeOrder = null;
        if (metaValue != null) {
            parameterOrder = metaValue.getParameterOrder();
            modeOrder = metaValue.getModeOrder();
        } else {
            parameterOrder = operation.getParameterOrdering();
        }
        if (parameterOrder != null && parameterOrder.isEmpty()) {
            parameterOrder = null;
        }
        if (!(parameterOrder == null || metaValue != null && metaValue.isWrapped() || input == null)) {
            Message inputMsg = input.getMessage();
            Map allInputs = inputMsg.getParts();
            List inputOrder = parameterOrder;
            if (modeOrder != null) {
                inputOrder = new ArrayList();
                for (int i2 = 0; i2 < modeOrder.size(); ++i2) {
                    if (!modeOrder.get(i2).equals("IN") && !modeOrder.get(i2).equals("INOUT")) continue;
                    inputOrder.add(parameterOrder.get(i2));
                }
            }
            List orderedInputs = inputMsg.getOrderedParts(inputOrder);
            if (allInputs.size() != orderedInputs.size()) {
                throw new IOException(Messages.getMessage("emitFail00", operation.getName()));
            }
        }
        String returnPart = null;
        if (metaValue != null) {
            returnPart = metaValue.getReturnPart();
        }
        Vector inputs = new Vector();
        Vector outputs = new Vector();
        boolean wrappedIn = false;
        boolean wrappedOut = false;
        StringHolder wrappedNamespace = new StringHolder();
        Style opStyle = bEntry.getBindingStyle();
        if (input != null && input.getMessage() != null && (wrappedIn = this.createBindingParams(inputs, this.getMessageEntry(input.getMessage().getQName()), true, boe, bEntry, wrappedNamespace, forceNoWrap, opStyle))) {
            opStyle = Style.WRAPPED;
        }
        if (output != null && output.getMessage() != null) {
            wrappedOut = this.createBindingParams(outputs, this.getMessageEntry(output.getMessage().getQName()), false, boe, bEntry, null, forceNoWrap, opStyle);
        }
        if (wrappedIn) {
            if (output == null || wrappedOut) {
                boe.setWrapped(true);
                boe.setNamespace(wrappedNamespace.value);
            } else {
                opStyle = bEntry.getBindingStyle();
                inputs = new Vector();
                outputs = new Vector();
                if (input != null && input.getMessage() != null) {
                    this.createBindingParams(inputs, this.getMessageEntry(input.getMessage().getQName()), true, boe, bEntry, wrappedNamespace, true, opStyle);
                }
                if (output != null && output.getMessage() != null) {
                    this.createBindingParams(outputs, this.getMessageEntry(output.getMessage().getQName()), false, boe, bEntry, null, true, opStyle);
                }
            }
        }
        if (parameterOrder != null) {
            boolean needParameterOrdering = false;
            if (wrappedOut) {
                needParameterOrdering = this.checkInOutOrdering(inputs, outputs, operation.getName(), outMessageQName);
            }
            boe.setDynamicVar(JavaGeneratorFactory.OUT_ORDERING_REQUIRED, String.valueOf(needParameterOrdering));
            for (int i3 = 0; i3 < parameterOrder.size(); ++i3) {
                String partName = (String)parameterOrder.get(i3);
                int index = -1;
                if (modeOrder == null || modeOrder.get(i3).equals("IN") || modeOrder.get(i3).equals("INOUT")) {
                    index = this.getParamIndex(partName, inputs);
                }
                int outdex = -1;
                if (modeOrder == null || modeOrder.get(i3).equals("OUT") || modeOrder.get(i3).equals("INOUT")) {
                    outdex = this.getParamIndex(partName, outputs);
                }
                if (index >= 0) {
                    if (partName.equals(returnPart) && outdex >= 0) {
                        BindingParamEntry ret = (BindingParamEntry)outputs.get(outdex);
                        ret.setMode((byte)2);
                        boe.setReturn(ret);
                        outputs.remove(outdex);
                        outdex = -1;
                    } else if (outdex >= 0 && needParameterOrdering) {
                        BindingParamEntry inBpe = (BindingParamEntry)inputs.get(index);
                        BindingParamEntry outBpe = (BindingParamEntry)outputs.get(outdex);
                        inBpe.setDynamicVar(JavaGeneratorFactory.OUT_POSITION, (String)outBpe.getDynamicVar(JavaGeneratorFactory.OUT_POSITION));
                    }
                    this.addInishParm(inputs, outputs, index, outdex, boe);
                    inputs.remove(index);
                    continue;
                }
                if (outdex >= 0) {
                    this.addOutParm(outputs, outdex, boe);
                    outputs.remove(outdex);
                    continue;
                }
                if (wrappedIn) continue;
                System.err.println(Messages.getMessage("noPart00", partName));
            }
        }
        if (wrappedIn && wrappedOut && inputs.size() == 1 && outputs.size() == 1 && ((BindingParamEntry)inputs.get(0)).getQName().equals(((BindingParamEntry)outputs.get(0)).getQName()) && (metaValue == null || metaValue.getReturnPart() != null)) {
            this.addInishParm(inputs, null, 0, -1, boe);
        } else {
            for (i = 0; i < inputs.size(); ++i) {
                BindingParamEntry p = (BindingParamEntry)inputs.get(i);
                int outdex = -1;
                for (int j = 0; j < outputs.size() && outdex == -1; ++j) {
                    if (!p.getQName().equals(((BindingParamEntry)outputs.get(j)).getQName())) continue;
                    outdex = j;
                }
                this.addInishParm(inputs, outputs, i, outdex, boe);
            }
        }
        if (outputs.size() == 1 && (metaValue == null || metaValue.getReturnPart() != null)) {
            BindingParamEntry ret = (BindingParamEntry)outputs.get(0);
            ret.setMode((byte)2);
            boe.setReturn(ret);
        } else {
            for (i = 0; i < outputs.size(); ++i) {
                this.addOutParm(outputs, i, boe);
            }
        }
    }

    private int getParamIndex(String paramOrderName, Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            BindingParamEntry parm = (BindingParamEntry)v.get(i);
            if (!parm.getQName().getLocalPart().equals(paramOrderName)) continue;
            return i;
        }
        return -1;
    }

    private void addInishParm(Vector inputs, Vector outputs, int index, int outdex, BindingOperationEntry boe) {
        BindingParamEntry p = (BindingParamEntry)inputs.get(index);
        p.setMode((byte)1);
        if (outdex >= 0) {
            BindingParamEntry outParam = (BindingParamEntry)outputs.get(outdex);
            if (p.getType().equals(outParam.getType())) {
                outputs.remove(outdex);
                p.setMode((byte)3);
                p.setOutMessageEntry(outParam.getOutMessageEntry());
            }
        }
        boe.addParameter(p);
    }

    private void addOutParm(Vector outputs, int outdex, BindingOperationEntry boe) {
        BindingParamEntry p = (BindingParamEntry)outputs.get(outdex);
        p.setMode((byte)2);
        boe.addParameter(p);
    }

    private boolean createBindingParams(Vector params, MessageEntry me, boolean input, BindingOperationEntry boe, BindingEntry bEntry, StringHolder wrappedNamespace, boolean forceNoWrap, Style opStyle) throws IOException {
        int numberOfElements;
        Use use = input ? boe.getInputBodyUse() : boe.getOutputBodyUse();
        String opName = boe.getQName().getLocalPart();
        boolean isWrapped = false;
        if (input) {
            numberOfElements = 0;
            boolean possiblyWrapped = false;
            List parts = me.getMessage().getOrderedParts(null);
            Iterator i = parts.iterator();
            while (i.hasNext()) {
                Part part = (Part)i.next();
                if (use == Use.ENCODED && part.getTypeName() == null) {
                    throw new IOException(Messages.getMessage("emitFailBadUse00", part.getName(), boe.getBindingOperation().getName()));
                }
                if (part.getElementName() == null) continue;
                ++numberOfElements;
                if (!input || !part.getElementName().getLocalPart().equals(opName)) continue;
                possiblyWrapped = true;
            }
            if (!forceNoWrap && opStyle == Style.DOCUMENT && use == Use.LITERAL && numberOfElements == 1 && possiblyWrapped) {
                isWrapped = true;
            }
        } else {
            numberOfElements = 0;
            List parts = me.getMessage().getOrderedParts(null);
            Iterator i = parts.iterator();
            while (i.hasNext()) {
                Part part = (Part)i.next();
                if (use == Use.ENCODED && part.getTypeName() == null) {
                    throw new IOException(Messages.getMessage("emitFailBadUse00", part.getName(), boe.getBindingOperation().getName()));
                }
                if (part.getElementName() == null) continue;
                ++numberOfElements;
            }
            if (!forceNoWrap && opStyle == Style.WRAPPED && use == Use.LITERAL && numberOfElements <= 1) {
                isWrapped = true;
            }
        }
        Iterator i = me.getMessage().getOrderedParts(null).iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            QName elementName = part.getElementName();
            QName typeName = part.getTypeName();
            String partName = part.getName();
            if (isWrapped) {
                if (input) {
                    wrappedNamespace.value = elementName.getNamespaceURI();
                }
                if (typeName != null && bEntry.hasMIMETypes()) {
                    String bindingName = bEntry == null ? "unknown" : bEntry.getBinding().getQName().toString();
                    throw new IOException(Messages.getMessage("literalTypePart00", new String[]{partName, opName, bindingName}));
                }
                Type type = this.getType(typeName);
                if (type == null) {
                    TypeEntry typeEntry = this.getElement(elementName);
                    while (typeEntry instanceof Element) {
                        typeEntry = typeEntry.getRefType();
                    }
                    type = (Type)typeEntry;
                }
                if (type == null) {
                    throw new IOException(Messages.getMessage("badTypeNode", new String[]{partName, opName, elementName.toString()}));
                }
                if (type.getExtensionBase() != null || type.getRestrictionBase() != null || type.isCollectionTypeEntry() || type.isBaseType() || type.isSimpleType() || type.isNotMappable()) {
                    isWrapped = false;
                }
                if (isWrapped) {
                    int j;
                    Vector children = type.getChildren();
                    if (children == null) {
                        isWrapped = false;
                    } else {
                        for (j = 0; j < children.size() && isWrapped; ++j) {
                            if (children.get(j) instanceof ChildElement) continue;
                            isWrapped = false;
                        }
                    }
                    if (isWrapped) {
                        if (children != null) {
                            for (j = 0; j < children.size(); ++j) {
                                ChildElement elem = (ChildElement)children.elementAt(j);
                                BindingParamEntry p = new BindingParamEntry(elem.getQName(), this);
                                if (input) {
                                    p.setInMessageEntry(me);
                                    p.setDynamicVar(JavaGeneratorFactory.IN_POSITION, String.valueOf(j));
                                } else {
                                    p.setOutMessageEntry(me);
                                    p.setDynamicVar(JavaGeneratorFactory.OUT_POSITION, String.valueOf(j));
                                }
                                p.setType(elem.getType());
                                p.setMinOccursIs0(elem.getMinOccursIs0());
                                p.setMaxOccursIs1(!elem.getType().isCollectionTypeEntry());
                                p.setNillable(elem.isNillable());
                                p.setParentNamespace(type.getQName().getNamespaceURI());
                                params.add(p);
                            }
                        }
                        return true;
                    }
                }
            }
            BindingParamEntry param = new BindingParamEntry(QNameTable.createQName("", partName), this);
            if (input) {
                param.setInMessageEntry(me);
            } else {
                param.setOutMessageEntry(me);
            }
            param.setName(partName);
            if (typeName != null) {
                param.setType(this.getType(typeName));
            } else if (elementName != null) {
                Element el = this.getElement(elementName);
                param.setType(el);
                param.setNillable(el != null && el.isNillable());
            } else {
                throw new IOException(Messages.getMessage("noTypeOrElement00", new String[]{partName, opName}));
            }
            params.add(param);
        }
        return isWrapped;
    }

    private void setMIMEInfo(BindingOperationEntry boe, List elems, boolean input) throws IOException {
        if (elems == null) {
            return;
        }
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof MIMEMultipartRelated)) continue;
            MIMEMultipartRelated mpr = (MIMEMultipartRelated)obj;
            List parts = mpr.getMIMEParts();
            Iterator i = parts.iterator();
            while (i.hasNext()) {
                MIMEPart part = (MIMEPart)i.next();
                List elems2 = part.getExtensibilityElements();
                Iterator j = elems2.iterator();
                while (j.hasNext()) {
                    Object obj2 = j.next();
                    if (!(obj2 instanceof MIMEContent)) continue;
                    MIMEContent content = (MIMEContent)obj2;
                    BindingParamEntry param = boe.getParameter(content.getPart());
                    if (param == null) {
                        param = boe.getReturn();
                    }
                    if (param == null) continue;
                    param.setMIMEType(content.getType());
                }
            }
        }
    }

    private void setMIMEType(BindingParamEntry p, String mimeType) {
        QName mimeQName;
        if (mimeType == null && (mimeQName = p.getType().getQName()).getNamespaceURI().equals("http://xml.apache.org/xml-soap")) {
            if (Constants.MIME_IMAGE.equals(mimeQName)) {
                mimeType = "image/jpeg";
            } else if (Constants.MIME_PLAINTEXT.equals(mimeQName)) {
                mimeType = "text/plain";
            } else if (Constants.MIME_MULTIPART.equals(mimeQName)) {
                mimeType = "multipart/related";
            } else if (Constants.MIME_SOURCE.equals(mimeQName)) {
                mimeType = "text/xml";
            }
        }
        p.setMIMEType(mimeType);
    }

    private void setHeaderInfo(BindingOperationEntry boe, List elems, boolean input) throws IOException {
        if (elems == null) {
            return;
        }
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof SOAPHeader) {
                SOAPHeader header2 = (SOAPHeader)obj;
                BindingParamEntry param = boe.getParameter(header2.getPart());
                if (param == null) continue;
                if (input) {
                    param.setInHeader(true);
                    continue;
                }
                param.setOutHeader(true);
                continue;
            }
            if (!(obj instanceof MIMEMultipartRelated)) continue;
            MIMEMultipartRelated mpr = (MIMEMultipartRelated)obj;
            Iterator i = mpr.getMIMEParts().iterator();
            while (i.hasNext()) {
                MIMEPart part = (MIMEPart)i.next();
                Iterator j = part.getExtensibilityElements().iterator();
                while (j.hasNext()) {
                    BindingParamEntry param;
                    Object extElement = j.next();
                    String headerParamName = null;
                    if (extElement instanceof SOAPHeader) {
                        headerParamName = ((SOAPHeader)extElement).getPart();
                    } else {
                        QName headerQname = ((ExtensibilityElement)extElement).getElementType();
                        if (headerQname.getLocalPart().equals("header") && extElement instanceof UnknownExtensibilityElement) {
                            org.w3c.dom.Element domElement = ((UnknownExtensibilityElement)extElement).getElement();
                            headerParamName = domElement.getAttributeNode("part").getValue();
                        }
                    }
                    if (headerParamName == null || (param = boe.getParameter(headerParamName)) == null) continue;
                    if (input) {
                        param.setInHeader(true);
                        continue;
                    }
                    param.setOutHeader(true);
                }
            }
        }
    }

    private void setHeaderFaultInfo(BindingOperationEntry boe, List elems, boolean input) throws IOException {
        if (elems == null) {
            return;
        }
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof SOAPHeader)) continue;
            SOAPHeader header2 = (SOAPHeader)obj;
            Iterator headerFaults = header2.getSOAPHeaderFaults().iterator();
            while (headerFaults.hasNext()) {
                SOAPHeaderFault headerFault = (SOAPHeaderFault)headerFaults.next();
                BindingFaultRefEntry fault2 = boe.getFault(headerFault.getMessage().getLocalPart());
                if (fault2 == null) {
                    fault2 = this.createBindingFaultRef(this.getMessageEntry(headerFault.getMessage()), boe);
                }
                if (input) {
                    fault2.setInHeader(true);
                } else {
                    fault2.setOutHeader(true);
                }
                fault2.setUse(Use.getUse(headerFault.getUse()));
            }
        }
    }

    private void addOperationFaults(BindingEntry bEntry, BindingOperationEntry boe) throws IOException {
        BindingOperation bindOp = boe.getBindingOperation();
        Binding binding = bEntry.getBinding();
        Iterator faultMapIter = bindOp.getBindingFaults().values().iterator();
        while (faultMapIter.hasNext()) {
            BindingFault bFault = (BindingFault)faultMapIter.next();
            String faultName = bFault.getName();
            if (faultName == null || faultName.length() == 0) {
                throw new IOException(Messages.getMessage("unNamedFault00", bindOp.getName(), binding.getQName().toString()));
            }
            SOAPFault soapFault = null;
            Iterator faultIter = bFault.getExtensibilityElements().iterator();
            while (faultIter.hasNext()) {
                Object obj = faultIter.next();
                if (!(obj instanceof SOAPFault)) continue;
                soapFault = (SOAPFault)obj;
                break;
            }
            if (soapFault == null && bEntry.getBindingType() != 4) {
                throw new IOException(Messages.getMessage("missingSoapFault00", faultName, bindOp.getName(), binding.getQName().toString()));
            }
            Fault opFault = bindOp.getOperation().getFault(bFault.getName());
            if (opFault == null) {
                throw new IOException(Messages.getMessage("noPortTypeFault", new String[]{bFault.getName(), bindOp.getName(), binding.getQName().toString()}));
            }
            MessageEntry me = this.getMessageEntry(opFault.getMessage().getQName());
            BindingFaultRefEntry fault2 = this.createBindingFaultRef(me, boe);
            if (bEntry.getBindingType() == 4) continue;
            fault2.setUse(Use.getUse(soapFault.getUse()));
            if (boe.getInputBodyUse() == null || fault2.getUse() == null || boe.getInputBodyUse() == fault2.getUse()) continue;
            throw new IOException(Messages.getMessage("useMismatch", new String[]{bindOp.getName(), "input use", boe.getInputBodyUse().toString(), "fault use", fault2.getUse().toString()}));
        }
    }

    private BindingFaultRefEntry createBindingFaultRef(MessageEntry me, BindingOperationEntry boe) {
        this.setMessageEntryAsFault(me);
        BindingFaultRefEntry fault2 = new BindingFaultRefEntry(me, this);
        boe.addFault(fault2);
        return fault2;
    }

    public void setMessageEntryAsFault(MessageEntry me) {
        if (me.isFault()) {
            return;
        }
        me.setFault(true);
        Vector<ChildFaultPartEntry> children = new Vector<ChildFaultPartEntry>();
        List parts = me.getMessage().getOrderedParts(null);
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            QName qName = QNameTable.createQName("", part.getName());
            TypeEntry te = null;
            te = part.getTypeName() != null ? this.getType(part.getTypeName()) : this.getElement(part.getElementName());
            children.add(new ChildFaultPartEntry(qName, te, this));
        }
        me.setFaultParts(children);
    }

    private void setBodyUseAndNamespace(BindingOperationEntry boe, List elems, boolean input) throws IOException {
        this.setBodyUse(boe, "literal", null, input);
        if (elems == null) {
            return;
        }
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof SOAPBody) {
                SOAPBody body = (SOAPBody)obj;
                this.setBodyUse(boe, body.getUse(), body.getEncodingStyles(), input);
                if (input && body.getNamespaceURI() != null) {
                    boe.setNamespace(body.getNamespaceURI());
                }
                if (input || body.getNamespaceURI() == null) continue;
                boe.setOutputNamespace(body.getNamespaceURI());
                continue;
            }
            if (obj instanceof SOAPHeader) {
                SOAPHeader header2 = (SOAPHeader)obj;
                this.setBodyUse(boe, header2.getUse(), header2.getEncodingStyles(), input);
                continue;
            }
            if (!(obj instanceof MIMEMultipartRelated)) continue;
            MIMEMultipartRelated mpr = (MIMEMultipartRelated)obj;
            List parts = mpr.getMIMEParts();
            Iterator i = parts.iterator();
            while (i.hasNext()) {
                MIMEPart part = (MIMEPart)i.next();
                List elems2 = part.getExtensibilityElements();
                Iterator j = elems2.iterator();
                while (j.hasNext()) {
                    Object obj2 = j.next();
                    if (obj2 instanceof SOAPBody) {
                        this.setBodyUse(boe, ((SOAPBody)obj2).getUse(), ((SOAPBody)obj2).getEncodingStyles(), input);
                        if (!input || ((SOAPBody)obj2).getNamespaceURI() == null) continue;
                        boe.setNamespace(((SOAPBody)obj2).getNamespaceURI());
                        continue;
                    }
                    if (!(obj2 instanceof SOAPHeader)) continue;
                    SOAPHeader header3 = (SOAPHeader)obj2;
                    this.setBodyUse(boe, header3.getUse(), header3.getEncodingStyles(), input);
                }
            }
        }
    }

    private void setBodyUse(BindingOperationEntry boe, String use_str, List encodingStyles, boolean input) throws IOException {
        Use use = use_str == null ? Use.LITERAL : Use.getUse(use_str);
        if (input) {
            boe.setInputBodyUse(use);
            if (encodingStyles != null && encodingStyles.size() > 0) {
                if (use == Use.LITERAL) {
                    if (log.isDebugEnabled()) {
                        log.debug("setBodyUse: input encodingStyle [" + encodingStyles.get(0) + "]provided with literal use and is being ignored");
                    }
                } else {
                    boe.setInputEncodingStyle((String)encodingStyles.get(0));
                }
            }
        } else {
            boe.setOutputBodyUse(use);
            if (encodingStyles != null && encodingStyles.size() > 0) {
                if (use == Use.LITERAL) {
                    if (log.isDebugEnabled()) {
                        log.debug("setBodyUse: output encodingStyle [" + encodingStyles.get(0) + "]provided with literal use and is being ignored");
                    }
                } else {
                    boe.setOutputEncodingStyle((String)encodingStyles.get(0));
                }
            }
        }
    }

    private void populateServices(Definition def) throws IOException {
        Entry sEntry = null;
        Iterator i = def.getServices().values().iterator();
        while (i.hasNext()) {
            Service service = (Service)i.next();
            if (service.getQName() == null || service.getQName().getLocalPart() == null || service.getQName().getLocalPart().equals("")) {
                throw new IOException(Messages.getMessage("BadServiceName00"));
            }
            this.addServices(service);
            sEntry = new ServiceEntry(service, this);
            this.symbolTablePut((SymTabEntry)sEntry);
            Map portMap = service.getPorts();
            Iterator portIt = portMap.values().iterator();
            while (portIt.hasNext()) {
                Port p = (Port)portIt.next();
                QName portQName = QNameTable.createQName(service.getQName().getNamespaceURI(), p.getName());
                ((ServiceEntry)sEntry).addPort(new PortEntry(portQName, p, this));
                BindingEntry be = this.getBindingEntry(p.getBinding().getQName());
                be.setServiceName(service.getQName());
            }
        }
        if (sEntry != null && this.isNonBoundWSDL(def)) {
            sEntry.setDynamicVar(NON_BOUND_WSDL, Boolean.TRUE);
            PortEntry portEntry = ((ServiceEntry)sEntry).getPort(0);
            Port port2 = portEntry.getPort();
            Binding binding = port2.getBinding();
            BindingEntry bEntry = this.getBindingEntry(binding.getQName());
            bEntry.setBindingType(4);
        }
    }

    private void setReferences(Definition def, Document doc) {
        TypeEntry type;
        int i;
        boolean postProcessTypes = false;
        Map stuff = this.getServices();
        if (stuff != null && stuff.isEmpty() && def != null) {
            stuff = def.getBindings();
            if (stuff != null && stuff.isEmpty()) {
                stuff = def.getPortTypes();
                if (stuff != null && stuff.isEmpty()) {
                    stuff = def.getMessages();
                    if (stuff != null && stuff.isEmpty()) {
                        for (i = 0; i < this.types.size() && !postProcessTypes; ++i) {
                            type = (TypeEntry)this.types.get(i);
                            postProcessTypes = this.setTypeReferences(type, doc, false) || postProcessTypes;
                        }
                    } else {
                        Iterator i2 = stuff.values().iterator();
                        while (i2.hasNext()) {
                            Message message = (Message)i2.next();
                            MessageEntry mEntry = this.getMessageEntry(message.getQName());
                            postProcessTypes = this.setMessageReferences(mEntry, def, doc, false, postProcessTypes) || postProcessTypes;
                        }
                    }
                } else {
                    Iterator i3 = stuff.values().iterator();
                    while (i3.hasNext()) {
                        PortType portType = (PortType)i3.next();
                        PortTypeEntry ptEntry = this.getPortTypeEntry(portType.getQName());
                        postProcessTypes = this.setPortTypeReferences(ptEntry, null, def, doc, postProcessTypes) || postProcessTypes;
                    }
                }
            } else {
                Iterator i4 = stuff.values().iterator();
                while (i4.hasNext()) {
                    Binding binding = (Binding)i4.next();
                    BindingEntry bEntry = this.getBindingEntry(binding.getQName());
                    postProcessTypes = this.setBindingReferences(bEntry, def, doc, postProcessTypes) || postProcessTypes;
                }
            }
        } else {
            Iterator i5 = stuff.values().iterator();
            while (i5.hasNext()) {
                Service service = (Service)i5.next();
                ServiceEntry sEntry = this.getServiceEntry(service.getQName());
                String serviceName = service.getQName().getLocalPart();
                if (!this.shouldServiceBeWritten(serviceName) || this.env.getSuspendGen()) continue;
                postProcessTypes = this.setServiceReferences(sEntry, def, doc, postProcessTypes) || postProcessTypes;
            }
        }
        if (postProcessTypes) {
            for (i = 0; i < this.types.size(); ++i) {
                type = (TypeEntry)this.types.get(i);
                if (type.isReferenced()) continue;
                this.setTypeReferences(type, doc, false, true);
            }
        }
    }

    private boolean setTypeReferences(TypeEntry entry, Document doc, boolean literalWrapped) {
        return this.setTypeReferences(entry, doc, literalWrapped, false);
    }

    private boolean setTypeReferences(TypeEntry entry, Document doc, boolean literalWrapped, boolean nested) {
        boolean rc = false;
        if (entry.isReferenced() && !literalWrapped || entry.isOnlyWrappedLiteralReferenced() && literalWrapped) {
            entry.setOnlyWrappedLiteralReference(literalWrapped);
            return rc;
        }
        if (!entry.isReferenced() && literalWrapped) {
            entry.setOnlyWrappedLiteralReference(true);
        } else if (entry.isOnlyWrappedLiteralReferenced() && !literalWrapped) {
            entry.setOnlyWrappedLiteralReference(false);
        }
        CustomRegistry registry = this.metaInfo.getCustomRegistry();
        Node node = entry.getNode();
        if (this.addImports || node == null || node.getOwnerDocument() == doc) {
            entry.setIsReferenced(true);
            if (entry instanceof DefinedElement) {
                BooleanHolder forElement = new BooleanHolder();
                QName referentName = Utils.getTypeQName(node, forElement, false, entry.getNodeStack(), this.env);
                if (referentName != null) {
                    if ((this.debug || log.isDebugEnabled()) && Constants.isSchemaXSD(referentName.getNamespaceURI()) && ("anyType".equals(referentName.getLocalPart()) || "any".equals(referentName.getLocalPart()))) {
                        String msg = "Debug: SIDX " + entry.getSIDX() + " " + entry.getQName().getLocalPart() + " refers to an anyType, ALL types will be generated. ";
                        if (log.isDebugEnabled()) {
                            log.debug(msg);
                        } else {
                            this.env.report(msg);
                        }
                    }
                    TypeEntry referent = null;
                    referent = forElement.value ? this.getElement(referentName) : this.getType(referentName);
                    if (referent != null) {
                        if (registry != null && registry.getJavaName(referent.getQName()) != null) {
                            referent.setIsReferenced(true);
                        } else {
                            rc = this.setTypeReferences(referent, doc, literalWrapped, nested) || rc;
                        }
                        return rc;
                    }
                }
                TypeEntry refType = entry.getRefType();
                while (refType instanceof Element) {
                    refType = refType.getRefType();
                }
                if (refType != null && ((Type)refType).isAnonType()) {
                    rc = this.setTypeReferences(refType, doc, literalWrapped, nested) || rc;
                    return rc;
                }
            }
        }
        if (registry != null && registry.getJavaName(entry.getQName()) != null) {
            return false;
        }
        if (!nested) {
            Set nestedTypes = Utils.getNestedTypes(entry, this);
            if (this.isReferencedViaAny(nestedTypes)) {
                return true;
            }
            Iterator it = nestedTypes.iterator();
            while (it.hasNext()) {
                TypeEntry nestedType = (TypeEntry)it.next();
                if (nestedType.isReferenced()) continue;
                this.setTypeReferences(nestedType, doc, false, true);
            }
        }
        return rc;
    }

    private boolean isReferencedViaAny(Set nestedTypes) {
        if (nestedTypes.size() == this.getTypes().size()) {
            Iterator it = nestedTypes.iterator();
            while (it.hasNext()) {
                TypeEntry type = (TypeEntry)it.next();
                if (!Constants.isSchemaXSD(type.getQName().getNamespaceURI()) || !type.getQName().getLocalPart().equals("anyType") && !type.getQName().getLocalPart().equals("any")) continue;
                if (this.debug || log.isDebugEnabled()) {
                    String msg = "Debug: SIDX " + type.getSIDX() + " is an anyType, ALL types will  be generated.";
                    if (log.isDebugEnabled()) {
                        log.debug(msg);
                    } else {
                        this.env.report(msg);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean setMessageReferences(MessageEntry entry, Definition def, Document doc, boolean literalWrapped, boolean postProcessTypes) {
        Message message = entry.getMessage();
        if (this.addImports) {
            entry.setIsReferenced(true);
        } else {
            Map messages = def.getMessages();
            if (messages.containsValue(message)) {
                entry.setIsReferenced(true);
            }
        }
        Iterator parts = message.getParts().values().iterator();
        while (parts.hasNext() && (!postProcessTypes || literalWrapped)) {
            Part part = (Part)parts.next();
            TypeEntry type = this.getType(part.getTypeName());
            if (type != null) {
                postProcessTypes = this.setTypeReferences(type, doc, literalWrapped);
                continue;
            }
            type = this.getElement(part.getElementName());
            if (type == null) continue;
            postProcessTypes = this.setTypeReferences(type, doc, literalWrapped);
        }
        return postProcessTypes;
    }

    private boolean setPortTypeReferences(PortTypeEntry entry, BindingEntry bEntry, Definition def, Document doc, boolean postProcessTypes) {
        PortType portType = entry.getPortType();
        if (this.addImports) {
            entry.setIsReferenced(true);
        } else {
            Map portTypes = def.getPortTypes();
            if (portTypes.containsValue(portType)) {
                entry.setIsReferenced(true);
            }
        }
        Iterator operations = portType.getOperations().iterator();
        while (operations.hasNext()) {
            MessageEntry mEntry;
            Message message;
            Operation operation = (Operation)operations.next();
            Input input = operation.getInput();
            Output output = operation.getOutput();
            boolean literalWrappedInput = false;
            boolean literalWrappedOutput = false;
            if (bEntry != null) {
                BindingOperationEntry boe = bEntry.getOperation(operation);
                literalWrappedInput = boe.getInputBodyUse() == Use.LITERAL && boe.isWrapped();
                boolean bl = literalWrappedOutput = boe.getOutputBodyUse() == Use.LITERAL && boe.isWrapped();
            }
            if (input != null && (message = input.getMessage()) != null && (mEntry = this.getMessageEntry(message.getQName())) != null) {
                boolean bl = postProcessTypes = this.setMessageReferences(mEntry, def, doc, literalWrappedInput, postProcessTypes) || postProcessTypes;
            }
            if (output != null && (message = output.getMessage()) != null && (mEntry = this.getMessageEntry(message.getQName())) != null) {
                postProcessTypes = this.setMessageReferences(mEntry, def, doc, literalWrappedOutput, postProcessTypes) || postProcessTypes;
            }
            Iterator faults = operation.getFaults().values().iterator();
            while (faults.hasNext()) {
                MessageEntry mEntry2;
                Message message2 = ((Fault)faults.next()).getMessage();
                if (message2 == null || (mEntry2 = this.getMessageEntry(message2.getQName())) == null) continue;
                postProcessTypes = this.setMessageReferences(mEntry2, def, doc, false, postProcessTypes) || postProcessTypes;
            }
        }
        return postProcessTypes;
    }

    private boolean setBindingReferences(BindingEntry entry, Definition def, Document doc, boolean postProcessTypes) {
        if (entry.getBindingType() == 0 || entry.getBindingType() == 4) {
            Binding binding = entry.getBinding();
            if (this.addImports) {
                entry.setIsReferenced(true);
            } else {
                Map bindings = def.getBindings();
                if (bindings.containsValue(binding)) {
                    entry.setIsReferenced(true);
                }
            }
            PortType portType = binding.getPortType();
            PortTypeEntry ptEntry = this.getPortTypeEntry(portType.getQName());
            if (ptEntry != null) {
                postProcessTypes = this.setPortTypeReferences(ptEntry, entry, def, doc, postProcessTypes) || postProcessTypes;
            }
            Iterator operations = entry.getOperations();
            while (operations.hasNext()) {
                BindingOperationEntry boe = (BindingOperationEntry)operations.next();
                for (int i = 0; i < boe.numFaults(); ++i) {
                    MessageEntry mEntry = boe.getFault(i).getMessageEntry();
                    postProcessTypes = this.setMessageReferences(mEntry, def, doc, false, postProcessTypes) || postProcessTypes;
                }
            }
        }
        return postProcessTypes;
    }

    private boolean setServiceReferences(ServiceEntry entry, Definition def, Document doc, boolean postProcessTypes) {
        Service service = entry.getService();
        if (this.addImports) {
            entry.setIsReferenced(true);
        } else {
            Map services = this.getServices();
            if (services.containsValue(service)) {
                entry.setIsReferenced(true);
            }
        }
        Iterator ports = service.getPorts().values().iterator();
        while (ports.hasNext()) {
            Port port2 = (Port)ports.next();
            Binding binding = port2.getBinding();
            BindingEntry bEntry = this.getBindingEntry(binding.getQName());
            if (bEntry == null) continue;
            postProcessTypes = this.setBindingReferences(bEntry, def, doc, postProcessTypes) || postProcessTypes;
        }
        return postProcessTypes;
    }

    private void symbolTablePut(SymTabEntry entry) throws IOException {
        QName name2 = entry.getQName();
        SymTabEntry existingEntry = this.get(name2, entry.getClass());
        if (existingEntry == null) {
            if (entry instanceof Type && this.get(name2, UndefinedType.class) != null) {
                if (((Type)this.get(name2, UndefinedType.class)).isSimpleType() && !((Type)entry).isSimpleType()) {
                    throw new IOException(Messages.getMessage("AttrNotSimpleType01", name2.toString()));
                }
                this.replaceUndefined(entry, name2, Type.class);
            } else if (entry instanceof Element && this.get(name2, UndefinedElement.class) != null) {
                this.replaceUndefined(entry, name2, Element.class);
            } else if (entry instanceof Attribute && this.get(name2, UndefinedAttribute.class) != null) {
                this.replaceUndefined(entry, name2, Attribute.class);
            } else if (entry instanceof Group && this.get(name2, UndefinedGroup.class) != null) {
                this.replaceUndefined(entry, name2, Group.class);
            } else if (entry instanceof AttributeGroup && this.get(name2, UndefinedAttributeGroup.class) != null) {
                this.replaceUndefined(entry, name2, AttributeGroup.class);
            } else {
                Vector<SymTabEntry> v = (Vector<SymTabEntry>)this.symbolTable.get(name2);
                if (v == null) {
                    v = new Vector<SymTabEntry>();
                    this.symbolTable.put(name2, v);
                }
                v.add(entry);
                this.entryList.add(entry);
                entry.setSIDX(this.entryList.size());
                if (entry instanceof TypeEntry) {
                    this.types.add(entry);
                } else if (entry instanceof Group) {
                    this.groups.add(entry);
                } else if (entry instanceof AttributeGroup) {
                    this.attributeGroups.add(entry);
                }
            }
        } else if (!(this.isDuringProcessingOfRedefine || this.resolver.isIncludedMultipleTimes || existingEntry instanceof TypeEntry && ((TypeEntry)existingEntry).isBaseType())) {
            this.env.reporterr(Messages.getMessage("alreadyExists00", "" + name2));
        }
    }

    protected SymTabEntry lookup(int SIDX) {
        if (SIDX <= 0) {
            return null;
        }
        return (SymTabEntry)this.entryList.get(SIDX - 1);
    }

    private void replaceUndefined(SymTabEntry entry, QName name2, Class entryClass) throws IOException {
        Vector v = (Vector)this.symbolTable.get(name2);
        for (int i = 0; i < v.size(); ++i) {
            SymTabEntry oldEntry = (SymTabEntry)v.elementAt(i);
            if (!(oldEntry instanceof Undefined) || !entryClass.isAssignableFrom(oldEntry.getClass())) continue;
            v.setElementAt(entry, i);
            Vector fastVector = null;
            if (entry instanceof TypeEntry) {
                fastVector = this.types;
            } else if (entry instanceof Group) {
                fastVector = this.groups;
            } else if (entry instanceof AttributeGroup) {
                fastVector = this.attributeGroups;
            }
            if (fastVector != null) {
                for (int j = 0; j < fastVector.size(); ++j) {
                    if (fastVector.elementAt(j) != oldEntry) continue;
                    fastVector.setElementAt(entry, j);
                }
            }
            entry.setSIDX(oldEntry.getSIDX());
            this.entryList.set(entry.getSIDX() - 1, entry);
        }
    }

    private TypeEntry createBaseType(QName qName) {
        DefinedType type = null;
        String localPart = qName.getLocalPart();
        String baseName = this.btm.getBaseName(qName);
        if (baseName != null) {
            type = new DefinedType(qName, this);
            if (!Constants.equals(qName, Constants.XSD_ANY)) {
                type.setSimpleType(true);
            }
        }
        return type;
    }

    private void reportUnmappableConstruct(QName qname) {
        if ((this.metaInfo == null || this.metaInfo.getProperty("noDataBinding") != Boolean.TRUE) && (this.metaInfo.getCustomRegistry() == null || this.metaInfo.getCustomRegistry().getJavaName(qname, "complexType") == null && this.metaInfo.getCustomRegistry().getJavaName(qname, "element") == null)) {
            if (this.unmappableTypes == null) {
                this.unmappableTypes = new LinkedHashSet();
            }
            if (this.unmappableTypes.contains(qname)) {
                return;
            }
            if (this.warnUnmappableTypes) {
                this.unmappableTypes.add(qname);
                this.env.reportWarning(Messages.getMessage("w2junmap00", qname.toString()));
            }
        }
    }

    private boolean isNonBoundWSDL(Definition def) {
        boolean nonBoundWSDL = false;
        Map services = this.getServices();
        if (services != null && services.size() > 0) {
            Iterator itServices = services.values().iterator();
            while (itServices.hasNext()) {
                Service service = (Service)itServices.next();
                Map ports = service.getPorts();
                if (ports == null || ports.size() <= 0) continue;
                Iterator itPorts = ports.values().iterator();
                while (itPorts.hasNext()) {
                    Port port2 = (Port)itPorts.next();
                    Binding binding = port2.getBinding();
                    nonBoundWSDL = this.getHttpSoapEJBBindingExtElement(binding) == null;
                }
            }
        }
        return nonBoundWSDL;
    }

    public void collectNamespaces() {
        Namespaces namespaces;
        Namespaces namespaces2 = namespaces = this.metaInfo == null ? null : this.metaInfo.getNamespaces();
        if (namespaces == null) {
            return;
        }
        TreeSet<String> nsSet = new TreeSet<String>();
        Iterator<Object> it = this.symbolTable.keySet().iterator();
        while (it.hasNext()) {
            String ns = ((QName)it.next()).getNamespaceURI();
            nsSet.add(ns);
        }
        TreeSet<String> defaultNSSet = new TreeSet<String>();
        it = nsSet.iterator();
        while (it.hasNext()) {
            String ns = (String)it.next();
            if (namespaces.get(ns) != null || Constants.isSchemaXSD(ns) || Constants.isSchemaXSI(ns) || Constants.isWSDL(ns) || Constants.isWSDLSOAP(ns) || Constants.isSOAP_ENV(ns) || Constants.isSOAP_ENC(ns) || "http://websphere.ibm.com/webservices/".equals(ns) || "http://xml.apache.org/xml-soap".equals(ns)) continue;
            defaultNSSet.add(ns);
            namespaces.getCreate(ns);
        }
        if (defaultNSSet.size() == 0) {
            return;
        }
        HashMap<String, ArrayList<String>> pkg2NS = new HashMap<String, ArrayList<String>>();
        it = namespaces.keySet().iterator();
        while (it.hasNext()) {
            String ns = (String)it.next();
            String pkg = (String)namespaces.get(ns);
            ArrayList<String> list = (ArrayList<String>)pkg2NS.get(pkg);
            if (list == null) {
                list = new ArrayList<String>();
                pkg2NS.put(pkg, list);
            }
            list.add(ns);
        }
        it = pkg2NS.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            if (list.size() <= 1) continue;
            Iterator it2 = this.symbolTable.keySet().iterator();
            boolean foundCollision = false;
            while (it2.hasNext() && !foundCollision) {
                String localPart = ((QName)it2.next()).getLocalPart();
                int count = 0;
                for (int n = 0; n < list.size() && count < 2; ++n) {
                    QName qName = QNameTable.createQName((String)list.get(n), localPart);
                    if (this.getSymbols(qName) == null) continue;
                    ++count;
                }
                foundCollision = count > 1;
            }
            if (!foundCollision) continue;
            for (int n = 0; n < list.size(); ++n) {
                String ns = (String)list.get(n);
                if (!defaultNSSet.contains(ns)) continue;
                String pkg = JavaUtils.makePackageName2(ns);
                namespaces.put(ns, pkg);
            }
        }
    }

    boolean checkInOutOrdering(Vector inputs, Vector outputs, String operationName, QName outMessageQName) {
        if (log.isDebugEnabled()) {
            log.debug("Entry");
            log.debug("operationName: " + operationName);
            log.debug("outMessageQName: " + outMessageQName);
        }
        boolean needParameterOrdering = false;
        if (outputs.size() == 1) {
            if (log.isDebugEnabled()) {
                log.debug("Only one output");
            }
        } else if (outputs.size() > inputs.size()) {
            if (log.isDebugEnabled()) {
                log.debug("More outputs than inputs");
            }
            needParameterOrdering = true;
        } else {
            for (int odx = 0; odx < outputs.size(); ++odx) {
                QName iQname = null;
                QName oQname = null;
                try {
                    iQname = ((BindingParamEntry)inputs.get(odx)).getQName();
                    oQname = ((BindingParamEntry)outputs.get(odx)).getQName();
                    if (oQname == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug(" input" + odx + "=" + iQname);
                        log.debug("output" + odx + "=" + oQname);
                    }
                    if (oQname.equals(iQname)) continue;
                    needParameterOrdering = true;
                    break;
                }
                catch (Exception e) {
                    needParameterOrdering = true;
                }
            }
        }
        if (log.isDebugEnabled()) {
            if (needParameterOrdering) {
                log.debug("Output ordering does not match input ordering; response element ordering is required.");
            } else {
                log.debug("Output ordering matches input ordering; response element ordering is not required.");
            }
            log.debug("Exit - needParameterOrdering=" + needParameterOrdering);
        }
        return needParameterOrdering;
    }
}

