/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import java.util.HashMap;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.xml.namespace.QName;

public class BindingEntry
extends SymTabEntry {
    public static final int TYPE_SOAP = 0;
    public static final int TYPE_HTTP_GET = 1;
    public static final int TYPE_HTTP_POST = 2;
    public static final int TYPE_UNKNOWN = 3;
    public static final int TYPE_NONSOAP = 4;
    private Binding binding;
    private int bindingType = 3;
    private Style bindingStyle = Style.DOCUMENT;
    private QName serviceQName = null;
    private HashMap operations = new HashMap();
    public static String BINDING_NAMESPACE = "BindingNamespace";
    public static String SOAP_TRANSPORT_URI = "SOAPTransportURI";

    public BindingEntry(Binding binding, SymbolTable symbolTable) {
        super(binding.getQName(), symbolTable);
        this.binding = binding;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public int getBindingType() {
        return this.bindingType;
    }

    void setBindingType(int bindingType) {
        this.bindingType = bindingType;
    }

    public Style getBindingStyle() {
        return this.bindingStyle;
    }

    void setBindingStyle(Style bindingStyle) {
        if (bindingStyle == null || bindingStyle.equals(Style.WRAPPED)) {
            throw new RuntimeException(Messages.getMessage("error01", "invalid binding style of" + bindingStyle));
        }
        this.bindingStyle = bindingStyle;
    }

    public BindingOperationEntry getOperation(Operation wsdlOp) {
        Input input = wsdlOp.getInput();
        String inputName = input == null ? null : input.getName();
        Output output = wsdlOp.getOutput();
        String outputName = output == null ? null : output.getName();
        OperationKey key = new OperationKey(wsdlOp.getName(), inputName, outputName);
        return (BindingOperationEntry)this.operations.get(key);
    }

    void addOperation(Operation wsdlOp, BindingOperationEntry operation) {
        Input input = wsdlOp.getInput();
        String inputName = input == null ? null : input.getName();
        Output output = wsdlOp.getOutput();
        String outputName = output == null ? null : output.getName();
        OperationKey key = new OperationKey(wsdlOp.getName(), inputName, outputName);
        this.operations.put(key, operation);
    }

    public Iterator getOperations() {
        return this.operations.values().iterator();
    }

    public boolean hasLiteral() {
        Iterator it = this.getOperations();
        while (it.hasNext()) {
            BindingOperationEntry boe = (BindingOperationEntry)it.next();
            if (boe.getInputBodyUse() != Use.LITERAL && boe.getOutputBodyUse() != Use.LITERAL) continue;
            return true;
        }
        return false;
    }

    public boolean hasMIMETypes() {
        Iterator it = this.getOperations();
        while (it.hasNext()) {
            BindingOperationEntry boe = (BindingOperationEntry)it.next();
            if (!boe.hasMIMETypes()) continue;
            return true;
        }
        return false;
    }

    public QName getServiceName() {
        return this.serviceQName;
    }

    public void setServiceName(QName sn) {
        this.serviceQName = sn;
    }

    class OperationKey {
        private String name;
        private String input;
        private String output;

        public OperationKey(String name2, String input, String output) {
            this.name = name2 == null ? "" : name2;
            this.input = input == null ? "" : input;
            this.output = output == null ? "" : output;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that instanceof OperationKey) {
                OperationKey thatKey = (OperationKey)that;
                return this.name.equals(thatKey.name) && this.input.equals(thatKey.input) && this.output.equals(thatKey.output);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.input.hashCode() ^ this.output.hashCode();
        }
    }
}

