/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.introspect;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.bytecode.ParamNameExtractor;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.fromJava.BeanPropertyDescriptor;
import com.ibm.ws.webservices.wsdl.fromJava.BeanUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;

public class TypeEntryIntrospector {
    protected static Log log = LogFactory.getLog(TypeEntryIntrospector.class.getName());
    private Emitter emitter;
    private ClassFactory classFactory;
    private SymbolTable symbolTable;
    private String INTROSPECT2 = "processedByIntrospect2";

    TypeEntryIntrospector(Emitter emitter) {
        this.emitter = emitter;
        this.classFactory = emitter.getToolEnv().getClassFactory();
        this.symbolTable = emitter.getSymbolTable();
    }

    void introspect1(TypeEntry tEntry) {
        if (tEntry.isOnlyWrappedLiteralReferenced()) {
            return;
        }
        JavaHelpers javaType = this.findType(tEntry);
    }

    void introspect2(TypeEntry tEntry) {
        boolean isException;
        Type restrictBase;
        if ((Boolean)tEntry.getDynamicVar(this.INTROSPECT2) == Boolean.TRUE) {
            return;
        }
        tEntry.setDynamicVar(this.INTROSPECT2, Boolean.TRUE);
        if (tEntry.isOnlyWrappedLiteralReferenced()) {
            return;
        }
        JavaHelpers javaType = this.findType(tEntry);
        if (javaType == null) {
            return;
        }
        if (!TypeEntryIntrospector.compatibleBeanTest(javaType)) {
            return;
        }
        if (!(tEntry instanceof Type)) {
            return;
        }
        JavaClass bean = (JavaClass)javaType;
        Type extBase = ((Type)tEntry).getExtensionBase();
        if (extBase != null) {
            this.introspect2(extBase);
        }
        if ((restrictBase = ((Type)tEntry).getRestrictionBase()) != null) {
            this.introspect2(restrictBase);
        }
        if (this.emitter.isDebug()) {
            this.symbolTable.getToolEnv().report(Messages.getMessage("introspectClass00", tEntry.getQName().toString(), bean.infoString()));
        }
        Type type = (Type)tEntry;
        List beanPropDescs = BeanUtils.getPd(bean, this.emitter.getToolEnv());
        Boolean value2 = (Boolean)type.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
        boolean bl = isException = value2 != null ? value2 : false;
        if (type.isEnumeration()) {
            this.processEnumChildren(type, bean);
            this.validateEnumeration(bean);
        } else {
            this.processChildren(type, beanPropDescs, isException);
            if (isException) {
                this.validateException(type, (JavaClass)javaType);
            } else {
                this.validateBean(type, javaType);
            }
        }
    }

    JavaHelpers findType(TypeEntry tEntry) {
        return TypeEntryIntrospector.locateClass(tEntry, this.emitter, this.classFactory);
    }

    private void processChildren(Type type, List list, boolean isException) {
        if (type.getChildren() != null) {
            for (int i = 0; i < type.getChildren().size(); ++i) {
                ChildEntry cEntry = (ChildEntry)type.getChildren().get(i);
                TypeEntryIntrospector.processChild(type, cEntry, list, isException, this.emitter, this.symbolTable, this.classFactory);
            }
        }
    }

    static void processChild(Entry parent, ChildEntry cEntry, List list, boolean isException, Emitter emitter, SymbolTable symbolTable, ClassFactory classFactory) {
        BeanPropertyDescriptor tryBPD;
        int j;
        BeanPropertyDescriptor bpd = null;
        String name2 = cEntry.getName();
        for (j = 0; list != null && j < list.size() && bpd == null; ++j) {
            tryBPD = (BeanPropertyDescriptor)list.get(j);
            if (!tryBPD.getName().equals(name2)) continue;
            bpd = tryBPD;
        }
        if (bpd == null) {
            name2 = cEntry.getQName().getLocalPart();
            for (j = 0; list != null && j < list.size() && bpd == null; ++j) {
                tryBPD = (BeanPropertyDescriptor)list.get(j);
                if (!tryBPD.getName().equals(name2)) continue;
                bpd = tryBPD;
                com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, cEntry, name2, false);
            }
        }
        if (bpd == null && "_value".equals(cEntry.getName()) && parent instanceof Type && ((Type)parent).isSimpleContent() && ((Type)parent).getExtensionBase() != null) {
            name2 = "value";
            for (j = 0; list != null && j < list.size() && bpd == null; ++j) {
                tryBPD = (BeanPropertyDescriptor)list.get(j);
                if (!tryBPD.getName().equals(name2)) continue;
                bpd = tryBPD;
                com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, cEntry, name2, false);
            }
        }
        if (bpd == null) {
            emitter.getToolEnv().reportFatalErr(Messages.getMessage(isException ? "noFaultProperty00" : "noBeanProperty00", parent.getName(), cEntry.getName()));
            return;
        }
        if (bpd.isField()) {
            cEntry.setDynamicVar(JavaGeneratorFactory.IS_DATA_MEMBER, Boolean.TRUE);
        } else {
            cEntry.setDynamicVar(JavaGeneratorFactory.GET_METHOD_NAME, bpd.getReadMethodName());
            cEntry.setDynamicVar(JavaGeneratorFactory.SET_METHOD_NAME, bpd.getWriteMethodName());
            if (!isException && bpd.getWriteMethodName() == null) {
                String mmdVersion;
                String msg = Messages.getMessage("noSetterMethod00", parent.getName(), cEntry.getName(), bpd.getReadMethodName());
                cEntry.setDynamicVar(JavaGeneratorFactory.MISSING_SETTER_NAME, Boolean.TRUE);
                String string = mmdVersion = symbolTable.getMetaInfo() == null ? null : (String)symbolTable.getMetaInfo().getProperty("MMDVersion");
                if ("1.0".equals(mmdVersion)) {
                    emitter.getToolEnv().reportWarning(msg);
                } else {
                    emitter.getToolEnv().reportFatalErr(msg);
                }
            }
        }
        if (bpd.hasCheckedException()) {
            parent.setDynamicVar("throwsCheckedException", Boolean.TRUE);
        }
        JavaGeneratorFactory.defaultChildJavaType(cEntry);
        String cTypeName = (String)cEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
        TypeEntry tEntry = cEntry.getType();
        while (!(tEntry instanceof Type) && !tEntry.isCollectionTypeEntry()) {
            tEntry = tEntry.getRefType();
        }
        BooleanHolder primitiveWrapperSubstitutionOccurred = new BooleanHolder();
        if (bpd.getRawType() != null) {
            String newJavaName = TypeEntryIntrospector.compatibleTypeTest(bpd.getRawType(), cTypeName, tEntry, emitter.getFactory().getBaseTypeMapping().getTypeMapping(), classFactory, symbolTable, emitter, false, true, primitiveWrapperSubstitutionOccurred);
            if (newJavaName == null) {
                emitter.getToolEnv().reportFatalErr(Messages.getMessage(isException ? "invalidFault02" : "incompatibleTypes02", parent.getName(), bpd.getRawType().getJavaName(), cTypeName));
            } else if (!newJavaName.equals(cTypeName)) {
                cEntry.setDynamicVar(JavaGeneratorFactory.JAVA_TYPE, newJavaName);
                if (primitiveWrapperSubstitutionOccurred.value) {
                    emitter.getToolEnv().reportWarning(Messages.getMessage(isException ? "invalidFault02" : "incompatibleTypes02", parent.getName(), bpd.getRawType().getJavaName(), cTypeName));
                }
            }
        }
    }

    private void validateBean(Type type, JavaHelpers javaType) {
        this.extensionCheck(type, javaType);
        JavaClass throwableClass = (JavaClass)this.classFactory.forName("java.lang.Throwable");
        if (throwableClass == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.Throwable"));
        }
        boolean constructorFound = false;
        Method method = this.getPublicNoArgConstructor((JavaClass)javaType);
        boolean bl = constructorFound = method != null;
        if (!constructorFound && !((JavaClass)javaType).isInterface()) {
            constructorFound = this.hasImplicitDefaultConstructor((JavaClass)javaType);
        }
        if (constructorFound && method != null && method.getJavaExceptions() != null && method.getJavaExceptions().size() > 0) {
            type.setDynamicVar("throwsCheckedException", Boolean.TRUE);
        }
        if (!constructorFound) {
            JavaHelpers simpleType = this.classFactory.forName("com.ibm.ws.webservices.engine.encoding.SimpleType");
            boolean bl2 = constructorFound = type.isSimpleTypeOrSimpleContent() && simpleType.isAssignableFrom((EClassifier)javaType);
        }
        if (!constructorFound && !type.isAbstract()) {
            String constructor = javaType.getJavaName().substring(javaType.getJavaName().lastIndexOf(46) + 1);
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidBean00", javaType.getJavaName(), constructor));
        }
    }

    private void validateException(Type userExceptionType, JavaClass userExceptionClass) {
        this.extensionCheck(userExceptionType, (JavaHelpers)userExceptionClass);
        JavaClass throwableClass = (JavaClass)this.classFactory.forName("java.lang.Throwable");
        if (throwableClass == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.Throwable"));
        }
        if (!throwableClass.isAssignableFrom((EClassifier)userExceptionClass)) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidFault00", userExceptionClass.getJavaName(), "java.lang.Throwable"));
        }
        List constructorParameterOrder = (List)userExceptionType.getDynamicVar("constructorOrder");
        List childEntryList = this.getChildEntryList(userExceptionType);
        childEntryList = this.sort(childEntryList, constructorParameterOrder, true);
        boolean jaxrpc_no_arg_style = this.isNoArgJAXRPCException(userExceptionClass, childEntryList);
        boolean jaxrpc_normal_style = false;
        boolean no_arg_style = false;
        boolean message_arg_style = false;
        if (!jaxrpc_no_arg_style) {
            jaxrpc_normal_style = this.isNormalJAXRPCException(userExceptionClass, childEntryList, constructorParameterOrder);
            no_arg_style = this.isNoArgException(userExceptionClass, childEntryList);
            message_arg_style = this.isMessageArgException(userExceptionClass, childEntryList);
        }
        ArrayList<String> initStyles = new ArrayList<String>();
        if (jaxrpc_normal_style) {
            initStyles.add("JAXRPC-Normal");
        }
        if (jaxrpc_no_arg_style) {
            initStyles.add("JAXRPC-NoArg");
        }
        if (no_arg_style) {
            initStyles.add("Non-JAXRPC-NoArg");
        }
        if (message_arg_style) {
            initStyles.add("Non-JAXRPC-MessageArg");
        }
        userExceptionType.setDynamicVar("ExceptionInitStyles", initStyles);
        if (!jaxrpc_no_arg_style && !jaxrpc_normal_style) {
            if (no_arg_style || message_arg_style) {
                if (this.emitter.isDebug() || this.emitter.isVerbose()) {
                    String debugMsg = "User Exception " + userExceptionClass.getJavaName() + " does not have a JAX-RPC compliant constructor. " + "An alternative instantiation will be used.";
                    this.symbolTable.getToolEnv().report(debugMsg);
                }
            } else {
                String constructor = userExceptionClass.getJavaName().substring(userExceptionClass.getJavaName().lastIndexOf(46) + 1);
                this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidFault01", userExceptionClass.getJavaName(), constructor, String.valueOf(constructorParameterOrder.size())));
            }
        }
    }

    private boolean isNoArgJAXRPCException(JavaClass userExceptionClass, List childEntryList) {
        if (childEntryList.size() != 0) {
            return false;
        }
        return this.getPublicNoArgConstructor(userExceptionClass) != null || this.hasImplicitDefaultConstructor(userExceptionClass);
    }

    private boolean isNormalJAXRPCException(JavaClass userExceptionClass, List childEntryList, List constructorParameterOrder) {
        if (childEntryList.size() == 0) {
            return false;
        }
        List methods = this.getPublicConstructorMethods(userExceptionClass, childEntryList.size());
        if (methods.size() == 0) {
            return false;
        }
        for (int i = 0; i < methods.size(); ++i) {
            List cel;
            Method method = (Method)methods.get(i);
            List paramNames = this.getParamNames(userExceptionClass, method);
            if (this.match(childEntryList, paramNames, false)) {
                cel = new ArrayList(childEntryList);
                cel = this.sort(cel, paramNames, false);
            } else {
                cel = childEntryList;
            }
            if (!this.isCompatibleConstructor(method, cel)) continue;
            if (cel != childEntryList) {
                constructorParameterOrder.clear();
                for (int j = 0; j < cel.size(); ++j) {
                    ChildEntry ce = (ChildEntry)cel.get(j);
                    constructorParameterOrder.add(ce.getQName().getLocalPart());
                }
            }
            return true;
        }
        return false;
    }

    private boolean isNoArgException(JavaClass userExceptionClass, List childEntryList) {
        if (this.getPublicNoArgConstructor(userExceptionClass) == null && !this.hasImplicitDefaultConstructor(userExceptionClass)) {
            return false;
        }
        return this.areAllWriteable(childEntryList, false);
    }

    private boolean isMessageArgException(JavaClass userExceptionClass, List childEntryList) {
        if (this.getPublicStringArgConstructor(userExceptionClass) == null) {
            return false;
        }
        return this.areAllWriteable(childEntryList, true);
    }

    private List getChildEntryList(Type type) {
        ArrayList<Type> ancestors = new ArrayList<Type>();
        Type next = type;
        while (next != null) {
            ancestors.add(next);
            if (next.getExtensionBase() != null) {
                next = next.getExtensionBase();
                continue;
            }
            next = next.getRestrictionBase();
        }
        ArrayList<ChildEntry> childEntryList = new ArrayList<ChildEntry>();
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            int j;
            Type te = (Type)ancestors.get(i);
            Vector children = te.getChildren();
            if (children == null) continue;
            for (j = 0; j < children.size(); ++j) {
                if (!(children.get(j) instanceof ChildAttribute)) continue;
                ChildAttribute attr = (ChildAttribute)children.get(j);
                childEntryList.add(attr);
            }
            for (j = 0; j < children.size(); ++j) {
                if (!(children.get(j) instanceof ChildElement)) continue;
                ChildElement elem = (ChildElement)children.get(j);
                childEntryList.add(elem);
            }
        }
        return childEntryList;
    }

    private List sort(List childEntryList, List names, boolean byLocalName) {
        if (this.isSorted(childEntryList, names, byLocalName)) {
            return childEntryList;
        }
        ArrayList<ChildEntry> outList = new ArrayList<ChildEntry>();
        for (int i = 0; i < names.size(); ++i) {
            String name2 = (String)names.get(i);
            boolean found = false;
            Iterator it = childEntryList.iterator();
            while (it.hasNext() && !found) {
                ChildEntry ce = (ChildEntry)it.next();
                boolean match = byLocalName && ce.getQName().getLocalPart().equals(name2) || !byLocalName && ce.getName().equals(name2);
                if (!match) continue;
                outList.add(ce);
                it.remove();
                found = true;
            }
        }
        outList.addAll(childEntryList);
        return outList;
    }

    private boolean isSorted(List childEntryList, List names, boolean byLocalName) {
        if (childEntryList.size() != names.size()) {
            return false;
        }
        for (int i = 0; i < childEntryList.size(); ++i) {
            boolean match;
            ChildEntry ce = (ChildEntry)childEntryList.get(i);
            String name2 = (String)names.get(i);
            boolean bl = match = byLocalName && ce.getQName().getLocalPart().equals(name2) || !byLocalName && ce.getName().equals(name2);
            if (match) continue;
            return false;
        }
        return true;
    }

    private boolean match(List childEntryList, List names, boolean byLocalName) {
        if (childEntryList.size() != names.size()) {
            return false;
        }
        for (int i = 0; i < childEntryList.size(); ++i) {
            ChildEntry ce = (ChildEntry)childEntryList.get(i);
            boolean found = false;
            for (int j = 0; j < names.size() && !found; ++j) {
                String name2 = (String)names.get(j);
                found = byLocalName && ce.getQName().getLocalPart().equals(name2) || !byLocalName && ce.getName().equals(name2);
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private Method getPublicNoArgConstructor(JavaClass cls) {
        String constructor = cls.getJavaName().substring(cls.getJavaName().lastIndexOf(46) + 1);
        return cls.getPublicMethod(constructor, new ArrayList());
    }

    private boolean hasImplicitDefaultConstructor(JavaClass cls) {
        String constructor = cls.getJavaName().substring(cls.getJavaName().lastIndexOf(46) + 1);
        EList list = cls.getMethods();
        if (list == null) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!((Method)list.get(i)).getName().equals(constructor)) continue;
            return false;
        }
        return true;
    }

    private Method getPublicStringArgConstructor(JavaClass cls) {
        String constructor = cls.getJavaName().substring(cls.getJavaName().lastIndexOf(46) + 1);
        JavaClass stringClass = (JavaClass)this.classFactory.forName("java.lang.String");
        if (stringClass == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.String"));
        }
        ArrayList<JavaClass> paramClasses = new ArrayList<JavaClass>();
        paramClasses.add(stringClass);
        return cls.getPublicMethod(constructor, paramClasses);
    }

    private List getPublicConstructorMethods(JavaClass cls, int numParams) {
        String constructor = cls.getJavaName().substring(cls.getJavaName().lastIndexOf(46) + 1);
        List methods = cls.getPublicMethodsNamed(constructor);
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            if (method.getParameters().size() == numParams) continue;
            it.remove();
        }
        return methods;
    }

    private boolean isCompatibleConstructor(Method method, List childEntryList) {
        EList classParams = method.getParameters();
        if (childEntryList.size() != classParams.size()) {
            return false;
        }
        for (int i = 0; i < classParams.size(); ++i) {
            ChildEntry ce = (ChildEntry)childEntryList.get(i);
            String ce_typeName = (String)ce.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
            JavaHelpers ce_type = this.classFactory.forName(ce_typeName);
            JavaParameter param = (JavaParameter)classParams.get(i);
            JavaHelpers param_type = param.getJavaType();
            if (this.isAssignableFrom(param_type, ce_type)) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignableFrom(JavaHelpers target, JavaHelpers source) {
        if (target instanceof ArrayType && source instanceof ArrayType) {
            return this.isAssignableFrom(((ArrayType)target).getComponentTypeAsHelper(), ((ArrayType)source).getComponentTypeAsHelper());
        }
        return target.isAssignableFrom((EClassifier)source);
    }

    private boolean areAllWriteable(List childEntryList, boolean ignoreMessage) {
        for (int i = 0; i < childEntryList.size(); ++i) {
            ChildEntry ce = (ChildEntry)childEntryList.get(i);
            if (ignoreMessage && ce.getName().equalsIgnoreCase("message") || this.isWriteable(ce)) continue;
            return false;
        }
        return true;
    }

    private boolean isWriteable(ChildEntry ce) {
        Boolean isDataMember = (Boolean)ce.getDynamicVar(JavaGeneratorFactory.IS_DATA_MEMBER);
        String setterMethod = (String)ce.getDynamicVar(JavaGeneratorFactory.SET_METHOD_NAME);
        return isDataMember != null && isDataMember != false || setterMethod != null;
    }

    private List getParamNames(JavaClass jemClass, Method jemMethod) {
        ArrayList<String> list = null;
        if (this.emitter.getToolEnv().isJavaIntrospectionAllowed()) {
            list = this.getParamNamesReflect(jemClass, jemMethod);
        }
        if (list == null || list.size() == 0) {
            list = new ArrayList<String>();
            EList params = jemMethod.getParameters();
            for (int i = 0; i < params.size(); ++i) {
                list.add(((JavaParameter)params.get(i)).getName());
            }
        }
        return list;
    }

    private List getParamNamesReflect(JavaClass jemClass, Method jemMethod) {
        ArrayList<String> list;
        block8: {
            Constructor constructor = null;
            try {
                Class cls = ClassUtils.forName(jemClass.getJavaName(), false, this.emitter.getToolEnv().getClassLoader());
                EList params = jemMethod.getParameters();
                Class[] paramClasses = new Class[params.size()];
                for (int i = 0; i < params.size(); ++i) {
                    JavaParameter jp = (JavaParameter)params.get(i);
                    JavaHelpers jh = jp.getJavaType();
                    paramClasses[i] = ClassUtils.forName(jh.getJavaName(), false, this.emitter.getToolEnv().getClassLoader());
                }
                constructor = cls.getDeclaredConstructor(paramClasses);
            }
            catch (Exception e) {
                // empty catch block
            }
            list = new ArrayList<String>();
            if (constructor != null) {
                try {
                    String[] paramNames = ParamNameExtractor.getParameterNamesFromDebugInfo(constructor);
                    if (paramNames != null) {
                        for (int i = 0; i < paramNames.length; ++i) {
                            list.add(paramNames[i]);
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.emitter.isDebug() && !this.emitter.isVerbose()) break block8;
                    this.symbolTable.getToolEnv().report("Debug Info: Could not read parameter names for constructor, " + constructor + ".  Processing continues.");
                }
            }
        }
        return list;
    }

    private void extensionCheck(Type type, JavaHelpers javaType) {
        Type base = type.getExtensionBase();
        if (base == null || type.isSimpleTypeOrSimpleContent()) {
            return;
        }
        JavaHelpers baseJavaType = this.findType(base);
        JavaClass superClass = ((JavaClass)javaType).getSupertype();
        if (!superClass.equals(baseJavaType)) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidBean02", javaType.getJavaName(), superClass.getJavaName(), base.getName()));
        }
    }

    private void validateEnumeration(JavaClass vEnum) {
        List methods = vEnum.getPublicMethodsNamed("getValue");
        if (methods.size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", vEnum.getJavaName(), "getValue"));
        }
        if ((methods = vEnum.getPublicMethodsNamed("fromValue")).size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", vEnum.getJavaName(), "fromValue"));
        }
        if ((methods = vEnum.getPublicMethodsNamed("fromString")).size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", vEnum.getJavaName(), "fromString"));
        }
        if ((methods = vEnum.getPublicMethodsNamed("toString")).size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", vEnum.getJavaName(), "toString"));
        }
        if ((methods = vEnum.getPublicMethodsNamed("setValue")).size() > 0) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum01", vEnum.getJavaName(), "setValue"));
        }
    }

    private void processEnumChildren(Type type, JavaClass vEnum) {
        EList list = vEnum.getFields();
        for (int i = 0; i < list.size(); ++i) {
            Field field = (Field)list.get(i);
            String value2 = com.ibm.ws.webservices.wsdl.fromJava.Utils.getInitialValue(field);
            if (value2 == null && field.getName().charAt(0) == '_') continue;
            ChildEnumValueEntry ceve = null;
            for (int j = 0; j < type.getChildren().size() && ceve == null; ++j) {
                ChildEnumValueEntry tryCEVE = (ChildEnumValueEntry)type.getChildren().get(j);
                if (!tryCEVE.getEnumValue().equals(value2)) continue;
                ceve = tryCEVE;
            }
            if (ceve == null) continue;
            com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(this.symbolTable, ceve, field.getName().substring(1), false);
        }
    }

    static String compatibleTypeTest(JavaHelpers javaType, String cTypeName, TypeEntry typeEntry, TypeMapping tm, ClassFactory classFactory, SymbolTable symbolTable, Emitter emitter, boolean queryOnly, boolean allowPrimitiveWrapperSubstitution, BooleanHolder primitiveWrapperSubstitutionOccurred) {
        JavaHelpers collectionType;
        Type enumBase;
        String jTypeName = javaType.getJavaName();
        if (jTypeName.equals(cTypeName)) {
            return jTypeName;
        }
        if (jTypeName.equals("javax.xml.soap.SOAPElement") || jTypeName.equals("org.w3c.dom.Element")) {
            if (!queryOnly) {
                return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, jTypeName);
            }
            return jTypeName;
        }
        QName xmlType = com.ibm.ws.webservices.wsdl.fromJava.Utils.getTypeQName(javaType, tm, emitter.getCustomRegistry(), classFactory);
        if (xmlType != null && xmlType.equals(typeEntry.getQName())) {
            if (jTypeName != cTypeName && (jTypeName.equals(Utils.getWrapperType(cTypeName)) || cTypeName.equals(Utils.getWrapperType(jTypeName)))) {
                if (allowPrimitiveWrapperSubstitution) {
                    primitiveWrapperSubstitutionOccurred.value = true;
                } else {
                    return null;
                }
            }
            return jTypeName;
        }
        if (Constants.equals(typeEntry.getQName(), Constants.XSD_ANY) && jTypeName.equals("javax.xml.soap.SOAPElement[]")) {
            return jTypeName;
        }
        JavaHelpers simpleType = classFactory.forName("com.ibm.ws.webservices.engine.encoding.SimpleType");
        if (simpleType != null && ((Type)typeEntry).isSimpleType() && simpleType.isAssignableFrom((EClassifier)javaType)) {
            com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, typeEntry, jTypeName, true);
            if (!queryOnly) {
                return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, jTypeName);
            }
            return jTypeName;
        }
        if (((Type)typeEntry).isEnumeration() && jTypeName.equals((enumBase = ((Type)typeEntry).getRestrictionBase()).getName())) {
            if (!queryOnly) {
                ((Type)typeEntry).setEnumeration(false);
                return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, jTypeName);
            }
            return jTypeName;
        }
        if (cTypeName.equals("java.lang.Object[]") && (collectionType = classFactory.forName("java.util.Collection")).isAssignableFrom((EClassifier)javaType)) {
            return jTypeName;
        }
        if (jTypeName.indexOf("[]") > 0) {
            String dims = typeEntry.getDimensions();
            TypeEntry componentType = typeEntry.getRefType();
            if (componentType == null) {
                componentType = (TypeEntry)typeEntry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN);
                dims = "[]";
            }
            if (componentType != null) {
                JavaHelpers component;
                if (dims.length() == 0) {
                    jTypeName = TypeEntryIntrospector.compatibleTypeTest(javaType, cTypeName, componentType, tm, classFactory, symbolTable, emitter, queryOnly, allowPrimitiveWrapperSubstitution, primitiveWrapperSubstitutionOccurred);
                    if (!queryOnly && jTypeName != null) {
                        return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, jTypeName);
                    }
                    return jTypeName;
                }
                int jIndex = jTypeName.lastIndexOf(dims);
                int cIndex = cTypeName.lastIndexOf(dims);
                if (jIndex >= 0 && cIndex >= 0 && (component = classFactory.forName(jTypeName.substring(0, jIndex))) != null) {
                    String compatComponent = TypeEntryIntrospector.compatibleTypeTest(component, cTypeName.substring(0, cIndex), componentType, tm, classFactory, symbolTable, emitter, queryOnly, allowPrimitiveWrapperSubstitution, primitiveWrapperSubstitutionOccurred);
                    if (compatComponent != null) {
                        jTypeName = compatComponent + dims;
                        if (!queryOnly && jTypeName != null) {
                            return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, jTypeName);
                        }
                        return jTypeName;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private static String setJavaName(SymbolTable symbolTable, TypeEntry typeEntry, String newJavaName) {
        boolean alreadyChanged;
        boolean bl = alreadyChanged = typeEntry.getDynamicVar("oldName2") != null;
        if (alreadyChanged && !newJavaName.equals(typeEntry.getName())) {
            return null;
        }
        com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, typeEntry, newJavaName, false);
        return newJavaName;
    }

    static boolean compatibleBeanTest(JavaHelpers javaType) {
        if (!(javaType instanceof JavaClass)) {
            return false;
        }
        JavaClass javaClass = (JavaClass)javaType;
        String javaName = javaType.getJavaName();
        if (javaClass.isArray() || javaType.isPrimitive()) {
            return false;
        }
        return !javaName.startsWith("java.") && !javaName.startsWith("javax.") && !javaName.startsWith("com.ibm.ws.webservices.engine.types") && !javaName.startsWith("org.w3c.dom");
    }

    public static JavaHelpers locateClass(SymTabEntry entry, Emitter emitter, ClassFactory classFactory) {
        JavaHelpers compJavaType;
        String name2 = "";
        JavaHelpers javaType = null;
        TypeEntry componentType = (TypeEntry)entry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN);
        if (componentType != null && (javaType = classFactory.forName(name2 = emitter.getJavaName(entry.getQName()))) != null) {
            entry.setDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN, null);
        }
        if (javaType == null) {
            name2 = entry.getName();
            javaType = classFactory.forName(name2);
        }
        if (javaType == null) {
            boolean isException;
            Boolean value2 = (Boolean)entry.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
            boolean bl = isException = value2 != null ? value2 : false;
            if (isException) {
                name2 = entry.getName() + "_Exception";
                javaType = classFactory.forName(name2);
            }
        }
        if (javaType == null && componentType != null && (compJavaType = TypeEntryIntrospector.locateClass(componentType, emitter, classFactory)) != null) {
            name2 = compJavaType.getJavaName() + "[]";
            javaType = classFactory.forName(name2);
        }
        if (javaType == null) {
            String localPart = entry.getQName().getLocalPart();
            String pkg = emitter.getNamespaces().getCreate(entry.getQName().getNamespaceURI());
            name2 = pkg + "." + localPart;
            javaType = classFactory.forName(name2);
            if (javaType == null) {
                name2 = pkg + "." + JavaUtils.xmlNameToJavaClass(localPart);
                javaType = classFactory.forName(name2);
            }
            if (javaType != null) {
                entry.setDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN, null);
            }
        }
        if (javaType != null && !name2.equals(entry.getName())) {
            com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(emitter.getSymbolTable(), entry, name2, false);
        }
        return javaType;
    }
}

