/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.trace;

import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class BinaryFormatter {
    protected byte[] buf;
    protected int size;
    protected CharArrayWriter cw = new CharArrayWriter();
    protected PrintWriter pw = new PrintWriter(this.cw);

    public BinaryFormatter(byte[] binaryData) {
        this.buf = binaryData;
        this.size = binaryData.length;
    }

    public String trace() {
        int rowNumber = 1;
        int rowOffset = 0;
        while (rowOffset < this.size) {
            this.traceRow(rowOffset);
            rowOffset = (++rowNumber - 1) * 16;
        }
        this.pw.println();
        this.pw.flush();
        return this.cw.toString();
    }

    private void traceRow(int rowOffset) {
        int byteOffset;
        this.pw.println();
        this.traceHex(rowOffset >> 12 & 0xF);
        this.traceHex(rowOffset >> 8 & 0xF);
        this.traceHex(rowOffset >> 4 & 0xF);
        this.traceHex(rowOffset & 0xF);
        this.pw.print(": ");
        for (byteOffset = 0; byteOffset < 16; ++byteOffset) {
            this.byteAsHex(rowOffset, byteOffset);
        }
        this.pw.print("  ");
        for (byteOffset = 0; byteOffset < 16; ++byteOffset) {
            this.byteAsChar(rowOffset, byteOffset);
        }
    }

    private void byteAsChar(int rowOffset, int byteOffset) {
        if (rowOffset + byteOffset < this.size) {
            char c = (char)this.buf[rowOffset + byteOffset];
            if (c > '\u001f' && c < '\u0080') {
                this.pw.print(c);
            } else {
                this.pw.print('.');
            }
        } else {
            this.pw.print(' ');
        }
    }

    private void byteAsHex(int rowOffset, int byteOffset) {
        if (rowOffset + byteOffset < this.size) {
            this.traceHex(this.buf[rowOffset + byteOffset] >> 4 & 0xF);
            this.traceHex(this.buf[rowOffset + byteOffset] & 0xF);
            this.pw.print(" ");
            if (byteOffset == 7) {
                this.pw.print("- ");
            }
        } else {
            this.pw.print("   ");
            if (byteOffset == 7) {
                this.pw.print("  ");
            }
        }
    }

    private void traceHex(int hexValue) {
        switch (hexValue) {
            case 0: {
                this.pw.print('0');
                break;
            }
            case 1: {
                this.pw.print('1');
                break;
            }
            case 2: {
                this.pw.print('2');
                break;
            }
            case 3: {
                this.pw.print('3');
                break;
            }
            case 4: {
                this.pw.print('4');
                break;
            }
            case 5: {
                this.pw.print('5');
                break;
            }
            case 6: {
                this.pw.print('6');
                break;
            }
            case 7: {
                this.pw.print('7');
                break;
            }
            case 8: {
                this.pw.print('8');
                break;
            }
            case 9: {
                this.pw.print('9');
                break;
            }
            case 10: {
                this.pw.print('A');
                break;
            }
            case 11: {
                this.pw.print('B');
                break;
            }
            case 12: {
                this.pw.print('C');
                break;
            }
            case 13: {
                this.pw.print('D');
                break;
            }
            case 14: {
                this.pw.print('E');
                break;
            }
            case 15: {
                this.pw.print('F');
            }
        }
    }

    public static void main(String[] args) {
        if (args[0] == null) {
            System.out.println("Usage: BinaryFormatter <stringToDumpAsBytes>");
            return;
        }
        byte[] ba = args[0].getBytes();
        BinaryFormatter b = new BinaryFormatter(ba);
        System.out.println(b.trace());
    }
}

