/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.sysengine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.soap.container.SoapContainerRouter;
import com.ibm.ws.soap.container.SoapContainerService;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.WebServicesSystemService;
import com.ibm.ws.webservices.component.WSSysServerImpl;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.metadata.SysServerModuleMetaData;
import com.ibm.ws.webservices.sysengine.SystemEndpointContextImpl;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.wsspi.soapcontainer.SOAPRequest;
import com.ibm.wsspi.soapcontainer.SOAPResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;

public class SystemEngineRouter
implements SoapContainerRouter,
MessageContext.OneWayListener {
    public static final String DOUBLE_QUOTES = "\"";
    protected static Log log = LogFactory.getLog(SystemEngineRouter.class.getName());

    public void doPost(SOAPRequest req, SOAPResponse res, Object metaData) {
        if (log.isDebugEnabled()) {
            log.debug("Enter SystemEngineRouter.doPost()");
        }
        SysServerModuleMetaData sysServerModuleMetaData = (SysServerModuleMetaData)metaData;
        String soapAction = null;
        MessageContext msgContext = null;
        Message responseMsg = null;
        WebServicesEngine engine2 = null;
        try {
            engine2 = this.getEngine();
        }
        catch (WebServicesFault e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", "76", this);
            log.error(Messages.getMessage("noEngine00"), e);
            throw new RuntimeException(e);
        }
        try {
            msgContext = this.createMessageContext(engine2, req, res);
            InputStream reqIs = req.getInputStream();
            byte[] reqBa = null;
            boolean isTraceEnabled = MessageTrace.isTraceEnabled();
            if (isTraceEnabled) {
                reqBa = this.extractRequestBytesForTrace(req, reqIs);
                reqIs = new ByteArrayInputStream(reqBa);
            }
            String contentType = req.getHeader("Content-Type");
            Message requestMsg = new Message((Object)reqIs, contentType, req.getHeader("Content-Location"));
            msgContext.setRequestMessage(requestMsg);
            if (isTraceEnabled && reqBa != null) {
                MessageTrace.log(MessageTrace.INBOUND_HTTP_REQUEST, contentType, reqBa);
            }
            try {
                soapAction = this.getSoapAction(req);
                if (soapAction != null) {
                    msgContext.setUseSOAPAction(true);
                    msgContext.setSOAPActionURI(soapAction);
                } else {
                    msgContext.setUseSOAPAction(false);
                    msgContext.setSOAPActionURI(soapAction);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Invoking WebServices Engine.");
                }
                engine2.invoke(msgContext);
                if (log.isDebugEnabled()) {
                    log.debug("Return from WebServices Engine.");
                }
                if ((responseMsg = msgContext.getResponseMessage()) != null) {
                    responseMsg.ifFaultThrowSelf();
                }
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", "129", this);
                log.error(Messages.getMessage("exception00"), e);
                int status = this.getHttpServletResponseStatus(e);
                if (status == 401) {
                    res.setHeader("WWW-Authenticate", "Basic realm=\"WebServices\"");
                }
                res.setStatusCode(status);
                responseMsg = msgContext.getResponseMessage();
                if (responseMsg == null) {
                    responseMsg = new Message(e);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", "145", this);
                log.error(Messages.getMessage("exception00"), e);
                res.setStatusCode(500);
                responseMsg = msgContext.getResponseMessage();
                if (responseMsg == null) {
                    responseMsg = new Message(WebServicesFault.makeFault(e));
                }
            }
        }
        catch (WebServicesFault fault2) {
            FFDCFilter.processException((Throwable)fault2, "com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", "162", this);
            log.error(Messages.getMessage("webServicesFault00"), fault2);
            responseMsg = msgContext.getResponseMessage();
            if (responseMsg == null) {
                responseMsg = new Message(fault2);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", "173", this);
            log.error(Messages.getMessage("exception00"), e);
            throw new RuntimeException(e);
        }
        if (responseMsg != null) {
            if (msgContext.isOneWay()) {
                log.error(Messages.getMessage("servlet.unexpected.oneway.response00"));
            } else {
                try {
                    this.sendResponse(this.getProtocolVersion(req), responseMsg.getContentType(msgContext.getSOAPConstants()), res, responseMsg);
                }
                catch (Exception e1) {
                    FFDCFilter.processException((Throwable)e1, "com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", "181", this);
                    log.error(Messages.getMessage("exception00"), e1);
                    throw new RuntimeException(e1);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Response sent.");
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("No Response Sent");
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit SystemEngineRouter.doPost()");
        }
    }

    private byte[] extractRequestBytesForTrace(SOAPRequest req, InputStream reqIs) throws IOException {
        String lenStr;
        byte[] reqBa = null;
        if (log.isDebugEnabled()) {
            log.debug("Start copying SOAP request to trace buffer");
        }
        if ((lenStr = req.getHeader("Content-Length")) != null) {
            int len = 0;
            try {
                len = Integer.parseInt(lenStr);
            }
            catch (NumberFormatException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", "650", this);
                log.error(Messages.getMessage("exception00"), e);
                len = reqIs.available();
            }
            reqBa = new byte[len];
            int leftToRead = len;
            int offset = 0;
            while (leftToRead > 0) {
                int bytesRead = reqIs.read(reqBa, offset, leftToRead);
                if (log.isDebugEnabled()) {
                    log.debug("Trace buffer needs " + leftToRead + " bytes at offset " + offset + " got " + bytesRead + " bytes");
                }
                if (bytesRead < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("End of stream with " + leftToRead + " bytes still expected");
                    }
                    leftToRead = 0;
                    continue;
                }
                leftToRead -= bytesRead;
                offset += bytesRead;
            }
        } else {
            int chunksize = 1024;
            ArrayList<byte[]> chunks = new ArrayList<byte[]>();
            ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
            int totalBytesRead = 0;
            int bytesFromRead = 0;
            while (bytesFromRead >= 0) {
                byte[] chunkBA = new byte[1024];
                bytesFromRead = reqIs.read(chunkBA, 0, 1024);
                if (bytesFromRead < 0) continue;
                chunks.add(chunkBA);
                chunkSizes.add(new Integer(bytesFromRead));
                totalBytesRead += bytesFromRead;
            }
            reqBa = new byte[totalBytesRead];
            int offset = 0;
            for (int i = 0; i < chunks.size(); ++i) {
                byte[] chunk = (byte[])chunks.get(i);
                int chunkSize = (Integer)chunkSizes.get(i);
                System.arraycopy(chunk, 0, reqBa, offset, chunkSize);
                offset += chunkSize;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Done copying SOAP request to trace buffer");
        }
        return reqBa;
    }

    private WebServicesEngine getEngine() throws WebServicesFault {
        SoapContainerService soapContainer = WSSysServerImpl.getWSSysServerImpl().getSOAPContainerService();
        WebServicesEngine cachedEngine = (WebServicesEngine)soapContainer.getEngine();
        if (cachedEngine == null) {
            WebServicesSystemService systemService = WebServicesServiceHome.getWebServicesSystemService();
            cachedEngine = ServerEngine.getServer(systemService, null);
            soapContainer.cacheEngine(cachedEngine);
        }
        return cachedEngine;
    }

    private MessageContext createMessageContext(WebServicesEngine engine2, SOAPRequest req, SOAPResponse res) {
        MessageContext msgContext = new MessageContext(engine2);
        if (log.isDebugEnabled()) {
            log.debug("MessageContext:" + msgContext);
            log.debug("HEADER_CONTENT_TYPE:" + req.getHeader("Content-Type"));
            log.debug("HEADER_CONTENT_LOCATION:" + req.getHeader("Content-Location"));
            log.debug("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + req.getRequestPathInfo());
            log.debug("HTTPConstants.HEADER_AUTHORIZATION:" + req.getHeader("Authorization"));
            log.debug("Constants.MC_REMOTE_ADDR:" + req.getRemoteAddr());
        }
        msgContext.setTransportName("http");
        String string = req.getRequestPathInfo();
        if (string != null) {
            String relativePath = string.substring(string.indexOf("/", 1));
            if (log.isDebugEnabled()) {
                log.debug("SystemEngineRouter.createMessageContext(engine, req, res): Setting msgcontext MC_RELATIVE_PATH to " + relativePath);
            }
            msgContext.setProperty("path", relativePath);
        }
        if ((string = req.getHeader("Authorization")) != null) {
            msgContext.setProperty("Authorization", string);
        }
        if ((string = req.getRemoteAddr()) != null) {
            msgContext.setProperty("remoteaddr", string);
        }
        SystemEndpointContextImpl sec = new SystemEndpointContextImpl(msgContext, req);
        msgContext.setProperty("servletEndpointContext", sec);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, res);
        msgContext.addOneWayListener(this);
        return msgContext;
    }

    private String getSoapAction(SOAPRequest req) throws WebServicesFault {
        String soapAction = req.getHeader("SOAPAction");
        if (log.isDebugEnabled()) {
            log.debug("HEADER_SOAP_ACTION:" + soapAction);
        }
        if (soapAction == null) {
            WebServicesFault af = new WebServicesFault("Client.NoSOAPAction", Messages.getMessage("noHeader00", "SOAPAction"), null, null);
            log.error(Messages.getMessage("genFault00"), af);
            throw af;
        }
        if (soapAction.length() == 0) {
            soapAction = null;
        }
        if (soapAction.length() > 1 && soapAction.startsWith(DOUBLE_QUOTES) && soapAction.endsWith(DOUBLE_QUOTES)) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        return soapAction;
    }

    protected int getHttpServletResponseStatus(WebServicesFault af) {
        return af.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    protected String getProtocolVersion(SOAPRequest req) {
        String ver;
        int sindex;
        String ret = HTTPConstants.HEADER_PROTOCOL_V10;
        String prot = req.getProtocol();
        if (prot != null && -1 != (sindex = prot.indexOf(47)) && HTTPConstants.HEADER_PROTOCOL_V11.equals((ver = prot.substring(sindex + 1)).trim())) {
            ret = HTTPConstants.HEADER_PROTOCOL_V11;
        }
        return ret;
    }

    private void sendResponse(String clientVersion, String contentType, SOAPResponse res, Message responseMsg) throws WebServicesFault, Exception {
        if (responseMsg == null) {
            if (log.isDebugEnabled()) {
                log.debug("NO WEBSERVICES MESSAGE TO RETURN!");
            }
            res.setStatusCode(204);
            String resp = Messages.getMessage("noData00");
            res.setContentLength(resp.getBytes().length);
            OutputStream os = res.getOutputStream();
            os.write(resp.getBytes());
            os.flush();
            res.finishResponse();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Returned Content-Type:" + contentType);
            }
            try {
                res.setContentType(contentType);
                if (!MessageTrace.isTraceEnabled()) {
                    responseMsg.writeTo(res.getOutputStream());
                } else {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    responseMsg.writeTo(baos);
                    byte[] msgBytes = baos.toByteArray();
                    res.getOutputStream().write(msgBytes);
                    MessageTrace.log(MessageTrace.OUTBOUND_HTTP_RESPONSE, contentType, msgBytes);
                }
                responseMsg.removeAllAttachments();
                res.finishResponse();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.sysengine.SystemEngineRouter.sendResponse", "484", this);
                log.error(Messages.getMessage("exception00"), e);
            }
        }
    }

    public void oneWay(MessageContext owe) {
        Object responseObject;
        if (log.isDebugEnabled()) {
            log.debug("Enter SystemEngineRouter.oneWay(owe)");
        }
        if ((responseObject = owe.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE)) != null) {
            SOAPResponse res = (SOAPResponse)responseObject;
            res.setContentLength(0);
            res.finishResponse();
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit SystemEngineRouter.oneWay(owe)");
        }
    }
}

