/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.SecurityRequestConsumerBindingConfig;
import com.ibm.etools.webservice.wsbnd.SecurityRequestReceiverBindingConfig;
import com.ibm.etools.webservice.wsbnd.SecurityResponseGeneratorBindingConfig;
import com.ibm.etools.webservice.wsbnd.SecurityResponseSenderBindingConfig;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityRequestSenderBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseConsumerBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseReceiverBindingConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscext.ClientServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestGeneratorServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestSenderServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseConsumerServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseReceiverServiceConfig;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wsext.LoginConfig;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.SecurityRequestConsumerServiceConfig;
import com.ibm.etools.webservice.wsext.SecurityRequestReceiverServiceConfig;
import com.ibm.etools.webservice.wsext.SecurityResponseGeneratorServiceConfig;
import com.ibm.etools.webservice.wsext.SecurityResponseSenderServiceConfig;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.engine.configurable.Configurable;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.dispatchers.java.JavaBeanDispatcher;
import com.ibm.ws.webservices.engine.enumtype.Scope;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;

public class SecurityHooks {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent tc = Tr.register(SecurityHooks.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    public static final String OPTION_REQUEST_RECEIVER_CONFIG = "RequestReceiverConfig";
    public static final String OPTION_RESPONSE_SENDER_CONFIG = "ResponseSenderConfig";
    public static final String OPTION_REQUEST_SENDER_CONFIG = "RequestSenderConfig";
    public static final String OPTION_RESPONSE_RECEIVER_CONFIG = "ResponseReceiverConfig";
    private static final JAXRPCHandler.QNameSet securityHeaderQNames;
    private static final JAXRPCHandler.QNameSet emptyQNames;
    private static WSSecurityService service;
    private static VariableMap varMap;
    private static ClassLoader cl;

    public static JAXRPCHandler.QNameSet getSecurityHeaderQNames() {
        return securityHeaderQNames;
    }

    public static void startup(WSSecurityService securityService, VariableMap map) {
        service = securityService;
        varMap = map;
    }

    public static void cleanup() {
        service = null;
        varMap = null;
    }

    public static void addWSSecurityConfigurationToWSDDPort(WSDDPort wsddPort, String wsdlServicePort, ServiceRef cbsr, com.ibm.etools.webservice.wscext.ServiceRef cesr, ClassLoader appClassLoader) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, ConfigurationError {
        block20: {
            block17: {
                com.ibm.etools.webservice.wscext.PortQnameBinding pqne;
                PortQnameBinding pqnb;
                block19: {
                    PortQnameBinding tmp;
                    int i;
                    int pqnecount;
                    int pqnbcount;
                    block18: {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "addWSSecurityConfigurationToWSDDPort(WSDDPort, wsdlServicePort, com.ibm.etools.webservice.wscbnd.ServiceRef, com.ibm.etools.webservice.wscext.ServiceRef, ClassLoader, VariableMap, WSSecurityService)", new Object[]{wsddPort, wsdlServicePort, cbsr, cesr, appClassLoader, varMap, service});
                        }
                        if (cbsr == null || cesr == null) break block17;
                        pqnbcount = cbsr.getPortQnameBindings().size();
                        pqnecount = cesr.getPortQnameBindings().size();
                        pqnb = null;
                        pqne = null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading Client Security Configuration for " + wsddPort.getQName() + ", wsdlServicePort is " + wsdlServicePort);
                        }
                        if (wsdlServicePort != null && wsdlServicePort.length() != 0) break block18;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The service has only one port");
                        }
                        if (pqnbcount > 1) {
                            Tr.error(tc, "wssec.config.binding.error");
                            throw new RuntimeException("There are more than one security bindings defined, but can not determined which one to use without the WSDL Service Port.");
                        }
                        if (pqnecount > 1) {
                            Tr.error(tc, "wssec.config.dd.error");
                            throw new RuntimeException("There are more than one security deployment descriptors defined, but can not determined which one to use without the WSDL Service Port.");
                        }
                        pqnb = (PortQnameBinding)cbsr.getPortQnameBindings().get(0);
                        pqne = (com.ibm.etools.webservice.wscext.PortQnameBinding)cesr.getPortQnameBindings().get(0);
                        if (tc.isDebugEnabled() && pqnb != null) {
                            Tr.debug(tc, "Client extention Binding for (" + pqnb.getPortQnameLocalNameLink() + ", " + pqnb.getPortQnameNamespaceLink() + ") found.");
                        }
                        if (!tc.isDebugEnabled() || pqne == null) break block19;
                        Tr.debug(tc, "Client extension DD for (" + pqne.getPortQnameLocalNameLink() + ", " + pqne.getPortQnameNamespaceLink() + ") found.");
                        break block19;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The service has " + pqnbcount + " ports, with " + pqnbcount + " portQnameBinding in Bindings " + pqnecount + " portQnameBinding in DD");
                    }
                    for (i = 0; i < pqnbcount; ++i) {
                        tmp = (PortQnameBinding)cbsr.getPortQnameBindings().get(i);
                        if (!wsdlServicePort.equals(tmp.getPortQnameLocalNameLink())) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Client extention Binding for (" + tmp.getPortQnameLocalNameLink() + ", " + tmp.getPortQnameNamespaceLink() + ") found.");
                        }
                        pqnb = tmp;
                        break;
                    }
                    for (i = 0; i < pqnecount; ++i) {
                        tmp = (com.ibm.etools.webservice.wscext.PortQnameBinding)cesr.getPortQnameBindings().get(i);
                        if (!wsdlServicePort.equals(tmp.getPortQnameLocalNameLink())) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Client extension DD for (" + tmp.getPortQnameLocalNameLink() + ", " + tmp.getPortQnameNamespaceLink() + ") found.");
                        }
                        pqne = tmp;
                        break;
                    }
                }
                SecurityRequestSenderBindingConfig reqSndBnd = null;
                SecurityResponseReceiverBindingConfig resRecBnd = null;
                SecurityRequestGeneratorBindingConfig reqGenBnd = null;
                SecurityResponseConsumerBindingConfig resConBnd = null;
                if (pqnb != null) {
                    reqSndBnd = pqnb.getSecurityRequestSenderBindingConfig();
                    resRecBnd = pqnb.getSecurityResponseReceiverBindingConfig();
                    reqGenBnd = pqnb.getSecurityRequestGeneratorBindingConfig();
                    resConBnd = pqnb.getSecurityResponseConsumerBindingConfig();
                }
                SecurityRequestSenderServiceConfig reqSndExt = null;
                SecurityResponseReceiverServiceConfig resRecExt = null;
                SecurityRequestGeneratorServiceConfig reqGenExt = null;
                SecurityResponseConsumerServiceConfig resConExt = null;
                ClientServiceConfig csConfig = null;
                String actorURI = null;
                if (pqne != null) {
                    csConfig = pqne.getClientServiceConfig();
                }
                if (csConfig != null) {
                    reqSndExt = csConfig.getSecurityRequestSenderServiceConfig();
                    resRecExt = csConfig.getSecurityResponseReceiverServiceConfig();
                    reqGenExt = csConfig.getSecurityRequestGeneratorServiceConfig();
                    resConExt = csConfig.getSecurityResponseConsumerServiceConfig();
                    actorURI = csConfig.getActorURI();
                }
                if (appClassLoader == null) {
                    throw new RuntimeException("Context ClassLoader is null");
                }
                SecurityHooks.createClientWSEMFClasses(reqSndExt, reqSndBnd, resRecExt, resRecBnd, reqGenExt, reqGenBnd, resConExt, resConBnd, wsddPort, appClassLoader, actorURI, varMap, service, pqnb);
                break block20;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No match security configuration found for " + wsddPort.getQName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWSSecurityConfigurationToWSDDPort");
        }
    }

    public static void createClientWSEMFClasses(SecurityRequestSenderServiceConfig reqSndExt, SecurityRequestSenderBindingConfig reqSndBnd, SecurityResponseReceiverServiceConfig resRecExt, SecurityResponseReceiverBindingConfig resRecBnd, SecurityRequestGeneratorServiceConfig reqGenExt, SecurityRequestGeneratorBindingConfig reqGenBnd, SecurityResponseConsumerServiceConfig resConExt, SecurityResponseConsumerBindingConfig resConBnd, WSDDPort wsddPort, ClassLoader appClassLoader, String actorURI, VariableMap varMap, WSSecurityService service) throws InstantiationException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, ConfigurationError {
        SecurityHooks.createClientWSEMFClasses(reqSndExt, reqSndBnd, resRecExt, resRecBnd, reqGenExt, reqGenBnd, resConExt, resConBnd, wsddPort, appClassLoader, actorURI, varMap, service, null);
    }

    public static void createClientWSEMFClasses(SecurityRequestSenderServiceConfig reqSndExt, SecurityRequestSenderBindingConfig reqSndBnd, SecurityResponseReceiverServiceConfig resRecExt, SecurityResponseReceiverBindingConfig resRecBnd, SecurityRequestGeneratorServiceConfig reqGenExt, SecurityRequestGeneratorBindingConfig reqGenBnd, SecurityResponseConsumerServiceConfig resConExt, SecurityResponseConsumerBindingConfig resConBnd, WSDDPort wsddPort, ClassLoader appClassLoader, String actorURI, VariableMap varMap, WSSecurityService service, PortQnameBinding portQnBnd) throws InstantiationException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, ConfigurationError {
        boolean was6 = true;
        if (reqSndExt != null || reqSndBnd != null || resRecExt != null || resRecBnd != null) {
            was6 = false;
        }
        if (reqGenExt != null || reqGenBnd != null || resConExt != null || resConBnd != null) {
            was6 = true;
        }
        boolean wssConfigured = false;
        if (was6) {
            Constructor<?> c;
            Class<?> clazz;
            Object obj;
            if (SecurityHooks.createRequestGeneratorConfig(reqGenExt, reqGenBnd, wsddPort.getQName())) {
                obj = null;
                try {
                    clazz = cl.loadClass("com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestGeneratorConfig");
                    c = clazz.getConstructor(SecurityRequestGeneratorBindingConfig.class, SecurityRequestGeneratorServiceConfig.class, String.class, VariableMap.class, WSSecurityService.class, ClassLoader.class);
                    obj = c.newInstance(reqGenBnd, reqGenExt, actorURI, varMap, service, appClassLoader);
                }
                catch (InvocationTargetException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.security.SecurityHooks.createClientWSEMFClasses", "360", null);
                    Throwable t = e.getTargetException();
                    Tr.error(tc, "wssec.loadconfig.failed", new Object[]{"com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestGeneratorConfig", t});
                    Tr.error(tc, "wssec.configuration.error", new Object[]{"Request Generator", wsddPort.getQName()});
                    throw new ConfigurationError(t);
                }
                if (obj != null) {
                    wsddPort.setObject(OPTION_REQUEST_SENDER_CONFIG, obj);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RequestGenerator Binding and DD Security Configuration for " + wsddPort.getQName() + " is loaded");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No RequestGenerator Binding and DD Security Configuration found for " + wsddPort.getQName());
                }
            }
            if (SecurityHooks.createResponseConsumerConfig(resConExt, resConBnd, wsddPort.getQName())) {
                obj = null;
                try {
                    clazz = cl.loadClass("com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseConsumerConfig");
                    c = clazz.getConstructor(SecurityResponseConsumerBindingConfig.class, SecurityResponseConsumerServiceConfig.class, String.class, VariableMap.class, WSSecurityService.class, ClassLoader.class);
                    obj = c.newInstance(resConBnd, resConExt, actorURI, varMap, service, appClassLoader);
                }
                catch (InvocationTargetException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.security.SecurityHooks.createClientWSEMFClasses", "394", null);
                    Throwable t = e.getTargetException();
                    Tr.error(tc, "wssec.loadconfig.failed", new Object[]{"com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseConsumerConfig", t});
                    Tr.error(tc, "wssec.configuration.error", new Object[]{"Response Consumer", wsddPort.getQName()});
                    throw new ConfigurationError(t);
                }
                if (obj != null) {
                    wsddPort.setObject(OPTION_RESPONSE_RECEIVER_CONFIG, obj);
                    wssConfigured = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RequestConsumer Binding and DD Security Configuration for " + wsddPort.getQName() + " is loaded");
                        Tr.debug(tc, "wssConfigured = [" + wssConfigured + "]");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No RequestConsumer Binding and DD Security Configuration found for " + wsddPort.getQName());
                }
            }
        } else {
            Constructor<?> c;
            Class<?> clazz;
            Object obj;
            if (SecurityHooks.createRequestSenderConfig(reqSndExt, reqSndBnd, wsddPort.getQName())) {
                obj = null;
                try {
                    clazz = cl.loadClass("com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestSenderConfig");
                    c = clazz.getConstructor(SecurityRequestSenderBindingConfig.class, SecurityRequestSenderServiceConfig.class, String.class, VariableMap.class, WSSecurityService.class, ClassLoader.class, PortQnameBinding.class);
                    obj = c.newInstance(reqSndBnd, reqSndExt, actorURI, varMap, service, appClassLoader, portQnBnd);
                }
                catch (InvocationTargetException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.security.SecurityHooks.createClientWSEMFClasses", "433", null);
                    Throwable t = e.getTargetException();
                    Tr.error(tc, "wssec.loadconfig.failed", new Object[]{"com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestSenderConfig", t});
                    Tr.error(tc, "wssec.configuration.error", new Object[]{"Request Sender", wsddPort.getQName()});
                    throw new ConfigurationError(t);
                }
                if (obj != null) {
                    wsddPort.setObject(OPTION_REQUEST_SENDER_CONFIG, obj);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RequestSender Binding and DD Security Configuration for " + wsddPort.getQName() + " is loaded");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No RequestSender Binding and DD Security Configuration found for " + wsddPort.getQName());
                }
            }
            if (SecurityHooks.createResponseReceiverConfig(resRecExt, resRecBnd, wsddPort.getQName())) {
                obj = null;
                try {
                    clazz = cl.loadClass("com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseReceiverConfig");
                    c = clazz.getConstructor(SecurityResponseReceiverBindingConfig.class, SecurityResponseReceiverServiceConfig.class, String.class, VariableMap.class, WSSecurityService.class, ClassLoader.class, PortQnameBinding.class);
                    obj = c.newInstance(resRecBnd, resRecExt, actorURI, varMap, service, appClassLoader, portQnBnd);
                }
                catch (InvocationTargetException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.security.SecurityHooks.createClientWSEMFClasses", "468", null);
                    Throwable t = e.getTargetException();
                    Tr.error(tc, "wssec.loadconfig.failed", new Object[]{"com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseReceiverConfig", t});
                    Tr.error(tc, "wssec.configuration.error", new Object[]{"Response Receiver", wsddPort.getQName()});
                    throw new ConfigurationError(t);
                }
                if (obj != null) {
                    wsddPort.setObject(OPTION_RESPONSE_RECEIVER_CONFIG, obj);
                    wssConfigured = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RequestReceiver Binding and DD Security Configuration for " + wsddPort.getQName() + " is loaded");
                        Tr.debug(tc, "wssConfigured = [" + wssConfigured + "]");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No RequestReceiver Binding and DD Security Configuration found for " + wsddPort.getQName());
                }
            }
        }
        if (wssConfigured) {
            wsddPort.addActorHeaderBinding(actorURI, securityHeaderQNames);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSE header(s) associated with actor [" + actorURI + "] for port [" + wsddPort.getQName() + "]");
            }
        } else {
            wsddPort.addActorHeaderBinding(actorURI, emptyQNames);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSE header(s) NOT associated with actor [" + actorURI + "] for port [" + wsddPort.getQName() + "]");
            }
        }
    }

    public static boolean createRequestGeneratorConfig(SecurityRequestGeneratorServiceConfig ext, SecurityRequestGeneratorBindingConfig bnd, QName service) throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRequestGeneratorConfig", new Object[]{ext, bnd, service});
        }
        boolean result = false;
        if (ext != null) {
            EList securityTokens;
            EList confidentialities;
            boolean[] tmp = new boolean[4];
            tmp[3] = false;
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            EList integrities = ext.getIntegrity();
            if (integrities != null) {
                for (int i = 0; i < integrities.size(); ++i) {
                    Integrity integrity = (Integrity)integrities.get(i);
                    EList parts = integrity.getMessageParts();
                    boolean bl = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getTimestamp();
                    boolean bl2 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getNonce();
                    boolean bl3 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Integrity constraint defined: " + tmp[0]);
            }
            if ((confidentialities = ext.getConfidentiality()) != null) {
                for (int i = 0; i < confidentialities.size(); ++i) {
                    Confidentiality confidentiality = (Confidentiality)confidentialities.get(i);
                    EList parts = confidentiality.getMessageParts();
                    boolean bl = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getTimestamp();
                    boolean bl4 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getNonce();
                    boolean bl5 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Confidentiality constraint defined: " + tmp[1]);
            }
            boolean bl = tmp[2] = (securityTokens = ext.getSecurityToken()) != null && !securityTokens.isEmpty();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SecurityToken constraint defined: " + tmp[2]);
            }
            boolean bl6 = tmp[3] = ext.getAddTimestamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddTimestamp constraint defined: " + tmp[2]);
            }
            if ((tmp[0] || tmp[1] || tmp[2]) && bnd == null) {
                throw new ConfigurationError("There is no binding defined for " + service + " RequestGenerator");
            }
            result = tmp[0] || tmp[1] || tmp[2] || tmp[3];
        } else if (bnd != null) {
            throw new ConfigurationError("There is no deployment descriptor defined for " + service + " RequestGenerator");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRequestGeneratorConfig returns " + result);
        }
        return result;
    }

    public static boolean createResponseConsumerConfig(SecurityResponseConsumerServiceConfig ext, SecurityResponseConsumerBindingConfig bnd, QName service) throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResponseConsumerConfig", new Object[]{ext, bnd, service});
        }
        boolean result = false;
        if (ext != null) {
            EList securityTokens;
            EList confidentialities;
            boolean[] tmp = new boolean[4];
            tmp[3] = false;
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            EList integrities = ext.getRequiredIntegrity();
            if (integrities != null) {
                for (int i = 0; i < integrities.size(); ++i) {
                    RequiredIntegrity integrity = (RequiredIntegrity)integrities.get(i);
                    EList parts = integrity.getMessageParts();
                    boolean bl = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getTimestamp();
                    boolean bl2 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getNonce();
                    boolean bl3 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredIntegrity constraint defined: " + tmp[0]);
            }
            if ((confidentialities = ext.getRequiredConfidentiality()) != null) {
                for (int i = 0; i < confidentialities.size(); ++i) {
                    RequiredConfidentiality confidentiality = (RequiredConfidentiality)confidentialities.get(i);
                    EList parts = confidentiality.getMessageParts();
                    boolean bl = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getTimestamp();
                    boolean bl4 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getNonce();
                    boolean bl5 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredConfidentiality constraint defined: " + tmp[1]);
            }
            boolean bl = tmp[2] = (securityTokens = ext.getRequiredSecurityToken()) != null && !securityTokens.isEmpty();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredSecurityToken constraint defined: " + tmp[2]);
            }
            boolean bl6 = tmp[3] = ext.getAddTimestamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddTimestamp constraint defined: " + tmp[3]);
            }
            if ((tmp[0] || tmp[1] || tmp[2]) && bnd == null) {
                throw new ConfigurationError("There is no binding defined for " + service + " ResponseConsumer");
            }
            result = tmp[0] || tmp[1] || tmp[2] || tmp[3];
        } else if (bnd != null) {
            throw new ConfigurationError("There is no deployment descriptor defined for " + service + " ResponseConsumer");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResponseConsumerConfig returns " + result);
        }
        return result;
    }

    public static boolean createRequestSenderConfig(SecurityRequestSenderServiceConfig ext, SecurityRequestSenderBindingConfig bnd, QName service) throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRequestSenderConfig", new Object[]{ext, bnd, service});
        }
        boolean result = false;
        if (ext != null) {
            com.ibm.etools.webservice.wscext.LoginConfig loginConfig;
            Confidentiality confidentiality;
            boolean[] tmp = new boolean[5];
            tmp[4] = false;
            tmp[3] = false;
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            Integrity integrity = ext.getIntegrity();
            if (integrity != null) {
                EList refs = integrity.getReferences();
                boolean bl = tmp[0] = refs != null && !refs.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Integrity constraint defined: " + tmp[0]);
            }
            if ((confidentiality = ext.getConfidentiality()) != null) {
                EList parts = confidentiality.getConfidentialParts();
                boolean bl = tmp[1] = parts != null && !parts.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Confidentiality constraint defined: " + tmp[1]);
            }
            if ((loginConfig = ext.getLoginConfig()) != null) {
                String authMethod = loginConfig.getAuthMethod();
                boolean bl = tmp[2] = authMethod != null && authMethod.length() != 0;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LoginConfig constraint defined: " + tmp[2]);
            }
            boolean bl = tmp[3] = ext.getAddCreatedTimeStamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddCreatedTimeStamp constraint defined: " + tmp[3]);
            }
            boolean bl2 = tmp[4] = ext.getIdAssertion() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IdAssertion constraint defined: " + tmp[4]);
            }
            if ((tmp[0] || tmp[1] || tmp[2]) && bnd == null) {
                throw new ConfigurationError("There is no binding defined for " + service + " RequestSender");
            }
            result = tmp[0] || tmp[1] || tmp[2] || tmp[3] || tmp[4];
        } else if (bnd != null) {
            throw new ConfigurationError("There is no deployment descriptor defined for " + service + " RequestSender");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRequestSenderConfig returns " + result);
        }
        return result;
    }

    public static boolean createResponseReceiverConfig(SecurityResponseReceiverServiceConfig ext, SecurityResponseReceiverBindingConfig bnd, QName service) throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResponseReceiverConfig", new Object[]{ext, bnd, service});
        }
        boolean result = false;
        if (ext != null) {
            RequiredConfidentiality confidentiality;
            boolean[] tmp = new boolean[3];
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            RequiredIntegrity integrity = ext.getRequiredIntegrity();
            if (integrity != null) {
                EList refs = integrity.getReferences();
                boolean bl = tmp[0] = refs != null && !refs.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredIntegrity constraint defined: " + tmp[0]);
            }
            if ((confidentiality = ext.getRequiredConfidentiality()) != null) {
                EList parts = confidentiality.getConfidentialParts();
                boolean bl = tmp[1] = parts != null && !parts.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredConfidentiality constraint defined: " + tmp[1]);
            }
            boolean bl = tmp[2] = ext.getAddReceivedTimeStamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddReceivedTimeStamp constraint defined: " + tmp[2]);
            }
            if ((tmp[0] || tmp[1]) && bnd == null) {
                throw new ConfigurationError("There is no binding defined for " + service + " ResponseReceiver");
            }
            result = tmp[0] || tmp[1] || tmp[2];
        } else if (bnd != null) {
            throw new ConfigurationError("There is no deployment descriptor defined for " + service + " ResponseReceiver");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResponseReceiverConfig returns " + result);
        }
        return result;
    }

    public static void processSecurity(WSDescBinding wsdesc, WsDescExt wsdescext, PortComponent pc, WSDDPort wsddPort, ClassLoader appClassLoader) throws RuntimeError, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        try {
            String portComponentName = pc.getPortComponentName();
            PCBinding pcb = SecurityHooks.findPortBinding(wsdesc, portComponentName);
            if (pcb != null) {
                if (pcb.getScope() != null) {
                    JavaBeanDispatcher.setScope((Configurable)wsddPort, pcb.getScope());
                }
                SecurityRequestReceiverBindingConfig reqRecBnd = pcb.getSecurityRequestReceiverBindingConfig();
                SecurityResponseSenderBindingConfig resSndBnd = pcb.getSecurityResponseSenderBindingConfig();
                SecurityRequestConsumerBindingConfig reqConBnd = pcb.getSecurityRequestConsumerBindingConfig();
                SecurityResponseGeneratorBindingConfig resGenBnd = pcb.getSecurityResponseGeneratorBindingConfig();
                PcBinding pcbe = SecurityHooks.findPcBinding(wsdescext, portComponentName);
                ServerServiceConfig ssConfig = null;
                if (pcbe != null) {
                    ssConfig = pcbe.getServerServiceConfig();
                }
                SecurityRequestReceiverServiceConfig reqRecExt = null;
                SecurityResponseSenderServiceConfig resSndExt = null;
                SecurityRequestConsumerServiceConfig reqConExt = null;
                SecurityResponseGeneratorServiceConfig resGenExt = null;
                String actorURI = null;
                if (ssConfig != null) {
                    reqRecExt = ssConfig.getSecurityRequestReceiverServiceConfig();
                    resSndExt = ssConfig.getSecurityResponseSenderServiceConfig();
                    reqConExt = ssConfig.getSecurityRequestConsumerServiceConfig();
                    resGenExt = ssConfig.getSecurityResponseGeneratorServiceConfig();
                    actorURI = ssConfig.getActorURI();
                }
                if (appClassLoader == null) {
                    throw new RuntimeException("Application ClassLoader is null");
                }
                SecurityHooks.createServerWSEMFClasses(reqRecExt, reqRecBnd, resSndExt, resSndBnd, reqConExt, reqConBnd, resGenExt, resGenBnd, wsddPort, appClassLoader, actorURI, varMap, service, pcb);
            } else {
                Object[] parms = new Object[]{portComponentName, ""};
                Tr.warning(tc, "no.matching.portcompbinding", parms);
            }
        }
        catch (RuntimeError e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.security.SecurityHooks.processSecurity", "951", null);
            String msgKey = "exception.context";
            Object[] parms = new Object[]{"createService", "portComponentName=" + pc.getPortComponentName() + "."};
            Tr.error(tc, msgKey, parms);
            throw e;
        }
    }

    public static void createServerWSEMFClasses(SecurityRequestReceiverServiceConfig reqRecExt, SecurityRequestReceiverBindingConfig reqRecBnd, SecurityResponseSenderServiceConfig resSndExt, SecurityResponseSenderBindingConfig resSndBnd, SecurityRequestConsumerServiceConfig reqConExt, SecurityRequestConsumerBindingConfig reqConBnd, SecurityResponseGeneratorServiceConfig resGenExt, SecurityResponseGeneratorBindingConfig resGenBnd, WSDDPort wsddPort, ClassLoader appClassLoader, String actorURI, VariableMap varMap, WSSecurityService service) throws RuntimeError, InstantiationException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException {
        SecurityHooks.createServerWSEMFClasses(reqRecExt, reqRecBnd, resSndExt, resSndBnd, reqConExt, reqConBnd, resGenExt, resGenBnd, wsddPort, appClassLoader, actorURI, varMap, service, null);
    }

    public static void createServerWSEMFClasses(SecurityRequestReceiverServiceConfig reqRecExt, SecurityRequestReceiverBindingConfig reqRecBnd, SecurityResponseSenderServiceConfig resSndExt, SecurityResponseSenderBindingConfig resSndBnd, SecurityRequestConsumerServiceConfig reqConExt, SecurityRequestConsumerBindingConfig reqConBnd, SecurityResponseGeneratorServiceConfig resGenExt, SecurityResponseGeneratorBindingConfig resGenBnd, WSDDPort wsddPort, ClassLoader appClassLoader, String actorURI, VariableMap varMap, WSSecurityService service, PCBinding portCmpBnd) throws RuntimeError, InstantiationException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException {
        boolean was6 = true;
        if (reqRecExt != null || reqRecBnd != null || resSndExt != null || resSndBnd != null) {
            was6 = false;
        }
        if (reqConExt != null || reqConBnd != null || resGenExt != null || resGenBnd != null) {
            was6 = true;
        }
        boolean wssConfigured = false;
        if (was6) {
            Constructor<?> c;
            Class<?> clazz;
            Object obj;
            if (SecurityHooks.createRequestConsumerConfig(reqConExt, reqConBnd, wsddPort.getQName())) {
                obj = null;
                try {
                    clazz = cl.loadClass("com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestConsumerConfig");
                    c = clazz.getConstructor(SecurityRequestConsumerBindingConfig.class, SecurityRequestConsumerServiceConfig.class, String.class, VariableMap.class, WSSecurityService.class, ClassLoader.class);
                    obj = c.newInstance(reqConBnd, reqConExt, actorURI, varMap, service, appClassLoader);
                }
                catch (InvocationTargetException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.security.SecurityHooks.createServerWSEMFClasses", "1029", null);
                    Throwable t = e.getTargetException();
                    Tr.error(tc, "wssec.loadconfig.failed", new Object[]{"com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestConsumerConfig", t});
                    Tr.error(tc, "wssec.configuration.error", new Object[]{"Request Consumer", wsddPort.getQName()});
                    throw new RuntimeError(t);
                }
                if (obj != null) {
                    wsddPort.setObject(OPTION_REQUEST_RECEIVER_CONFIG, obj);
                    wssConfigured = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RequestConsumer Binding and DD Security Configuration for " + wsddPort.getQName() + " is loaded");
                        Tr.debug(tc, "wssConfigured = [" + wssConfigured + "]");
                    }
                }
            }
            if (SecurityHooks.createResponseGeneratorConfig(resGenExt, resGenBnd, wsddPort.getQName())) {
                obj = null;
                try {
                    clazz = cl.loadClass("com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseGeneratorConfig");
                    c = clazz.getConstructor(SecurityResponseGeneratorBindingConfig.class, SecurityResponseGeneratorServiceConfig.class, String.class, VariableMap.class, WSSecurityService.class, ClassLoader.class);
                    obj = c.newInstance(resGenBnd, resGenExt, actorURI, varMap, service, appClassLoader);
                }
                catch (InvocationTargetException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.security.SecurityHooks.createServerWSEMFClasses", "1060", null);
                    Throwable t = e.getTargetException();
                    Tr.error(tc, "wssec.loadconfig.failed", new Object[]{"com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseGeneratorConfig", t});
                    Tr.error(tc, "wssec.configuration.error", new Object[]{"Response Generator", wsddPort.getQName()});
                    throw new RuntimeError(t);
                }
                if (obj != null) {
                    wsddPort.setObject(OPTION_RESPONSE_SENDER_CONFIG, obj);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ResponseGenerator Binding and DD Security Configuration for " + wsddPort.getQName() + " is loaded");
                    }
                }
            }
        } else {
            Constructor<?> c;
            Class<?> clazz;
            Object obj;
            if (SecurityHooks.createRequestReceiverConfig(reqRecExt, reqRecBnd, wsddPort.getQName())) {
                obj = null;
                try {
                    clazz = cl.loadClass("com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestReceiverConfig");
                    c = clazz.getConstructor(SecurityRequestReceiverBindingConfig.class, SecurityRequestReceiverServiceConfig.class, String.class, VariableMap.class, WSSecurityService.class, ClassLoader.class, PCBinding.class);
                    obj = c.newInstance(reqRecBnd, reqRecExt, actorURI, varMap, service, appClassLoader, portCmpBnd);
                }
                catch (InvocationTargetException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.security.SecurityHooks.createServerWSEMFClasses", "1093", null);
                    Throwable t = e.getTargetException();
                    Tr.error(tc, "wssec.loadconfig.failed", new Object[]{"com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestReceiverConfig", t});
                    Tr.error(tc, "wssec.configuration.error", new Object[]{"Request Receiver", wsddPort.getQName()});
                    throw new RuntimeError(t);
                }
                if (obj != null) {
                    wsddPort.setObject(OPTION_REQUEST_RECEIVER_CONFIG, obj);
                    wssConfigured = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RequestReceiver Binding and DD Security Configuration for " + wsddPort.getQName() + " is loaded");
                        Tr.debug(tc, "wssConfigured = [" + wssConfigured + "]");
                    }
                }
            }
            if (SecurityHooks.createResponseSenderConfig(resSndExt, resSndBnd, wsddPort.getQName())) {
                obj = null;
                try {
                    clazz = cl.loadClass("com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseSenderConfig");
                    c = clazz.getConstructor(SecurityResponseSenderBindingConfig.class, SecurityResponseSenderServiceConfig.class, String.class, VariableMap.class, WSSecurityService.class, ClassLoader.class, PCBinding.class);
                    obj = c.newInstance(resSndBnd, resSndExt, actorURI, varMap, service, appClassLoader, portCmpBnd);
                }
                catch (InvocationTargetException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.security.SecurityHooks.createServerWSEMFClasses", "1125", null);
                    Throwable t = e.getTargetException();
                    Tr.error(tc, "wssec.loadconfig.failed", new Object[]{"com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseSenderConfig", t});
                    Tr.error(tc, "wssec.configuration.error", new Object[]{"Response Sender", wsddPort.getQName()});
                    throw new RuntimeError(t);
                }
                if (obj != null) {
                    wsddPort.setObject(OPTION_RESPONSE_SENDER_CONFIG, obj);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ResponseSender Binding and DD Security Configuration for " + wsddPort.getQName() + " is loaded");
                    }
                }
            }
        }
        if (wssConfigured) {
            wsddPort.addActorHeaderBinding(actorURI, securityHeaderQNames);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSE header(s) associated with actor [" + actorURI + "] for port [" + wsddPort.getQName() + "]");
            }
        } else {
            wsddPort.addActorHeaderBinding(actorURI, emptyQNames);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSE header(s) NOT associated with actor [" + actorURI + "] for port [" + wsddPort.getQName() + "]");
            }
        }
    }

    public static boolean createRequestConsumerConfig(SecurityRequestConsumerServiceConfig ext, SecurityRequestConsumerBindingConfig bnd, QName serviceName) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRequestConsumerConfig", new Object[]{ext, bnd, serviceName});
        }
        boolean result = false;
        if (ext != null) {
            EList securityTokens;
            EList confidentialities;
            boolean[] tmp = new boolean[5];
            tmp[4] = false;
            tmp[3] = false;
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            EList integrities = ext.getRequiredIntegrity();
            if (integrities != null) {
                for (int i = 0; i < integrities.size(); ++i) {
                    RequiredIntegrity integrity = (RequiredIntegrity)integrities.get(i);
                    EList parts = integrity.getMessageParts();
                    boolean bl = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getTimestamp();
                    boolean bl2 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getNonce();
                    boolean bl3 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredIntegrity constraint defined: " + tmp[0]);
            }
            if ((confidentialities = ext.getRequiredConfidentiality()) != null) {
                for (int i = 0; i < confidentialities.size(); ++i) {
                    RequiredConfidentiality confidentiality = (RequiredConfidentiality)confidentialities.get(i);
                    EList parts = confidentiality.getMessageParts();
                    boolean bl = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getTimestamp();
                    boolean bl4 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getNonce();
                    boolean bl5 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredConfidentiality constraint defined: " + tmp[1]);
            }
            boolean bl = tmp[2] = (securityTokens = ext.getRequiredSecurityToken()) != null && !securityTokens.isEmpty();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredSecurityToken constraint defined: " + tmp[2]);
            }
            boolean bl6 = tmp[3] = ext.getCaller() != null && !ext.getCaller().isEmpty();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caller constraint defined: " + tmp[3]);
            }
            boolean bl7 = tmp[4] = ext.getAddTimestamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddTimestamp constraint defined: " + tmp[4]);
            }
            if ((tmp[0] || tmp[1] || tmp[2] || tmp[3]) && bnd == null) {
                throw new RuntimeError("There is no binding defined for " + serviceName + " RequestConsumer");
            }
            result = tmp[0] || tmp[1] || tmp[2] || tmp[3] || tmp[4];
        } else if (bnd != null) {
            throw new RuntimeError("There is no deployment descriptor defined for " + serviceName + " RequestConsumer");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRequestConsumerConfig returns " + result);
        }
        return result;
    }

    public static boolean createResponseGeneratorConfig(SecurityResponseGeneratorServiceConfig ext, SecurityResponseGeneratorBindingConfig bnd, QName serviceName) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResponseGeneratorConfig", new Object[]{ext, bnd, serviceName});
        }
        boolean result = false;
        if (ext != null) {
            EList securityTokens;
            EList confidentialities;
            boolean[] tmp = new boolean[4];
            tmp[3] = false;
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            EList integrities = ext.getIntegrity();
            if (integrities != null) {
                for (int i = 0; i < integrities.size(); ++i) {
                    Integrity integrity = (Integrity)integrities.get(i);
                    EList parts = integrity.getMessageParts();
                    boolean bl = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getTimestamp();
                    boolean bl2 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getNonce();
                    boolean bl3 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Integrity constraint defined: " + tmp[0]);
            }
            if ((confidentialities = ext.getConfidentiality()) != null) {
                for (int i = 0; i < confidentialities.size(); ++i) {
                    Confidentiality confidentiality = (Confidentiality)confidentialities.get(i);
                    EList parts = confidentiality.getMessageParts();
                    boolean bl = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getTimestamp();
                    boolean bl4 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getNonce();
                    boolean bl5 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Confidentiality constraint defined: " + tmp[1]);
            }
            boolean bl = tmp[2] = (securityTokens = ext.getSecurityToken()) != null && !securityTokens.isEmpty();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SecurityToken constraint defined: " + tmp[2]);
            }
            boolean bl6 = tmp[3] = ext.getAddTimestamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddTimestamp constraint defined: " + tmp[2]);
            }
            if ((tmp[0] || tmp[1] || tmp[2]) && bnd == null) {
                throw new RuntimeError("There is no binding defined for " + serviceName + " ResponseGenerator");
            }
            result = tmp[0] || tmp[1] || tmp[2] || tmp[3];
        } else if (bnd != null) {
            throw new RuntimeError("There is no deployment descriptor defined for " + serviceName + " ResponseGenerator");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResponseGeneratorConfig returns " + result);
        }
        return result;
    }

    public static boolean createRequestReceiverConfig(SecurityRequestReceiverServiceConfig ext, SecurityRequestReceiverBindingConfig bnd, QName serviceName) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRequestReceiverConfig", new Object[]{ext, bnd, serviceName});
        }
        boolean result = false;
        if (ext != null) {
            LoginConfig loginConfig;
            RequiredConfidentiality confidentiality;
            boolean[] tmp = new boolean[5];
            tmp[4] = false;
            tmp[3] = false;
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            RequiredIntegrity integrity = ext.getRequiredIntegrity();
            if (integrity != null) {
                EList ref = integrity.getReferences();
                boolean bl = tmp[0] = ref != null && !ref.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredIntegrity constraint defined: " + tmp[0]);
            }
            if ((confidentiality = ext.getRequiredConfidentiality()) != null) {
                EList parts = confidentiality.getConfidentialParts();
                boolean bl = tmp[1] = parts != null && !parts.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredConfidentiality constraint defined: " + tmp[1]);
            }
            if ((loginConfig = ext.getLoginConfig()) != null) {
                EList authMethods = loginConfig.getAuthMethods();
                boolean bl = tmp[2] = authMethods != null && !authMethods.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LoginConfig constraint defined: " + tmp[2]);
            }
            boolean bl = tmp[3] = ext.getAddReceivedTimestamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddReceivedTimestamp constraint defined: " + tmp[3]);
            }
            boolean bl2 = tmp[4] = ext.getIdAssertion() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IDAssertion constraint defined: " + tmp[4]);
            }
            if ((tmp[0] || tmp[1] || tmp[4]) && bnd == null) {
                throw new RuntimeError("There is no binding defined for " + serviceName + " RequestReceiver");
            }
            result = tmp[0] || tmp[1] || tmp[2] || tmp[3] || tmp[4];
        } else if (bnd != null) {
            throw new RuntimeError("There is no deployment descriptor defined for " + serviceName + " RequestReceiver");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRequestReceiverConfig returns " + result);
        }
        return result;
    }

    public static boolean createResponseSenderConfig(SecurityResponseSenderServiceConfig ext, SecurityResponseSenderBindingConfig bnd, QName serviceName) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResponseSenderConfig", new Object[]{ext, bnd, serviceName});
        }
        boolean result = false;
        if (ext != null) {
            Confidentiality confidentiality;
            boolean[] tmp = new boolean[3];
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            Integrity integrity = ext.getIntegrity();
            if (integrity != null) {
                EList ref = integrity.getReferences();
                boolean bl = tmp[0] = ref != null && !ref.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Integrity constraint defined: " + tmp[0]);
            }
            if ((confidentiality = ext.getConfidentiality()) != null) {
                EList parts = confidentiality.getConfidentialParts();
                boolean bl = tmp[1] = parts != null && !parts.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Confidentiality constraint defined: " + tmp[1]);
            }
            boolean bl = tmp[2] = ext.getAddCreatedTimestamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddCreatedTimeStamp constraint defined: " + tmp[2]);
            }
            if ((tmp[0] || tmp[1]) && bnd == null) {
                throw new RuntimeError("There is no binding defined for " + serviceName + " ResponseSender");
            }
            result = tmp[0] || tmp[1] || tmp[2];
        } else if (bnd != null) {
            throw new RuntimeError("There is no deployment descriptor defined for " + serviceName + " ResponseSender");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResponseSenderConfig returns " + result);
        }
        return result;
    }

    private static PCBinding findPortBinding(WSDescBinding wsdesc, String PortComponentName) throws RuntimeError {
        if (wsdesc != null) {
            int pcbCount = wsdesc.getPcBindings().size();
            for (int mm = 0; mm < pcbCount; ++mm) {
                PCBinding pcBinding = (PCBinding)wsdesc.getPcBindings().get(mm);
                if (!PortComponentName.equals(pcBinding.getPcNameLink())) continue;
                if (pcBinding.getScope() != null && !Scope.isValid(pcBinding.getScope())) {
                    String msgKey = "illegal.scope";
                    Object[] parms = new Object[]{"", PortComponentName, pcBinding.getScope()};
                    Tr.error(tc, msgKey, parms);
                    throw new RuntimeError(nls.getFormattedMessage(msgKey, parms, null));
                }
                return pcBinding;
            }
        }
        return null;
    }

    private static PcBinding findPcBinding(WsDescExt wsdescext, String name2) throws RuntimeError {
        if (wsdescext != null) {
            int pcbCount = wsdescext.getPcBinding().size();
            for (int mm = 0; mm < pcbCount; ++mm) {
                PcBinding pcBinding = (PcBinding)wsdescext.getPcBinding().get(mm);
                if (!name2.equals(pcBinding.getPcNameLink())) continue;
                if (pcBinding.getScope() != null && !Scope.isValid(pcBinding.getScope())) {
                    String msgKey = "illegal.scope";
                    Object[] parms = new Object[]{"", name2, pcBinding.getScope()};
                    Tr.error(tc, msgKey, parms);
                    throw new RuntimeError(nls.getFormattedMessage(msgKey, parms, null));
                }
                return pcBinding;
            }
        }
        return null;
    }

    static {
        emptyQNames = new JAXRPCHandler.QNameSet();
        service = null;
        varMap = null;
        cl = SecurityHooks.class.getClassLoader();
        securityHeaderQNames = new JAXRPCHandler.QNameSet();
        securityHeaderQNames.add(QNameTable.createQName("http://schemas.xmlsoap.org/ws/2002/04/secext", "Security"));
        securityHeaderQNames.add(QNameTable.createQName("http://schemas.xmlsoap.org/ws/2002/07/secext", "Security"));
        securityHeaderQNames.add(QNameTable.createQName("http://schemas.xmlsoap.org/ws/2003/06/secext", "Security"));
        securityHeaderQNames.add(QNameTable.createQName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
    }
}

