/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.provider.ejb.stubless.impl.FaultWrapper;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;

public abstract class ModelInvocationHandler
implements InvocationHandler {
    protected InvocationContext invocationContext;
    protected static ArrayList propertyNames = new ArrayList();

    protected ModelInvocationHandler(InvocationContext invContext) {
        this.invocationContext = invContext;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object response;
        if (method.getName().charAt(0) == '_') {
            response = this.invokeSpecialMethod(method, args);
        } else {
            try {
                response = this.invokeOperation(method, args);
            }
            catch (RemoteException e) {
                Throwable t = e;
                while (((Throwable)t).getCause() != null) {
                    if (!this.isDeclaredException(method, t = ((Throwable)t).getCause())) continue;
                    throw t;
                }
                throw e;
            }
        }
        return response;
    }

    protected abstract Object invokeOperation(Method var1, Object[] var2) throws RemoteException;

    protected Object invokeSpecialMethod(Method method, Object[] args) throws RemoteException {
        Object response = null;
        String methodName = method.getName();
        if ("_getPropertyNames".equals(methodName)) {
            response = this.doGetPropertyNames();
        } else if ("_getProperty".equals(methodName)) {
            response = this.doGetProperty(args[0]);
        } else if ("_setProperty".equals(methodName)) {
            this.doSetProperty(args[0], args[1]);
        } else {
            this.doUnknownSpecialMethod(method, args);
        }
        return response;
    }

    protected Object doGetPropertyNames() {
        Iterator response = propertyNames.iterator();
        return response;
    }

    protected Object doGetProperty(Object name2) {
        if (this.isIllegalPropertyNameForStub((String)name2)) {
            throw new JAXRPCException(Messages.getMessage("badCallPropName", name2.toString()));
        }
        return this.invocationContext.getProperty((String)name2);
    }

    protected void doSetProperty(Object name2, Object value2) {
        if (this.isIllegalPropertyNameForStub((String)name2)) {
            throw new JAXRPCException(Messages.getMessage("badCallPropName", name2.toString()));
        }
        this.invocationContext.setProperty((String)name2, value2);
    }

    protected Object doUnknownSpecialMethod(Method method, Object[] args) throws RemoteException {
        throw new IllegalArgumentException(Messages.getMessage("invalidMethod", method.getName()));
    }

    protected boolean isIllegalPropertyNameForStub(String name2) {
        if (name2 == null) {
            return true;
        }
        if (name2.equals("javax.xml.rpc.service.endpoint.address") || name2.equals("javax.xml.rpc.security.auth.password") || name2.equals("javax.xml.rpc.session.maintain") || name2.equals("javax.xml.rpc.security.auth.username")) {
            return false;
        }
        return name2.startsWith("javax.xml.rpc");
    }

    protected boolean isDeclaredException(Method method, Throwable throwable) {
        if (throwable instanceof FaultWrapper) {
            return false;
        }
        Class<?>[] declaredExceptions = method.getExceptionTypes();
        for (int i = 0; i < declaredExceptions.length; ++i) {
            if (!declaredExceptions[i].isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    static {
        propertyNames.add("javax.xml.rpc.session.maintain");
    }
}

