/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.provider.BindingGenerator;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import com.ibm.ws.webservices.utils.OptionDescriptor;
import com.ibm.wsdl.BindingFaultImpl;
import com.ibm.wsdl.BindingInputImpl;
import com.ibm.wsdl.BindingOperationImpl;
import com.ibm.wsdl.BindingOutputImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;

public abstract class ModelBindingGenerator
implements BindingGenerator {
    protected String bindingTypeName;
    protected OptionDescriptor[] defaultOptionDescriptors = null;

    public ModelBindingGenerator(String bindingName) {
        this.bindingTypeName = bindingName;
        this.defaultOptionDescriptors = new OptionDescriptor[]{new OptionDescriptor(this.bindingTypeName + ".bindingName", false, Messages.getMessage("desc.bindingName", this.bindingTypeName)), new OptionDescriptor(this.bindingTypeName + ".servicePortName", false, Messages.getMessage("desc.servicePortName", this.bindingTypeName)), new OptionDescriptor(this.bindingTypeName + ".location", false, Messages.getMessage("desc.locationURI", this.bindingTypeName))};
    }

    public String getBindingTypeName() {
        return this.bindingTypeName;
    }

    protected OptionDescriptor[] getDefaultOptionDescriptors() {
        return this.defaultOptionDescriptors;
    }

    public OptionDescriptor[] getOptionDescriptors() {
        return this.getDefaultOptionDescriptors();
    }

    public Binding makeBinding(Definition def, PortType portType, QName bindingQName, Properties properties) {
        Binding newBinding = def.createBinding();
        newBinding.setPortType(portType);
        newBinding.setQName(bindingQName);
        ExtensibilityElement bindingExtension = this.getBindingExtension(portType);
        if (bindingExtension != null) {
            newBinding.addExtensibilityElement(bindingExtension);
        }
        this.addOperations(portType, newBinding);
        newBinding.setUndefined(false);
        this.addNamespaces(def);
        return newBinding;
    }

    protected abstract ExtensibilityElement getBindingExtension(PortType var1);

    protected void addOperations(PortType p, Binding b) {
        Iterator i = p.getOperations().iterator();
        while (i.hasNext()) {
            Output output;
            Input input;
            Operation op = (Operation)i.next();
            BindingOperationImpl bop = new BindingOperationImpl();
            bop.setName(op.getName());
            bop.setOperation(op);
            ExtensibilityElement operationExtension = this.getBindingOperation(op);
            if (operationExtension != null) {
                bop.addExtensibilityElement(operationExtension);
            }
            if ((input = op.getInput()) != null) {
                BindingInputImpl bin = new BindingInputImpl();
                bin.setName(input.getName());
                this.doGetBindingInput(op, bop, bin);
                bop.setBindingInput(bin);
            }
            if ((output = op.getOutput()) != null) {
                BindingOutputImpl bout = new BindingOutputImpl();
                bout.setName(output.getName());
                this.doGetBindingOutput(op, bop, bout);
                bop.setBindingOutput(bout);
            }
            if (op.getFaults() != null) {
                Iterator it = op.getFaults().values().iterator();
                while (it.hasNext()) {
                    Fault fault2 = (Fault)it.next();
                    BindingFaultImpl bindingFault = new BindingFaultImpl();
                    bindingFault.setName(fault2.getName());
                    bop.addBindingFault(bindingFault);
                }
            }
            b.addBindingOperation(bop);
        }
    }

    protected abstract ExtensibilityElement getBindingOperation(Operation var1);

    protected void doGetBindingInput(Operation op, BindingOperation bop, BindingInput bin) {
    }

    protected void doGetBindingOutput(Operation op, BindingOperation bop, BindingOutput bout) {
    }

    protected void addNamespaces(Definition def) {
        Map namespaces = this.getRequiredNamespaces();
        if (namespaces != null) {
            Iterator i = namespaces.keySet().iterator();
            while (i.hasNext()) {
                String name2 = (String)i.next();
                String uri = (String)namespaces.get(name2);
                if (def.getNamespace(name2) != null) continue;
                def.addNamespace(name2, uri);
            }
        }
    }

    protected abstract Map getRequiredNamespaces();

    public ExtensibilityElement makePortAddress(Definition def, Port port2, Properties properties) {
        String specificUrl = properties.getProperty(this.bindingTypeName + ".location");
        String genericUrl = properties.getProperty("location");
        AgnosticAddress agnosticAddress = new AgnosticAddress();
        agnosticAddress.setLocationURI(specificUrl != null ? specificUrl : genericUrl);
        String agnosticAddressNS = AgnosticAddress.AGNOSTIC_ADDRESS_ELEMENT_QNAME.getNamespaceURI();
        if (def.getNamespace(agnosticAddressNS) == null) {
            def.addNamespace("generic", agnosticAddressNS);
        }
        return agnosticAddress;
    }

    public String getBindingName(Properties properties) {
        String bindingName;
        String specificBindingName = properties.getProperty(this.bindingTypeName + ".bindingName");
        if (specificBindingName != null) {
            bindingName = specificBindingName;
        } else {
            String genericBindingName = properties.getProperty("bindingName");
            bindingName = genericBindingName + JavaUtils.capitalizeFirstChar(this.bindingTypeName) + "Binding";
        }
        return bindingName;
    }

    public String getPortName(Properties properties) {
        String portName;
        String specificPortName = properties.getProperty(this.bindingTypeName + ".servicePortName");
        if (specificPortName != null) {
            portName = specificPortName;
        } else {
            String genericPortName = properties.getProperty("servicePortName");
            portName = genericPortName + JavaUtils.capitalizeFirstChar(this.bindingTypeName);
        }
        return portName;
    }
}

