/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webservices.configuration.WASEngineConfigurationProvider;
import com.ibm.ws.webservices.configuration.WebServicesEngineConfigurationGenerator;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.metadata.ServerPortMetaData;
import com.ibm.ws.webservices.pmi.modules.ModulePmiModule;
import com.ibm.ws.webservices.pmi.modules.ServicePmiModule;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webservices.management.EndpointManagerMBean;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class ServerModuleMetaData {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static TraceComponent _tc = Tr.register(ServerModuleMetaData.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private final String applicationName;
    private final String moduleName;
    protected WSDDDeployment deployment;
    protected boolean tryLoadDeploy = false;
    private EngineConfiguration configuration;
    private String routerModuleName;
    private WebServicesPerf pmiServicesModule;
    private ModulePmiModule pmiEndpointsModule;
    protected Map serverPorts = new HashMap();
    private String binaryURL;
    private EndpointManagerMBean mbean = null;
    private List endpoints = null;
    private Map serviceRefInfo = null;

    public ServerModuleMetaData(String applicationName, String moduleName) {
        this.applicationName = applicationName;
        this.moduleName = moduleName;
    }

    public void destroy() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, this.applicationName + "#" + this.moduleName + ": Destroying " + this);
        }
        this.deployment = null;
        this.pmiServicesModule = null;
        this.pmiEndpointsModule = null;
        if (this.serverPorts != null) {
            Iterator iter = this.serverPorts.values().iterator();
            while (iter.hasNext()) {
                ServerPortMetaData spmd = (ServerPortMetaData)iter.next();
                if (spmd == null) continue;
                spmd.destroy();
            }
            this.serverPorts.clear();
            this.serverPorts = null;
        }
        if (this.configuration != null) {
            this.configuration.destroy();
            this.configuration = null;
            this.deployment = null;
        }
    }

    public Map getPorts() {
        return this.serverPorts;
    }

    public ServerPortMetaData getPort(String name2, boolean force) {
        ServerPortMetaData spmd = (ServerPortMetaData)this.serverPorts.get(name2);
        if (spmd == null && force) {
            spmd = new ServerPortMetaData(name2);
            this.serverPorts.put(name2, spmd);
        }
        return spmd;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public synchronized WSDDDeployment getDeployment() {
        if (this.deployment == null && !this.tryLoadDeploy) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating engine config");
            }
            this.deployment = WebServicesEngineConfigurationGenerator.createServerDeployment(this.serverPorts.values());
            this.tryLoadDeploy = true;
        }
        if (_tc.isDebugEnabled() && this.deployment != null) {
            Tr.debug(_tc, "this.hashCode=" + this.hashCode() + "getConfiguration: configuration=" + this.deployment);
        }
        return this.deployment;
    }

    public synchronized EngineConfiguration getConfiguration() {
        if (this.configuration == null) {
            WSDDDeployment deploy2 = this.getDeployment();
            this.configuration = new WASEngineConfigurationProvider(deploy2);
        }
        return this.configuration;
    }

    public WebServicesPerf getPMIServicesModule() {
        return this.pmiServicesModule;
    }

    public ModulePmiModule getPMIEndpointsModule() {
        return this.pmiEndpointsModule;
    }

    public String getRouterModuleName() {
        return this.routerModuleName;
    }

    public void setRouterModuleName(String name2) {
        this.routerModuleName = name2;
    }

    public String getBinaryURL() {
        return this.binaryURL;
    }

    public void setBinaryURL(String string) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "absolute binary url", string);
        }
        this.binaryURL = string;
    }

    public void collaboratorStarted() {
        if (this.getDeployment() != null) {
            WSDDPort wsddPort;
            int sidx;
            WSDDPort[] wsddPorts;
            this.pmiServicesModule = PmiFactory.createWebServicesPerf((String)this.getApplicationName(), (String)this.getModuleName());
            if (StatsFactory.isPMIEnabled()) {
                this.pmiEndpointsModule = new ModulePmiModule(this.getApplicationName(), this.getModuleName());
            }
            if (this.getPMIServicesModule() != null) {
                wsddPorts = this.getDeployment().getPorts();
                for (sidx = 0; sidx < wsddPorts.length; ++sidx) {
                    wsddPort = wsddPorts[sidx];
                    this.getPMIServicesModule().onServiceLoad(wsddPort.getQName().toString());
                }
            }
            if (this.getPMIEndpointsModule() != null) {
                wsddPorts = this.getDeployment().getPorts();
                for (sidx = 0; sidx < wsddPorts.length; ++sidx) {
                    ServicePmiModule pmiService;
                    wsddPort = wsddPorts[sidx];
                    QName serviceQName = wsddPort.getServiceQName();
                    QName portQName = wsddPort.getWSDLPort();
                    if (serviceQName == null || (pmiService = this.getPMIEndpointsModule().registerService(serviceQName.toString())) == null || portQName == null) continue;
                    pmiService.registerEndpoint(portQName.getLocalPart().toString());
                }
            }
        }
    }

    public void collaboratorStopped() {
        if (this.getDeployment() != null && this.getPMIServicesModule() != null) {
            WSDDPort[] wsddPorts = this.getDeployment().getPorts();
            for (int sidx = 0; sidx < wsddPorts.length; ++sidx) {
                WSDDPort wsddPort = wsddPorts[sidx];
                this.getPMIServicesModule().onServiceUnload(wsddPort.getQName().toString());
            }
            PmiFactory.removePmiModule((Object)this.getPMIServicesModule());
            this.getPMIEndpointsModule().destroy();
            this.pmiServicesModule = null;
            this.pmiEndpointsModule = null;
        }
    }

    public void bindRouterURLPatterns(WebAppConfiguration wjar) {
        HashMap mappingLists = wjar.getServletMappings();
        Iterator i = mappingLists.values().iterator();
        while (i.hasNext()) {
            List mappings = (List)i.next();
            Iterator j = mappings.iterator();
            while (j.hasNext()) {
                ServletMapping mapping = (ServletMapping)j.next();
                IServletConfig servlet = mapping.getServletConfig();
                String portComponentName = servlet.getServletName();
                String urlPattern2 = mapping.getUrlPattern();
                ServerPortMetaData portComponent = this.getPort(portComponentName, true);
                portComponent.setServletName(servlet.getServletName());
                if (urlPattern2 != null) {
                    portComponent.setURLPattern(urlPattern2, false);
                    continue;
                }
                portComponent.setURLPattern("/services/" + portComponentName, true);
            }
        }
        if (_tc.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg = msg.append("warMetaDataCreated for a non Web Services enabled module ");
            msg = msg.append(this.moduleName);
            msg = msg.append(", portComponentName info: \n");
            Map map = this.getPorts();
            if (map != null) {
                Iterator i2 = map.values().iterator();
                while (i2.hasNext()) {
                    ServerPortMetaData spmd = (ServerPortMetaData)i2.next();
                    msg.append("\t");
                    msg.append(spmd);
                    msg.append("\n");
                }
            }
            Tr.debug(_tc, msg.toString());
        }
    }

    public EndpointManagerMBean getEndpointManagerMbean() {
        return this.mbean;
    }

    public void setEndpointManagerMbean(EndpointManagerMBean mbean) {
        this.mbean = mbean;
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        this.endpoints = endpoints;
    }

    public void setServiceRefInfo(Map serviceRefInfo) {
        this.serviceRefInfo = serviceRefInfo;
    }

    public Map getServiceRefInfo() {
        return this.serviceRefInfo;
    }
}

