/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.ext;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.builders.RequestResponseProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class RequestResponse {
    protected static Log log = LogFactory.getLog(RequestResponse.class.getName());
    protected Vector params = new Vector();
    protected boolean needDeser = false;
    OperationDesc[] tryOperations = null;
    OperationDesc operation = null;
    DeserializationContext context = null;
    SOAPBody body;
    boolean isResponse;
    QName operationQName = null;
    boolean legacyTestMode = false;
    boolean inDeserialize = false;

    public RequestResponse(String namespace, String localPart, SOAPBody body, boolean isResponse, OperationDesc[] tryOperations, DeserializationContext context) throws SOAPException {
        this.body = body;
        this.isResponse = isResponse;
        this.tryOperations = tryOperations;
        if (tryOperations != null && tryOperations.length == 1) {
            this.operation = tryOperations[0];
        }
        this.context = context;
        this.operationQName = QNameTable.createQName(namespace, localPart);
        this.needDeser = true;
        if (body != null) {
            body.setAlternateContent(this);
        }
    }

    public RequestResponse(String namespace, String localPart, SOAPBody body, boolean isResponse) throws SOAPException {
        this.body = body;
        this.isResponse = isResponse;
        this.operationQName = QNameTable.createQName(namespace, localPart);
        if (body != null) {
            body.setAlternateContent(this);
        }
    }

    public SOAPBody getBody() {
        return this.body;
    }

    public void attachToBody(SOAPBody body) throws SOAPException {
        this.body = body;
        if (body != null) {
            body.setAlternateContent(this);
        }
    }

    public QName getQName() {
        return this.operationQName;
    }

    public OperationDesc getOperation() throws SAXException {
        if (this.needDeser && !this.inDeserialize) {
            this.deserialize(this.context);
        }
        return this.operation;
    }

    public void addParams(Object[] args) {
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] instanceof ParamValue) {
                this.addParam((ParamValue)args[i]);
                continue;
            }
            String name2 = null;
            if (name2 == null) {
                name2 = "arg" + i;
            }
            this.addParam(new ParamValue("", name2, args[i]));
        }
    }

    public void setNeedDeser(boolean needDeser) {
        this.needDeser = needDeser;
    }

    public boolean hasDeserializedParams() {
        return !this.needDeser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deserialize(DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("RequestResponse: deserialize() starting");
        }
        this.inDeserialize = true;
        boolean origProtect = this.body.getSOAPFactory().getProtectState();
        this.body.getSOAPFactory().setProtectState(false);
        this.params.clear();
        MessageContext msgContext = context.getMessageContext();
        Message msg = msgContext.getCurrentMessage();
        RequestResponseProcessor reqRespProcessor = new RequestResponseProcessor(this, this.isResponse);
        this.operation = this._resolveOperation(msgContext, msg);
        if (this.operation != null) {
            msgContext.setOperation(this.operation);
        }
        if (this.tryOperations != null) {
            SAXException savedException = null;
            if (this.tryOperations.length > 1) {
                reqRespProcessor.setEnableSecondaryLookup(false);
            }
            for (int i = 0; i < this.tryOperations.length; ++i) {
                this.operation = this.tryOperations[i];
                msgContext.setOperation(this.operation);
                boolean isNoDataBinding = RequestResponse.isNoDataBindingOperation(this.operation);
                if (log.isDebugEnabled()) {
                    log.debug("RequestResponse: deserialize() trying to deserialize with \n" + this.operation.toString());
                }
                reqRespProcessor.setOperation(this.operation);
                try {
                    SOAPElement operationElement;
                    context.createEventConverter(new WrapperProcessor(reqRespProcessor));
                    if (this.operation.getStyle() == Style.DOCUMENT) {
                        operationElement = this.body;
                    } else {
                        operationElement = this.body.getChildElement(0);
                        Iterator it = this.body.getChildElements();
                        while (it.hasNext()) {
                            SOAPElement se;
                            String id;
                            Node node = (Node)it.next();
                            if (!(node instanceof SOAPElement) || (id = AttributeUtils.getID((se = (SOAPElement)((Object)node)).getSAXAttributes())) == null) continue;
                            context.getHrefTable().addObjectByID(id, se);
                        }
                    }
                    try {
                        if (isNoDataBinding) {
                            reqRespProcessor.processNoDataBinding(operationElement, context);
                        } else {
                            operationElement.toEvents(context.getEventConverter());
                        }
                    }
                    catch (Exception e) {
                        throw MCUtils.interceptDeserializationException(e, context);
                    }
                    this.updateQName();
                    this.needDeser = false;
                    if (log.isDebugEnabled()) {
                        log.debug("RequestResponse: deserialize() ending");
                    }
                    return;
                }
                catch (SAXException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("RequestResponse: deserialize() deserialize failed with \n" + e.toString());
                    }
                    if (savedException == null) {
                        savedException = e;
                    }
                    this.params.clear();
                    msgContext.setOperation(null);
                    continue;
                }
                finally {
                    context.freeEventConverter();
                }
            }
            if (savedException != null) {
                throw savedException;
            }
            if (!msgContext.isClient()) {
                this.throwResolutionError(this.body, msgContext);
            } else {
                reqRespProcessor.setOperation(this.tryOperations[0]);
                this.operation = this.tryOperations[0];
                this.updateQName();
            }
        } else if (this.legacyTestMode) {
            SOAPElement operationElement;
            reqRespProcessor.setLegacyTestMode(this.legacyTestMode);
            if (this.tryOperations != null && this.tryOperations.length > 0 && this.operation.getStyle() == Style.DOCUMENT) {
                operationElement = this.body;
            } else {
                operationElement = this.body.getChildElement(0);
                Iterator it = this.body.getChildElements();
                while (it.hasNext()) {
                    SOAPElement se;
                    String id;
                    Node node = (Node)it.next();
                    if (!(node instanceof SOAPElement) || (id = AttributeUtils.getID((se = (SOAPElement)((Object)node)).getSAXAttributes())) == null) continue;
                    context.getHrefTable().addObjectByID(id, se);
                }
            }
            try {
                context.createEventConverter(new WrapperProcessor(reqRespProcessor));
                operationElement.toEvents(context.getEventConverter());
            }
            finally {
                context.freeEventConverter();
            }
            this.body.getSOAPFactory().setProtectState(origProtect);
            this.needDeser = false;
            this.inDeserialize = false;
            if (log.isDebugEnabled()) {
                log.debug("RequestResponse: deserialize() ending");
            }
        }
    }

    private void updateQName() {
        if (this.operation != null && !this.isResponse && this.operation.getStyle() == Style.DOCUMENT) {
            this.operationQName = this.operation.getElementQName();
        }
    }

    public ParamValue getParam(String name2) throws SAXException {
        if (this.needDeser && !this.inDeserialize) {
            this.deserialize(this.context);
        }
        for (int i = 0; i < this.params.size(); ++i) {
            ParamValue param = (ParamValue)this.params.elementAt(i);
            if (!param.getName().equals(name2)) continue;
            return param;
        }
        return null;
    }

    public Vector getParams() throws SAXException {
        if (this.needDeser && !this.inDeserialize) {
            this.deserialize(this.context);
        }
        return this.params;
    }

    public void addParam(ParamValue param) {
        if (param != null) {
            this.params.addElement(param);
        }
    }

    public void outputImpl(SerializationContext context) throws Exception {
        OperationDesc od;
        String val;
        boolean hasOperationElement;
        String encodingStyle = this.body.getEncodingStyle();
        MessageContext msgContext = context.getMessageContext();
        boolean bl = hasOperationElement = msgContext == null || msgContext.getOperationStyleString().equals("rpc") || msgContext.getOperationStyleString().equals("wrapped");
        if (hasOperationElement) {
            context.getSerializationWriter().startElement(this.operationQName, NullAttributes.singleton);
        }
        boolean needOutputOrdering = false;
        if (this.isResponse && msgContext != null && msgContext.getOperationStyle() == com.ibm.ws.webservices.engine.enum.Style.WRAPPED && JavaUtils.hasValue(val = (String)(od = msgContext.getOperation()).getOption(JavaGeneratorFactory.OUT_ORDERING_REQUIRED)) && val.equals("true")) {
            needOutputOrdering = true;
        }
        if (!needOutputOrdering) {
            for (int i = 0; i < this.params.size(); ++i) {
                ParamValue param = (ParamValue)this.params.elementAt(i);
                ParameterDesc pd = param.getParamDesc();
                if (pd != null && (!this.isResponse || pd.isOutHeader()) && (this.isResponse || pd.isInHeader())) continue;
                param.serialize(context, this);
            }
        } else {
            ParameterDesc pd;
            int i;
            boolean needPdNull = false;
            boolean needNullOutPos = false;
            int numParams = this.params.size();
            block1: for (i = 0; i < numParams; ++i) {
                for (int j = 0; j < numParams; ++j) {
                    ParamValue param = (ParamValue)this.params.elementAt(j);
                    ParameterDesc pd2 = param.getParamDesc();
                    if (pd2 != null) {
                        String outPos = (String)pd2.getOption(JavaGeneratorFactory.OUT_POSITION);
                        if (JavaUtils.hasValue(outPos) && outPos.equals(String.valueOf(i))) {
                            if (pd2.isOutHeader()) continue block1;
                            param.serialize(context, this);
                            continue block1;
                        }
                        if (JavaUtils.hasValue(outPos)) continue;
                        needNullOutPos = true;
                        continue;
                    }
                    needPdNull = true;
                }
            }
            if (needNullOutPos) {
                for (i = 0; i < numParams; ++i) {
                    String outPos;
                    ParamValue param = (ParamValue)this.params.elementAt(i);
                    pd = param.getParamDesc();
                    if (pd == null || JavaUtils.hasValue(outPos = (String)pd.getOption(JavaGeneratorFactory.OUT_POSITION)) || pd.isOutHeader()) continue;
                    param.serialize(context, this);
                }
            }
            if (needPdNull) {
                for (i = 0; i < numParams; ++i) {
                    ParamValue param = (ParamValue)this.params.elementAt(i);
                    pd = param.getParamDesc();
                    if (pd != null) continue;
                    param.serialize(context, this);
                }
            }
        }
        if (hasOperationElement) {
            context.getSerializationWriter().endElement();
        }
    }

    private void pruneDocLitOperations(Message msg, MessageContext msgContext) throws SAXException {
        if (this.isResponse || this.tryOperations.length <= 1 || this.tryOperations[0].getStyle() != Style.DOCUMENT || this.tryOperations[0].getUse() != Use.LITERAL) {
            return;
        }
        ArrayList<QName> args = new ArrayList<QName>();
        for (Node node = this.body.getFirstChild(); node != null; node = node.getNextSibling()) {
            QName qname;
            if (!(node instanceof SOAPElement) || args.contains(qname = ((SOAPElement)((Object)node)).getQName())) continue;
            args.add(qname);
        }
        ArrayList<OperationDesc> opers = new ArrayList<OperationDesc>();
        for (int i = 0; i < this.tryOperations.length; ++i) {
            OperationDesc oper = this.tryOperations[i];
            boolean valid = true;
            ParameterDesc prev = null;
            for (int j = 0; j < args.size() && valid; ++j) {
                QName qName = (QName)args.get(j);
                ParameterDesc param = oper.getInputParamByQName(qName);
                if (param == null || param.isInHeader()) {
                    valid = false;
                    continue;
                }
                if (prev != null && prev.getOrder() > param.getOrder()) {
                    valid = false;
                    continue;
                }
                prev = param;
            }
            if (valid) {
                int indx;
                for (indx = 0; indx < opers.size() && ((OperationDesc)opers.get(indx)).getNumInParams(true) < oper.getNumInParams(true); ++indx) {
                }
                opers.add(indx, oper);
                if (!log.isDebugEnabled()) continue;
                log.debug("RequestResponse: pruneDocLitOperations() saving for consideration " + oper.getName());
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("RequestResponse: pruneDocLitOperations() removing from consideration " + oper.getName());
        }
        if (opers.size() == 0) {
            this.throwResolutionError(this.body, msgContext);
        }
        if (opers.size() > 1 && ((OperationDesc)opers.get(0)).getNumInParams(true) == ((OperationDesc)opers.get(1)).getNumInParams(true)) {
            ArrayList<QName> ops = new ArrayList<QName>();
            OperationDesc first = (OperationDesc)opers.get(0);
            ops.add(first.getElementQName());
            for (int i = 1; i < opers.size(); ++i) {
                OperationDesc opDesc = (OperationDesc)opers.get(i);
                if (opDesc.getNumInParams(true) != first.getNumInParams(true)) continue;
                ops.add(opDesc.getElementQName());
            }
            this.throwAmbiguousError(args, ops, msgContext);
        }
        this.tryOperations = new OperationDesc[1];
        this.tryOperations[0] = (OperationDesc)opers.get(0);
    }

    private ArrayList getAttachments(Message msg) {
        ArrayList<QName> args = new ArrayList<QName>();
        Iterator attachments = msg.getAttachments();
        while (attachments.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)attachments.next();
            String partName = attachment.getContentIdPartName();
            args.add(new QName("", partName));
        }
        return args;
    }

    public static boolean isNoDataBindingOperation(OperationDesc op) {
        if (op.getUse() != Use.LITERAL) {
            return false;
        }
        if (op.getStyle() != Style.RPC && op.getStyle() != Style.DOCUMENT) {
            return false;
        }
        ParameterDesc pd = op.getReturnParamDesc();
        if (pd == null || pd.getJavaType() == null || !pd.getJavaType().equals(javax.xml.soap.SOAPElement.class) && !pd.getJavaType().equals(Void.TYPE)) {
            return false;
        }
        for (int i = 0; i < op.getNumParams(); ++i) {
            pd = op.getParameter(i);
            if (pd.getJavaType() != null && pd.getJavaType().equals(class$javax$xml$soap$SOAPElement == null ? RequestResponse.class$("javax.xml.soap.SOAPElement") : class$javax$xml$soap$SOAPElement)) continue;
            return false;
        }
        return true;
    }

    public static OperationDesc[] getPossibleOperationsByQName(QName qName, MessageContext msgContext) throws WebServicesFault {
        OperationDesc[] possibleOperations = null;
        SOAPPort _port = msgContext.getPort();
        if (_port == null) {
            try {
                if (qName != null) {
                    msgContext.setPort(msgContext.getEngine().getPortByNamespaceURI(qName.getNamespaceURI()));
                }
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse", "710");
            }
        }
        if (_port != null) {
            _port.getInitializedPortDesc(msgContext);
            PortDesc portDesc = _port.getPortDesc();
            if (portDesc != null) {
                ArrayList allOperations = portDesc.getOperations();
                ArrayList<OperationDesc> documentOperations = null;
                boolean foundNonDocumentOperations = false;
                for (int i = 0; i < allOperations.size(); ++i) {
                    OperationDesc tryOp = (OperationDesc)allOperations.get(i);
                    if (tryOp.getStyle() == Style.DOCUMENT) {
                        if ((qName != null || tryOp.getNumInParams(true) != 0) && (qName == null || tryOp.getParamByQName(qName) == null)) continue;
                        if (documentOperations == null) {
                            documentOperations = new ArrayList<OperationDesc>();
                        }
                        documentOperations.add(tryOp);
                        continue;
                    }
                    foundNonDocumentOperations = true;
                }
                if (foundNonDocumentOperations && qName != null) {
                    possibleOperations = portDesc.getOperationsByQName(qName);
                }
                if (documentOperations != null && documentOperations.size() > 0) {
                    OperationDesc[] possibleDocOperations = new OperationDesc[documentOperations.size()];
                    possibleDocOperations = documentOperations.toArray(possibleDocOperations);
                    if (possibleOperations != null) {
                        OperationDesc od;
                        int i;
                        ArrayList<OperationDesc> total = new ArrayList<OperationDesc>();
                        for (i = 0; i < possibleOperations.length; ++i) {
                            od = possibleOperations[i];
                            if (total.contains(od)) continue;
                            total.add(od);
                        }
                        for (i = 0; i < possibleDocOperations.length; ++i) {
                            od = possibleDocOperations[i];
                            if (total.contains(od)) continue;
                            total.add(od);
                        }
                        possibleOperations = total.toArray(possibleOperations);
                    } else {
                        possibleOperations = possibleDocOperations;
                    }
                }
            }
        }
        return possibleOperations;
    }

    private void throwResolutionError(SOAPBody body, MessageContext msgContext) throws SAXException {
        QName qNameInMsg = null;
        if (body.getNumChildren() > 0) {
            qNameInMsg = body.getChildElement(0).getQName();
        }
        PortDesc portDesc = msgContext != null ? msgContext.getPortDesc() : null;
        String insert1 = qNameInMsg == null ? "<no element in body>" : qNameInMsg.toString();
        String insertDebug = portDesc == null ? "null portDesc" : portDesc.toString();
        String case1Insert = "";
        String case2Insert = "";
        if (portDesc != null) {
            ArrayList allOperations = portDesc.getOperations();
            for (int i = 0; i < allOperations.size(); ++i) {
                OperationDesc tryOp = (OperationDesc)allOperations.get(i);
                if (tryOp.getStyle() != Style.DOCUMENT) {
                    if ((qNameInMsg != null || tryOp.getNumInParams(true) != 0) && (qNameInMsg == null || tryOp.getParamByQName(qNameInMsg) == null)) continue;
                    case1Insert = case1Insert + " " + tryOp.getElementQName();
                    continue;
                }
                if (qNameInMsg == null || !tryOp.getElementQName().getLocalPart().equals(qNameInMsg.getLocalPart())) continue;
                case2Insert = case2Insert + " " + tryOp.getElementQName();
            }
            String insert2 = null;
            String insert3 = null;
            String insert4 = null;
            if (case1Insert.length() > 0 || case2Insert.length() > 0) {
                if (case1Insert.length() > 0) {
                    insert2 = case1Insert;
                    insert3 = "document";
                    insert4 = "rpc or wrapped document";
                } else {
                    insert2 = case2Insert;
                    insert3 = "rpc or wrapped document";
                    insert4 = "document";
                }
                throw new SAXException(new WebServicesFault(QNameTable.createQName(msgContext.getSOAPConstants().getEnvelopeURI(), "Client"), Messages.getMessage("noSuchOperation2", insert1, insert2, insert3, insert4, insertDebug), null, null));
            }
        }
        throw new SAXException(new WebServicesFault(QNameTable.createQName(msgContext.getSOAPConstants().getEnvelopeURI(), "Client"), Messages.getMessage("noSuchOperation", insert1, insertDebug), null, null));
    }

    private void throwAmbiguousError(List args, List possibleOperations, MessageContext msgContext) throws SAXException {
        String insert1 = "";
        for (int i = 0; i < args.size(); ++i) {
            insert1 = insert1 + args.get(i).toString() + " ";
        }
        String insert2 = "";
        for (int i = 0; i < possibleOperations.size(); ++i) {
            insert2 = insert2 + possibleOperations.get(i).toString() + " ";
        }
        PortDesc portDesc = msgContext != null ? msgContext.getPortDesc() : null;
        String insert3 = portDesc == null ? "null portDesc" : portDesc.toString();
        throw new SAXException(Messages.getMessage("ambiguousOperation00", insert1, insert2, insert3));
    }

    public OperationDesc resolveOperation(MessageContext msgContext, Message msg) {
        try {
            return this._resolveOperation(msgContext, msg);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("resolveOperation caught exception : " + e);
            }
            this.tryOperations = null;
            this.operation = null;
            this.operationQName = null;
            return null;
        }
    }

    private OperationDesc _resolveOperation(MessageContext msgContext, Message msg) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("start _resolveOperation");
        }
        if (this.operation != null) {
            if (log.isDebugEnabled()) {
                log.debug("end _resolveOperation: " + this.operation.toString());
            }
            return this.operation;
        }
        if (this.tryOperations == null || this.tryOperations.length == 0) {
            ArrayList attachments;
            this.operationQName = null;
            if (this.body.getNumChildren() > 0) {
                this.operationQName = this.body.getChildElement(0).getQName();
            }
            if (this.operationQName == null && msg != null && (attachments = this.getAttachments(msg)) != null && attachments.size() > 0) {
                this.operationQName = (QName)attachments.get(0);
            }
            try {
                if (log.isDebugEnabled()) {
                    if (this.operationQName == null) {
                        log.debug("call getPossibleOperationsByQName with a null QName");
                    } else {
                        log.debug("call getPossibleOperationsByQName with: " + this.operationQName.toString());
                    }
                }
                this.tryOperations = RequestResponse.getPossibleOperationsByQName(this.operationQName, msgContext);
            }
            catch (WebServicesFault wsf) {
                FFDCFilter.processException(wsf, "com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse", "972");
                if (log.isDebugEnabled()) {
                    log.debug("ERROR with getPossibleOperationsByQName " + wsf.toString());
                    log.debug("end _resolveOperation: null");
                }
                this.tryOperations = null;
                return null;
            }
        }
        if (this.tryOperations == null || this.tryOperations.length == 0) {
            PortDesc portDesc = msgContext.getPortDesc();
            if (portDesc != null) {
                this.throwResolutionError(this.body, msgContext);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("RequestResponse: No OperationDesc and No PortDesc.  This is an UNSUPPORTED.");
                }
                this.legacyTestMode = true;
            }
        }
        if (this.tryOperations != null) {
            if (log.isDebugEnabled()) {
                log.debug("RequestResponse: deserialize() there are " + this.tryOperations.length + " to try before prune.");
            }
            this.pruneDocLitOperations(msg, msgContext);
            if (log.isDebugEnabled()) {
                log.debug("RequestResponse: deserialize() there are " + this.tryOperations.length + " to try after prune.");
            }
        }
        if (this.tryOperations != null && this.tryOperations.length == 1) {
            this.operation = this.tryOperations[0];
            if (log.isDebugEnabled()) {
                log.debug("end _resolveOperation: " + this.operation.toString());
            }
            return this.operation;
        }
        if (log.isDebugEnabled()) {
            log.debug("end _resolveOperation: null");
        }
        return null;
    }
}

