/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.ext;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.TypeMappingImpl;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import org.apache.commons.logging.Log;

public final class ParamValue {
    protected static Log log = LogFactory.getLog(ParamValue.class.getName());
    private transient QName qName;
    private Object value = null;
    private int countSetCalls = 0;
    private ParameterDesc paramDesc;
    private Boolean wantXSIType = null;
    private static Method valueSetMethod;

    public ParamValue(QName qName, Object value2) {
        this.qName = qName;
        this.value = value2;
    }

    public ParamValue(String namespace, String localPart, Object value2) {
        this(QNameTable.createQName(namespace, localPart), value2);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value2) {
        this.value = value2;
    }

    public void set(Object newValue) {
        boolean expectComponents;
        ++this.countSetCalls;
        boolean bl = expectComponents = this.paramDesc != null && !this.paramDesc.isMaxOccursIs1();
        if (expectComponents) {
            if (this.countSetCalls == 1) {
                this.value = new ArrayList();
            }
            ((ArrayList)this.value).add(newValue);
            return;
        }
        if (this.countSetCalls == 1) {
            this.value = newValue;
            return;
        }
        if (this.countSetCalls == 2) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.value);
            this.value = list;
        }
        ((ArrayList)this.value).add(newValue);
    }

    public String getName() {
        return this.qName.getLocalPart();
    }

    public QName getQName() {
        return this.qName;
    }

    public static Method getValueSetMethod() {
        return valueSetMethod;
    }

    public ParameterDesc getParamDesc() {
        return this.paramDesc;
    }

    public void setParamDesc(ParameterDesc paramDesc) {
        this.paramDesc = paramDesc;
    }

    public void setXSITypeGeneration(Boolean value2) {
        this.wantXSIType = value2;
    }

    public Boolean getXSITypeGeneration() {
        return this.wantXSIType;
    }

    public void serialize(SerializationContext context) throws IOException {
        Object serializeValue = this.value;
        if (serializeValue != null && serializeValue instanceof ArrayList) {
            serializeValue = ((ArrayList)serializeValue).toArray();
        }
        if (this.value != null && this.value instanceof Holder) {
            try {
                serializeValue = JavaUtils.getHolderValue(this.value);
            }
            catch (JavaUtils.HolderException he) {
                FFDCFilter.processException((Throwable)he, "com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue.serialize", "301", this);
                throw new IOException(he.toString());
            }
        }
        Class<?> javaType = serializeValue == null ? null : serializeValue.getClass();
        boolean maxOccurs1 = true;
        boolean minOccurs0 = false;
        if (this.paramDesc != null) {
            minOccurs0 = this.paramDesc.isMinOccursIs0();
            if (serializeValue != null && !(maxOccurs1 = this.paramDesc.isMaxOccursIs1()) && javaType != null && javaType.getComponentType() == null) {
                maxOccurs1 = true;
            }
        }
        if (maxOccurs1) {
            this.serializeItem(context, serializeValue, false, !minOccurs0);
        } else {
            for (int i = 0; i < Array.getLength(serializeValue); ++i) {
                this.serializeItem(context, Array.get(serializeValue, i), true, true);
            }
        }
    }

    private void serializeItem(SerializationContext context, Object serializeValue, boolean isComponent, boolean useXSINil) throws IOException {
        Class javaType = serializeValue == null ? null : serializeValue.getClass();
        QName xmlType = null;
        if (this.paramDesc != null) {
            xmlType = this.paramDesc.getTypeQName();
            Class<?> expectedJavaType = this.paramDesc.getJavaType();
            if (isComponent) {
                expectedJavaType = expectedJavaType.getComponentType();
            }
            if (javaType == null) {
                javaType = expectedJavaType;
            } else if (!javaType.equals(expectedJavaType)) {
                Class primitiveCls = JavaUtils.getPrimitiveClass(javaType);
                if (primitiveCls != null) {
                    javaType = primitiveCls;
                }
                if (!javaType.equals(expectedJavaType)) {
                    QName xmlTypeIn = xmlType;
                    if (Constants.equals(xmlType, Constants.XSD_ANYTYPE)) {
                        xmlType = null;
                    }
                    QName qName = ((TypeMappingImpl)context.getTypeMapping()).getXMLType(javaType, xmlType);
                    if (xmlTypeIn != null && !xmlTypeIn.equals(qName)) {
                        this.wantXSIType = Boolean.TRUE;
                    }
                }
            }
        }
        context.serialize(this.qName, null, serializeValue, xmlType, javaType, useXSINil, this.wantXSIType, null);
    }

    public void serialize(SerializationContext context, RequestResponse rr) throws IOException {
        Object serializeValue = this.value;
        if (serializeValue != null && serializeValue instanceof ArrayList) {
            serializeValue = ((ArrayList)serializeValue).toArray();
        }
        if (this.value != null && this.value instanceof Holder) {
            try {
                serializeValue = JavaUtils.getHolderValue(this.value);
            }
            catch (JavaUtils.HolderException he) {
                FFDCFilter.processException((Throwable)he, "com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue.serialize", "301", this);
                throw new IOException(he.toString());
            }
        }
        Class<?> javaType = serializeValue == null ? null : serializeValue.getClass();
        boolean maxOccurs1 = true;
        boolean minOccurs0 = false;
        if (this.paramDesc != null) {
            minOccurs0 = this.paramDesc.isMinOccursIs0();
            if (serializeValue != null && !(maxOccurs1 = this.paramDesc.isMaxOccursIs1()) && javaType != null && javaType.getComponentType() == null) {
                maxOccurs1 = true;
            }
        }
        if (maxOccurs1) {
            this.serializeItem(context, serializeValue, false, !minOccurs0, rr);
        } else {
            for (int i = 0; i < Array.getLength(serializeValue); ++i) {
                this.serializeItem(context, Array.get(serializeValue, i), true, true, rr);
            }
        }
    }

    private void serializeItem(SerializationContext context, Object serializeValue, boolean isComponent, boolean useXSINil, RequestResponse rr) throws IOException {
        Class javaType = serializeValue == null ? null : serializeValue.getClass();
        QName xmlType = null;
        if (this.paramDesc != null) {
            xmlType = this.paramDesc.getTypeQName();
            Class<?> expectedJavaType = this.paramDesc.getJavaType();
            if (isComponent) {
                expectedJavaType = expectedJavaType.getComponentType();
            }
            if (javaType == null) {
                javaType = expectedJavaType;
            } else if (!javaType.equals(expectedJavaType)) {
                Class primitiveCls = JavaUtils.getPrimitiveClass(javaType);
                if (primitiveCls != null) {
                    javaType = primitiveCls;
                }
                if (!javaType.equals(expectedJavaType)) {
                    QName xmlTypeIn = xmlType;
                    if (Constants.equals(xmlType, Constants.XSD_ANYTYPE)) {
                        xmlType = null;
                    }
                    QName qName = ((TypeMappingImpl)context.getTypeMapping()).getXMLType(javaType, xmlType);
                    if (xmlTypeIn != null && !xmlTypeIn.equals(qName)) {
                        this.wantXSIType = Boolean.TRUE;
                    }
                }
            }
        }
        context.serialize(this.qName, null, serializeValue, xmlType, javaType, useXSINil, this.wantXSIType, null, rr);
    }

    static {
        Class cls = ParamValue.class;
        try {
            valueSetMethod = cls.getMethod("set", Object.class);
        }
        catch (NoSuchMethodException e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue", "122");
            log.error(Messages.getMessage("noValue00", "" + e));
            System.exit(-1);
        }
    }
}

