/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPDocument;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPHeaderBuilder;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPEnvelopeBuilder
extends SOAPBuilder {
    private boolean gotHeader = false;
    private boolean gotBody = false;
    private boolean errorChecking = false;

    public SOAPEnvelopeBuilder(SOAPEnvelope envelope) {
        this.myElement = envelope;
        SOAPDocument doc = (SOAPDocument)this.myElement.getOwnerDocument();
        this.errorChecking = doc.getErrorChecking();
        doc.setErrorChecking(false);
    }

    public SOAPEnvelope getEnvelope() {
        return (SOAPEnvelope)this.myElement;
    }

    public void startElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        SOAPConstants soapConstants;
        SOAPEnvelope envelope = (SOAPEnvelope)this.myElement;
        if (envelope.getSOAPFactory().getSOAPConstants().getSOAPProtocol().equals("Dynamic Protocol")) {
            SOAPConstants factorySOAPConstants = envelope.getSOAPFactory().getSOAPConstants();
            if (SOAPConstants.SOAP11_CONSTANTS.getEnvelopeURI().equals(namespace)) {
                factorySOAPConstants = SOAPConstants.SOAP11_CONSTANTS;
            } else if (SOAPConstants.SOAP12_CONSTANTS.getEnvelopeURI().equals(namespace)) {
                factorySOAPConstants = SOAPConstants.SOAP12_CONSTANTS;
            }
            envelope.getSOAPFactory().setSOAPConstants(factorySOAPConstants);
            if (!envelope.getNamespaceURI().equals(namespace)) {
                envelope.setQName(namespace, prefixedName);
                try {
                    SOAPBody body;
                    SOAPHeader header2 = envelope.getHeader();
                    if (header2 != null) {
                        header2.detachNode();
                        envelope.addHeader();
                    }
                    if ((body = envelope.getBody()) != null) {
                        body.detachNode();
                        envelope.addBody();
                    }
                }
                catch (SOAPException se) {
                    throw new SAXException((Exception)((Object)se));
                }
            }
        }
        if (!localName.equals("Envelope")) {
            throw new SAXException(Messages.getMessage("badTag00", localName));
        }
        if (namespace.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            soapConstants = SOAPConstants.SOAP11_CONSTANTS;
        } else if (namespace.equals("http://www.w3.org/2003/05/soap-envelope")) {
            soapConstants = SOAPConstants.SOAP12_CONSTANTS;
        } else {
            String msg = Messages.getMessage("badNamespace00", namespace);
            WebServicesFault fault2 = new WebServicesFault(QNameTable.createQName(envelope.getSOAPFactory().getSOAPConstants().getEnvelopeURI(), "VersionMismatch"), msg, null, null);
            throw new SAXException(msg, fault2);
        }
        if (context.getMessageContext() != null) {
            context.getMessageContext().setSOAPConstants(soapConstants);
        }
        envelope.setMappingScope(mappingScope);
        String prefix = "";
        int idx = prefixedName.indexOf(58);
        if (idx > 0) {
            prefix = prefixedName.substring(0, idx);
        }
        envelope.setPrefix(prefix);
        envelope.getSOAPFactory().setSOAPConstants(soapConstants);
    }

    public DEventProcessor onStartChild(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        try {
            SOAPBuilder builder = null;
            QName thisQName = QNameTable.createQName(namespace, localName);
            if (thisQName.equals(this.myElement.getSOAPFactory().getSOAPConstants().getHeaderQName())) {
                if (this.gotHeader) {
                    throw new SAXException(Messages.getMessage("only1Header00"));
                }
                this.gotHeader = true;
                builder = new SOAPHeaderBuilder();
                this.myChildElement = this.myElement.getSOAPFactory().createSOAPHeader(prefixedName, attributes, mappingScope, context, (SOAPEnvelope)this.myElement);
                builder.setMyElement(this.myChildElement);
                return builder;
            }
            if (thisQName.equals(this.myElement.getSOAPFactory().getSOAPConstants().getBodyQName())) {
                if (this.gotBody) {
                    throw new SAXException(Messages.getMessage("only1Body00"));
                }
                this.gotBody = true;
                builder = new SOAPBodyBuilder();
                this.myChildElement = this.myElement.getSOAPFactory().createSOAPBody(prefixedName, attributes, mappingScope, context, (SOAPEnvelope)this.myElement);
                builder.setMyElement(this.myChildElement);
                return builder;
            }
            throw new SAXException(Messages.getMessage("noCustomElems00"));
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPEnvelopeBuilder.onStartChild", "230", this);
            throw new SAXException((Exception)((Object)se));
        }
    }

    public void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        try {
            block5: {
                try {
                    if (!this.gotHeader && ((SOAPEnvelope)this.myElement).getHeader() != null) {
                        ((SOAPEnvelope)this.myElement).getHeader().detachNode();
                    }
                    if (this.gotBody || ((SOAPEnvelope)this.myElement).getBody() == null) break block5;
                    ((SOAPEnvelope)this.myElement).getBody().detachNode();
                }
                catch (SOAPException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPEnvelopeBuilder.endElement", "260", this);
                    throw new SAXException((Exception)((Object)e));
                }
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            SOAPDocument doc = (SOAPDocument)this.myElement.getOwnerDocument();
            doc.setErrorChecking(this.errorChecking);
            throw throwable;
        }
        SOAPDocument doc = (SOAPDocument)this.myElement.getOwnerDocument();
        doc.setErrorChecking(this.errorChecking);
    }

    public void characters(String value2) throws SAXException {
        if (!XMLUtils.isXMLWhitespace(value2)) {
            throw new SAXException(Messages.getMessage("nonWSDetected00", value2, this.myElement.getQName().toString()));
        }
        super.characters(value2);
    }
}

