/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.types;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.types.NonNegativeInteger;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public class PositiveInteger
extends NonNegativeInteger
implements Serializable {
    private BigInteger iMinInclusive = new BigInteger("1");

    public PositiveInteger(byte[] val) {
        super(val);
        this.checkValidity();
    }

    public PositiveInteger(int signum, byte[] magnitude) {
        super(signum, magnitude);
        this.checkValidity();
    }

    public PositiveInteger(int bitLength, int certainty, Random rnd) {
        super(bitLength, certainty, rnd);
        this.checkValidity();
    }

    public PositiveInteger(int numBits, Random rnd) {
        super(numBits, rnd);
        this.checkValidity();
    }

    public PositiveInteger(String val) {
        super(val);
        this.checkValidity();
    }

    public PositiveInteger(String val, int radix) {
        super(val, radix);
        this.checkValidity();
    }

    private void checkValidity() {
        if (this.compareTo(this.iMinInclusive) < 0) {
            throw new NumberFormatException(Messages.getMessage("badposInt00", this.toString()));
        }
    }
}

