/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.Config;
import com.ibm.ws.webservices.engine.transport.ConfigProvider;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.security.ConfigSSL;
import com.ibm.ws.webservices.engine.transport.security.JSSEConfigSSL;
import com.ibm.ws.webservices.engine.transport.security.WASConfigSSL;
import com.ibm.ws.webservices.engine.transport.security.WSConfigSSLChangeListener;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class ConfigSSLProvider
implements ConfigProvider {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(ConfigSSLProvider.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static JSSEHelper _jhlpr = null;
    private static ConfigSSLProvider cfgPvdr = null;
    private static Hashtable sslConfigTable = null;
    private static HashMap connInfoTable = null;

    private ConfigSSLProvider() {
    }

    public static final synchronized ConfigSSLProvider getInstance() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ConfigSSLProvider.getInstance()");
        }
        if (cfgPvdr == null) {
            _jhlpr = JSSEHelper.getInstance();
            cfgPvdr = new ConfigSSLProvider();
            sslConfigTable = new Hashtable();
            connInfoTable = new HashMap();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ConfigSSLProvider.getInstance()");
        }
        return cfgPvdr;
    }

    public Config getConfig(MessageContext mc, WSAddress addr) throws WebServicesFault {
        ConfigSSL retConfig = null;
        Object key = null;
        Properties currProps = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ConfigSSLProvider.getConfig()");
        }
        try {
            boolean programmaticSet = false;
            boolean aliasBased = false;
            String sslAliasName = null;
            String certAliasName = null;
            WSConfigSSLChangeListener slistener = new WSConfigSSLChangeListener();
            currProps = _jhlpr.getSSLPropertiesOnThread();
            if (currProps != null) {
                programmaticSet = true;
                currProps = _jhlpr.getProperties(null, null, slistener);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("sslPropertiesProgramSet", currProps.toString(), slistener.toString()));
                }
                retConfig = new WASConfigSSL();
            } else if (!programmaticSet) {
                try {
                    sslAliasName = ((DefaultHTTPSTransportClientProperties)TransportClientPropertiesFactory.create(addr.getSchemaInString())).getSSLConfigurationName();
                    certAliasName = ((DefaultHTTPSTransportClientProperties)TransportClientPropertiesFactory.create(addr.getSchemaInString())).getSSLCertificateAliasName();
                }
                catch (ClassCastException cEx) {
                    FFDCFilter.processException((Throwable)cEx, "com.ibm.ws.webservices.engine.transport.security.getConfigSSL", "%C", this);
                    sslAliasName = null;
                    certAliasName = null;
                    throw WebServicesFault.makeFault(cEx);
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("sslConfigFromContext", sslAliasName == null ? "" : sslAliasName, certAliasName == null ? "" : certAliasName));
                }
                if ((currProps = _jhlpr.getProperties(sslAliasName, this.getConnInfo(addr), slistener)) == null) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("sslConfigResolveFailed00"));
                    }
                    if ((currProps = _jhlpr.getProperties("DefaultSystemProperties", this.getConnInfo(addr), slistener)) == null) {
                        throw new WebServicesFault(Messages.getMessage("sslConfigResolveFailed01", addr.toString()));
                    }
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("sslPropertiesFromJSSEHelper", currProps.toString(), slistener.toString()));
                }
                if (currProps.getProperty("com.ibm.ssl.alias").equalsIgnoreCase("DefaultSystemProperties")) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("invokeMethod00", "JSSEConfigSSL", JSSEConfigSSL.class.getName()));
                    }
                    retConfig = new JSSEConfigSSL();
                } else {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("invokeMethod00", "WASConfigSSL", WASConfigSSL.class.getName()));
                    }
                    retConfig = new WASConfigSSL();
                    String aNameConfigured = sslAliasName;
                    int lastslash = aNameConfigured.lastIndexOf("/");
                    if (lastslash != -1) {
                        aNameConfigured = aNameConfigured.substring(lastslash + 1);
                    }
                    String aNameFromHelper = currProps.getProperty("com.ibm.ssl.alias");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The absolute name for configured SSL Configuration alias is: " + aNameConfigured);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The SSL alias name from JSSEHelper properties is: " + aNameFromHelper);
                    }
                    if (aNameFromHelper.equalsIgnoreCase(aNameConfigured)) {
                        aliasBased = true;
                    }
                }
            }
            retConfig.putAll((Map)currProps);
            retConfig.setlistener(slistener);
            if (programmaticSet) {
                retConfig.setPreConfig(currProps);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Saved previous programmatic SSL configuration: " + currProps.toString());
                }
            } else {
                retConfig.setPreConfig(null);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "No previous programmatic SSL configuration to be saved.");
                }
            }
            if (JavaUtils.hasValue(certAliasName) && !programmaticSet && aliasBased) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Setting com.ibm.ssl.keyStoreClientAlias = " + certAliasName);
                }
                retConfig.setProperty("com.ibm.ssl.keyStoreClientAlias", certAliasName);
            }
            if (JavaUtils.hasValue(sslAliasName) && !programmaticSet && aliasBased) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Setting alias = " + sslAliasName);
                }
                retConfig.setProperty("alias", sslAliasName);
            }
            _jhlpr.setSSLPropertiesOnThread(retConfig);
        }
        catch (SSLException sE) {
            FFDCFilter.processException((Throwable)sE, "com.ibm.ws.webservices.engine.transport.security.getConfigSSL", "%C", this);
            WebServicesFault.makeFault(sE);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ConfigSSLProvider.getConfig()");
        }
        return retConfig;
    }

    private HashMap getConnInfo(WSAddress addr) {
        String targetKey = "outbound" + addr.getSchemaInString() + addr.getHostname() + String.valueOf(addr.getPort());
        HashMap<String, String> retHmap = (HashMap<String, String>)connInfoTable.get(targetKey);
        if (retHmap == null) {
            retHmap = new HashMap<String, String>();
            retHmap.put("com.ibm.ssl.direction", "outbound");
            if (addr.getSchema() == 1 || addr.getSchema() == 2) {
                retHmap.put("com.ibm.ssl.endPointName", "WEBSERVICES_HTTP");
            } else {
                retHmap.put("com.ibm.ssl.endPointName", addr.getSchemaInString());
            }
            retHmap.put("com.ibm.ssl.remoteHost", addr.getHostname());
            retHmap.put("com.ibm.ssl.remotePort", String.valueOf(addr.getPort()));
            connInfoTable.put(targetKey, retHmap);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, Messages.getMessage("sslConnectionInfo", retHmap.toString()));
        }
        return retHmap;
    }
}

