/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperIBM;
import com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperSPEC;
import java.net.URL;

public class JMSSender
extends BasicHandler {
    private static final TraceComponent _tc = Tr.register(JMSSender.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");
    private JMSSenderHelperIBM ibmSender = null;
    private JMSSenderHelperSPEC specSender = null;

    public JMSSender() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSender ctor");
        }
        this.ibmSender = new JMSSenderHelperIBM();
        this.specSender = new JMSSenderHelperSPEC();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSSender ctor");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext msgContext) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invoke");
        }
        try {
            try {
                URL targetURL = msgContext.getTargetEndpointAddressAsURL();
                if (targetURL == null) {
                    throw new WebServicesFault(Messages.getMessage("JMS.noEndpoint"));
                }
                if (targetURL.toString().startsWith("jms:jndi")) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "SPEC protocol Target URL string is [" + targetURL.toString() + "]");
                    }
                    this.specSender.invoke(msgContext);
                } else {
                    if (!targetURL.toString().startsWith("jms")) throw new WebServicesFault(Messages.getMessage("JMS.wrongEndpoint"));
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "IBM protocol Target URL string is [" + targetURL.toString() + "]");
                    }
                    this.ibmSender.invoke(msgContext);
                }
                Object var5_5 = null;
                if (!_tc.isEntryEnabled()) return;
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.invoke", "178", this);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.invoke", "183", this);
                WebServicesFault wsf = WebServicesFault.makeFault(e);
                throw wsf;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "invoke");
            throw throwable;
        }
        Tr.exit(_tc, "invoke");
    }

    public void _init() {
        super._init();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMSSender._init() " + this.toString());
        }
    }

    public void _destroy() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMSSender._destroy() " + this.toString());
        }
        try {
            if (this.ibmSender != null) {
                this.ibmSender._destroy();
            }
            if (this.specSender != null) {
                this.specSender._destroy();
            }
        }
        catch (WebServicesFault e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSender._destroy", "1436", this);
        }
        super._destroy();
    }
}

