/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.WebServicesService;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.ModuleData;
import com.ibm.ws.webservices.deploy.PublishWSDLInfo;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.security.servlet.ServletSecurityProvider;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPSender;
import com.ibm.ws.webservices.engine.transport.http.ServletEndpointContextImpl;
import com.ibm.ws.webservices.engine.transport.http.WebServicesHttpSession;
import com.ibm.ws.webservices.engine.transport.http.WebServicesServletBase;
import com.ibm.ws.webservices.engine.transport.jms.JMSSender;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.management.Endpoint;
import com.ibm.ws.webservices.management.EndpointManagerMBeanImpl;
import com.ibm.ws.webservices.metadata.ServerModuleMetaData;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.ws.webservices.trace.UserExceptionTrace;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.wsdl.WSDLException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class WebServicesServlet
extends WebServicesServletBase
implements MessageContext.OneWayListener {
    protected static Log log;
    public static boolean enableHTTPPrefix;
    public static final String INIT_PROPERTY_TRANSPORT_NAME = "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY = "use-servlet-security";
    public static final String INIT_PROPERTY_JWS_CLASS_DIR = "webservices.jws.servletClassDir";
    public static final String DOUBLE_QUOTES = "\"";
    private static boolean isResponseCacheable;
    private EndpointManagerMBeanImpl endptMgrMBean = null;
    private boolean checkedForMBean = false;
    private String transportName;
    private ServletSecurityProvider securityProvider = null;
    private static boolean isDebug;
    private String jwsClassDir = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$WebServicesService;

    protected String getJWSClassDir() {
        return this.jwsClassDir;
    }

    public static boolean getCacheableStatus() {
        return isResponseCacheable;
    }

    public void init() throws ServletException {
        super.init();
        ServletContext context = this.getServletConfig().getServletContext();
        isDebug = log.isDebugEnabled();
        if (isDebug) {
            log.debug("In servlet init");
        }
        this.transportName = this.getOption(context, INIT_PROPERTY_TRANSPORT_NAME, "http");
        if (JavaUtils.isTrueExplicitly(this.getOption(context, INIT_PROPERTY_USE_SECURITY, null))) {
            this.securityProvider = new ServletSecurityProvider();
        }
        this.jwsClassDir = this.getOption(context, INIT_PROPERTY_JWS_CLASS_DIR, null);
        if (this.jwsClassDir != null) {
            if (this.getHomeDir() != null) {
                this.jwsClassDir = this.getHomeDir() + this.jwsClassDir;
            }
        } else {
            this.jwsClassDir = this.getDefaultJWSClassDir();
        }
        this.setEndptMgrMBean();
    }

    private void processWsdlRequest(HttpServletRequest request, HttpServletResponse response, PrintWriter writer, String portName, boolean forExtWSDL) throws WebServicesFault {
        block34: {
            String infSlashWsdl = "INF" + File.separator + "wsdl" + File.separator;
            boolean empty = false;
            String servletPath = request.getServletPath();
            String pathInfo = request.getPathInfo();
            try {
                SOAPPort port2 = this.getEngine().getPort(portName);
                if (port2 != null) {
                    String wsdlFileRelativePath = "";
                    String wsdlFilePath = port2.getPortDesc().getWSDLFile();
                    int relativePathStart = wsdlFilePath.lastIndexOf(infSlashWsdl);
                    wsdlFileRelativePath = relativePathStart > 0 ? wsdlFilePath.substring(relativePathStart + infSlashWsdl.length()) : wsdlFilePath.substring(wsdlFilePath.lastIndexOf(File.separator) + 1);
                    try {
                        if (pathInfo == null || pathInfo.equals("") || pathInfo.equals("/")) {
                            String requestString = request.getRequestURL().toString();
                            if (!requestString.endsWith("/")) {
                                requestString = requestString + "/";
                            }
                            requestString = requestString.endsWith("wsdl/") || requestString.endsWith("extwsdl/") ? requestString + wsdlFileRelativePath : (forExtWSDL ? requestString + "extwsdl/" : requestString + "wsdl/") + wsdlFileRelativePath;
                            response.sendRedirect(requestString);
                            wsdlFilePath = null;
                        } else {
                            relativePathStart = wsdlFilePath.lastIndexOf(infSlashWsdl);
                            wsdlFilePath = relativePathStart > 0 ? wsdlFilePath.substring(0, relativePathStart + infSlashWsdl.length()) : wsdlFilePath.substring(0, wsdlFilePath.lastIndexOf(File.separator) + 1);
                            if (pathInfo.startsWith("/")) {
                                pathInfo = pathInfo.substring(1);
                            }
                            wsdlFilePath = wsdlFilePath + pathInfo;
                        }
                        if (wsdlFilePath == null) break block34;
                        wsdlFilePath = wsdlFilePath.replace('\\', '/');
                        wsdlFilePath = wsdlFilePath.replace('/', File.separatorChar);
                        Document doc = null;
                        PublishWSDLInfo wsdlInfo = null;
                        try {
                            block35: {
                                Map moduleDatas = (Map)this.getEngine().getConfiguration().getGlobalOptions().get(DeployUtils.APPLICATION_MODULE_DATA);
                                String contextRoot = request.getContextPath();
                                if (contextRoot != null && contextRoot.length() == 0) {
                                    empty = true;
                                }
                                if (enableHTTPPrefix) {
                                    ModuleData moduleData = (ModuleData)moduleDatas.get(contextRoot);
                                    if (moduleData == null) {
                                        String moduleMsg = "getUpdatedWSDLFile: moduleData null";
                                        throw new WSDLException("INVALID_WSDL", moduleMsg);
                                    }
                                    String httpPrefixStr = moduleData.getDefaultPrefix();
                                    try {
                                        URL httpPrefixStrURL = new URL(httpPrefixStr);
                                        String scheme = httpPrefixStrURL.getProtocol();
                                        String host = httpPrefixStrURL.getHost();
                                        String portStr = httpPrefixStrURL.getPath();
                                        int portNo = httpPrefixStrURL.getPort();
                                        if (portNo != -1) {
                                            portStr = Integer.toString(portNo).concat(portStr);
                                        }
                                        if (host.length() == 0 && portStr.length() == 0 || host.indexOf(".") == -1) {
                                            wsdlInfo = DeployUtils.getUpdatedWSDLFile(moduleDatas, wsdlFilePath, request.getScheme(), request.getServerName(), Integer.toString(request.getServerPort()), contextRoot, portName, forExtWSDL);
                                            break block35;
                                        }
                                        wsdlInfo = DeployUtils.getUpdatedWSDLFile(moduleDatas, wsdlFilePath, scheme, host, portStr, contextRoot, portName, forExtWSDL);
                                    }
                                    catch (MalformedURLException me) {
                                        if (log.isDebugEnabled()) {
                                            log.debug("The custom HTTPPrefix value is invalid.  ?WSDL will return to default behavior.");
                                        }
                                        wsdlInfo = DeployUtils.getUpdatedWSDLFile(moduleDatas, wsdlFilePath, request.getScheme(), request.getServerName(), Integer.toString(request.getServerPort()), contextRoot, portName, forExtWSDL);
                                    }
                                } else if (!enableHTTPPrefix) {
                                    wsdlInfo = DeployUtils.getUpdatedWSDLFile(moduleDatas, wsdlFilePath, request.getScheme(), request.getServerName(), Integer.toString(request.getServerPort()), contextRoot, portName, forExtWSDL);
                                }
                            }
                            doc = wsdlInfo.getWSDLDoc();
                        }
                        catch (WSDLException e1) {
                            if (!empty) {
                                FFDCFilter.processException((Throwable)e1, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", "1:383:1.68", this);
                            }
                            if (isDebug) {
                                if (empty) {
                                    log.debug("Context root is an empty string");
                                } else {
                                    log.debug("wsdl exception caught while getting wsdl", e1);
                                }
                            }
                            try {
                                doc = XMLUtils.newDocument(wsdlFilePath);
                            }
                            catch (Exception e2) {
                                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", "1:407:1.70", this);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (doc != null) {
                            if (!forExtWSDL && wsdlInfo != null && wsdlInfo.hasService() && !wsdlInfo.hasSOAPPorts()) {
                                this.reportNoSOAPPorts(response, writer);
                                doc = null;
                            } else {
                                response.setContentType("text/xml");
                                XMLUtils.DocumentToWriter(doc, writer);
                            }
                            break block34;
                        }
                        this.reportNoWSDL(response, writer);
                    }
                    catch (IOException ex) {
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", "1:437:1.70", this);
                        log.error(Messages.getMessage("exception00"), ex);
                        try {
                            response.sendError(500);
                            break block34;
                        }
                        catch (IOException ioe) {
                            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", "1:447:1.70", this);
                            log.error(Messages.getMessage("exception00"), ioe);
                        }
                    }
                    break block34;
                }
                this.reportNoWSDL(response, writer);
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", "1:460:1.70", this);
                if (webServicesFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                    this.reportNoWSDL(response, writer);
                }
                throw webServicesFault;
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, FileNotFoundException {
        if (isDebug) {
            log.debug("Enter: doGet()");
        }
        PrintWriter writer = null;
        try {
            block25: {
                try {
                    ServerEngine engine2 = this.getEngine();
                    ServletContext servletContext = this.getServletConfig().getServletContext();
                    String pathInfo = request.getPathInfo();
                    String servletPath = request.getServletPath();
                    String realpath = servletContext.getRealPath(request.getServletPath());
                    if (realpath == null) {
                        realpath = servletPath;
                    }
                    boolean forWSDL = false;
                    boolean forExtWSDL = false;
                    if (request.getRequestURI().endsWith(".jws")) {
                        pathInfo = request.getServletPath();
                    }
                    String queryString = request.getQueryString();
                    String portName = servletPath.substring(1);
                    if (queryString != null) {
                        if (queryString.equalsIgnoreCase("wsdl")) {
                            forWSDL = true;
                        } else if (queryString.equalsIgnoreCase("extwsdl")) {
                            forExtWSDL = true;
                        }
                    } else if (servletPath.endsWith("/wsdl") || servletPath.endsWith("/wsdl/")) {
                        forWSDL = true;
                        portName = portName.substring(0, portName.lastIndexOf("/wsdl"));
                    } else if (servletPath.endsWith("/extwsdl") || servletPath.endsWith("/extwsdl/")) {
                        forExtWSDL = true;
                        portName = portName.substring(0, portName.lastIndexOf("/extwsdl"));
                    }
                    if (this.endptMgrMBean == null && !this.checkedForMBean) {
                        this.setEndptMgrMBean();
                        this.checkedForMBean = true;
                    }
                    if (this.endptMgrMBean != null) {
                        Endpoint endpoint = this.endptMgrMBean.getEndpointListenerWithUrlPattern("/" + portName);
                        if (endpoint != null) {
                            if (endpoint.getState() == 3) {
                                throw new FileNotFoundException(Messages.getMessage("endpointStopped00", "/" + portName));
                            }
                        } else {
                            log.warn(Messages.getMessage("endpointNotFound00", "/" + portName));
                        }
                    }
                    writer = response.getWriter();
                    if (forWSDL || forExtWSDL) {
                        this.processWsdlRequest(request, response, writer, portName, forExtWSDL);
                        break block25;
                    }
                    this.reportAvailableServices(response, writer, request, portName);
                }
                catch (FileNotFoundException ex) {
                    log.error(Messages.getMessage("exception00"), ex);
                    response.setStatus(404);
                    throw ex;
                }
            }
            Object var15_15 = null;
            if (writer != null) {
                writer.close();
            }
            if (isDebug) {
                log.debug("Exit: doGet()");
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (writer != null) {
                writer.close();
            }
            if (isDebug) {
                log.debug("Exit: doGet()");
            }
            throw throwable;
        }
    }

    protected void reportNoWSDL(HttpServletResponse res, PrintWriter writer) {
        res.setStatus(404);
        res.setContentType("text/html");
        writer.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        writer.println("<p>" + Messages.getMessage("noWSDL00") + "</p>");
    }

    protected void reportNoSOAPPorts(HttpServletResponse res, PrintWriter writer) {
        res.setStatus(200);
        res.setContentType("text/html");
        writer.println("<h2>" + Messages.getMessage("noSoapPorts00") + "</h2>");
    }

    protected void reportAvailableServices(HttpServletResponse response, PrintWriter writer, HttpServletRequest request, String portName) throws ConfigurationException, WebServicesFault {
        ServerEngine engine2 = this.getEngine();
        response.setContentType("text/html");
        SOAPPort sp = engine2.getPort(portName);
        if (sp != null) {
            writer.println("<h2>" + sp.getPortDesc().getWSDLPort() + "</h2>");
            writer.println("<h3>" + Messages.getMessage("webServicesService00") + "</h3>");
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, FileNotFoundException {
        Message responseMsg;
        MessageContext msgContext;
        block72: {
            String soapAction = null;
            msgContext = null;
            if (isDebug) {
                log.debug("Enter: doPost()");
            }
            responseMsg = null;
            ServerEngine engine2 = null;
            try {
                engine2 = this.getEngine();
            }
            catch (WebServicesFault wsf) {
                FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", "1:640:1.70", this);
                ServletException se = new ServletException(Messages.getMessage("noEngine00"), wsf);
                if (isDebug) {
                    log.debug("No Engine Found..possibly startup errors occurred!", wsf);
                }
                throw se;
            }
            if (engine2 == null) {
                ServletException se = new ServletException(Messages.getMessage("noEngine00"));
                if (isDebug) {
                    log.debug("No Engine Found!", se);
                }
                throw se;
            }
            try {
                if (this.endptMgrMBean == null && !this.checkedForMBean) {
                    this.setEndptMgrMBean();
                    this.checkedForMBean = true;
                }
                if (this.endptMgrMBean != null) {
                    Endpoint endpoint = this.endptMgrMBean.getEndpointListenerWithUrlPattern(req.getServletPath());
                    if (endpoint != null) {
                        if (endpoint.getState() == 3) {
                            throw new FileNotFoundException(Messages.getMessage("endpointStopped00", req.getServletPath()));
                        }
                    } else {
                        log.warn(Messages.getMessage("endpointNotFound00", req.getServletPath()));
                    }
                }
            }
            catch (FileNotFoundException ex) {
                log.error(Messages.getMessage("exception00"), ex);
                res.setStatus(404);
                throw ex;
            }
            try {
                String url;
                res.setBufferSize(8192);
                msgContext = this.createMessageContext(engine2, req, res);
                if (this.securityProvider != null) {
                    if (isDebug) {
                        log.debug("securityProvider:" + this.securityProvider);
                    }
                    msgContext.setProperty("securityProvider", this.securityProvider);
                }
                if ((url = req.getRequestURL().toString()) != null && url.length() > 0) {
                    msgContext.setProperty("inbound.url", url);
                    if (isDebug) {
                        log.debug("Set inbound.url property on MessageContext to: " + url);
                    }
                }
                InputStream reqIs = req.getInputStream();
                byte[] reqBa = null;
                boolean isTraceEnabled = MessageTrace.isTraceEnabled();
                if (isTraceEnabled) {
                    reqBa = this.extractRequestBytesForTrace(req, reqIs);
                    reqIs = new ByteArrayInputStream(reqBa);
                }
                String contentType = req.getHeader("Content-Type");
                Message requestMsg = new Message((Object)reqIs, contentType, req.getHeader("Content-Location"));
                requestMsg.setCharacterEncoding(req.getCharacterEncoding());
                msgContext.setRequestMessage(requestMsg);
                if (isTraceEnabled && reqBa != null) {
                    MessageTrace.log(MessageTrace.INBOUND_HTTP_REQUEST, contentType, reqBa);
                }
                try {
                    soapAction = this.getSoapAction(req);
                    if (soapAction != null) {
                        msgContext.setUseSOAPAction(true);
                        msgContext.setSOAPActionURI(soapAction);
                    } else {
                        msgContext.setUseSOAPAction(false);
                        msgContext.setSOAPActionURI(soapAction);
                    }
                    msgContext.setSession(new WebServicesHttpSession(req));
                    if (isDebug) {
                        log.debug("Invoking WebServices Engine.");
                    }
                    engine2.invoke(msgContext);
                    if (isDebug) {
                        log.debug("Return from WebServices Engine.");
                    }
                    if ((responseMsg = msgContext.getResponseMessage()) != null) {
                        responseMsg.ifFaultThrowSelf();
                    }
                }
                catch (WebServicesFault e) {
                    if (e.isUserException()) {
                        UserExceptionTrace.log(e, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", "713", this);
                    } else {
                        log.error(Messages.getMessage("exception00"), e);
                    }
                    isResponseCacheable = false;
                    req.setAttribute("httpResponseIsCacheable", new Boolean(false));
                    int status = this.getHttpServletResponseStatus(e);
                    if (status == 401) {
                        res.setHeader("WWW-Authenticate", "Basic realm=\"WebServices\"");
                    }
                    res.setStatus(status);
                    responseMsg = msgContext.getResponseMessage();
                    if (responseMsg == null) {
                        responseMsg = new Message(e);
                        msgContext.setResponseMessage(responseMsg);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", "1:797:1.70", this);
                    log.error(Messages.getMessage("exception00"), e);
                    if (e instanceof IOException) {
                        ServletException se = new ServletException(Messages.getMessage("exception00"), e);
                        throw se;
                    }
                    isResponseCacheable = false;
                    req.setAttribute("httpResponseIsCacheable", new Boolean(false));
                    res.setStatus(500);
                    responseMsg = msgContext.getResponseMessage();
                    if (responseMsg == null) {
                        responseMsg = new Message(WebServicesFault.makeFault(e));
                        msgContext.setResponseMessage(responseMsg);
                    }
                }
            }
            catch (WebServicesFault fault2) {
                FFDCFilter.processException((Throwable)fault2, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", "1:828:1.70", this);
                log.error(Messages.getMessage("webServicesFault00"), fault2);
                isResponseCacheable = false;
                req.setAttribute("httpResponseIsCacheable", new Boolean(false));
                responseMsg = msgContext.getResponseMessage();
                if (responseMsg != null) break block72;
                responseMsg = new Message(fault2);
                msgContext.setResponseMessage(responseMsg);
            }
        }
        if (responseMsg != null) {
            boolean jmsRedirect = false;
            String target = msgContext.getTargetEndpointAddress();
            if (target != null && target.toLowerCase().startsWith("jms")) {
                jmsRedirect = true;
                if (isDebug) {
                    log.debug("Redirect directive to JMS found.");
                }
            }
            if (msgContext.isOneWay()) {
                log.error(Messages.getMessage("servlet.unexpected.oneway.response00"));
                if (isDebug) {
                    log.debug("No Response Sent");
                }
            } else if (msgContext.getProperty("com.ibm.ws.wsaddressing.NoneURI") != null) {
                if (isDebug) {
                    log.debug("Discard Response : WSAddressing NoneURI specified.");
                }
                if (isDebug) {
                    log.debug("No Response Sent");
                }
            } else if (jmsRedirect) {
                try {
                    this.sendJMSResponse(msgContext);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", "1:890:1.70", this);
                }
            } else {
                String reqAcceptEncoding = req.getHeader(HTTPConstants.HEADER_ACCEPT_ENCODING);
                if (isDebug) {
                    log.debug(Messages.getMessage("acceptEncHdrFromHttpRequest", reqAcceptEncoding));
                }
                if (JavaUtils.hasValue(reqAcceptEncoding)) {
                    String propValue = msgContext.getStrProp("com.ibm.websphere.webservices.http.responseContentEncoding");
                    if (!JavaUtils.hasValue(propValue)) {
                        propValue = System.getProperty("com.ibm.websphere.webservices.http.responseContentEncoding");
                    }
                    if (isDebug) {
                        log.debug("com.ibm.websphere.webservices.http.responseContentEncoding = " + propValue);
                    }
                    if (JavaUtils.hasValue(propValue)) {
                        if (propValue.equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_GZIP)) {
                            res.setHeader(HTTPConstants.HEADER_CF_WSZIP, HTTPConstants.HEADER_C_ENC_GZIP);
                        } else if (propValue.equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_XGZIP)) {
                            res.setHeader(HTTPConstants.HEADER_CF_WSZIP, HTTPConstants.HEADER_C_ENC_XGZIP);
                        } else if (propValue.equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_DEFLATE)) {
                            res.setHeader(HTTPConstants.HEADER_CF_WSZIP, HTTPConstants.HEADER_C_ENC_DEFLATE);
                        } else if (isDebug) {
                            log.debug(Messages.getMessage("noCompression"));
                        }
                    } else if (isDebug) {
                        log.debug(Messages.getMessage("noCompression"));
                    }
                } else if (isDebug) {
                    log.debug(Messages.getMessage("noCompression"));
                }
                HashMap responseTransportHeaders = null;
                responseTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
                if (responseTransportHeaders != null) {
                    if (isDebug) {
                        log.debug("Adding handler response transport property headers to response message.");
                    }
                    this.setResponseHandlerTransportProperties(res, responseTransportHeaders);
                }
                this.sendResponse(this.getProtocolVersion(req), responseMsg.getContentType(msgContext.getSOAPConstants()), res, responseMsg);
                if (isDebug) {
                    log.debug("Response sent.");
                }
            }
        } else if (isDebug) {
            log.debug("No Response Sent");
        }
        if (msgContext.getRequestMessage() != null) {
            msgContext.getRequestMessage().removeAllAttachments();
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: doPost()");
        }
    }

    private byte[] extractRequestBytesForTrace(HttpServletRequest req, InputStream reqIs) throws IOException {
        String lenStr;
        byte[] reqBa = null;
        if (isDebug) {
            log.debug("Start copying HTTP request to trace buffer");
        }
        if ((lenStr = req.getHeader("Content-Length")) != null) {
            int len = 0;
            try {
                len = Integer.parseInt(lenStr);
            }
            catch (NumberFormatException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", "1:1035:1.70", this);
                log.error(Messages.getMessage("exception00"), e);
                len = reqIs.available();
            }
            reqBa = new byte[len];
            int leftToRead = len;
            int offset = 0;
            while (leftToRead > 0) {
                int bytesRead = reqIs.read(reqBa, offset, leftToRead);
                if (isDebug) {
                    log.debug("Trace buffer needs " + leftToRead + " bytes at offset " + offset + " got " + bytesRead + " bytes");
                }
                if (bytesRead < 0) {
                    if (isDebug) {
                        log.debug("End of stream with " + leftToRead + " bytes still expected");
                    }
                    leftToRead = 0;
                    continue;
                }
                leftToRead -= bytesRead;
                offset += bytesRead;
            }
        } else {
            int chunksize = 1024;
            ArrayList<byte[]> chunks = new ArrayList<byte[]>();
            ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
            int totalBytesRead = 0;
            int bytesFromRead = 0;
            while (bytesFromRead >= 0) {
                byte[] chunkBA = new byte[1024];
                bytesFromRead = reqIs.read(chunkBA, 0, 1024);
                if (bytesFromRead < 0) continue;
                chunks.add(chunkBA);
                chunkSizes.add(new Integer(bytesFromRead));
                totalBytesRead += bytesFromRead;
            }
            reqBa = new byte[totalBytesRead];
            int offset = 0;
            for (int i = 0; i < chunks.size(); ++i) {
                byte[] chunk = (byte[])chunks.get(i);
                int chunkSize = (Integer)chunkSizes.get(i);
                System.arraycopy(chunk, 0, reqBa, offset, chunkSize);
                offset += chunkSize;
            }
        }
        if (isDebug) {
            log.debug("Done copying HTTP request to trace buffer");
        }
        return reqBa;
    }

    public void oneWay(MessageContext owe) {
        Object responseObject;
        if (isDebug) {
            log.debug("Entry: oneWay()");
        }
        if ((responseObject = owe.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE)) != null) {
            HttpServletResponse res = (HttpServletResponse)responseObject;
            try {
                res.setContentLength(0);
                if (this.thisResponseShouldBeRedirected(owe)) {
                    if (isDebug) {
                        log.debug("Sending 202 back...");
                    }
                    res.setStatus(202);
                } else if (isDebug) {
                    log.debug("Oneway is back...");
                }
                res.flushBuffer();
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.oneWay", "1:1128:1.70", this);
            }
        }
        if (isDebug) {
            log.debug("Exit: oneWay()");
        }
    }

    protected int getHttpServletResponseStatus(WebServicesFault af) {
        if (af.getFaultCode() != null) {
            return af.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
        }
        if (log.isDebugEnabled()) {
            log.debug("faultCode is null. Check that the SOAP Fault is formed correctly.");
        }
        return 500;
    }

    private void sendResponse(String clientVersion, String contentType, HttpServletResponse res, Message responseMsg) throws WebServicesFault, IOException {
        if (responseMsg == null) {
            res.setStatus(204);
            if (isDebug) {
                log.debug("NO WEBSERVICES MESSAGE TO RETURN!");
            }
        } else {
            if (isDebug) {
                log.debug("Returned Content-Type:" + contentType);
            }
            try {
                res.setContentType(contentType);
                MessageContext ctx = responseMsg.getMessageContext();
                if (this.thisResponseShouldBeRedirected(ctx)) {
                    EngineConfiguration ecfg = EngineConfigurationFactoryFinder.newFactory("NONE").getClientEngineConfig();
                    try {
                        SimpleTargetedChain hdler = (SimpleTargetedChain)ecfg.getTransport(QNameTable.createQName(null, "http"));
                        HTTPSender hsender = (HTTPSender)hdler.getPivotHandler();
                        MessageContext.setCurrentThreadsContext(ctx);
                        ctx.setProperty(HTTPConstants.MC_HTTP_OUTBOUND_ASYNC_RESPONSE, "yes".intern());
                        hsender.invoke(ctx);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.sendResponse", "1:1238:1.70", this);
                        log.error(Messages.getMessage("exception00"), ex);
                        throw new SOAPException("WSAddressing determined that response should be sent asynchronously. An error occured with this response, which cannot be processed any further.", (Throwable)ex);
                    }
                } else {
                    responseMsg.writeTo(res.getOutputStream());
                    if (MessageTrace.isTraceEnabled()) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        responseMsg.writeTo(baos);
                        byte[] msgBytes = baos.toByteArray();
                        MessageTrace.log(MessageTrace.OUTBOUND_HTTP_RESPONSE, contentType, msgBytes);
                    }
                }
                responseMsg.removeAllAttachments();
            }
            catch (SOAPException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.sendResponse", "1:1268:1.70", this);
                log.error(Messages.getMessage("exception00"), e);
            }
        }
    }

    private void sendJMSResponse(MessageContext msgContext) throws Exception {
        try {
            EngineConfiguration ecfg = EngineConfigurationFactoryFinder.newFactory("NONE").getClientEngineConfig();
            if (ecfg != null) {
                SimpleTargetedChain jmshdler = (SimpleTargetedChain)ecfg.getTransport(QNameTable.createQName(null, "jms"));
                if (jmshdler != null) {
                    JMSSender jmssender = (JMSSender)jmshdler.getPivotHandler();
                    MessageContext.setCurrentThreadsContext(msgContext);
                    if (jmssender != null) {
                        URL targetURL = msgContext.getTargetEndpointAddressAsURL();
                        if (isDebug) {
                            log.debug("Attempting to redirect to JMS to " + targetURL);
                        }
                        jmssender.invoke(msgContext);
                    } else if (isDebug) {
                        log.debug("JMSSender is null");
                    }
                } else if (isDebug) {
                    log.debug("JMSHandler is null");
                }
            } else if (isDebug) {
                log.debug("EngineConfiguration is null");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.sendJMSResponse", "1:1316:1.70", this);
            throw new Exception("WSAddressing determined that response should be sent asynchronously. An error occured with this response, which cannot be processed any further.", e);
        }
    }

    private MessageContext createMessageContext(WebServicesEngine engine2, HttpServletRequest req, HttpServletResponse res) {
        String string;
        MessageContext msgContext = new MessageContext(engine2);
        if (isDebug) {
            log.debug("MessageContext:" + msgContext);
            log.debug("HEADER_CONTENT_TYPE:" + req.getHeader("Content-Type"));
            log.debug("HEADER_CONTENT_LOCATION:" + req.getHeader("Content-Location"));
            log.debug("Constants.MC_HOME_DIR:" + String.valueOf(this.getHomeDir()));
            log.debug("Constants.MC_RELATIVE_PATH:" + req.getServletPath());
            log.debug("HTTPConstants.MC_HTTP_SERVLETLOCATION:" + String.valueOf(this.getWebInfPath()));
            log.debug("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + req.getPathInfo());
            log.debug("HTTPConstants.HEADER_AUTHORIZATION:" + req.getHeader("Authorization"));
            log.debug("Constants.MC_REMOTE_ADDR:" + req.getRemoteAddr());
            log.debug("configPath:" + String.valueOf(this.getWebInfPath()));
        }
        if (this.transportName != null) {
            msgContext.setTransportName(this.transportName);
        }
        if (this.jwsClassDir != null) {
            msgContext.setProperty("jws.classDir", this.jwsClassDir);
        }
        if ((string = this.getHomeDir()) != null) {
            msgContext.setProperty("home.dir", string);
        }
        if ((string = req.getServletPath()) != null) {
            msgContext.setProperty("path", string);
        }
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, this);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, req);
        if (res != null) {
            msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, res);
        }
        if ((string = this.getWebInfPath()) != null) {
            msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, string);
            msgContext.setProperty("configPath", string);
        }
        if ((string = req.getPathInfo()) != null) {
            msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, string);
        }
        if ((string = req.getHeader("Authorization")) != null) {
            msgContext.setProperty("Authorization", string);
        }
        if ((string = req.getRemoteAddr()) != null) {
            msgContext.setProperty("remoteaddr", string);
        }
        ServletEndpointContextImpl sec = ServletEndpointContextImpl.get();
        msgContext.setProperty("servletEndpointContext", sec);
        String realpath = this.getServletConfig().getServletContext().getRealPath(req.getServletPath());
        if (realpath != null) {
            msgContext.setProperty("realpath", realpath);
        }
        msgContext.addOneWayListener(this);
        return msgContext;
    }

    private String getSoapAction(HttpServletRequest req) throws WebServicesFault {
        String soapAction = req.getHeader("SOAPAction");
        if (isDebug) {
            log.debug("HEADER_SOAP_ACTION:" + soapAction);
        }
        if (soapAction == null) {
            WebServicesFault af = new WebServicesFault("Client.NoSOAPAction", Messages.getMessage("noHeader00", "SOAPAction"), null, null);
            log.error(Messages.getMessage("genFault00"), af);
            throw af;
        }
        if (soapAction.length() == 0) {
            soapAction = null;
        } else if (soapAction.length() > 1 && soapAction.startsWith(DOUBLE_QUOTES) && soapAction.endsWith(DOUBLE_QUOTES)) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        return soapAction;
    }

    protected String getDefaultJWSClassDir() {
        return this.getWebInfPath() == null ? null : this.getWebInfPath() + File.separator + "jwsClasses";
    }

    protected String getProtocolVersion(HttpServletRequest req) {
        String ver;
        int sindex;
        String ret = HTTPConstants.HEADER_PROTOCOL_V10;
        String prot = req.getProtocol();
        if (prot != null && -1 != (sindex = prot.indexOf(47)) && HTTPConstants.HEADER_PROTOCOL_V11.equals((ver = prot.substring(sindex + 1)).trim())) {
            ret = HTTPConstants.HEADER_PROTOCOL_V11;
        }
        return ret;
    }

    public boolean thisResponseShouldBeRedirected(MessageContext msgCtx) {
        Object redirectFlag;
        if (log.isDebugEnabled()) {
            log.debug("Entry: thisResponseShouldBeRedirected()");
        }
        if (msgCtx != null && (redirectFlag = msgCtx.getProperty("com.ibm.ws.wsaddressing.RedirectRequired")) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: thisResponseShouldBeRedirected() - true");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: thisResponseShouldBeRedirected() - false");
        }
        return false;
    }

    private void setResponseHandlerTransportProperties(HttpServletResponse message, HashMap responseTransportHeaders) throws WebServicesFault {
        try {
            if (responseTransportHeaders != null) {
                Iterator headerIterator = responseTransportHeaders.entrySet().iterator();
                while (headerIterator.hasNext()) {
                    boolean wasHere;
                    String transportHeaderValue;
                    String transportHeaderKey;
                    Map.Entry headerMapEntry = headerIterator.next();
                    if (headerMapEntry.getKey() == null || !(headerMapEntry.getKey() instanceof String) || !JavaUtils.hasValue(transportHeaderKey = ((String)headerMapEntry.getKey()).trim()) || headerMapEntry.getValue() == null || !(headerMapEntry.getValue() instanceof String) || !JavaUtils.hasValue(transportHeaderValue = ((String)headerMapEntry.getValue()).trim()) || (wasHere = message.containsHeader(transportHeaderKey))) continue;
                    message.setHeader(transportHeaderKey, transportHeaderValue);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.setResponseHandlerTransportProperties", "1:1586:1.70", this);
            throw new WebServicesFault("HTTP", e.toString(), null, null);
        }
    }

    private synchronized void setEndptMgrMBean() {
        if (log.isDebugEnabled()) {
            log.debug("Entry :: setEndptMgrMBean");
        }
        if (this.endptMgrMBean != null || this.checkedForMBean) {
            return;
        }
        try {
            WebServicesService service = null;
            try {
                service = (WebServicesService)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return WsServiceRegistry.getService(this, class$com$ibm$ws$webservices$WebServicesService == null ? (class$com$ibm$ws$webservices$WebServicesService = WebServicesServlet.class$("com.ibm.ws.webservices.WebServicesService")) : class$com$ibm$ws$webservices$WebServicesService);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            if (service != null) {
                ServerModuleMetaData smmd = service.getServerModuleMetaData();
                if (smmd != null) {
                    this.endptMgrMBean = (EndpointManagerMBeanImpl)smmd.getEndpointManagerMbean();
                } else if (log.isDebugEnabled()) {
                    log.debug("SMMD was null.");
                }
            } else if (log.isDebugEnabled()) {
                log.debug("WebServicesService was null.");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.setEndptMgrMBean", "1812", this);
            log.error(Messages.getMessage("exception00"), e);
        }
        if (this.endptMgrMBean == null) {
            log.warn(Messages.getMessage("endpointMgrNotFound00", this.getServletName()));
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit :: setEndptMgrMBean");
        }
    }

    static {
        block3: {
            log = LogFactory.getLog(WebServicesServlet.class.getName());
            enableHTTPPrefix = false;
            String propName = "com.ibm.ws.webservices.enableHTTPPrefix";
            try {
                enableHTTPPrefix = MCUtils.isPropertyEnabled(propName);
                if (log.isDebugEnabled()) {
                    log.debug(MCUtils.getSettingMsg(propName, enableHTTPPrefix));
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Exception occurred obtaining and evaluating system property {" + propName + "}: " + ex);
            }
        }
        isResponseCacheable = true;
        isDebug = false;
    }
}

