/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelManager;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class OutboundConnectionGroup {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(OutboundConnectionGroup.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final Integer STATE_INVALID = new Integer(0);
    private static final Integer STATE_NOT_IN_USE = new Integer(1);
    private static final Integer STATE_IN_USE = new Integer(2);
    private static float ldFactor = 0.75f;
    private static int initSize = 131;
    private static WSChannelManager wMgr = null;
    private VirtualConnectionFactory vcf = null;
    private long idleTime = 5000L;
    private HashMap thePool = new HashMap(initSize, ldFactor);
    private Vector Cleanup = new Vector();

    public OutboundConnectionGroup() {
        Long temp = null;
        try {
            temp = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Long.getLong("com.ibm.websphere.webservices.http.connectionIdleTimeout");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        if (temp != null) {
            this.idleTime = temp * 1000L;
        }
        wMgr = WSChannelManager.getInstance();
    }

    public WSOutboundConnection createConnection(WSAddress addrtoConnect) throws WebServicesFault, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.createConnection()");
        }
        WSOutboundConnection wOC = null;
        String keyChainName = addrtoConnect.keyValueforPool();
        if (this.vcf == null) {
            this.vcf = wMgr.getVCFactory(addrtoConnect);
        }
        wOC = wMgr.getWSOutboundConnection(keyChainName, addrtoConnect, this.vcf);
        this.thePool.put(wOC, STATE_IN_USE);
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("createdOCobject", wOC.toString(), String.valueOf(this.vcf)));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.createConnection()");
        }
        return wOC;
    }

    protected WSOutboundConnection invalidateConnection(WSAddress addrtoConnect) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.invalidateConnection()");
        }
        WSOutboundConnection wOC = null;
        if (this.thePool.size() > 0) {
            Iterator it = this.thePool.keySet().iterator();
            while (it.hasNext()) {
                wOC = (WSOutboundConnection)it.next();
                if (!wOC.getTargetAddress().equals(addrtoConnect)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, Messages.getMessage("invalidatedConnObject01", addrtoConnect.toString(), wOC.toString()));
                }
                this.thePool.put(wOC, STATE_INVALID);
                break;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.invalidateConnection()");
        }
        return wOC;
    }

    protected WSOutboundConnection getConnection(WSAddress addrtoConnect) throws WebServicesFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.getConnection()");
        }
        WSOutboundConnection wOC = null;
        if (this.thePool.size() > 0) {
            Iterator it = this.thePool.keySet().iterator();
            while (it.hasNext()) {
                wOC = (WSOutboundConnection)it.next();
                int state = (Integer)this.thePool.get(wOC);
                if (state == STATE_NOT_IN_USE) {
                    long sincelastAccess = wOC.timeFromLastAccess();
                    if (sincelastAccess >= this.idleTime) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("expiredOCobject", wOC.toString(), String.valueOf(sincelastAccess)));
                        }
                        wOC.release(null);
                        this.Cleanup.add(wOC);
                        it.remove();
                        wOC = this.createConnection(addrtoConnect);
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "OutboundConnectionGroup.getConnection()");
                        }
                        return wOC;
                    }
                    if (!_tc.isEventEnabled()) break;
                    Tr.event(_tc, Messages.getMessage("existedOCobject", wOC.toString()));
                    break;
                }
                wOC = null;
            }
            if (wOC != null) {
                wOC.updateEndpoint(addrtoConnect);
                this.thePool.put(wOC, STATE_IN_USE);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.getConnection()");
        }
        return wOC;
    }

    protected WSOutboundConnection addConnection(WSAddress addrtoConnect, WSOutboundConnection wOC, String searchKey) throws WebServicesFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.addConnection()");
        }
        WSOutboundConnection retwOC = null;
        if (!searchKey.equals(wOC.groupID())) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The intended connection object: " + wOC + " does not originally belong to this group:" + this);
                Tr.debug(_tc, "Original connection group ID: " + wOC.groupID() + ". Current connection group ID: " + searchKey);
            }
            wOC.release(null);
            this.Cleanup.add(wOC);
            retwOC = this.createConnection(addrtoConnect);
        } else if (wOC.isClosed()) {
            if (_tc.isEventEnabled()) {
                Tr.debug(_tc, "The intended connection object: " + wOC + " has been closed.");
            }
            wOC.release(null);
            this.Cleanup.add(wOC);
            retwOC = this.createConnection(addrtoConnect);
        } else {
            long sincelastAccess = wOC.timeFromLastAccess();
            if (sincelastAccess >= this.idleTime) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("expiredOCobject", wOC.toString(), String.valueOf(sincelastAccess)));
                }
                wOC.release(null);
                this.Cleanup.add(wOC);
                retwOC = this.createConnection(addrtoConnect);
            } else {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("existedOCobject", wOC.toString()));
                }
                retwOC = wOC;
                retwOC.updateEndpoint(addrtoConnect);
                this.thePool.put(retwOC, STATE_IN_USE);
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Connection object " + retwOC + " has been established in group: " + this);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.addConnection()");
        }
        return retwOC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnConnection(WSOutboundConnection wOC, boolean poolIsFull) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.returnConnection()");
        }
        if (poolIsFull) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "The pool is full. Removing " + wOC + " from the group: " + this + " to make room.");
            }
            this.thePool.remove(wOC);
            return;
        }
        int state = (Integer)this.thePool.get(wOC);
        if (state == STATE_INVALID) {
            this.thePool.remove(wOC);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("returnInvalidOCobject", wOC.toString()));
            }
            wOC.release(null);
            Vector vector = this.Cleanup;
            synchronized (vector) {
                this.Cleanup.add(wOC);
            }
        } else if (wOC.isClosed()) {
            this.thePool.remove(wOC);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("returnClosedOCobject", wOC.toString()));
            }
            wOC.release(null);
            Vector vector = this.Cleanup;
            synchronized (vector) {
                this.Cleanup.add(wOC);
            }
        } else {
            this.thePool.put(wOC, STATE_NOT_IN_USE);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("returnValidOCobject", wOC.toString()));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.returnConnection()");
        }
    }

    protected boolean isEmpty() {
        return this.thePool.isEmpty() && this.Cleanup.isEmpty();
    }

    protected int currPoolSize() {
        return this.thePool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ChannelException, ChainException {
        Iterator<Object> it;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cleanup()");
        }
        WSOutboundConnection wOC = null;
        Cloneable cloneable = this.thePool;
        synchronized (cloneable) {
            if (this.thePool.size() > 0) {
                it = this.thePool.keySet().iterator();
                WSOutboundConnection conn = null;
                while (it.hasNext()) {
                    conn = (WSOutboundConnection)it.next();
                    long sincelastAccess = conn.timeFromLastAccess();
                    int state = (Integer)this.thePool.get(conn);
                    if (state == STATE_INVALID) {
                        conn = null;
                        continue;
                    }
                    if (sincelastAccess < this.idleTime || state != STATE_NOT_IN_USE) continue;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("expiredOCobject", conn.toString(), String.valueOf(sincelastAccess)));
                    }
                    this.Cleanup.add(conn);
                    it.remove();
                    conn.release(null);
                }
            }
        }
        cloneable = this.Cleanup;
        synchronized (cloneable) {
            it = this.Cleanup.iterator();
            while (it.hasNext()) {
                wOC = (WSOutboundConnection)it.next();
                wOC.release(null);
                if (!_tc.isEventEnabled()) continue;
                Tr.event(_tc, Messages.getMessage("removeOCobject", wOC.toString()));
            }
            this.Cleanup.clear();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cleanup()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws ChannelException, ChainException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "release()");
        }
        if (this.vcf != null) {
            VirtualConnectionFactory virtualConnectionFactory = this.vcf;
            synchronized (virtualConnectionFactory) {
                if (this.vcf != null) {
                    this.vcf.destroy();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("objectReleased", String.valueOf(this.vcf)));
                    }
                    this.vcf = null;
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "release()");
        }
    }

    public int totalInUse() {
        int result = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "totalInUse()");
        }
        Iterator it = this.thePool.values().iterator();
        while (it.hasNext()) {
            if (!((Integer)it.next()).equals(STATE_IN_USE)) continue;
            ++result;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "totalInUse()");
        }
        return result;
    }

    public boolean findUnused() {
        boolean result = false;
        WSOutboundConnection wOC = null;
        if (this.thePool.size() > 1) {
            Iterator it = this.thePool.keySet().iterator();
            while (it.hasNext()) {
                wOC = (WSOutboundConnection)it.next();
                if (!((Integer)this.thePool.get(wOC)).equals(STATE_NOT_IN_USE)) continue;
                this.Cleanup.add(wOC);
                it.remove();
                wOC.release(null);
                result = true;
            }
        }
        return result;
    }
}

