/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.orderedset;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.orderedset.BasicOperableOrderedSet;
import com.ibm.ws.webservices.engine.orderedset.EmptySet;
import com.ibm.ws.webservices.engine.orderedset.OperableOrderedSet;
import com.ibm.ws.webservices.engine.orderedset.Operation;
import com.ibm.ws.webservices.engine.orderedset.OperationException;
import com.ibm.ws.webservices.engine.orderedset.OrderedSet;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.lang.reflect.Array;
import java.util.List;
import org.apache.commons.logging.Log;

public abstract class BasicListSet
extends BasicOperableOrderedSet
implements OrderedSet {
    protected static Log log = LogFactory.getLog(BasicListSet.class.getName());
    private List _list;

    protected BasicListSet(List list) {
        this._list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object object) {
        List list = this._list;
        synchronized (list) {
            if (!this._list.contains(object)) {
                this._list.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        List list = this._list;
        synchronized (list) {
            return this._list.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        List list = this._list;
        synchronized (list) {
            return this._list.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] get() {
        List list = this._list;
        synchronized (list) {
            if (this._list.size() == 0) {
                return null;
            }
            Object[] ret = new Object[this._list.size()];
            return this._list.toArray(ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] get(Class expectedObjectClass) {
        List list = this._list;
        synchronized (list) {
            if (this._list.size() == 0) {
                return null;
            }
            Object[] ret = (Object[])Array.newInstance(expectedObjectClass, this._list.size());
            return this._list.toArray(ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Operation op) throws OperationException {
        List list = this._list;
        synchronized (list) {
            this.getSet().apply(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyReverse(Operation op) throws OperationException {
        List list = this._list;
        synchronized (list) {
            this.getSet().applyReverse(op);
        }
    }

    private OperableOrderedSet getSet() {
        BasicOperableOrderedSet _set = this._list.size() == 0 ? new EmptySet() : new SubSet(0, this._list.size() - 1, 1);
        return _set;
    }

    private class SubSet
    extends BasicOperableOrderedSet {
        private final int _first;
        private final int _last;
        private final int _step;

        public SubSet(int first, int last, int direction) {
            this.setIgnoreExceptions(super.getIgnoreExceptions());
            this._first = first;
            this._last = last;
            if (this._first < 0 || this._last < 0 || this._first >= BasicListSet.this._list.size() || this._last >= BasicListSet.this._list.size() || direction == 0) {
                this._step = 0;
            } else if (direction < 0 && this._first < this._last || direction > 0 && this._first > this._last) {
                log.error(Messages.getMessage("invalidSubset00", String.valueOf(this._first), String.valueOf(this._last), String.valueOf(direction)));
                this._step = 0;
            } else {
                int n = this._step = direction > 0 ? 1 : -1;
            }
            if (log.isDebugEnabled()) {
                log.debug("SubSet(" + this._first + ", " + this._last + ", " + this._step + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply(Operation op) throws OperationException {
            if (this._step == 0) {
                return;
            }
            List list = BasicListSet.this._list;
            synchronized (list) {
                block13: {
                    int next = this._first;
                    if (this.getIgnoreExceptions()) {
                        while (true) {
                            Object obj = BasicListSet.this._list.get(next);
                            try {
                                op.op(obj);
                            }
                            catch (Throwable t) {
                                log.info(Messages.getMessage("ignoringException01", obj.toString()), t);
                            }
                            if (next != this._last) {
                                next += this._step;
                                continue;
                            }
                            break block13;
                            break;
                        }
                    }
                    Object element = null;
                    try {
                        while (true) {
                            element = BasicListSet.this._list.get(next);
                            op.op(element);
                            if (next != this._last) {
                                next += this._step;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.orderedset.BasicListSet.apply", "245", this);
                        SubSet preSet = new SubSet(next - 1, this._first, -this._step);
                        SubSet postSet = new SubSet(next + 1, this._last, this._step);
                        throw new OperationException(t, element, preSet, postSet);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyReverse(Operation op) throws OperationException {
            if (this._step == 0) {
                return;
            }
            List list = BasicListSet.this._list;
            synchronized (list) {
                block13: {
                    int next = this._last;
                    if (this.getIgnoreExceptions()) {
                        while (true) {
                            Object obj = BasicListSet.this._list.get(next);
                            try {
                                op.op(obj);
                            }
                            catch (Throwable t) {
                                log.info(Messages.getMessage("ignoringException01", obj.toString()), t);
                            }
                            if (next != this._first) {
                                next -= this._step;
                                continue;
                            }
                            break block13;
                            break;
                        }
                    }
                    Object element = null;
                    try {
                        while (true) {
                            element = BasicListSet.this._list.get(next);
                            op.op(element);
                            if (next != this._first) {
                                next -= this._step;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.orderedset.BasicListSet.applyReverse", "296", this);
                        SubSet preSet = new SubSet(next + 1, this._last, this._step);
                        SubSet postSet = new SubSet(next - 1, this._first, -this._step);
                        throw new OperationException(t, element, preSet, postSet);
                    }
                }
            }
        }
    }
}

