/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.websphere.csi.Pool;
import com.ibm.websphere.csi.PoolManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerPool;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerProxy;
import com.ibm.ws.webservices.engine.resources.Messages;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import org.apache.commons.logging.Log;

public class WASHandlerPool
extends HandlerPool {
    protected static Log log = LogFactory.getLog(WASHandlerPool.class.getName());
    private static final PoolManager poolManager = PoolManager.newInstance();
    private final Pool _pool;

    WASHandlerPool(HandlerInfo handlerInfo) throws IllegalAccessException, InstantiationException {
        super(handlerInfo);
        if (log.isDebugEnabled()) {
            log.debug("In WASHandlerPool ctor.  handlerInfo: " + handlerInfo.getHandlerClass().getName());
        }
        if (handlerInfo instanceof ExtendedHandlerInfo) {
            ExtendedHandlerInfo ehi = (ExtendedHandlerInfo)handlerInfo;
            this._pool = poolManager.createThreadSafePool(ehi.getMinPoolSize(), ehi.getMaxPoolSize());
            if (log.isDebugEnabled()) {
                log.debug("WASHandlerPool ctor.  getting pool with ExtendedHandlerInfo: " + this._pool);
            }
        } else {
            this._pool = poolManager.createThreadSafePool(5, 25);
            if (log.isDebugEnabled()) {
                log.debug("WASHandlerPool ctor.  getting pool with RegularHandlerInfo: " + this._pool);
            }
        }
        this.getHandlerClass().newInstance();
    }

    protected void finalize() {
        if (this._pool != null) {
            this._pool.destroy();
        }
    }

    public Handler get() {
        HandlerProxy result = (HandlerProxy)this._pool.get();
        if (result == null) {
            try {
                result = new HandlerProxy(this);
                if (log.isDebugEnabled()) {
                    log.debug("WASHandlerPool.get.  newing up handler " + result);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.handlers.jaxrpc.WASHandlerPool.get", "103", this);
                log.error(Messages.getMessage("jaxRpcHandlerUnexpectedClassLoadFailure00", this.getHandlerClassName()), e);
                throw new JAXRPCException(Messages.getMessage("jaxRpcHandlerUnexpectedClassLoadFailure00", this.getHandlerClassName()), e);
            }
        }
        return result;
    }

    public void put(Handler handler2) {
        this._pool.put((HandlerProxy)handler2);
    }

    public void faulted(Handler handler2) {
        if (log.isDebugEnabled()) {
            log.debug("WASHandlerPool.faulted.  handler " + handler2);
        }
        handler2.destroy();
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug("WASHandlerPool.destroy. _pool " + this._pool);
        }
        if (this._pool != null) {
            this._pool.destroy();
        }
    }
}

