/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.utils.DeserializerTarget;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VectorDeserializer
extends Deserializer {
    protected static Log log = LogFactory.getLog(VectorDeserializer.class.getName());
    public int curIndex = 0;

    public VectorDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public void onStartElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: VectorDeserializer::startElement()");
        }
        if (AttributeUtils.isNil(attributes)) {
            return;
        }
        this.setValue(new Vector());
        if (log.isDebugEnabled()) {
            log.debug("Exit: VectorDeserializer::startElement()");
        }
    }

    public DEventProcessor onStartChild(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: VectorDeserializer::onStartChild()");
        }
        if (attributes == null) {
            throw new SAXException(Messages.getMessage("noType01"));
        }
        if (AttributeUtils.isNil(attributes)) {
            this.setValue(null, new Integer(this.curIndex++));
            return new NOOPProcessor();
        }
        QName itemType = AttributeUtils.getTypeFromAttributes(namespace, localName, attributes, mappingScope);
        Deserializer dSer = null;
        if (itemType != null) {
            dSer = context.getDeserializer(null, itemType);
        }
        if (dSer == null) {
            dSer = new DefaultDeserializer();
        }
        dSer.registerValueTarget(new DeserializerTarget(this, new Integer(this.curIndex)));
        ++this.curIndex;
        if (log.isDebugEnabled()) {
            log.debug("Exit: VectorDeserializer::onStartChild()");
        }
        this.addChildDeserializer(dSer, attributes.getValue("href"));
        return dSer;
    }

    public void setValue(Object value2, Object hint) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("gotValue00", "VectorDeserializer", "" + value2));
        }
        if (hint instanceof Deserializer) {
            super.setValue(value2, hint);
        } else {
            Vector v;
            int offset = (Integer)hint;
            if (offset >= (v = (Vector)this.value).size()) {
                v.setSize(offset + 1);
            }
            v.setElementAt(value2, offset);
        }
    }

    public boolean recycle() {
        boolean rc = super.recycle();
        if (rc) {
            this.curIndex = 0;
        }
        return rc;
    }
}

