/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.custom.CustomPropertyProviderFactory;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.encoding.utils.BeanPropertyTarget;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BeanDeserializer
extends AttributeDeserializer {
    protected static Log log = LogFactory.getLog(BeanDeserializer.class.getName());
    protected boolean isLiteral = false;
    FieldDesc childFieldDesc = null;
    BeanPropertyDescriptor childPropDesc = null;
    protected FieldDesc childCollectionFieldDesc;
    protected int childIndex = 0;
    Deserializer childDSer = null;
    protected ArrayList childList = new ArrayList();
    protected boolean childIsNil = false;
    private DEventProcessor noopProcessor = null;
    protected Class proxy;
    private static boolean ignoreUnknownElement = (Boolean)CustomPropertyProviderFactory.getProvider().getValue("com.ibm.ws.webservices.ignoreUnknownElements");

    public BeanDeserializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, BeanDesc.getBeanDescForClass(javaType));
    }

    public BeanDeserializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        super(javaType, xmlType);
    }

    public BeanDeserializer(Class javaType, QName xmlType, BeanDesc beanDesc) {
        this(javaType, xmlType, beanDesc, BeanDeserializerFactory.getProperties(javaType, beanDesc));
    }

    public BeanDeserializer(Class javaType, QName xmlType, BeanDesc beanDesc, Map propertyMap) {
        super(javaType, xmlType, beanDesc, propertyMap);
    }

    public final void startElement(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("begin startElement");
        }
        String href = attributes.getValue("href");
        if (this.value == null && href == null) {
            this.createValue();
        }
        boolean bl = this.isLiteral = context.getEncodingStyle() == null || context.getEncodingStyle().length() == 0;
        if (log.isDebugEnabled()) {
            log.debug(" is literal deserialization=" + this.isLiteral);
        }
        super.startElement(namespace, localPart, prefixedName, attributes, mappingScope, context, this.isLiteral ? Boolean.TRUE : null);
        if (log.isDebugEnabled()) {
            log.debug("end startElement");
        }
    }

    public final void onStartElement(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled() && this.beanDesc == null) {
            log.debug("onStartElement beanDesc is NULL, EAR file may not be WSDeployed: localPart= " + localPart);
        }
        if (this.beanDesc != null && this.beanDesc.hasAttributes()) {
            this.processAttributes(attributes, mappingScope, context, false);
        }
    }

    public final DEventProcessor onStartChild(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("begin onStartChild for " + localPart);
        }
        this.childDSer = null;
        this.childIsNil = false;
        this.childFieldDesc = this.beanDesc.getFieldDesc(namespace, localPart);
        if (this.childFieldDesc == null && prefixedName.length() == localPart.length() && namespace != null && namespace.equals(this.xmlType.getNamespaceURI())) {
            this.childFieldDesc = this.beanDesc.getFieldDesc("", localPart);
        }
        QName childXMLType = null;
        if (this.childFieldDesc == null) {
            this.childFieldDesc = this.beanDesc.getFieldByName("_any");
            if (this.childFieldDesc != null) {
                childXMLType = this.childFieldDesc.getXmlType();
            } else {
                Deserializer anyDSer = this.anyProcessing(namespace, localPart, prefixedName, attributes, mappingScope, context);
                if (anyDSer != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("end onStartChild for " + prefixedName + " (due to anyContent processing)");
                    }
                    return anyDSer;
                }
                if (log.isDebugEnabled()) {
                    log.debug("com.ibm.ws.webservices.ignoreUnknownElements: " + ignoreUnknownElement);
                }
                if (ignoreUnknownElement) {
                    if (log.isDebugEnabled()) {
                        log.debug("Will ignore unknown element " + localPart);
                    }
                    return this.getNilProcessor();
                }
                throw new SAXException(Messages.getMessage("badElem00", this.javaType.getName(), localPart, namespace));
            }
        }
        if (AttributeUtils.isNil(attributes)) {
            this.childIsNil = true;
            if (!this.isLiteral && this.childFieldDesc.isMaxOccurs()) {
                if (this.childFieldDesc != this.childCollectionFieldDesc) {
                    this.childIndex = 0;
                }
                this.childCollectionFieldDesc = this.childFieldDesc;
                ++this.childIndex;
            }
            if (log.isDebugEnabled()) {
                log.debug("end onStartChild for " + localPart + " (due to isNil processing)");
            }
            return this.getNilProcessor();
        }
        childXMLType = childXMLType == null ? AttributeUtils.getTypeFromXSITypeAttr(attributes, mappingScope) : childXMLType;
        QName qName = childXMLType = childXMLType == null ? this.childFieldDesc.getXmlType() : childXMLType;
        if (log.isDebugEnabled()) {
            log.debug("childXMLType= " + childXMLType);
        }
        String href = this.isLiteral ? null : attributes.getValue("href");
        Deserializer deserializer = this.childDSer = childXMLType == this.childFieldDesc.getXmlType() && href == null ? this.getCachedDeserializer(this.childFieldDesc, context) : null;
        if (log.isDebugEnabled() && this.childDSer != null) {
            log.debug("using cached deserializer");
        }
        Deserializer deserializer2 = this.childDSer = this.childDSer != null ? this.childDSer : this.getDeserializer(childXMLType, this.childFieldDesc.getJavaType(), href, context);
        if (log.isDebugEnabled() && this.childDSer != null) {
            log.debug("child deserializer= " + this.childDSer.getClass());
        }
        if (this.childDSer == null) {
            throw new SAXException(Messages.getMessage("noDeser00", childXMLType.toString() + " javaType=" + this.childFieldDesc.getJavaType()));
        }
        if (!this.isLiteral) {
            this.childPropDesc = this.childFieldDesc.getPropertyDescriptor();
            if (this.childFieldDesc.isMaxOccurs() && !(this.childDSer instanceof ArrayDeserializer)) {
                if (log.isDebugEnabled()) {
                    log.debug("maxOccurs encoded processing");
                }
                if (this.childFieldDesc != this.childCollectionFieldDesc) {
                    this.childIndex = 0;
                }
                this.childCollectionFieldDesc = this.childFieldDesc;
                this.childDSer.registerValueTarget(new BeanPropertyTarget(this.value, this.childPropDesc, this.childIndex));
                ++this.childIndex;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("non-maxOccurs encoded processing");
                }
                this.childDSer.registerValueTarget(new BeanPropertyTarget(this.value, this.childPropDesc));
            }
            this.addChildDeserializer(this.childDSer, href);
        }
        if (log.isDebugEnabled()) {
            log.debug("end onStartChild for " + localPart);
        }
        return this.childDSer;
    }

    public final void onEndChild(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("begin onEndChild:" + localName);
        }
        if (this.isLiteral && this.childFieldDesc != null) {
            Object childValue;
            Object object = childValue = this.childIsNil || this.childDSer == null ? null : this.childDSer.getValue();
            if (this.childFieldDesc.isMaxOccurs()) {
                if (log.isDebugEnabled()) {
                    log.debug("literal maxOccurs processing");
                }
                this.setIndexedProperty(childValue);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("literal non-maxOccurs processing");
                }
                if (!this._tryElementSetFromObject(this.childFieldDesc.getXmlName(), childValue)) {
                    if (log.isDebugEnabled()) {
                        log.debug("generated set did not succeed.");
                    }
                    this.childPropDesc = this.childFieldDesc.getPropertyDescriptor();
                    this.setIt(this.childPropDesc, childValue);
                }
            }
            if (this.childDSer != null) {
                this.childDSer.relinquish();
            }
        }
        this.containsChild = true;
        if (log.isDebugEnabled()) {
            log.debug("end onEndChild:" + localName);
        }
    }

    public final void onSimpleChild(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, String strValue) throws SAXException {
        String childValue;
        this.childDSer = null;
        this.childIsNil = false;
        this.childFieldDesc = this.beanDesc.getFieldDesc(namespace, localPart);
        if (this.childFieldDesc == null && prefixedName.length() == localPart.length() && namespace != null && (namespace == this.xmlType.getNamespaceURI() || namespace.equals(this.xmlType.getNamespaceURI()))) {
            this.childFieldDesc = this.beanDesc.getFieldDesc("", localPart);
        }
        if (this.childFieldDesc == null) {
            if (log.isDebugEnabled()) {
                log.debug("leave onSimpleChild due to no fieldDesc");
            }
            super.onSimpleChild(namespace, localPart, prefixedName, attributes, mappingScope, context, strValue);
            return;
        }
        if (this.tryElementSetFromString(this.childFieldDesc.getXmlName(), strValue)) {
            if (log.isDebugEnabled()) {
                log.debug("leave onSimpleChild.. generated set did not succeed");
            }
            return;
        }
        this.childPropDesc = this.childFieldDesc.getPropertyDescriptor();
        Class javaType = this.childFieldDesc.getJavaType();
        if (this.childPropDesc == null || javaType != String.class && !javaType.isPrimitive()) {
            if (log.isDebugEnabled()) {
                log.debug("leave onSimpleChild because type is not simple:" + javaType);
            }
            super.onSimpleChild(namespace, localPart, prefixedName, attributes, mappingScope, context, strValue);
            return;
        }
        String string = childValue = javaType == String.class ? strValue : SimpleDeserializer.convert(strValue, javaType);
        if (this.childFieldDesc.isMaxOccurs()) {
            this.setIndexedProperty(childValue);
        } else {
            this.setIt(this.childPropDesc, childValue);
        }
        this.containsChild = true;
    }

    public final void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("begin onEndElement:" + localName);
        }
        if (this.childCollectionFieldDesc != null) {
            if (log.isDebugEnabled()) {
                log.debug("complete indexed property assignment");
            }
            this.assignChildListToIndexedProperty();
        }
        if (log.isDebugEnabled()) {
            log.debug("end onEndElement:" + localName);
        }
    }

    protected final void setIndexedProperty(Object value2) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("begin setIndexedProperty");
        }
        if (this.isLiteral) {
            if (log.isDebugEnabled()) {
                log.debug("literal processing");
            }
            if (this.childFieldDesc != this.childCollectionFieldDesc) {
                if (this.childCollectionFieldDesc != null) {
                    this.assignChildListToIndexedProperty();
                }
                this.childCollectionFieldDesc = this.childFieldDesc;
            }
            this.childList.add(value2);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("encoded processing");
            }
            if (this.childFieldDesc != this.childCollectionFieldDesc) {
                this.childIndex = 0;
                this.childCollectionFieldDesc = this.childFieldDesc;
            }
            this.setIt(this.childFieldDesc.getPropertyDescriptor(), value2, this.childIndex);
        }
        ++this.childIndex;
        if (log.isDebugEnabled()) {
            log.debug("end setIndexedProperty");
        }
    }

    private final void assignChildListToIndexedProperty() throws SAXException {
        if (!this.isLiteral) {
            return;
        }
        if (!this.tryElementSetFromList(this.childCollectionFieldDesc.getXmlName(), this.childList)) {
            this.childPropDesc = this.childCollectionFieldDesc.getPropertyDescriptor();
            for (int i = this.childList.size() - 1; i >= 0; --i) {
                this.setIt(this.childPropDesc, this.childList.get(i), i);
            }
        }
        this.childList.clear();
        this.childIndex = 0;
        this.childCollectionFieldDesc = null;
    }

    private BeanPropertyDescriptor getAnyPropertyDesc() {
        if (this.beanDesc == null) {
            return null;
        }
        return this.beanDesc.getAnyDesc();
    }

    public final boolean recycle() {
        boolean rc = super.recycle();
        if (rc) {
            this.value = null;
            this.isLiteral = false;
            this.childIsNil = false;
            this.childCollectionFieldDesc = null;
            this.childIndex = 0;
            this.childList.clear();
            this.proxy = null;
        }
        return rc;
    }

    private final void setIt(BeanPropertyDescriptor pd, Object value2) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("setIt(" + pd.getName() + " , " + JavaUtils.getObjectIdentity(value2) + ")");
        }
        try {
            pd.set(this.getValue(), value2);
        }
        catch (Exception e) {
            try {
                Class type = pd.getType();
                if (!JavaUtils.isConvertable(value2, type)) {
                    throw e;
                }
                value2 = JavaUtils.convert(value2, type);
                pd.set(this.getValue(), value2);
            }
            catch (Exception ex) {
                Throwable t;
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.setIt", "528", this);
                String field = pd.getName();
                if (log.isErrorEnabled()) {
                    String valueType = "null";
                    if (value2 != null) {
                        valueType = value2.getClass().getName();
                    }
                    log.error(Messages.getMessage("cantConvert02", new String[]{valueType, field, pd.getType().getName()}));
                }
                if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) != null) {
                    throw new SAXException(t.getMessage());
                }
                throw new SAXException(ex);
            }
        }
    }

    private final void setIt(BeanPropertyDescriptor pd, Object value2, int index) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("setIt(" + pd.getName() + " , " + JavaUtils.getObjectIdentity(value2) + " , " + index + ")");
        }
        try {
            pd.set(this.getValue(), index, value2);
        }
        catch (Exception e) {
            try {
                Class type = pd.getType();
                if (JavaUtils.isConvertable(value2, type)) {
                    value2 = JavaUtils.convert(value2, type);
                    pd.set(this.getValue(), index, value2);
                }
                if (index == 0 && value2.getClass().isArray() && !type.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(value2); ++i) {
                        Object item = JavaUtils.convert(Array.get(value2, i), type);
                        pd.set(this.getValue(), i, item);
                    }
                }
                throw e;
            }
            catch (Exception ex) {
                Throwable t;
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.setIt", "595", this);
                String field = pd.getName();
                field = field + "[" + index + "]";
                if (log.isErrorEnabled()) {
                    String valueType = "null";
                    if (value2 != null) {
                        valueType = value2.getClass().getName();
                    }
                    log.error(Messages.getMessage("cantConvert02", new String[]{valueType, field, pd.getType().getName()}));
                }
                if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) != null) {
                    throw new SAXException(t.getMessage());
                }
                throw new SAXException(ex);
            }
        }
    }

    public final void valueComplete() throws SAXException {
        if (this.proxy != null && this.componentsReady()) {
            try {
                Method method = null;
                try {
                    method = (Method)AccessController.doPrivileged(new getMethodPRIV(this.proxy, "convert"));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                this.value = method.invoke(this.value, null);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.valueComplete", "662", this);
                throw new SAXException(e);
            }
        }
        super.valueComplete();
    }

    private final DEventProcessor getNilProcessor() {
        if (this.noopProcessor == null || !this.noopProcessor.recycle()) {
            this.noopProcessor = new NOOPProcessor();
        }
        return this.noopProcessor;
    }

    private final Deserializer anyProcessing(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        BeanPropertyDescriptor propDesc = this.getAnyPropertyDesc();
        if (propDesc != null) {
            try {
                javax.xml.soap.SOAPElement[] curElements = (javax.xml.soap.SOAPElement[])propDesc.get(this.value);
                int length = 0;
                if (curElements != null) {
                    length = curElements.length;
                }
                javax.xml.soap.SOAPElement[] newElements = new javax.xml.soap.SOAPElement[length + 1];
                if (curElements != null) {
                    System.arraycopy(curElements, 0, newElements, 0, length);
                }
                SOAPElementDeserializer builder = new SOAPElementDeserializer(SOAPElement.class, Constants.WEBSERVICES_SOAPELEMENT);
                SOAPFactory sf = null;
                sf = length > 0 ? ((SOAPElement)newElements[0]).getSOAPFactory() : new SOAPFactory();
                SOAPElement el = sf.createSOAPElement(namespace, localPart, prefixedName, attributes, mappingScope.flatten(), context, null);
                builder.setMyElement(el);
                newElements[length] = el;
                propDesc.set(this.value, newElements);
                return builder;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.onStartChild", "273", this);
                throw new SAXException(e);
            }
        }
        return null;
    }

    protected void createValue() throws SAXException {
        this.value = null;
        Exception origE = null;
        try {
            if (!Throwable.class.isAssignableFrom(this.javaType)) {
                this.value = this.javaType.newInstance();
            }
        }
        catch (Exception e) {
            origE = e;
        }
        if (this.value == null) {
            try {
                Class helper = null;
                Object ret = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return BeanDeserializer.this.javaType.getClassLoader();
                        }
                        catch (Throwable e) {
                            return e;
                        }
                    }
                });
                ClassLoader clsLoader = null;
                if (ret instanceof ClassLoader) {
                    clsLoader = (ClassLoader)ret;
                }
                if (clsLoader == null) {
                    helper = ClassUtils.forName(this.javaType.getName() + "_Helper");
                } else {
                    try {
                        helper = ClassUtils.forName(this.javaType.getName() + "_Helper", true, clsLoader);
                    }
                    catch (ClassNotFoundException e) {
                        helper = ClassUtils.forName(this.javaType.getName() + "_Helper");
                    }
                }
                Method method = null;
                try {
                    method = (Method)AccessController.doPrivileged(new getMethodPRIV(helper, "createProxy"));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                this.value = method.invoke(null, null);
                this.proxy = this.value.getClass();
                this.beanDesc.setBeanPropertyDescriptors(this.proxy);
                this.propertyMap = this.beanDesc.getPropertyDescriptorMap();
            }
            catch (Exception e2) {
                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.createValue", "644", this);
                Exception e = origE != null ? origE : e2;
                throw new SAXException(Messages.getMessage("cantCreateBean00", this.javaType.getName(), e.toString()));
            }
        }
    }

    protected boolean tryElementSetFromString(QName qName, String strValue) {
        return false;
    }

    protected boolean tryElementSetFromObject(QName qName, Object objValue) {
        if (objValue instanceof String) {
            return this.tryElementSetFromString(qName, (String)objValue);
        }
        return false;
    }

    protected boolean _tryElementSetFromObject(QName qName, Object value2) {
        if (value2 == null) {
            try {
                boolean rc = this.tryElementSetFromObject(qName, value2);
                if (!rc && log.isDebugEnabled()) {
                    log.debug("tryElementSetFromObject returned unsuccessfully for QName= " + qName + " and a null value." + "Processing continues without exception.");
                }
                return true;
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug("tryElementSetFromObject threw an exception for QName= " + qName + " and a null value." + "Processing continues, and the following exception is ignored " + t);
                }
                return true;
            }
        }
        return this.tryElementSetFromObject(qName, value2);
    }

    protected boolean tryElementSetFromList(QName qName, List list) {
        return false;
    }

    public String getBuildNumber() {
        return this.beanDesc == null ? null : this.beanDesc.getBuildNumber();
    }

    private class getMethodPRIV
    implements PrivilegedExceptionAction {
        private Class clazz;
        private String methodName;

        getMethodPRIV(Class clazz, String methodName) {
            this.clazz = clazz;
            this.methodName = methodName;
        }

        public Object run() throws Exception {
            return this.clazz.getMethod(this.methodName, null);
        }
    }
}

