/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.ComponentDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AttributeDeserializer
extends ComponentDeserializer {
    protected Map propertyMap = null;
    protected BeanDesc beanDesc = null;
    protected HashMap deferredAttributesMap = null;

    protected AttributeDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public AttributeDeserializer(Class javaType, QName xmlType, BeanDesc beanDesc, Map propertyMap) {
        super(javaType, xmlType);
        this.beanDesc = beanDesc;
        this.propertyMap = propertyMap;
    }

    void setup(BeanDesc beanDesc, Map propertyMap) {
        this.beanDesc = beanDesc;
        this.propertyMap = propertyMap;
    }

    public boolean recycle() {
        boolean rc = super.recycle();
        if (rc) {
            this.deferredAttributesMap = null;
        }
        return rc;
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (this.deferredAttributesMap == null) {
            return;
        }
        Set entries = this.deferredAttributesMap.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            FieldDesc fieldDesc = (FieldDesc)entry.getKey();
            Object val = entry.getValue();
            BeanPropertyDescriptor bpd = fieldDesc.getPropertyDescriptor();
            if (!bpd.isWriteable() || bpd.isIndexed()) continue;
            try {
                bpd.set(this.value, val);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer.onEndElement", "115", this);
                throw new SAXException(e);
            }
        }
    }

    protected void processAttributes(Attributes attributes, MappingScope mappingScope, DeserializationContext context, boolean deferSet) throws SAXException {
        if (this.beanDesc == null || this.propertyMap == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            BeanPropertyDescriptor bpd;
            String localPart;
            String namespaceURI = attributes.getURI(i);
            FieldDesc fieldDesc = this.beanDesc.getFieldDesc(namespaceURI, localPart = attributes.getLocalName(i));
            if (fieldDesc == null || fieldDesc.isElement()) continue;
            String strValue = attributes.getValue(i);
            if (!deferSet && this.tryAttributeSetFromString(fieldDesc.getXmlName(), strValue) || (bpd = fieldDesc.getPropertyDescriptor()) == null || !bpd.isWriteable() || bpd.isIndexed()) continue;
            Deserializer dSer = this.getCachedDeserializer(fieldDesc, context);
            Deserializer deserializer = dSer = dSer != null ? dSer : this.getDeserializer(null, fieldDesc.getJavaType(), null, context);
            if (dSer == null) {
                throw new SAXException(Messages.getMessage("noDeser00", bpd.getType().toString()));
            }
            if (!(dSer instanceof SimpleDeserializer)) {
                throw new SAXException(Messages.getMessage("AttrNotSimpleType00", bpd.getName(), bpd.getType().toString()));
            }
            dSer.onStartElement(namespaceURI, localPart, "", NullAttributes.singleton, mappingScope, context);
            dSer.characters(strValue);
            dSer.endElement(namespaceURI, localPart, context);
            Object val = dSer.getValue();
            dSer.relinquish();
            if (deferSet) {
                if (this.deferredAttributesMap == null) {
                    this.deferredAttributesMap = new HashMap();
                }
                this.deferredAttributesMap.put(fieldDesc, val);
                continue;
            }
            try {
                bpd.set(this.value, val);
                continue;
            }
            catch (InvocationTargetException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer.processAttributes", "187", this);
                throw new SAXException(e);
            }
            catch (IllegalAccessException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer.processAttributes", "190", this);
                throw new SAXException(e);
            }
        }
    }

    protected final Deserializer getCachedDeserializer(FieldDesc field, DeserializationContext context) {
        Deserializer dSer = field.getDeserializer();
        if (dSer != null) {
            return dSer;
        }
        DeserializerFactory dSerF = null;
        try {
            dSerF = (DeserializerFactory)context.getTypeMapping().getDeserializer(field.getJavaType(), field.getXmlType());
        }
        catch (JAXRPCException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer.getCachedDeserializer", "152", this);
            log.error(Messages.getMessage("noFactory00", field.getXmlType().toString()));
        }
        if (dSerF != null) {
            field.setDeserializerFactory(dSerF);
            dSer = field.getDeserializer();
        }
        return dSer;
    }

    protected boolean tryAttributeSetFromString(QName qName, String strValue) {
        return false;
    }
}

