/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.custom;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.custom.CustomProvider;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class CustomRegistry {
    private static Log log = LogFactory.getLog(CustomRegistry.class.getName());
    private CustomRegistry parent;
    private List providers = new ArrayList();

    public CustomRegistry() {
    }

    protected CustomRegistry(CustomRegistry parent) {
        this.parent = parent;
    }

    public void populate(List providers) {
        CustomProvider[] cps = providers.toArray(new CustomProvider[0]);
        LinkedList<CustomProvider> moduleProvider = new LinkedList<CustomProvider>();
        LinkedList<CustomProvider> appProvider = new LinkedList<CustomProvider>();
        LinkedList<CustomProvider> serverProvider = new LinkedList<CustomProvider>();
        for (int i = 0; i < cps.length; ++i) {
            CustomProvider provider = cps[i];
            short scope = provider.getScope();
            if (scope == 1) {
                serverProvider.add(provider);
                continue;
            }
            if (scope == 2) {
                appProvider.add(provider);
                continue;
            }
            if (scope != 3) continue;
            moduleProvider.add(provider);
        }
        CustomRegistry parentRegistry = null;
        if (!serverProvider.isEmpty()) {
            parentRegistry = new CustomRegistry();
            for (int i = 0; i < serverProvider.size(); ++i) {
                parentRegistry.addProvider((CustomProvider)serverProvider.get(i));
            }
        }
        if (!appProvider.isEmpty()) {
            parentRegistry = new CustomRegistry(parentRegistry);
            for (int i = 0; i < appProvider.size(); ++i) {
                parentRegistry.addProvider((CustomProvider)appProvider.get(i));
            }
        }
        this.parent = parentRegistry;
        for (int i = 0; i < moduleProvider.size(); ++i) {
            this.addProvider((CustomProvider)moduleProvider.get(i));
        }
    }

    public void addProvider(CustomProvider provider) {
        if (this.pathExists(provider.getPath())) {
            if (log.isDebugEnabled()) {
                log.debug("The provider is not added because its path already exists: " + provider.getPath());
            }
        } else {
            this.providers.add(provider);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("addCustomProvider00", provider.getPath()));
            }
        }
    }

    public QName[] getQNames() {
        int i;
        HashSet<QName> qnames = new HashSet<QName>();
        if (this.parent != null) {
            QName[] qns = this.parent.getQNames();
            for (i = 0; i < qns.length; ++i) {
                qnames.add(qns[i]);
            }
        }
        CustomProvider[] pa = this.providers.toArray(new CustomProvider[0]);
        for (i = 0; i < pa.length; ++i) {
            QName[] qns = pa[i].getQNames();
            for (int j = 0; j < qns.length; ++j) {
                qnames.add(qns[j]);
            }
        }
        return qnames.toArray(new QName[0]);
    }

    public String getJavaName(QName qname, String qnameScope) {
        String localPart;
        if (qnameScope.equals("element") && !(localPart = qname.getLocalPart()).startsWith(">")) {
            localPart = ">" + localPart;
            qname = QNameTable.createQName(qname.getNamespaceURI(), localPart);
        }
        return this.getJavaName(qname);
    }

    public String getJavaName(QName qname) {
        String javaName = null;
        CustomProvider[] pa = this.providers.toArray(new CustomProvider[0]);
        for (int i = 0; i < pa.length && (javaName = pa[i].getJavaName(qname)) == null; ++i) {
        }
        if (javaName == null && this.parent != null) {
            javaName = this.parent.getJavaName(qname);
        }
        return javaName;
    }

    public QName getQName(String javaName) {
        QName qname = null;
        CustomProvider[] pa = this.providers.toArray(new CustomProvider[0]);
        for (int i = 0; i < pa.length && (qname = pa[i].getQName(javaName)) == null; ++i) {
        }
        if (qname == null && this.parent != null) {
            qname = this.parent.getQName(javaName);
        }
        return qname;
    }

    public String getBinderName(QName qname, String javaName, String qnameScope) {
        String localPart;
        if (qnameScope.equals("element") && !(localPart = qname.getLocalPart()).startsWith(">")) {
            localPart = ">" + localPart;
            qname = QNameTable.createQName(qname.getNamespaceURI(), localPart);
        }
        return this.getBinderName(qname, javaName);
    }

    public String getBinderName(QName qname, String javaName) {
        String binderName = null;
        CustomProvider[] pa = this.providers.toArray(new CustomProvider[0]);
        for (int i = 0; i < pa.length && (binderName = pa[i].getBinderName(qname, javaName)) == null; ++i) {
        }
        if (binderName == null && this.parent != null) {
            binderName = this.parent.getBinderName(qname, javaName);
        }
        return binderName;
    }

    public Properties getMappingInitParams(QName qname, String javaName) {
        Properties props = null;
        CustomProvider[] pa = this.providers.toArray(new CustomProvider[0]);
        for (int i = 0; i < pa.length && (props = pa[i].getMappingInitParams(qname, javaName)) == null; ++i) {
        }
        if (props == null && this.parent != null) {
            props = this.parent.getMappingInitParams(qname, javaName);
        }
        return props;
    }

    private boolean pathExists(String path) {
        boolean exists = false;
        CustomProvider[] pa = this.providers.toArray(new CustomProvider[0]);
        for (int i = 0; i < pa.length; ++i) {
            String p = pa[i].getPath();
            if (!p.equals(path)) continue;
            exists = true;
            break;
        }
        if (exists && log.isDebugEnabled()) {
            log.debug("The path is found at the current registry: " + path);
        }
        if (!exists && this.parent != null && (exists = this.parent.pathExists(path)) && log.isDebugEnabled()) {
            log.debug("The path is found at its parent registry: " + path);
        }
        return exists;
    }
}

