/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.utils.Callback;
import com.ibm.ws.webservices.engine.encoding.utils.CallbackTarget;
import com.ibm.ws.webservices.engine.encoding.utils.Target;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class Deserializer
extends DEventProcessor
implements javax.xml.rpc.encoding.Deserializer,
Callback {
    protected static Log log = LogFactory.getLog(Deserializer.class.getName());
    protected QName xmlType;
    protected Class javaType;
    protected Object value = null;
    protected Vector targets = null;
    protected QName defaultType = null;
    private boolean componentsReadyFlag = false;
    protected boolean isEnded = false;
    protected boolean isHref = false;
    protected boolean isNil = false;
    protected String id = null;
    private HashSet activeDeserializers = null;

    public Deserializer(Class javaType, QName xmlType) {
        this.javaType = javaType;
        this.xmlType = xmlType;
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value2) {
        this.value = value2;
    }

    public Object getValue(Object hint) {
        return null;
    }

    public void setValue(Object value2, Object hint) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("setValue of " + JavaUtils.getObjectIdentity(this) + " value=" + JavaUtils.getObjectIdentity(value2) + " hint =" + JavaUtils.getObjectIdentity(hint));
        }
        if (hint instanceof Deserializer) {
            if (this.activeDeserializers != null) {
                this.activeDeserializers.remove(hint);
            }
            if (this.componentsReady()) {
                this.valueComplete();
            }
        }
    }

    public void setDefaultType(QName qName) {
        this.defaultType = qName;
    }

    public QName getDefaultType() {
        return this.defaultType;
    }

    public void registerValueTarget(Target target) {
        if (this.targets == null) {
            this.targets = new Vector();
        }
        this.targets.addElement(target);
    }

    public Vector getValueTargets() {
        if (log.isDebugEnabled()) {
            log.debug("getValueTargets of " + JavaUtils.getObjectIdentity(this));
        }
        return this.targets;
    }

    public void removeValueTargets() {
        if (log.isDebugEnabled()) {
            log.debug("removeValueTargets of " + JavaUtils.getObjectIdentity(this));
        }
        if (this.targets != null) {
            this.targets.clear();
        }
    }

    public void moveValueTargets(Deserializer other) {
        Vector v;
        if (log.isDebugEnabled()) {
            log.debug("moveValueTargets of " + JavaUtils.getObjectIdentity(this) + " other=" + JavaUtils.getObjectIdentity(other));
        }
        if (other == null || other.getValueTargets() == null) {
            return;
        }
        if (this.targets == null) {
            this.targets = new Vector();
        }
        if ((v = other.getValueTargets()) != null) {
            for (int i = 0; i < v.size(); ++i) {
                this.targets.addElement(v.get(i));
            }
        }
        other.removeValueTargets();
    }

    public boolean componentsReady() {
        return this.componentsReadyFlag || !this.isHref && this.isEnded && (this.activeDeserializers == null || this.activeDeserializers.isEmpty());
    }

    public void valueComplete() throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("valueComplete of " + JavaUtils.getObjectIdentity(this) + " componentsReady=" + this.componentsReady());
        }
        if (this.componentsReady() && this.targets != null) {
            for (int i = 0; i < this.targets.size(); ++i) {
                Target target = (Target)this.targets.get(i);
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("setValueInTarget00", JavaUtils.getObjectIdentity(this.value), "" + JavaUtils.getObjectIdentity(target)));
                }
                target.set(this.value);
            }
            if (this.targets.size() > 0) {
                this.removeValueTargets();
                if (this.id == null) {
                    this.relinquish();
                }
            }
        }
    }

    public void addChildDeserializer(Deserializer dSer, String href) {
        if (this.activeDeserializers == null) {
            this.activeDeserializers = new HashSet();
        }
        this.activeDeserializers.add(dSer);
        CallbackTarget cb = new CallbackTarget(this, dSer);
        if (log.isDebugEnabled()) {
            log.debug("Register callback " + JavaUtils.getObjectIdentity(cb) + " for child deser " + JavaUtils.getObjectIdentity(dSer) + " on deserializer " + JavaUtils.getObjectIdentity(this));
        }
        dSer.registerValueTarget(cb);
    }

    public void startElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        this.startElement(namespace, localName, prefixedName, attributes, mappingScope, context, null);
    }

    protected final void startElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, Boolean literal) throws SAXException {
        String href;
        if (AttributeUtils.isNil(attributes)) {
            this.value = null;
            this.isNil = true;
            return;
        }
        context.logBuildNumber(this.getBuildNumber());
        String string = this.id = literal == Boolean.TRUE ? null : attributes.getValue("id");
        if (this.id != null) {
            context.getHrefTable().addObjectByID(this.id, this.value);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("deserInitPutValueDebug00", JavaUtils.getObjectIdentity(this.value), this.id));
            }
            context.getHrefTable().registerFixupByHref("#" + this.id, this);
        }
        if ((href = attributes.getValue("href")) != null) {
            this.isHref = true;
            Object ref = context.getHrefTable().getObjectByHref(href);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("gotForID00", new String[]{JavaUtils.getObjectIdentity(ref), href, ref == null ? "*null*" : ref.getClass().toString()}));
            }
            if (ref == null) {
                context.getHrefTable().registerFixupByHref(href, this);
                return;
            }
            if (ref instanceof SOAPElement) {
                context.getEventConverter().popDEventProcessor();
                context.getEventConverter().pushDEventProcessor(new WrapperProcessor(this));
                ((SOAPElement)ref).toEvents(context.getEventConverter());
                return;
            }
            if (!href.startsWith("#") && this.defaultType != null && ref instanceof Part) {
                Deserializer dser = context.getDeserializer(null, this.defaultType);
                if (null != dser) {
                    dser.startElement(namespace, localName, prefixedName, attributes, mappingScope, context);
                    ref = dser.getValue();
                    context.getMessageContext().setProperty("com.ibm.ws.webservices.engine.attachment.style", "HREF");
                }
                this.value = ref;
                this.componentsReadyFlag = true;
                this.valueComplete();
                return;
            }
            this.value = ref;
            this.componentsReadyFlag = true;
            this.valueComplete();
            return;
        }
        this.isHref = false;
        this.onStartElement(namespace, localName, prefixedName, attributes, mappingScope, context);
    }

    public void onStartElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
    }

    public abstract DEventProcessor onStartChild(String var1, String var2, String var3, Attributes var4, MappingScope var5, DeserializationContext var6) throws SAXException;

    public final void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug("start endElement of " + JavaUtils.getObjectIdentity(this));
        }
        this.isEnded = true;
        if (!this.isHref) {
            this.onEndElement(namespace, localName, context);
        }
        if (this.id != null) {
            context.getHrefTable().addObjectByID(this.id, this.value);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("deserPutValueDebug00", JavaUtils.getObjectIdentity(this.value), this.id));
            }
        }
        if (this.componentsReady()) {
            this.valueComplete();
        }
        if (log.isDebugEnabled()) {
            log.debug("end endElement of " + JavaUtils.getObjectIdentity(this));
        }
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
    }

    public boolean recycle() {
        boolean rc = super.recycle();
        if (rc) {
            if (log.isDebugEnabled()) {
                log.debug("reusing deserializer " + JavaUtils.getObjectIdentity(this));
            }
            this.value = null;
            if (this.targets != null) {
                if (log.isDebugEnabled() && this.targets.size() > 0) {
                    log.debug("PROBLEM: reusing deserializer with targets: " + this.targets.size());
                }
                this.targets.clear();
            }
            this.defaultType = null;
            this.componentsReadyFlag = false;
            this.isEnded = false;
            this.isHref = false;
            this.isNil = false;
            this.id = null;
            if (this.activeDeserializers != null) {
                if (log.isDebugEnabled() && this.activeDeserializers.size() > 0) {
                    log.debug("PROBLEM: reusing deserializer with active children deserializers: " + this.activeDeserializers.size());
                }
                this.activeDeserializers.clear();
            }
        }
        return rc;
    }

    public void relinquish() {
        if (log.isDebugEnabled()) {
            log.debug("relinquishing deserializer " + JavaUtils.getObjectIdentity(this));
        }
        this.value = null;
        super.relinquish();
    }

    public String getBuildNumber() {
        return null;
    }
}

