/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.description;

import com.ibm.ws.webservices.engine.description.BaseDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;

public class ParameterDesc
extends BaseDesc {
    public static final byte IN = 1;
    public static final byte OUT = 2;
    public static final byte INOUT = 3;
    public static String PART_NAME = "partName";
    public static String PART_QNAME_STRING = "partQNameString";
    public static String MIME_TYPE = "MIMEType";
    private Class javaType = null;
    private Class javaSigType = null;
    private String _javaType = null;
    private String _javaSigType = null;
    private QName name;
    private QName typeQName;
    private byte mode = 1;
    private int order = -1;
    private boolean isReturn = false;
    private boolean inHeader = false;
    private boolean outHeader = false;
    private boolean minOccursIs0 = false;
    private boolean maxOccursIs1 = true;
    private boolean wsdl11MIME = true;

    public ParameterDesc() {
    }

    public ParameterDesc(ParameterDesc copy) {
        this.name = copy.name;
        this.mode = copy.mode;
        this.typeQName = copy.typeQName;
        this.javaType = copy.javaType;
        this._javaType = copy._javaType;
        this.javaSigType = copy.javaSigType;
        this._javaSigType = copy._javaSigType;
        this.order = copy.order;
        this.isReturn = copy.isReturn;
        this.inHeader = copy.inHeader;
        this.outHeader = copy.outHeader;
        this.minOccursIs0 = copy.minOccursIs0;
        this.maxOccursIs1 = copy.maxOccursIs1;
        this.wsdl11MIME = copy.wsdl11MIME;
        this.setOptions(copy.getOptions());
    }

    public ParameterDesc(QName name2, byte mode, QName typeQName) {
        this.name = name2;
        this.mode = mode;
        this.typeQName = typeQName;
    }

    public ParameterDesc(QName name2, byte mode, QName typeQName, Class javaType, boolean inHeader, boolean outHeader) {
        this(name2, mode, typeQName);
        this.javaType = javaType;
        this.inHeader = inHeader;
        this.outHeader = outHeader;
    }

    public ParameterDesc(QName name2, byte mode, QName typeQName, Class javaType, boolean inHeader, boolean outHeader, boolean minOccursIs0, boolean maxOccursIs1) {
        this(name2, mode, typeQName);
        this.javaType = javaType;
        this.inHeader = inHeader;
        this.outHeader = outHeader;
        this.minOccursIs0 = minOccursIs0;
        this.maxOccursIs1 = maxOccursIs1;
    }

    public ParameterDesc(QName name2, byte mode, QName typeQName, Class javaType, boolean isReturn, boolean inHeader, boolean outHeader, boolean minOccursIs0, boolean maxOccursIs1, boolean wsdl11MIME) {
        this(name2, mode, typeQName);
        this.setJavaType(javaType);
        this.isReturn = isReturn;
        this.inHeader = inHeader;
        this.outHeader = outHeader;
        this.minOccursIs0 = minOccursIs0;
        this.maxOccursIs1 = maxOccursIs1;
        this.wsdl11MIME = wsdl11MIME;
    }

    public ParameterDesc(QName name2, byte mode, QName typeQName, String javaType, boolean isReturn, boolean inHeader, boolean outHeader, boolean minOccursIs0, boolean maxOccursIs1, boolean wsdl11MIME) {
        this(name2, mode, typeQName);
        this._javaType = javaType;
        this.isReturn = isReturn;
        this.inHeader = inHeader;
        this.outHeader = outHeader;
        this.minOccursIs0 = minOccursIs0;
        this.maxOccursIs1 = maxOccursIs1;
        this.wsdl11MIME = wsdl11MIME;
    }

    public QName getQName() {
        return this.name;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getLocalPart();
    }

    public void setName(String name2) {
        this.name = new QName("", name2);
    }

    public void setQName(QName name2) {
        this.name = name2;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName typeQName) {
        this.typeQName = typeQName;
    }

    public Class getJavaType() {
        if (this._javaType != null) {
            this.javaType = this.toClass(this._javaType);
            this._javaType = null;
        }
        return this.javaType;
    }

    public void setJavaType(Class javaType) {
        this.javaType = javaType;
        if (this.javaSigType == null && this._javaSigType == null) {
            this.javaSigType = javaType;
        }
        this._javaType = null;
        this._javaSigType = null;
    }

    public Class getJavaSigType() {
        if (this._javaSigType != null) {
            this.javaSigType = this.toClass(this._javaSigType);
            this._javaSigType = null;
        }
        return this.javaSigType;
    }

    public void setJavaSigType(Class javaSigType) {
        if (javaSigType != null && ((this.mode == 1 || this.isReturn) && Holder.class.isAssignableFrom(javaSigType) || this.mode != 1 && !this.isReturn && !Holder.class.isAssignableFrom(javaSigType))) {
            throw new IllegalArgumentException(Messages.getMessage("setJavaTypeErr00", javaSigType.getName(), ParameterDesc.getModeAsString(this.mode)));
        }
        this.javaSigType = javaSigType;
        this._javaSigType = null;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setInHeader(boolean value2) {
        this.inHeader = value2;
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    public void setOutHeader(boolean value2) {
        this.outHeader = value2;
    }

    public boolean isOutHeader() {
        return this.outHeader;
    }

    public boolean getIsReturn() {
        return this.isReturn;
    }

    public void setIsReturn(boolean value2) {
        this.isReturn = value2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ParameterDesc other = (ParameterDesc)object;
        if (this.name != null && !this.name.equals(other.name) || this.name == null && other.name != null) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        if (this.typeQName != null && !this.typeQName.equals(other.typeQName) || this.typeQName == null && other.typeQName != null) {
            return false;
        }
        if (this.javaType != other.javaType) {
            return false;
        }
        if (this.javaSigType != other.javaSigType) {
            return false;
        }
        if (this.inHeader != other.inHeader) {
            return false;
        }
        if (this.outHeader != other.outHeader) {
            return false;
        }
        if (this.minOccursIs0 != other.minOccursIs0) {
            return false;
        }
        return this.maxOccursIs1 == other.maxOccursIs1;
    }

    public int hashCode() {
        int hc = 0;
        if (this.name != null) {
            hc += this.name.hashCode();
        }
        if (this.typeQName != null) {
            hc += this.typeQName.hashCode();
        }
        if (this.javaType != null) {
            hc += this.javaType.hashCode();
        }
        return hc;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String text = "";
        text = text + indent + "identity:    " + JavaUtils.getObjectIdentity(this) + "\n";
        text = text + indent + "name:       " + this.name + "\n";
        text = text + indent + "mode:       " + (this.mode == 1 ? "IN" : (this.mode == 3 ? "INOUT" : "OUT:  position:" + this.order)) + "\n";
        text = text + indent + "isReturn:   " + this.isReturn + "\n";
        text = text + indent + "typeQName:  " + this.typeQName + "\n";
        text = text + indent + "javaType:   " + this.javaType + "\n";
        text = text + indent + "javaSigType:" + this.javaSigType + "\n";
        text = text + indent + "inHeader:   " + this.inHeader + "\n";
        text = text + indent + "outHeader:  " + this.outHeader + "\n";
        text = text + indent + "minOccursIs0:" + this.minOccursIs0 + "\n";
        text = text + indent + "maxOccursIs1:" + this.maxOccursIs1 + "\n";
        text = text + indent + "properties: \n";
        text = text + this.toStringConfigurable(indent + " ");
        return text;
    }

    public static byte modeFromString(String modeStr) {
        int ret = 1;
        if (modeStr == null) {
            return 1;
        }
        if (modeStr.equalsIgnoreCase("out")) {
            ret = 2;
        } else if (modeStr.equalsIgnoreCase("inout")) {
            ret = 3;
        }
        return (byte)ret;
    }

    public static String getModeAsString(byte mode) {
        if (mode == 3) {
            return "inout";
        }
        if (mode == 2) {
            return "out";
        }
        if (mode == 1) {
            return "in";
        }
        throw new IllegalArgumentException(Messages.getMessage("badParameterMode", Byte.toString(mode)));
    }

    public boolean isMinOccursIs0() {
        return this.minOccursIs0;
    }

    public void setMinOccursIs0(boolean minOccursIs0) {
        this.minOccursIs0 = minOccursIs0;
    }

    public boolean isMaxOccursIs1() {
        return this.maxOccursIs1;
    }

    public void setMaxOccursIs1(boolean maxOccursIs1) {
        this.maxOccursIs1 = maxOccursIs1;
    }

    public boolean isWSDL11MIME() {
        return this.wsdl11MIME;
    }

    public void setWSDL11MIME(boolean wsdl11MIME) {
        this.wsdl11MIME = wsdl11MIME;
    }

    private Class toClass(String javaType) {
        try {
            return ClassUtils.forName(javaType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isMIMEType() {
        if (this.isWSDL11MIME()) {
            String javaName = this.getJavaType().getName();
            return "java.awt.Image".equals(javaName) || "javax.xml.transform.Source".equals(javaName) || "javax.mail.internet.MimeMultipart".equals(javaName) || "javax.activation.DataHandler".equals(javaName);
        }
        return false;
    }
}

