/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd.dispatchers;

import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDispatcher;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor;
import com.ibm.ws.webservices.engine.dispatchers.java.JavaBeanDispatcher;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;

public class WSDDGenericDispatcher
extends WSDDDispatcher {
    private Class _class;

    public WSDDGenericDispatcher(String dispatcherClassname) throws ConfigurationException, ClassNotFoundException {
        if (dispatcherClassname == null) {
            throw new ConfigurationException(Messages.getMessage("noHandlerClass00"));
        }
        this._class = ClassUtils.forName(dispatcherClassname, true, Thread.currentThread().getContextClassLoader());
        if (!Handler.class.isAssignableFrom(this._class)) {
            throw new ConfigurationException(Messages.getMessage("badHandlerClass00", this._class.getName()));
        }
    }

    public WSDDGenericDispatcher(Class dispatcherClass) throws ConfigurationException {
        if (dispatcherClass == null) {
            throw new ConfigurationException(Messages.getMessage("badHandlerClass00", "<null>"));
        }
        if (!Handler.class.isAssignableFrom(dispatcherClass)) {
            throw new ConfigurationException(Messages.getMessage("badHandlerClass00", dispatcherClass.getName()));
        }
        this._class = dispatcherClass;
    }

    public Handler newDispatcherInstance(WSDDPort wsddPort, EngineConfiguration registry) throws IllegalAccessException, InstantiationException {
        JavaBeanDispatcher.setProcessor(wsddPort, SoapRPCProcessor.getProcessor());
        return (Handler)this._class.newInstance();
    }
}

