/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfo;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPHandlerChain;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleException;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleOwner;
import com.ibm.ws.webservices.engine.lifecycle.LifeCycleSetImpl;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleObject;
import com.ibm.ws.webservices.engine.lifecycle._LifeCycleSet;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.wsspi.webservices.rpc.handler.Handler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDJAXRPCHandlerInfoChain
extends WSDDElement
implements _LifeCycleObject {
    private static Log log = LogFactory.getLog(WSDDJAXRPCHandlerInfoChain.class.getName());
    private final boolean _reverse;
    private boolean _dirty = false;
    private boolean _specSemantic = true;
    private List _hiList;
    private Collection _roles;
    private List _globalHeaders;
    private _LifeCycleSet _lifeCycleSet;

    public WSDDJAXRPCHandlerInfoChain(boolean reverse) {
        this(reverse, true);
    }

    public WSDDJAXRPCHandlerInfoChain(boolean reverse, boolean specSemantic) {
        this._reverse = reverse;
        this._specSemantic = specSemantic;
        this._lifeCycleSet = this.lifeCycleSetFactory(this);
    }

    public WSDDJAXRPCHandlerInfoChain(boolean reverse, Element e) throws WSDDException {
        super(e);
        int i;
        this._reverse = reverse;
        this._lifeCycleSet = this.lifeCycleSetFactory(this);
        Element[] elements = this.getChildElements(e, "handlerInfo");
        if (elements.length != 0) {
            for (i = 0; i < elements.length; ++i) {
                this.addHandlerInfo(new WSDDJAXRPCHandlerInfo(elements[i]));
            }
        }
        if ((elements = this.getChildElements(e, "role")).length != 0) {
            this._roles = new TreeSet();
            for (i = 0; i < elements.length; ++i) {
                String role2 = elements[i].getAttribute("soapActorName");
                this._roles.add(role2);
            }
        }
    }

    protected QName getElementName() {
        return WSDDConstants.QNAME_JAXRPC_HANDLERINFOCHAIN;
    }

    public List getHandlerInfoList() {
        this._dirty = true;
        return this._hiList;
    }

    public void setHandlerInfoList(List hiList) {
        this._dirty = true;
        this._hiList = hiList;
    }

    public void addHandlerInfoList(List hiList) {
        if (hiList != null) {
            if (this._hiList == null) {
                this._hiList = new ArrayList();
            }
            this._dirty = true;
            this._hiList.addAll(hiList);
        }
    }

    public void addHandlerInfo(WSDDJAXRPCHandlerInfo hi) {
        if (hi != null) {
            if (this._hiList == null) {
                this._hiList = new ArrayList();
            }
            this._dirty = true;
            this._hiList.add(hi);
        }
    }

    public List getProtectedHeaders() {
        ArrayList<QName> protectedHeaders = new ArrayList<QName>();
        if (this._hiList != null) {
            Iterator hiIter = this._hiList.iterator();
            while (hiIter.hasNext()) {
                QName[] tempHeaders;
                WSDDJAXRPCHandlerInfo hi = (WSDDJAXRPCHandlerInfo)hiIter.next();
                if (hi == null || (tempHeaders = hi.getProtectedHeaders()) == null || tempHeaders.length == 0) continue;
                for (int i = 0; i < tempHeaders.length; ++i) {
                    protectedHeaders.add(tempHeaders[i]);
                }
            }
        }
        return protectedHeaders;
    }

    public List getAllHeaders() {
        ArrayList<QName> headers = new ArrayList<QName>();
        if (this._hiList != null) {
            Iterator hiIter = this._hiList.iterator();
            while (hiIter.hasNext()) {
                QName[] tempHeaders;
                WSDDJAXRPCHandlerInfo hi = (WSDDJAXRPCHandlerInfo)hiIter.next();
                if (hi == null || (tempHeaders = hi.getHeaders()) == null || tempHeaders.length == 0) continue;
                for (int i = 0; i < tempHeaders.length; ++i) {
                    headers.add(tempHeaders[i]);
                }
            }
        }
        return headers;
    }

    public void addGlobalHeaders(List headers) {
        if (headers != null) {
            if (this._globalHeaders == null) {
                this._globalHeaders = new ArrayList();
            }
            this._globalHeaders.addAll(headers);
        }
    }

    public List getGlobalHeaders() {
        return this._globalHeaders;
    }

    public Collection getRoles() {
        return this._roles;
    }

    public void setRoles(Collection roles) {
        this._roles = roles;
    }

    public void addRole(String role2) {
        if (this._roles == null) {
            this._roles = new TreeSet();
        }
        this._roles.add(role2);
    }

    public void addRoles(Collection roles) {
        if (roles != null) {
            if (this._roles == null) {
                this._roles = new TreeSet();
            }
            this._roles.addAll(roles);
        }
    }

    public HandlerChain getHandlerChain() {
        if (this._dirty) {
            this.sort();
        }
        ArrayList<ExtendedHandlerInfo> infoList = new ArrayList<ExtendedHandlerInfo>();
        if (this._hiList != null) {
            for (int i = 0; i < this._hiList.size(); ++i) {
                WSDDJAXRPCHandlerInfo handlerInfo = (WSDDJAXRPCHandlerInfo)this._hiList.get(i);
                try {
                    ExtendedHandlerInfo hi = handlerInfo.getHandlerInfo();
                    if (hi == null) continue;
                    infoList.add(hi);
                    continue;
                }
                catch (ClassNotFoundException cnf) {
                    FFDCFilter.processException((Throwable)cnf, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDJAXRPCHandlerInfoChain.getHandlerChain", "109", null);
                    log.warn(Messages.getMessage("jaxRpcHandlerLoadFailed00", handlerInfo.getHandlerClassName()), cnf);
                }
            }
        }
        return this._specSemantic ? new SOAPHandlerChain(infoList, this._roles) : new JAXRPCHandlerChain(infoList, this._roles);
    }

    public int size() {
        return this._hiList == null ? 0 : this._hiList.size();
    }

    private void sort() {
        if (this._hiList != null) {
            int i;
            if (this._reverse) {
                Collections.sort(this._hiList, Collections.reverseOrder());
                int max2 = this._hiList.size() - 1;
                for (int i2 = 0; i2 <= max2; ++i2) {
                    WSDDJAXRPCHandlerInfo handler2 = (WSDDJAXRPCHandlerInfo)this._hiList.get(i2);
                    handler2.putHandlerMap(Handler.HANDLER_PARAM_POSITION, String.valueOf(max2 - i2));
                }
            } else {
                Collections.sort(this._hiList);
                for (i = 0; i < this._hiList.size(); ++i) {
                    WSDDJAXRPCHandlerInfo handler3 = (WSDDJAXRPCHandlerInfo)this._hiList.get(i);
                    handler3.putHandlerMap(Handler.HANDLER_PARAM_POSITION, String.valueOf(i));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("HandlerInfoChain: reverse=" + this._reverse);
                for (i = 0; i < this._hiList.size(); ++i) {
                    WSDDJAXRPCHandlerInfo handler4 = (WSDDJAXRPCHandlerInfo)this._hiList.get(i);
                    log.debug("Handler: name=" + handler4.getName() + ", class=" + handler4.getHandlerClassName() + ", priority=" + handler4.getPriority() + ", poolMin=" + handler4.getMinPoolSize() + ", poolMax=" + handler4.getMaxPoolSize());
                }
            }
            this._dirty = false;
        }
    }

    public void writeToContext(SerializationContext context) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "reverse", "reverse", "CDATA", String.valueOf(this._reverse));
        attrs.addAttribute("", "specSemantic", "specSemantic", "CDATA", String.valueOf(this._specSemantic));
        context.getSerializationWriter().startElement(QNAME_JAXRPC_HANDLERINFOCHAIN, attrs);
        if (this._dirty) {
            this.sort();
        }
        if (this._hiList != null) {
            Iterator hiIter = this._hiList.iterator();
            while (hiIter.hasNext()) {
                WSDDJAXRPCHandlerInfo hi = (WSDDJAXRPCHandlerInfo)hiIter.next();
                hi.writeToContext(context);
            }
        }
        if (this._roles != null && this._roles.size() > 0) {
            Iterator rIter = this._roles.iterator();
            while (rIter.hasNext()) {
                AttributesImpl attrs1 = new AttributesImpl();
                attrs1.addAttribute("", "soapActorName", "soapActorName", "CDATA", (String)rIter.next());
                context.getSerializationWriter().simpleElement(QNAME_JAXRPC_ROLE, attrs1, null);
            }
        } else {
            context.getSerializationWriter().simpleElement(QNAME_JAXRPC_ROLE, null, null);
        }
        context.getSerializationWriter().endElement();
    }

    protected LifeCycleSetImpl lifeCycleSetFactory(_LifeCycleObject container) {
        return new LifeCycleSetImpl(container, true, false);
    }

    public void setOwner(LifeCycleOwner owner) throws LifeCycleException {
        this._lifeCycleSet.setOwner(owner);
    }

    public LifeCycleOwner getOwner() {
        return this._lifeCycleSet.getOwner();
    }

    public final void init() throws LifeCycleException {
        this._lifeCycleSet.init();
    }

    public void _init() throws LifeCycleException {
        this._lifeCycleSet._init();
    }

    public final void destroy() {
        this._lifeCycleSet.destroy();
    }

    public void _destroy() {
        if (this._hiList != null) {
            this._hiList.clear();
            this._hiList = null;
        }
        this._roles = null;
        this._lifeCycleSet._destroy();
    }

    public int getState() {
        return this._lifeCycleSet.getState();
    }

    public boolean isActive() {
        return this._lifeCycleSet.isActive();
    }

    public void verifyActive() throws LifeCycleException {
        this._lifeCycleSet.verifyActive();
    }

    public void verifyInactive() throws LifeCycleException {
        this._lifeCycleSet.verifyInactive();
    }
}

