/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDUndeployment;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDDDocument
extends WSDDConstants {
    protected static Log log = LogFactory.getLog(WSDDDocument.class.getName());
    private Document doc;
    private WSDDDeployment deployment;
    private WSDDUndeployment undeployment;

    public WSDDDocument() {
    }

    public WSDDDocument(int modeClientServer, Document doc) throws WSDDException {
        this.doc = doc;
        Element docEl = doc.getDocumentElement();
        if ("undeployment".equals(docEl.getLocalName())) {
            this.undeployment = new WSDDUndeployment(docEl);
        } else {
            this.deployment = new WSDDDeployment(modeClientServer, docEl);
        }
    }

    public WSDDDocument(int modeClientServer, Element e) throws WSDDException {
        this.doc = e.getOwnerDocument();
        if ("undeployment".equals(e.getLocalName())) {
            this.undeployment = new WSDDUndeployment(e);
        } else {
            this.deployment = new WSDDDeployment(modeClientServer, e);
        }
    }

    public WSDDDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = new WSDDDeployment();
        }
        return this.deployment;
    }

    public Document getDOMDocument() throws ConfigurationException {
        StringWriter sw = new StringWriter();
        BufferedWriter writer = new BufferedWriter(sw);
        SerializationContextImpl context = new SerializationContextImpl(writer, null);
        context.getSerializationWriter().setPretty(true);
        try {
            this.deployment.writeToContext(context);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDocument.getDOMDocument", "159", this);
            log.error(Messages.getMessage("exception00"), e);
        }
        try {
            ((Writer)writer).close();
            return XMLUtils.newDocument(new InputSource(new StringReader(sw.getBuffer().toString())));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void writeToContext(SerializationContext context) throws IOException {
        this.getDeployment().writeToContext(context);
    }

    public void setDocument(Document document) {
        this.doc = document;
        this.deployment = null;
    }

    public void deploy(WSDDDeployment registry) throws ConfigurationException {
        if (this.deployment != null) {
            this.deployment.deployToRegistry(registry);
        }
        if (this.undeployment != null) {
            this.undeployment.undeployFromRegistry(registry);
        }
    }
}

