/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.configuration;

import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.NullEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistryImpl;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;

public class SimpleEngineConfigurationProvider
extends NullEngineConfigurationProvider
implements EngineConfiguration {
    protected static Log log = LogFactory.getLog(SimpleEngineConfigurationProvider.class.getName());
    private HashMap _transports = new HashMap();
    private HashMap _soapPorts = new HashMap();
    private TypeMappingRegistry _tmr = null;
    private final EngineConfiguration _defaultConfiguration;

    public SimpleEngineConfigurationProvider() {
        this(null);
    }

    public SimpleEngineConfigurationProvider(EngineConfiguration defaultCfg) {
        EngineConfiguration engineConfiguration = this._defaultConfiguration = defaultCfg != null ? defaultCfg : this.defaultEngineConfigurationFactory();
        if (this._defaultConfiguration != null) {
            this.manageLifeCycleOf(this._defaultConfiguration);
        }
    }

    protected EngineConfiguration defaultEngineConfigurationFactory() {
        return null;
    }

    public EngineConfiguration getDefaultEngineConfiguration() {
        return this._defaultConfiguration;
    }

    public Map getGlobalOptions() throws ConfigurationException {
        if (this._defaultConfiguration != null) {
            return this._defaultConfiguration.getGlobalOptions();
        }
        return null;
    }

    public SimpleTargetedChain getGlobalHandler() throws ConfigurationException {
        if (this._defaultConfiguration != null) {
            return this._defaultConfiguration.getGlobalHandler();
        }
        return null;
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        if (this._tmr != null) {
            return this._tmr;
        }
        if (this._defaultConfiguration != null) {
            return this._defaultConfiguration.getTypeMappingRegistry();
        }
        this._tmr = new TypeMappingRegistryImpl();
        return this._tmr;
    }

    public TypeMapping getTypeMapping(String encodingStyle) throws ConfigurationException {
        return (TypeMapping)this.getTypeMappingRegistry().getTypeMapping(encodingStyle);
    }

    public Handler getTransport(QName qname) throws ConfigurationException {
        Handler transport2 = (Handler)this._transports.get(qname);
        if (this._defaultConfiguration != null && transport2 == null) {
            transport2 = this._defaultConfiguration.getTransport(qname);
        }
        return transport2;
    }

    public SOAPPort getPort(QName qname) throws ConfigurationException {
        SOAPPort service = (SOAPPort)this._soapPorts.get(qname);
        if (this._defaultConfiguration != null && service == null) {
            service = this._defaultConfiguration.getPort(qname);
        }
        return service;
    }

    public SOAPPort getPortByNamespaceURI(String namespace) throws ConfigurationException {
        SOAPPort soapPort = (SOAPPort)this._soapPorts.get(QNameTable.createQName("", namespace));
        if (soapPort == null && this._defaultConfiguration != null) {
            soapPort = this._defaultConfiguration.getPortByNamespaceURI(namespace);
        }
        return soapPort;
    }

    public void deployPort(QName qname, SOAPPort soapPort) {
        SOAPPort oldSoapPort = (SOAPPort)this._soapPorts.get(qname);
        if (oldSoapPort != null && this.releaseLifeCycleManagementOf(oldSoapPort) && oldSoapPort.isActive()) {
            oldSoapPort.destroy();
        }
        if (soapPort != null) {
            this._soapPorts.put(qname, soapPort);
            this.manageLifeCycleOf(soapPort);
        }
    }

    public void deployPort(String name2, SOAPPort soapPort) {
        this.deployPort(QNameTable.createQName(null, name2), soapPort);
    }

    public void deployTransport(QName qname, SimpleTargetedChain transport2) {
        Handler oldTransport = (Handler)this._transports.get(qname);
        if (oldTransport != null && this.releaseLifeCycleManagementOf(oldTransport) && oldTransport.isActive()) {
            oldTransport.destroy();
        }
        if (transport2 != null) {
            this._transports.put(qname, transport2);
            this.manageLifeCycleOf(transport2);
        }
    }

    public void deployTransport(String name2, SimpleTargetedChain transport2) {
        this.deployTransport(QNameTable.createQName(null, name2), transport2);
    }

    public Iterator getDeployedPorts() throws ConfigurationException {
        ArrayList<PortDesc> portDescs = new ArrayList<PortDesc>();
        Iterator i = this._soapPorts.values().iterator();
        while (i.hasNext()) {
            SOAPPort port2 = (SOAPPort)i.next();
            portDescs.add(port2.getPortDesc());
        }
        return portDescs.iterator();
    }
}

