/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.NoEndPointException;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.MimeUtils;
import com.ibm.ws.webservices.engine.client.Connection;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.client.Transport;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.custom.Utils;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.enum.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.session.SessionContext;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.multiprotocol.utils.WSDLFactoryImpl;
import com.ibm.ws.webservices.tools.WSDLQuery;
import com.ibm.ws.webservices.wsdl.query.WsdlImportResolver;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.Metadata;
import com.ibm.wsspi.wsaddressing.ServiceName;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.w3c.dom.Document;

public class Call
implements com.ibm.wsspi.webservices.rpc.Call {
    protected static Log log = LogFactory.getLog(Call.class.getName());
    protected static Log entLog = LogFactory.getLog("com.ibm.ws.webservices.engine.enterprise");
    protected SessionContext cachedSessionContext = null;
    private boolean parmAndRetReq = true;
    private Service service = null;
    private MessageContext msgContext = null;
    private Connection connection = null;
    private OperationDesc operation = new OperationDesc();
    private Vector myHeaders = null;
    private Map outParams = null;
    private ArrayList outParamsList = null;
    private boolean invokeOneWayCalled = false;
    private boolean customBinderLoaded = false;
    private WSDLQuery wsdlQuery = null;
    private boolean wsdlQueryUnavailable = false;
    private boolean wsdlQueryReloadOp = false;
    public static final boolean FAULT_ON_NO_RESPONSE = false;
    public static final String SEND_TYPE_ATTR = "send_type_attr";
    public static final String TIMEOUT = "timeout";
    public static final String TRANSPORT_NAME = "transport_name";
    public static final String WSDL_PORT_NAME = "wsdl.portName";
    public static final String OPERATION_USE_PROPERTY = "operation_use";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT = "attachment_encapsulation_format";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT_MIME = "webservices.attachment.style.mime";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT_DIME = "webservices.attachment.style.dime";
    private static ArrayList propertyNames = new ArrayList();
    protected Vector attachmentParts = new Vector();

    public Call(Service service) {
        this.service = service;
        this.msgContext = new MessageContext(service.getEngine());
        this.msgContext.setProperty("javax.xml.rpc.session.maintain", new Boolean(service.getMaintainSession()));
        this.msgContext.setOperation(this.operation);
    }

    public Call(String url) throws MalformedURLException {
        this(new Service());
        this.setTargetEndpointAddress(new URL(url));
    }

    public Call(URL url) {
        this(new Service());
        this.setTargetEndpointAddress(url);
    }

    public void setProperty(String name2, Object value2) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.setProperty()  " + name2);
        }
        if ("javax.xml.rpc.service.endpoint.address".equals(name2)) {
            this.setTargetEndpointAddress((String)value2);
        } else if ("com.ibm.websphere.wsaddressing.destinationEPR".equals(name2)) {
            this.msgContext.setProperty(name2, value2);
            EndpointReference epr = (EndpointReference)value2;
            AttributedURI auri = epr.getAddress();
            if (auri != null) {
                URI uri = auri.getURI();
                if (uri != null) {
                    String uriString = uri.toString();
                    if (entLog.isDebugEnabled()) {
                        entLog.debug("Setting based on WSADDRESSING_DESTINATION_EPR address:" + uriString);
                    }
                    this.setTargetEndpointAddress(uriString);
                } else if (entLog.isDebugEnabled()) {
                    entLog.debug("WSADDRESSING_DESTINATION_EPR address (URI) is null.");
                }
            } else if (entLog.isDebugEnabled()) {
                entLog.debug("WSADDRESSING_DESTINATION_EPR address (AttributedURI) is null.");
            }
            Metadata met = epr.getMetadata();
            if (met != null) {
                ServiceName sn;
                if (entLog.isDebugEnabled()) {
                    entLog.debug("Metadata Found. Checking Service and Endpoint Name");
                }
                if ((sn = met.getServiceName()) != null) {
                    String epname;
                    if (entLog.isDebugEnabled()) {
                        entLog.debug("ServiceName found in Metadata");
                    }
                    QName sername = sn.getQName();
                    QName wsdlServiceName = this.service.getServiceName();
                    if (wsdlServiceName == null) {
                        if (entLog.isDebugEnabled()) {
                            entLog.debug("No ServiceName available from Service. Not checking.");
                        }
                    } else if (!wsdlServiceName.equals(sername)) {
                        String eprSername = sername == null ? "null" : sername.toString();
                        throw new JAXRPCException(Messages.getMessage("MismatchedServiceName", eprSername, wsdlServiceName.toString()));
                    }
                    if ((epname = sn.getEndpointName()) != null) {
                        QName epPort = new QName(epname);
                        QName existingPort = this.getPortName();
                        if (existingPort != null) {
                            if (!existingPort.equals(epPort)) {
                                String epPortStr = epPort == null ? "null" : epPort.toString();
                                throw new JAXRPCException(Messages.getMessage("MismatchedPortName", epPortStr, existingPort.toString()));
                            }
                        } else {
                            if (entLog.isDebugEnabled()) {
                                entLog.debug("EndpointName found in Metadata. Setting PortName to " + epname);
                            }
                            this.setPortName(new QName(epname));
                        }
                    }
                }
            }
        } else {
            this.msgContext.setProperty(name2, value2);
        }
        if ("noDataBinding".equals(name2) || "jaxrpcMappingFile".equals(name2)) {
            this.wsdlQuery = null;
            this.wsdlQueryUnavailable = false;
            this.wsdlQueryReloadOp = true;
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.setProperty()");
        }
    }

    public Object getProperty(String name2) {
        if (name2 == null || !this.isPropertySupported(name2)) {
            throw new JAXRPCException(name2 == null ? Messages.getMessage("badProp03") : Messages.getMessage("badProp05", name2));
        }
        return this.msgContext.getProperty(name2);
    }

    public void removeProperty(String name2) {
        if (name2 == null || !this.isPropertySupported(name2)) {
            throw new JAXRPCException(name2 == null ? Messages.getMessage("badProp03") : Messages.getMessage("badProp05", name2));
        }
        this.msgContext.removeProperty(name2);
    }

    public Iterator getPropertyNames() {
        return propertyNames.iterator();
    }

    public boolean isPropertySupported(String name2) {
        return propertyNames.contains(name2) || !name2.startsWith("java.") && !name2.startsWith("javax.");
    }

    public void setUsername(String username) {
        this.msgContext.setUsername(username);
    }

    public String getUsername() {
        return this.msgContext.getUsername();
    }

    public void setPassword(String password) {
        this.msgContext.setPassword(password);
    }

    public String getPassword() {
        return this.msgContext.getPassword();
    }

    public void setMaintainSession(boolean yesno) {
        this.msgContext.setMaintainSession(yesno);
    }

    public boolean getMaintainSession() {
        return this.msgContext.getMaintainSession();
    }

    public void setOperationStyle(String operationStyle) {
        this.msgContext.setOperationStyle(operationStyle);
    }

    public Style getOperationStyle() {
        return this.msgContext.getOperationStyle();
    }

    public String getOperationStyleString() {
        return this.msgContext.getOperationStyleString();
    }

    public void setOperationUse(String operationUse) {
        this.msgContext.setOperationUse(operationUse);
    }

    public com.ibm.ws.webservices.engine.enum.Use getOperationUse() {
        return this.msgContext.getOperationUse();
    }

    public String getOperationUseString() {
        return this.msgContext.getOperationUseString();
    }

    public void setUseSOAPAction(boolean useSOAPAction) {
        this.msgContext.setUseSOAPAction(useSOAPAction);
    }

    public boolean useSOAPAction() {
        return this.msgContext.useSOAPAction();
    }

    public void setSOAPActionURI(String SOAPActionURI) throws IllegalArgumentException {
        this.msgContext.setSOAPActionURI(SOAPActionURI);
    }

    public String getSOAPActionURI() {
        return this.msgContext.getSOAPActionURI();
    }

    public void setEncodingStyle(String namespaceURI) {
        this.msgContext.setEncodingStyle(namespaceURI);
    }

    public String getEncodingStyle() {
        return this.msgContext.getEncodingStyle();
    }

    public void setTargetEndpointAddress(String address) {
        URL urlAddress;
        try {
            urlAddress = new URL(address);
        }
        catch (MalformedURLException mue) {
            FFDCFilter.processException((Throwable)mue, "com.ibm.ws.webservices.engine.client.Call.setTargetEndpointAddress", "555", this);
            throw new JAXRPCException(mue);
        }
        this.setTargetEndpointAddress(urlAddress);
    }

    public void setTargetEndpointAddress(URL address) {
        this.msgContext.setTargetEndpointAddress(address);
        this.connection = this.service.getConnection(address);
    }

    public String getTargetEndpointAddress() {
        return (String)this.msgContext.getProperty("javax.xml.rpc.service.endpoint.address");
    }

    public URL getTargetEndpointAddressAsURL() {
        return this.msgContext.getTargetEndpointAddressAsURL();
    }

    public Integer getTimeout() {
        return (Integer)this.msgContext.getProperty(TIMEOUT);
    }

    public Integer getWriteTimeout() {
        return (Integer)this.msgContext.getProperty("write_timeout");
    }

    public void setTimeout(Integer timeout) {
        this.msgContext.setTimeout(timeout);
    }

    public void setWriteTimeout(Integer timeout) {
        this.msgContext.setWriteTimeout(timeout);
    }

    public String getTransportName() {
        return (String)this.getProperty(TRANSPORT_NAME);
    }

    public void setTransportName(String transportName) {
        if (transportName != null) {
            this.setProperty(TRANSPORT_NAME, transportName);
        }
    }

    public boolean isParameterAndReturnSpecRequired(QName operationName) {
        return this.parmAndRetReq;
    }

    public void addParameter(QName paramName, QName xmlType, ParameterMode parameterMode) {
        Class javaType = null;
        TypeMapping tm = this.getTypeMapping();
        if (tm != null) {
            javaType = tm.getClassForQName(xmlType);
        }
        this.addParameter(paramName, xmlType, javaType, parameterMode);
    }

    public void addParameter(QName paramName, QName xmlType, Class javaType, ParameterMode parameterMode) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.addParameter()  " + paramName.toString());
        }
        ParameterDesc param = new ParameterDesc();
        param.setQName(paramName);
        param.setTypeQName(xmlType);
        param.setJavaType(javaType);
        byte mode = 1;
        if (parameterMode == ParameterMode.INOUT) {
            mode = 3;
        } else if (parameterMode == ParameterMode.OUT) {
            mode = 2;
        }
        param.setMode(mode);
        this.operation.addParameter(param);
        this.parmAndRetReq = true;
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.addParameter()");
        }
    }

    public void addParameter(String paramName, QName xmlType, ParameterMode parameterMode) {
        Class javaType = null;
        TypeMapping tm = this.getTypeMapping();
        if (tm != null) {
            javaType = tm.getClassForQName(xmlType);
        }
        this.addParameter(QNameTable.createQName("", paramName), xmlType, javaType, parameterMode);
    }

    public void addParameter(String paramName, QName xmlType, Class javaType, ParameterMode parameterMode) {
        this.addParameter(QNameTable.createQName("", paramName), xmlType, javaType, parameterMode);
    }

    public void addParameterAsHeader(QName paramName, QName xmlType, Class javaType, ParameterMode parameterMode, ParameterMode headerMode) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.addParameterAsHeader()  " + paramName.toString());
        }
        ParameterDesc param = new ParameterDesc();
        param.setQName(paramName);
        param.setTypeQName(xmlType);
        param.setJavaType(javaType);
        if (parameterMode == ParameterMode.IN) {
            param.setMode((byte)1);
        } else if (parameterMode == ParameterMode.INOUT) {
            param.setMode((byte)3);
        } else if (parameterMode == ParameterMode.OUT) {
            param.setMode((byte)2);
        }
        if (headerMode == ParameterMode.IN) {
            param.setInHeader(true);
        } else if (headerMode == ParameterMode.INOUT) {
            param.setInHeader(true);
            param.setOutHeader(true);
        } else if (headerMode == ParameterMode.OUT) {
            param.setOutHeader(true);
        }
        this.operation.addParameter(param);
        this.parmAndRetReq = true;
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.addParameterAsHeader()");
        }
    }

    public QName getParameterTypeByName(String paramName) {
        QName paramQName = QNameTable.createQName("", paramName);
        return this.getParameterTypeByQName(paramQName);
    }

    public QName getParameterTypeByQName(QName paramQName) {
        ParameterDesc param = this.operation.getParamByQName(paramQName);
        if (param != null) {
            return param.getTypeQName();
        }
        return null;
    }

    public void setReturnType(QName type) {
        TypeMapping tm = this.getTypeMapping();
        Class javaType = tm.getClassForQName(type);
        this.setReturnType(type, javaType);
    }

    public void setReturnType(QName xmlType, Class javaType) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.setReturnType() " + (xmlType == null ? "null" : xmlType.getLocalPart()));
        }
        this.operation.setReturnType(xmlType);
        this.operation.setReturnClass(javaType);
        this.parmAndRetReq = true;
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.setReturnType() ");
        }
    }

    public void setReturnTypeAsHeader(QName xmlType) {
        this.setReturnType(xmlType);
        this.operation.setReturnHeader(true);
    }

    public void setReturnTypeAsHeader(QName xmlType, Class javaType) {
        this.setReturnType(xmlType, javaType);
        this.operation.setReturnHeader(true);
    }

    public QName getReturnType() {
        return this.operation.getReturnType();
    }

    public void setReturnQName(QName qname) {
        this.operation.setReturnQName(qname);
    }

    public void setReturnClass(Class cls) {
        QName qname = this.getTypeMapping().getTypeQName(cls);
        this.setReturnType(qname, cls);
    }

    public void removeAllParameters() {
        this.operation.removeParameters();
        this.parmAndRetReq = true;
    }

    public QName getOperationName() {
        return this.operation.getElementQName();
    }

    public void setOperationName(QName opName) {
        this.operation.setElementQName(opName);
    }

    public void setOperationName(String opName) {
        this.operation.setElementQName(QNameTable.createQName("", opName));
    }

    public void setOperation(QName portName, String opName) {
        this.setOperation(portName, opName, null);
    }

    public void setOperation(QName portName, String opName, String inMsgName) {
        QName type;
        BindingInput bIn;
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.setOperation()  " + opName);
        }
        if (this.service == null) {
            throw new JAXRPCException(Messages.getMessage("noService04"));
        }
        this.setPortName(portName);
        this.setEncodingStyle(null);
        this.removeAllParameters();
        this.setOperationName(opName);
        javax.wsdl.Service wsdlService = this.service.getWSDLService();
        if (wsdlService == null) {
            return;
        }
        Port port2 = wsdlService.getPort(portName.getLocalPart());
        if (port2 == null) {
            throw new JAXRPCException(Messages.getMessage("noPortType00", "" + this.getPortName()));
        }
        Binding binding = port2.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new JAXRPCException(Messages.getMessage("noPortType00", "" + this.getPortName()));
        }
        List operations = portType.getOperations();
        if (operations == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation01", opName));
        }
        Operation op = null;
        for (int i = 0; i < operations.size() && !opName.equals((op = (Operation)operations.get(i)).getName()); ++i) {
            op = null;
        }
        if (op == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation01", opName));
        }
        List list = port2.getExtensibilityElements();
        for (int i = 0; list != null && i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof SOAPAddress)) continue;
            try {
                SOAPAddress addr = (SOAPAddress)obj;
                URL url = new URL(addr.getLocationURI());
                this.setTargetEndpointAddress(url);
                continue;
            }
            catch (Exception exp) {
                FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.client.Call.setOperation", "1044", this);
                throw new JAXRPCException(Messages.getMessage("cantSetURI00", "" + exp));
            }
        }
        BindingOperation bop = binding.getBindingOperation(opName, inMsgName, null);
        if (bop == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation02", opName));
        }
        list = bop.getExtensibilityElements();
        for (int i = 0; list != null && i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof SOAPOperation)) continue;
            SOAPOperation sop = (SOAPOperation)obj;
            String action = sop.getSoapActionURI();
            if (action != null) {
                this.setUseSOAPAction(true);
                this.setSOAPActionURI(action);
                break;
            }
            this.setUseSOAPAction(false);
            this.setSOAPActionURI(null);
            break;
        }
        if ((bIn = bop.getBindingInput()) != null) {
            list = bIn.getExtensibilityElements();
            for (int i = 0; list != null && i < list.size(); ++i) {
                String ns;
                Object obj = list.get(i);
                if (obj instanceof MIMEMultipartRelated) {
                    MIMEMultipartRelated mpr = (MIMEMultipartRelated)obj;
                    Object part = null;
                    List l = mpr.getMIMEParts();
                    for (int j = 0; l != null && j < l.size() && part == null; ++j) {
                        MIMEPart mp2 = (MIMEPart)l.get(j);
                        List ll = mp2.getExtensibilityElements();
                        for (int k = 0; ll != null && k < ll.size() && part == null; ++k) {
                            part = ll.get(k);
                            if (part instanceof SOAPBody) continue;
                            part = null;
                        }
                    }
                    if (null != part) {
                        obj = part;
                    }
                }
                if (!(obj instanceof SOAPBody)) continue;
                SOAPBody sBody = (SOAPBody)obj;
                list = sBody.getEncodingStyles();
                if (list != null && list.size() > 0) {
                    this.setEncodingStyle((String)list.get(0));
                }
                if ((ns = sBody.getNamespaceURI()) == null || ns.equals("")) break;
                this.setOperationName(QNameTable.createQName(ns, opName));
                break;
            }
        }
        List paramOrder = op.getParameterOrdering();
        Input input = op.getInput();
        javax.wsdl.Message message = null;
        List parts = null;
        if (input != null) {
            message = input.getMessage();
        }
        if (message != null) {
            parts = message.getOrderedParts(paramOrder);
        }
        if (parts != null) {
            for (int i = 0; i < parts.size(); ++i) {
                Part part = (Part)parts.get(i);
                if (part == null) continue;
                String name2 = part.getName();
                type = part.getTypeName();
                if (type == null) {
                    type = part.getElementName();
                    if (type != null) {
                        type = QNameTable.createQName("java", "org.w3c.dom.Element");
                    } else {
                        throw new JAXRPCException(Messages.getMessage("typeNotSet00", name2));
                    }
                }
                QName qname = QNameTable.createQName(type.getNamespaceURI(), type.getLocalPart());
                ParameterMode mode = ParameterMode.IN;
                this.addParameter(name2, qname, mode);
            }
        }
        Output output = op.getOutput();
        message = null;
        parts = null;
        if (output != null) {
            message = output.getMessage();
        }
        if (message != null) {
            parts = message.getOrderedParts(null);
        }
        if (output != null && this.operation != null && this.operation.getNumParams() > 0) {
            this.setReturnType(Constants.WEBSERVICES_VOID);
        }
        if (parts != null) {
            for (int i = 0; i < parts.size(); ++i) {
                Part part = (Part)parts.get(i);
                if (paramOrder != null && paramOrder.contains(part.getName())) continue;
                type = part.getTypeName();
                if (type == null) {
                    type = part.getElementName();
                    if (type != null) {
                        type = QNameTable.createQName("java", "org.w3c.dom.Element");
                    } else {
                        throw new JAXRPCException(Messages.getMessage("typeNotSet00", "<return>"));
                    }
                }
                QName qname = QNameTable.createQName(type.getNamespaceURI(), type.getLocalPart());
                this.setReturnType(qname);
                break;
            }
        }
        this.loadOperationFromWSDL(portName.getLocalPart(), opName);
        this.parmAndRetReq = false;
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.setOperation()");
        }
    }

    public QName getPortName() {
        return this.msgContext.getPortName();
    }

    public void setPortName(QName portName) {
        this.msgContext.setPortName(portName);
    }

    public QName getPortTypeName() {
        QName portName = this.getPortName();
        return portName == null ? QNameTable.createQName("", "") : portName;
    }

    public void setPortTypeName(QName portType) {
        this.setPortName(portType);
    }

    public void setSOAPVersion(SOAPConstants soapConstants) {
        this.msgContext.setSOAPConstants(soapConstants);
    }

    public Object invoke(QName operationName, Object[] params) throws RemoteException {
        this.operation.setElementQName(operationName);
        return this.invoke(params);
    }

    public Object invoke(Object[] params) throws RemoteException {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.invoke(Object[])  " + this.operation.getElementQName().toString());
        }
        if (!this.invokeOneWayCalled && this.operation.getReturnClass() == null) {
            this.setReturnType(Constants.WEBSERVICES_VOID);
        }
        if (this.operation.getElementQName() == null) {
            throw new WebServicesFault(Messages.getMessage("noOperation00"));
        }
        this.validateTargetEndpointAddress();
        this.syncProperties();
        try {
            QName portQName;
            QName qName = portQName = this.msgContext == null ? null : this.msgContext.getWSDLPort();
            if (this.wsdlQueryReloadOp && portQName != null) {
                this.loadOperationFromWSDL(portQName.getLocalPart(), this.operation.getElementQName().getLocalPart());
                this.wsdlQueryReloadOp = false;
            } else {
                this.copyOptionsFromWSDLOperation(portQName, this.operation.getElementQName());
            }
            this.msgContext.protectProperties();
            if (this.cachedSessionContext != null) {
                this.msgContext.setProperty("com.ibm.ws.webservices.engine.session.context", this.cachedSessionContext);
            }
            Vector res = this.connection.invoke(this.msgContext, params, this.myHeaders, this.attachmentParts);
            Object sessionContext = this.msgContext.getProperty("com.ibm.ws.webservices.engine.session.context");
            if (sessionContext != null) {
                this.cachedSessionContext = (SessionContext)sessionContext;
            }
            this.msgContext.resetProperties();
            Object ret = this.sortOutputs(res);
            Class returnClass = this.operation.getReturnClass();
            if (returnClass != null) {
                ret = JavaUtils.convert(ret, returnClass);
            }
            if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                log.debug("Exit Call.invoke(Object[])");
            }
            return ret;
        }
        catch (WebServicesFault af) {
            FFDCFilter.processException((Throwable)af, "com.ibm.ws.webservices.engine.client.Call.invoke", "1335", this);
            throw af;
        }
        catch (Exception exp) {
            FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.client.Call.invoke", "1339", this);
            if (entLog.isDebugEnabled()) {
                entLog.debug(Messages.getMessage("toWebServicesFault00"), exp);
            }
            throw new WebServicesFault(Messages.getMessage("errorInvoking00", "\n" + exp));
        }
    }

    private Object sortOutputs(Vector resArgs) throws WebServicesFault {
        Object result = null;
        this.outParams = new HashMap();
        this.outParamsList = new ArrayList();
        if (resArgs != null && resArgs.size() > 0) {
            int outParamStart = 0;
            boolean findReturnParam = false;
            QName returnParamQName = this.operation.getReturnQName();
            if (!Constants.WEBSERVICES_VOID.equals(this.operation.getReturnType())) {
                if (returnParamQName == null) {
                    ParamValue param = (ParamValue)resArgs.get(0);
                    result = param.getValue();
                    outParamStart = 1;
                } else {
                    findReturnParam = true;
                }
            }
            for (int i = outParamStart; i < resArgs.size(); ++i) {
                ParamValue param = (ParamValue)resArgs.get(i);
                Class javaType = this.getJavaTypeForQName(param.getQName());
                Object value2 = param.getValue();
                if (javaType != null && value2 != null && !javaType.isAssignableFrom(value2.getClass())) {
                    value2 = JavaUtils.convert(value2, javaType);
                }
                if (findReturnParam && returnParamQName.equals(param.getQName())) {
                    result = value2;
                    findReturnParam = false;
                    continue;
                }
                this.outParams.put(param.getQName().getLocalPart(), value2);
                this.outParamsList.add(value2);
            }
            if (findReturnParam) {
                String returnParamName = returnParamQName.toString();
                throw new WebServicesFault(Messages.getMessage("noReturnParam", returnParamName));
            }
        }
        return result;
    }

    private Class getJavaTypeForQName(QName name2) {
        ParameterDesc param = this.operation.getOutputParamByQName(name2);
        return param == null ? null : param.getJavaType();
    }

    public void invokeOneWay(Object[] params) {
        block7: {
            if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                log.debug("Entry Call.invokeOneWay(Object[])");
            }
            if (this.operation.isOneway()) {
                try {
                    try {
                        this.invokeOneWayCalled = true;
                        this.invoke(params);
                    }
                    catch (Exception exp) {
                        FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.client.Call.invokeOneWay", "1540", this);
                        throw new JAXRPCException(exp.toString());
                    }
                    Object var4_2 = null;
                    this.invokeOneWayCalled = false;
                    this.outParams = null;
                    this.outParamsList = null;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    this.invokeOneWayCalled = false;
                    this.outParams = null;
                    this.outParamsList = null;
                    throw throwable;
                }
            }
            throw new JAXRPCException(Messages.getMessage("onewayInvalid"));
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.invokeOneWay(Object[])");
        }
    }

    public SOAPEnvelope invoke(SOAPEnvelope env) throws RemoteException {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.invoke(SOAPEnvelope)");
        }
        this.validateTargetEndpointAddress();
        try {
            QName portQName;
            Message msg = null;
            msg = new Message(env);
            this.syncProperties();
            this.msgContext.setRequestMessage(msg);
            QName qName = portQName = this.msgContext == null ? null : this.msgContext.getWSDLPort();
            if (this.wsdlQueryReloadOp && portQName != null) {
                this.loadOperationFromWSDL(portQName.getLocalPart(), this.operation.getElementQName().getLocalPart());
                this.wsdlQueryReloadOp = false;
            } else {
                this.copyOptionsFromWSDLOperation(portQName, this.operation.getElementQName());
            }
            this.msgContext.protectProperties();
            this.connection.invoke(this.msgContext, this.myHeaders, this.attachmentParts);
            msg = this.msgContext.getResponseMessage();
            this.msgContext.resetProperties();
            if (msg == null) {
                return null;
            }
            if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                log.debug("Exit Call.invoke(SOAPEnvelope)");
            }
            return msg.getSOAPEnvelope();
        }
        catch (Exception exp) {
            FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.client.Call.invoke", "1519", this);
            if (exp instanceof WebServicesFault) {
                throw (WebServicesFault)exp;
            }
            if (entLog.isDebugEnabled()) {
                entLog.debug(Messages.getMessage("toWebServicesFault00"), exp);
            }
            throw new WebServicesFault(Messages.getMessage("errorInvoking00", "\n" + exp));
        }
    }

    public List invoke(SOAPBodyElement[] params) throws RemoteException {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.invoke(SOAPBodyElement[])");
        }
        if (!this.invokeOneWayCalled && this.operation.getReturnClass() == null) {
            this.setReturnType(Constants.WEBSERVICES_VOID);
        }
        SOAPEnvelope env = null;
        if (params != null && params.length > 0) {
            SOAPFactory sf = params[0].getSOAPFactory();
            sf.setSOAPConstants(this.msgContext.getSOAPConstants());
            try {
                int i;
                env = sf.createSOAPEnvelope(true);
                for (i = 0; i < params.length; ++i) {
                    env.getBody().addChildElement((javax.xml.soap.SOAPElement)params[i]);
                }
                if ((env = this.invoke(env)) == null) {
                    if (entLog.isDebugEnabled()) {
                        entLog.debug("No SOAP Response envelope; OK if request was one-way.  Was request one-way? " + this.invokeOneWayCalled);
                    }
                    if (this.invokeOneWayCalled) {
                        return null;
                    }
                    throw new WebServicesFault(Messages.getMessage("nullResponse00"));
                }
                ArrayList<SOAPElement> children = new ArrayList<SOAPElement>();
                com.ibm.ws.webservices.engine.xmlsoap.SOAPBody body = (com.ibm.ws.webservices.engine.xmlsoap.SOAPBody)env.getBody();
                for (i = 0; i < body.getNumChildren(); ++i) {
                    children.add(body.getChildElement(i));
                }
                if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                    log.debug("Exit Call.invoke(SOAPBodyElement[])");
                }
                return children;
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.client.Call.invoke", "1371", this);
                throw WebServicesFault.makeFault(se);
            }
        }
        if (this.operation.getElementQName() == null) {
            throw new WebServicesFault(Messages.getMessage("noOperation00"));
        }
        try {
            Vector res = this.connection.invoke(this.msgContext, params, this.myHeaders, this.attachmentParts);
            ArrayList ret = (ArrayList)this.sortOutputs(res);
            Class returnClass = this.operation.getReturnClass();
            if (returnClass != null) {
                ret = (ArrayList)JavaUtils.convert(ret, returnClass);
            }
            if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                log.debug("Exit Call.invoke(SOAPBodyElement[])");
            }
            return ret;
        }
        catch (WebServicesFault af) {
            FFDCFilter.processException((Throwable)af, "com.ibm.ws.webservices.engine.client.Call.invoke", "1335", this);
            throw af;
        }
        catch (Exception exp) {
            FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.client.Call.invoke", "1339", this);
            if (entLog.isDebugEnabled()) {
                entLog.debug(Messages.getMessage("toWebServicesFault00"), exp);
            }
            throw new WebServicesFault(Messages.getMessage("errorInvoking00", "\n" + exp));
        }
    }

    public void invokeOneWay(SOAPBodyElement[] params) {
        block7: {
            if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                log.debug("Entry Call.invokeOneWay(SOAPBodyElement[])");
            }
            if (this.operation.isOneway()) {
                try {
                    try {
                        this.invokeOneWayCalled = true;
                        this.invoke(params);
                    }
                    catch (Exception exp) {
                        FFDCFilter.processException((Throwable)exp, "com.ibm.ws.webservices.engine.client.Call.invokeOneWay", "1540", this);
                        throw new JAXRPCException(exp.toString());
                    }
                    Object var4_2 = null;
                    this.invokeOneWayCalled = false;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    this.invokeOneWayCalled = false;
                    throw throwable;
                }
            }
            throw new JAXRPCException(Messages.getMessage("onewayInvalid"));
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.invokeOneWay(SOAPBodyElement[])");
        }
    }

    public Message getResponseMessage() {
        return this.msgContext.getResponseMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void addHeader(SOAPHeaderElement header2) {
        if (this.myHeaders == null) {
            this.myHeaders = new Vector();
        }
        this.myHeaders.add(header2);
    }

    public void clearHeaders() {
        this.myHeaders = null;
    }

    private TypeMapping getTypeMapping() {
        TypeMapping tm = this.msgContext.getTypeMapping();
        TypeMappingRegistry tmr = this.msgContext.getTypeMappingRegistry();
        if (tm == null || tm == tmr.getDefaultTypeMapping()) {
            tm = (TypeMapping)tmr.createTypeMapping();
            tmr.register(this.msgContext.getEncodingStyle(), tm);
        }
        if (!this.customBinderLoaded) {
            Boolean preload = (Boolean)this.getProperty("custom.binder.preload");
            if (preload == null) {
                preload = Boolean.TRUE;
            }
            if (preload.booleanValue()) {
                List providers = (List)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Utils.loadCustomProviders(Thread.currentThread().getContextClassLoader());
                    }
                });
                Utils.populateTypeMapping(providers, tm);
                this.customBinderLoaded = true;
            }
        }
        return tm;
    }

    public void registerTypeMapping(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory df) {
        this.registerTypeMapping(javaType, xmlType, sf, df, true);
    }

    public void registerTypeMapping(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory df, boolean force) {
        TypeMapping tm = this.getTypeMapping();
        if (!force && tm.isRegistered(javaType, xmlType)) {
            return;
        }
        tm.register(javaType, xmlType, sf, df);
    }

    public void registerTypeMapping(Class javaType, QName xmlType, Class sfClass, Class dfClass) {
        this.registerTypeMapping(javaType, xmlType, sfClass, dfClass, true);
    }

    public void registerTypeMapping(Class javaType, QName xmlType, Class sfClass, Class dfClass, boolean force) {
        SerializerFactory sf = BaseSerializerFactory.createFactory(sfClass, javaType, xmlType);
        DeserializerFactory df = BaseDeserializerFactory.createFactory(dfClass, javaType, xmlType);
        if (sf != null || df != null) {
            this.registerTypeMapping(javaType, xmlType, sf, df, force);
        }
    }

    public void setTransport(Transport transport2) {
        this.setTransport(transport2, null);
    }

    public void setTransport(Transport transport2, URL address) {
        this.connection = this.service.getConnection(transport2, address);
        this.msgContext.setTargetEndpointAddress(address);
    }

    public Object invoke(String method, Object[] args) throws RemoteException {
        return this.invoke(QNameTable.createQName("", method), args);
    }

    public Map getOutputParams() {
        if (this.outParams == null) {
            throw new JAXRPCException(Messages.getMessage("noOutputForGetOutput", "getOutputParams"));
        }
        return this.outParams;
    }

    public List getOutputValues() {
        if (this.outParamsList == null) {
            throw new JAXRPCException(Messages.getMessage("noOutputForGetOutput", "getOutputValues"));
        }
        return this.outParamsList;
    }

    public Service getService() {
        return this.service;
    }

    public void addAttachmentPart(Object attachment) {
        this.attachmentParts.add(attachment);
    }

    public void addFault(QName faultCode, Class cls, QName msgQName, QName xmlType, QName partQName) {
        FaultDesc fault2 = new FaultDesc();
        fault2.setFaultCode(faultCode);
        fault2.setClassName(cls.getName());
        fault2.setPartXmlType(xmlType);
        fault2.setPartQName(partQName);
        fault2.setMessageQName(msgQName);
        this.operation.addFault(fault2);
    }

    public void addAttachmentParameter(QName paramName, String mimeType, Class javaType, ParameterMode mode) {
        this.addParameter(paramName, MimeUtils.getMIMETypeQName(mimeType), javaType, mode);
    }

    public void setAttachmentReturnType(String mimeType, Class javaType) {
        this.setReturnType(MimeUtils.getMIMETypeQName(mimeType), javaType);
    }

    private void syncProperties() {
        String prop = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
        if (prop != null) {
            if (this.msgContext != null) {
                this.msgContext.setOperationStyle(prop);
            }
            this.operation.setStyle(Style.getStyle(prop));
        }
        if ((prop = (String)this.getProperty(OPERATION_USE_PROPERTY)) != null) {
            if (this.msgContext != null) {
                this.msgContext.setOperationUse(prop);
            }
            this.operation.setUse(Use.getUse(prop));
        }
        if ((prop = (String)this.getProperty("javax.xml.rpc.encodingstyle.namespace.uri")) != null && this.msgContext != null) {
            this.msgContext.setEncodingStyle(prop);
        }
    }

    private void validateTargetEndpointAddress() throws NoEndPointException {
        if (this.connection == null) {
            throw new NoEndPointException();
        }
    }

    private void invokeWSDLQueryParse(final String context, final Document doc, final Definition def) throws Exception {
        Object ret = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Call.this.wsdlQuery.parse(context, doc, def);
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        });
        if (ret != null) {
            throw (Exception)ret;
        }
    }

    private Archive setImportResolverForWSDLQuery(final WSDLQuery wsdlQuery, final String wsdlLoadStrategyPath) {
        Archive arch = (Archive)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    CommonarchiveFactory archiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                    ArchiveOptions options = new ArchiveOptions();
                    options.setIsReadOnly(true);
                    options.setUseJavaReflection(false);
                    options.setDiscriminateNestedArchives(false);
                    Archive archive = archiveFactory.openArchive(options, wsdlLoadStrategyPath);
                    LoadStrategy wsdlLoadStrategy = archive.getLoadStrategy();
                    WsdlImportResolver im = new WsdlImportResolver(wsdlLoadStrategy);
                    if (log.isDebugEnabled()) {
                        log.debug("WSDLQuery - setting ImportResolver: im = " + im.toString());
                    }
                    wsdlQuery.setResolver(im);
                    return archive;
                }
                catch (Throwable e) {
                    if (log.isDebugEnabled()) {
                        log.debug("WSDLQuery - caught exception trying to set ImportResolver.", e);
                    }
                    return null;
                }
            }
        });
        return arch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WSDLQuery getWSDLQuery() {
        block18: {
            Definition wsdlDefinition;
            if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
                log.debug("Entry Call.getWSDLQuery()");
            }
            if (!this.wsdlQueryUnavailable && this.wsdlQuery == null && (wsdlDefinition = this.service.getWSDLDefinition()) != null) {
                Definition definition = wsdlDefinition;
                synchronized (definition) {
                    Archive archive = null;
                    try {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug("Attempting WSDLQuery.  doc base URI = " + wsdlDefinition.getDocumentBaseURI());
                            }
                            this.wsdlQueryUnavailable = false;
                            this.wsdlQuery = new WSDLQuery();
                            this.wsdlQuery.setLogToConsole(false);
                            String wsdlLoadStrategyPath = this.service.getWsdlLoadStrategyPath();
                            if (log.isDebugEnabled()) {
                                log.debug("WSDLQuery: got wsdlLoadStrategyPath = " + wsdlLoadStrategyPath);
                            }
                            if (wsdlLoadStrategyPath != null && !wsdlLoadStrategyPath.equals("")) {
                                archive = this.setImportResolverForWSDLQuery(this.wsdlQuery, wsdlLoadStrategyPath);
                            }
                            Boolean noDataBinding = (Boolean)this.getProperty("noDataBinding");
                            String inputMappingFile = (String)this.getProperty("jaxrpcMappingFile");
                            if (log.isDebugEnabled()) {
                                log.debug("WSDLQuery - noDataBindings = " + (noDataBinding == null ? null : noDataBinding.toString()) + ", inputMappingFile = " + inputMappingFile);
                            }
                            if (noDataBinding != null) {
                                this.wsdlQuery.setNoDataBinding(noDataBinding);
                            }
                            if (inputMappingFile != null) {
                                this.wsdlQuery.setInputMappingFile(inputMappingFile);
                            }
                            WSDLFactoryImpl wsdlFactory = new WSDLFactoryImpl();
                            WSDLWriter writer = wsdlFactory.newWSDLWriter();
                            Document newDoc = writer.getDocument(wsdlDefinition);
                            this.invokeWSDLQueryParse(wsdlDefinition.getDocumentBaseURI(), newDoc, wsdlDefinition);
                        }
                        catch (Throwable e) {
                            this.wsdlQueryUnavailable = true;
                            this.wsdlQuery = null;
                            if (log.isDebugEnabled()) {
                                log.debug("Call:: WSDLQuery failed, exception ignored, processing continues. " + e.getMessage(), e);
                            }
                            Object var11_12 = null;
                            if (archive != null) {
                                archive.close();
                            }
                            break block18;
                        }
                        Object var11_11 = null;
                        if (archive == null) break block18;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        if (archive != null) {
                            archive.close();
                        }
                        throw throwable;
                    }
                    archive.close();
                }
            }
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.getWSDLQuery().  wsdlQuery = " + this.wsdlQuery);
        }
        return this.wsdlQuery;
    }

    private OperationDesc findOpDescInVector(Vector opDescs, String opName) {
        OperationDesc retOpDesc = null;
        for (int i = 0; i < opDescs.size() && retOpDesc == null; ++i) {
            OperationDesc desc = (OperationDesc)opDescs.get(i);
            if (!desc.getName().equals(opName)) continue;
            retOpDesc = desc;
        }
        return retOpDesc;
    }

    private OperationDesc getWSDLQueryOperationDesc(String portName, String opName) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.getWSDLQueryOperationsDesc()" + opName);
        }
        OperationDesc retOpDesc = null;
        WSDLQuery wsdlQuery = this.getWSDLQuery();
        if (wsdlQuery != null) {
            Vector opDescs = null;
            if (portName != null) {
                opDescs = wsdlQuery.getOperationDescs(portName);
                if (opDescs != null) {
                    retOpDesc = this.findOpDescInVector(opDescs, opName);
                }
            } else {
                HashMap allPortOpDesc = wsdlQuery.getOperationDescs();
                if (allPortOpDesc != null && allPortOpDesc.values() != null) {
                    Iterator opIt = allPortOpDesc.values().iterator();
                    while (opIt.hasNext() && retOpDesc == null) {
                        opDescs = (Vector)opIt.next();
                        retOpDesc = this.findOpDescInVector(opDescs, opName);
                    }
                }
            }
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.getWSDLQueryOperationsDesc(). OperationDesc : " + retOpDesc);
        }
        return retOpDesc;
    }

    public boolean loadOperationFromWSDL(String portName, String operationName) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.loadOperationsFromWSDL()" + operationName);
        }
        boolean retval = true;
        OperationDesc opDesc = this.getWSDLQueryOperationDesc(portName, operationName);
        if (opDesc == null) {
            retval = false;
        } else {
            this.operation = opDesc;
            this.msgContext.setOperation(opDesc);
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.loadOperationsFromWSDL(). Return value is : " + retval);
        }
        return retval;
    }

    public boolean copyOptionsFromWSDLOperation(QName portName, QName operationName) {
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Entry Call.copyOptionsFromWSDLOperation()" + operationName.toString());
        }
        boolean retval = true;
        String portLocalName = portName == null ? null : portName.getLocalPart();
        OperationDesc opDesc = this.getWSDLQueryOperationDesc(portLocalName, operationName.getLocalPart());
        if (opDesc == null) {
            this.operation.setOption(OperationDesc.WSDL_UNAVAILABLE, "true");
            String tns = null;
            if (operationName != null) {
                tns = operationName.getNamespaceURI();
            } else if (portName != null) {
                tns = portName.getNamespaceURI();
            }
            this.operation.setOption(OperationDesc.TARGET_NAMESPACE, tns);
            retval = false;
        } else if (opDesc != this.operation) {
            Iterator keys = opDesc.getOptions().keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.operation.setOption(key, opDesc.getOption(key));
            }
        }
        if (log.isDebugEnabled() || entLog.isDebugEnabled()) {
            log.debug("Exit Call.copyOptionsFromWSDLOperation(). Return value: " + retval);
        }
        return retval;
    }

    static {
        propertyNames.add("javax.xml.rpc.security.auth.username");
        propertyNames.add("javax.xml.rpc.security.auth.password");
        propertyNames.add("http.proxyHost");
        propertyNames.add("http.proxyPort");
        propertyNames.add("http.proxyUser");
        propertyNames.add("http.proxyPassword");
        propertyNames.add("https.proxyHost");
        propertyNames.add("https.proxyPort");
        propertyNames.add("https.proxyUser");
        propertyNames.add("https.proxyPassword");
        propertyNames.add("ssl.configName");
        propertyNames.add("http.redirect.enabled");
        propertyNames.add("javax.xml.rpc.session.maintain");
        propertyNames.add(ATTACHMENT_ENCAPSULATION_FORMAT);
        propertyNames.add("javax.xml.rpc.soap.operation.style");
        propertyNames.add("javax.xml.rpc.soap.http.soapaction.use");
        propertyNames.add("javax.xml.rpc.soap.http.soapaction.uri");
        propertyNames.add("javax.xml.rpc.encodingstyle.namespace.uri");
        propertyNames.add(OPERATION_USE_PROPERTY);
        propertyNames.add(TRANSPORT_NAME);
        propertyNames.add("javax.xml.rpc.service.endpoint.address");
    }
}

