/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.image.ImageIOFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;

public class ImageDataSource
implements DataSource {
    protected static Log log = LogFactory.getLog(ImageDataSource.class.getName());
    public static final String CONTENT_TYPE = "image/jpeg";
    private final String name;
    private final String contentType;
    private byte[] data;
    private ByteArrayInputStream is;
    private ByteArrayOutputStream os;

    public ImageDataSource(String name2, Image data) {
        this(name2, CONTENT_TYPE, data);
    }

    public ImageDataSource(String name2, String contentType, Image data) {
        this.name = name2;
        this.contentType = contentType == null ? CONTENT_TYPE : contentType;
        this.os = new ByteArrayOutputStream();
        try {
            if (data != null) {
                ImageIOFactory.getImageIO().saveImage(this.contentType, data, this.os);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.ImageDataSource.ImageDataSource", "97", this);
            log.error(Messages.getMessage("exception00"), e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return new ByteArrayInputStream(this.data == null ? new byte[]{} : this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return this.os;
    }
}

