/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.client.util;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;

class XmlWebAccessor {
    private static TraceComponent tc = Tr.register(XmlWebAccessor.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private final WebApp webApp;
    private final AppDeploymentTask appDeploymentTask;
    private final AppDeploymentInfo appDeploymentInfo;

    XmlWebAccessor(WebApp webApp, AppDeploymentTask appDeploymentTask, AppDeploymentInfo appDeploymentInfo) {
        this.webApp = webApp;
        this.appDeploymentTask = appDeploymentTask;
        this.appDeploymentInfo = appDeploymentInfo;
    }

    String getUrlPatternForServletName(String targetServletName) throws AppDeploymentException {
        int index;
        EList list = this.webApp.getServletMappings();
        Iterator iterator = list.iterator();
        String urlPattern2 = null;
        while (iterator.hasNext()) {
            ServletMapping mapping = (ServletMapping)iterator.next();
            String servletName2 = mapping.getServlet().getServletName();
            if (!servletName2.equals(targetServletName)) continue;
            if (urlPattern2 != null) {
                Object[] fillins = new Object[]{util.formUriString((AppDeploymentInfo)this.appDeploymentInfo, (EObject)this.webApp), targetServletName};
                String message = MessageFormat.format(util.getMessage((AppDeploymentTask)this.appDeploymentTask, (String)"WSWS0031E"), fillins);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getUrlPatternForServletName: " + message);
                }
                Tr.error(tc, "WSWS0031E", fillins);
                throw new AppDeploymentException(message, null);
            }
            urlPattern2 = mapping.getUrlPattern();
        }
        if (urlPattern2 != null && (index = urlPattern2.indexOf(42)) != -1) {
            Object[] fillins = new Object[]{util.formUriString((AppDeploymentInfo)this.appDeploymentInfo, (EObject)this.webApp), urlPattern2, targetServletName};
            String message = MessageFormat.format(util.getMessage((AppDeploymentTask)this.appDeploymentTask, (String)"WSWS0032E"), fillins);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getUrlPatternForServletName: " + message);
            }
            Tr.error(tc, "WSWS0032E", fillins);
            throw new AppDeploymentException(message, null);
        }
        return urlPattern2;
    }
}

