/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.ServerBindPort;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ServerBindPortTaskHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(ServerBindPortTaskHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        return new ServerBindPort(appController);
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        String[][] newTaskData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (task.getTaskData() != null) {
            return;
        }
        Vector<String> dataForTwoDimensionalArray = new Vector<String>();
        String[] columnNames = task.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            dataForTwoDimensionalArray.addElement(columnNames[i]);
        }
        Vector wars = appDeploymentInfo.getModuleConfig("WAR_DD");
        boolean webServiceEnabled = false;
        boolean firstRowFilled = false;
        Iterator iter = wars.iterator();
        while (iter.hasNext()) {
            WSDeploymentDescriptorAccessor ddAccessor;
            EObject refObject = (EObject)iter.next();
            String moduleURI = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)refObject);
            String[] pieces = util.separateUriString((String)moduleURI);
            String moduleName = pieces[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prepareTask: working on module " + moduleURI);
            }
            if ((ddAccessor = new WSDeploymentDescriptorAccessor(refObject, appDeploymentInfo, task)).isModuleWebServiceEnabled(task)) {
                EList services;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prepareTask: module " + moduleURI + " is Web Service enabled");
                }
                webServiceEnabled = true;
                WSBindingsFileAccessor bindingAccessor = new WSBindingsFileAccessor(refObject, moduleURI, task, appDeploymentInfo);
                WSBinding serverBinding = bindingAccessor.getServerBinding();
                if (serverBinding == null || (services = serverBinding.getWsdescBindings()) == null || services.isEmpty()) continue;
                this.fillServicesRows(dataForTwoDimensionalArray, moduleName, services);
                firstRowFilled = true;
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "prepareTask: module " + moduleURI + " is NOT Web Service enabled");
        }
        if (webServiceEnabled) {
            if (!firstRowFilled) {
                for (int i = 0; i < columnNames.length; ++i) {
                    dataForTwoDimensionalArray.addElement("");
                }
            }
            newTaskData = util.buildTaskData(dataForTwoDimensionalArray, (int)columnNames.length);
            task.setTaskData(newTaskData);
        } else {
            newTaskData = null;
            task.setTaskData(newTaskData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private void fillServicesRows(Vector dataForTwoDimensionalArray, String moduleName, EList services) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillServicesRows", new Object[]{moduleName});
        }
        int size = services.size();
        for (int i = 0; i < size; ++i) {
            WSDescBinding ws = (WSDescBinding)services.get(i);
            String serviceName = ws.getWsDescNameLink();
            EList ports = ws.getPcBindings();
            int portsSize = ports.size();
            for (int j = 0; j < portsSize; ++j) {
                PCBinding port2 = (PCBinding)ports.get(j);
                dataForTwoDimensionalArray.addElement(moduleName);
                dataForTwoDimensionalArray.addElement(serviceName);
                dataForTwoDimensionalArray.addElement(port2.getPcNameLink());
                String scope = port2.getScope();
                if (scope == null) {
                    scope = "";
                }
                dataForTwoDimensionalArray.addElement(scope);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fillServicesRows");
        }
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!task.isTaskEmpty() && !task.isTaskDisabled()) {
            Hashtable appOptions = appDeploymentInfo.getAppOptions();
            String[][] taskData = task.getTaskData();
            Vector ejbJars = appDeploymentInfo.getModuleConfig("JAR_DD");
            Vector wars = appDeploymentInfo.getModuleConfig("WAR_DD");
            Vector combined = new Vector();
            combined.addAll(ejbJars);
            combined.addAll(wars);
            Iterator iter = combined.iterator();
            while (iter.hasNext()) {
                EList services;
                WSBindingsFileAccessor bindingAccessor;
                WSBinding serverBinding;
                EObject refObject = (EObject)iter.next();
                String moduleURI = util.formUriString((AppDeploymentInfo)appDeploymentInfo, (EObject)refObject);
                String[] pieces = util.separateUriString((String)moduleURI);
                String moduleName = pieces[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask: working on module " + moduleURI);
                }
                if ((serverBinding = (bindingAccessor = new WSBindingsFileAccessor(refObject, moduleURI, task, appDeploymentInfo)).getServerBinding()) == null || (services = serverBinding.getWsdescBindings()) == null || services.isEmpty()) continue;
                this.searchServicesAndSetPortInfo(moduleName, services, taskData);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void searchServicesAndSetPortInfo(String moduleMatch, EList services, String[][] taskData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchServicesAndSetPortInfo", new Object[]{moduleMatch});
        }
        int size = services.size();
        for (int i = 0; i < size; ++i) {
            WSDescBinding ws = (WSDescBinding)services.get(i);
            String serviceName = ws.getWsDescNameLink();
            EList ports = ws.getPcBindings();
            int portsSize = ports.size();
            block1: for (int j = 0; j < portsSize; ++j) {
                PCBinding port2 = (PCBinding)ports.get(j);
                for (int jj = 1; jj < taskData.length; ++jj) {
                    String[] taskRow = taskData[jj];
                    if (!moduleMatch.equals(taskRow[0]) || !serviceName.equals(taskRow[1]) || !port2.getPcNameLink().equals(taskRow[2])) continue;
                    String inputScope = taskRow[3];
                    String currentScope = port2.getScope();
                    if (inputScope == null && currentScope == null) continue block1;
                    if (inputScope == null) {
                        inputScope = "";
                    }
                    if (currentScope == null) {
                        currentScope = "";
                    }
                    if (currentScope.equals(inputScope)) continue;
                    port2.setScope(inputScope);
                    continue block1;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchServicesAndSetPortInfo");
        }
    }
}

